unit KA.Data.KADao.Table platform;
interface

uses
 System.Text,
 System.Runtime.InteropServices,
 Borland.Vcl.Windows,
 Borland.Vcl.SysUtils,
 Borland.Vcl.Classes,
 Borland.Vcl.Db,
 Borland.Vcl.DBCommon,
 Borland.Vcl.Forms,
 Borland.Vcl.Variants,
 Borland.Vcl.TypInfo,
 KA.Data.Dao360,
 KA.Data.KADao.DAOApi,
 KA.Data.KADao.DataBase;

//******************************************************* DatabaseError Messages
{$I 'KA.Data.KADao.ErrLangTB.pas'}
//******************************************************************************


const
        MYBOOKMARKSIZE   = 4;
        GUID_ID          = 47554944;
        GUID_VALID_CHARS = ['{','}','-','0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F','a','b','c','d','e','f'];


Type
TKADaoTable = class;

TBlobData = String;

TDaoInfo=packed record
        RecordNo        : Integer;
        RecordData      : TObject;
        BookmarkFlag    : TBookmarkFlag;
        BookmarkData    : Integer;
End;

TLockType = (ltReadLock, ltWriteLock);
TKeyType  = (KeyValue,RangeStart,RangeEnd);

TLoadMode = (lmAppend, lmEmptyAppend);

TOO    = (
          dbDenyWrite,
          dbDenyRead,
          dbReadOnly,
          dbAppendOnly,
          dbInconsistent,
          dbConsistent,
          dbSQLPassThrough,
          dbFailOnError,
          dbForwardOnly,
          dbSeeChanges,
          dbRunAsync,
          dbExecDirect
          );
TOOSet = Set of TOO;

TExportMethod        = (VisibleFields,AllFields);
TExportProgressEvent = procedure(Current,Total:Integer) of object;
TImportProgressEvent = procedure(Current:Integer) of object;

TKADaoIndexDefs = Class(TIndexDefs)
  Private
    FDataset : TKADaoTable;
    Procedure UpdateIndexes;
    Procedure CreateIndex(IndexDef : TIndexDef);
    Function  DeleteIndex(const Name : string):Boolean;
  Public
    Constructor Create(DataSet: TDataSet);
End;



TKADaoTable = class(TDataSet)
private
        FRecNo           : Integer;
        FRecPos          : Integer;
        FLastRecord      : Integer;
        FRefreshRC       : Boolean;
        FOldRC           : Integer;
        FPostMade        : Boolean;
        FInPost          : Boolean;
        FBatchMode       : Boolean;


        FOldValue        : TValueBuffer;
        FActiveKeyBuffer : TRecordBuffer;
        FKeyBuffer       : TRecordBuffer;
        FRangeStartBuffer: TRecordBuffer;
        FRangeEndBuffer  : TRecordBuffer;

        FBookmarkRN      : TList;
        FBookmarkID      : TList;
        FBookmarkable    : Boolean;

        FFilterBuffer    : TRecordBuffer;
        FBufferSize      : Integer;
        FStartMyInfo     : Integer;
        FStartCalc       : Integer;
        FMDisabled       : Boolean;
        FKeyFields       : TStringList;
        FUpdatableFields : TList;

        FParamCheck      : Boolean;
        FParams          : TParams;

        Procedure       FOnGetMemoText(Sender: TField; var Text: String; DisplayText: Boolean);
        Procedure       FOnGetGUIDText(Sender: TField; var Text: String; DisplayText: Boolean);
        Procedure       FOnSetGUIDText(Sender: TField; const Text: string);
        Function        GetActiveRecordBuffer:  TRecordBuffer;
        Function        GetDaoInfo(Buffer : TRecordBuffer):TDaoInfo;
        Procedure       SetDaoInfo(Buffer : TRecordBuffer; Data :TDaoInfo);
        Function        FilterRecord(Buffer: TRecordBuffer): Boolean;
protected
        FDatabase               : TKADaoDatabase;
        FActive                 : Boolean;
        FReadOnly               : Boolean;
        FProcessMessages        : Boolean;

        FDaoTable               : Recordset;
        FDetailRecordset        : Recordset;


        FSQL                    : TStrings;
        FSortedBy               : TStrings;
        FRefreshSorted          : Boolean;
        FFieldNames             : TStrings;
        FSortFieldNames         : TStrings;
        FFieldTypeNames         : TStrings;
        FDefaultValues          : TStrings;
        FDisplayLabels          : TStrings;

        FQD_ParamNames          : TStringList;
        FQD_ParamDaoTypes       : TStringList;
        FQD_ParamBDETypes       : TStringList;
        FQueryDefMaxRecords     : Integer;
        FQueryDefType           : String;
        FQueryDefCanModify      : Boolean;

        FMasterLink             : TMasterDataLink;
        FMasterFields           : TStrings;
        FUseBrackets            : Boolean;
        FMasterAutoActivate     : Boolean;
        FDatabaseAutoActivate   : Boolean;
        FUseRecordCountCache    : Boolean;
        FUseGetRecNo            : Boolean;
        FUseDisplayLabels       : Boolean;
        FUseDaoProperties       : Boolean;
        FAutoFindIndex          : Boolean;

        FIndexDefs              : TKADaoIndexDefs;

        FRangeFiltered          : Boolean;
        FFiltered               : Boolean;
        FFilter                 : String;
        FOnFilterRecord         : TFilterRecordEvent;
        FOnExportProgress       : TExportProgressEvent;
        FOnImportProgress       : TImportProgressEvent;

        FTableName              : String;
        FQueryDefName           : String;
        FQueryDefParameters     : TStrings;
        FQueryDefSQLText        : TStrings;
        FIndexName              : String;
        FIndexFieldCount        : Integer;
        FTableType              : Integer;
        FLockType               : Integer;
        FOpenOptions            : TOOSet;
        FRecordSize             : Integer;

        FFindKeyFields          : String;
        FFindKeyValues          : Variant;
        FFindOptions            : TLocateOptions;

        FExportMethod           : TExportMethod;

        FKeyKeyFields           : String;
        FKeyKeyValues           : Variant;

        FDateCreated            : String;
        FLastUpdated            : String;
        FComponentVersion       : String;
        FWarnOnBadDatabase      : Boolean;
        FCacheMemos             : Boolean;
        FCacheBlobs             : Boolean;
        FCacheLookups           : Boolean;
        FShowGUID               : Boolean;

        FEncrypter              : TComponent;
        FEncodedString          : TPropInfo;
        FDecodedString          : TPropInfo;
        FHasEncoder             : Boolean;

        FTranslation            : Boolean;

        Letters                  : String;
        DaoFields                : Array of TObject;
        DaoOpenOptions           : Integer;
        DaoSortString            : String;
        InInternalOpen           : Boolean;

        Procedure                Loaded; override;
        Procedure                Notification(AComponent: TComponent; Operation: TOperation);Override;

        Procedure       SetComponentVersion(Value: String);
        Function        GetDatabase:TKADaoDatabase;
        Procedure       SetDatabase(Value:TKADaoDatabase);
        Function        GetTableName:String;
        Procedure       SetTableName(Value:String);
        Function        GetDateCreated:String;
        Function        GetLastUpdated:String;

        Function        GetIndexName:String;
        Procedure       SetIndexName(Value:String);
        Function        GetIndexFieldNames:String;
        Procedure       SetIndexFieldNames(Value:String);
        Function        GetIndexFieldCount:Integer;
        Procedure       SetIndexFieldCount(Value:Integer);

        Procedure       SetTableType(Value:Integer);
        Procedure       SetLockType(Value:Integer);
        Procedure       SetOpenOptions(Value:TOOSet);
        Procedure       SetReadOnly(Value:Boolean);
        Function        GetLockEdits:Boolean;
        Procedure       SetSort(Value:TStrings);

        Procedure       SetSQL(Value:TStrings);
        Procedure       SetQueryDefName(Value:String);
        Procedure       SetQueryDefParameters(Value:TStrings);
        Procedure       SetQueryDefSQLText(Value:TStrings);
        Function        GetQueryDefType:String;

        Function        GetMasterSource: TDataSource;
        Procedure       SetMasterSource(Value: TDataSource);
        Procedure       FProcessMasterFields(Value:TStrings);
        Procedure       SetMasterFields(Value:TStrings);

        Procedure       SetMaster(Value:TStrings);
        Procedure       SetDetail(Value:TStrings);
        Function        WWStringReplace(Src,Pattern,Repl:String):String;
        Function        ChangeQuotes(S:String):String;
        Function        ChangeOnlyQuotes(S:String):String;
        Function        ChangeCommas(S:String):String;
        Function        FComposeSQL(SQL:TStrings):String;
        Function        FRecalculateRecNo(TempRS:Recordset;BK:Integer):Integer;
        //*********************************************************** 22.02.2002
        Function        ComposeFilter:String;
        Procedure       SetFiltered(Value:Boolean);Override;
        Procedure       SetFilterText(Const Value:String);Override;
        //*********************************************************** 22.02.2002

        Procedure       SetOnFilterRecord(Const Value: TFilterRecordEvent);Override;

        Function        GetIndexField(Index: Integer): TField;
        Procedure       SetIndexField(Index: Integer; Value: TField);

        Procedure       FSetBatchMode(Value:Boolean);
        Procedure       SetCacheMemos(Value:Boolean);
        Procedure       SetCacheBlobs(Value:Boolean);
        Procedure       SetCacheLookups(Value:Boolean);
        Procedure       SetShowGUID(Value:Boolean);
        

        Procedure       SetEncrypter(Value:TComponent);

        //**********************************************************************
        Procedure       SetParamsList(Value: TParams);
        Procedure       UpdateParamsList(Sender: TObject);
        Procedure       WriteParamData(Writer: TWriter);
        Function        GetParamsCount: Word;
        Procedure       DefineProperties(Filer: TFiler); override;
        Procedure       ReadParamData(Reader: TReader);
        //**********************************************************************
        Procedure       MasterDatasetChanged;
        Procedure       UpdateFromMaster;
        Procedure       RefreshQueryParams;
        Procedure       MasterChanged(Sender: TObject);
        Procedure       MasterDisabled(Sender: TObject);
        Procedure       DoOnNewRecord; override;
        //**********************************************************************
        Procedure       ClearKey;
        Procedure       ClearRange(Var Buffer : TRecordBuffer);
        Function        FilterRange(Buffer:TRecordBuffer): Boolean;
        Function        CompareRecordsRange(B1,B2: TRecordBuffer; CT : Integer) : Integer;
        Function        CompareFieldsRange(B1,B2 : String; FieldType: TFieldType):Integer;
        //**********************************************************************
        Function        InternalCalcRecordSize:Integer;
        Function        IntegerToBuffer(Buffer: TValueBuffer; S: String): Boolean;
        Function        Int16ToBuffer(Buffer: TValueBuffer; S: String): Boolean;
        Function        FloatToBuffer(Buffer: TValueBuffer; S: String): Boolean;
        Function        BooleanToBuffer(Buffer: TValueBuffer; S: String): Boolean;

        Function        DateToBuffer(Buffer: TValueBuffer; S: String): Boolean;
        Function        TimeToBuffer(Buffer: TValueBuffer; S: String): Boolean;
        Function        DateTimeToBuffer(Buffer: TValueBuffer; S: String): Boolean;

        Function        BufferToDate(Buffer: TValueBuffer): String;
        Function        BufferToTime(Buffer: TValueBuffer): String;
        Function        BufferToDateTime(Buffer: TValueBuffer): String;
        Function        BufferToFloat(Buffer: TValueBuffer): String;

        Function        GUIDToBuffer(Buffer: TValueBuffer; S: String): Boolean;
        Function        BufferToGUID(Buffer:TValueBuffer):String;


        Function        ProcessDTDefault(S:String):String;
        Procedure       OpenDaoRecordset;
        Procedure       ReOpenDaoRecordset;
        Procedure       GetQueryDefReturnParams(QueryDefName:String);
        Procedure       CloseDaoRecordset;

        Procedure       InternalOpen; override;
        Procedure       InternalClose; override;
        Function        IsCursorOpen: Boolean; override;
        Function        GetCanModify: Boolean; override;
        Function        GetRecordSize: Word;override;
        Function        AllocRecordBuffer: TRecordBuffer; override;
        Procedure       FreeRecordBuffer(var Buffer: TRecordBuffer); override;
        Function        InternalFillRecordData(RS : Recordset; MainTable : Boolean; Buffer:TRecordBuffer):Boolean;
        Function        GetRecord(Buffer: TRecordBuffer; GetMode: TGetMode; DoCheck: Boolean): TGetResult; override;
        Procedure       InternalInitIndexDefs;
        Procedure       UpdateIndexDefs; override;
        Procedure       InternalInitFieldDefs; override;
        Procedure       InternalSetDisplayLabels;
        Procedure       InternalInitRecord(Buffer: TRecordBuffer); override;
        Procedure       SetFieldData(Field: TField; Buffer: TValueBuffer);override;
        Procedure       ClearCalcFields(Buffer: TRecordBuffer);override;



        //*********************************************** Navigation and Editing
        Procedure       InternalFirst;override;
        Procedure       InternalLast;override;
        Procedure       InternalMoveToBookmark(Bookmark: Integer);
        Procedure       InternalSetToRecord(Buffer: TRecordBuffer); override;
        Procedure       InternalEdit; override;
        Procedure       InternalInsert; override;
        Procedure       InternalCancel; override;
        Procedure       InternalPost; override;
        Procedure       InternalAddRecord(Buffer: TRecordBuffer; Append: Boolean); override;
        Procedure       InternalDelete; override;
        Procedure       InternalRefresh; override;
        Procedure       DaoInternalRefresh;
        //***********************************************
        Function        GetDaoBookMark(RS:Recordset):Integer;
        Function        GetDaoLastModifiedBookMark(RS:Recordset):Integer;

        Procedure       InternalClearBookmarks;
        Procedure       InternalGotoBookmark(const Bookmark: TBookmark); override;

        Function        GetBookmarkFlag(Buffer: TRecordBuffer): TBookmarkFlag; override;
        Procedure       SetBookmarkFlag(Buffer: TRecordBuffer; Value: TBookmarkFlag); override;

        Function        GetBookmarkStr: TBookmarkStr; override;
        Procedure       SetBookmarkStr(const Value: TBookmarkStr); override;

        Procedure       GetBookmarkData(Buffer: TRecordBuffer; var Bookmark: TBookmark); override;
        Procedure       SetBookmarkData(Buffer: TRecordBuffer; Const Bookmark: TBookmark); override;

        Procedure       InternalHandleException; override;

        Function        GetRecordCount  : Integer; override;
        Function        GetRecNo        : Integer; override;
        Procedure       SetRecNo        (Value: Integer); override;


        //************************************************* TTable Compatibility
        Function        FindRecord(Restart, GoForward: Boolean): Boolean; override;
        //************************************************* TTable Compatibility

        Procedure       StringToList(Items: String; List: TStringList);
        Procedure       VariantToList(Items: Variant; List: TStringList);

        Function        StringToBlob(Field:TBlobField; Data:String):OleVariant;
        Function        BlobToString(Field:TBlobField; Data:OleVariant; DataSize:Integer):String;


        Function        BuildKeySQL(KN,KV:TStringList):String;
        Function        BuildLocateSQL(KN,KV:TStringList;Options: TLocateOptions):String;
        Function        BuildDetailSQL  : String;

        Function        Find(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions;FindType:Integer): Boolean;
        Function        InsertSQLString(MDString: String): String;
        Function        UnquoteString(S:String):String;
        Function        GetTickCountEx:Cardinal;

        procedure       ProcDataEvent(Event: TDataEvent; Info: TObject);
  public
        //*********************************** Public By Property Editors request
        FDetail                         : TStrings;
        FMaster                         : TStrings;
        FMDFieldNames                   : TStrings;
        //**********************************************************************
        MainDatabaseShutdown             : Boolean;
        QueryDefTypeInt                  : Integer;
        QueryDefReturnParams             : Array of TObject;
        RecordsAffected                  : Integer;

        CoreRecordset                    : Recordset;
        SQLExecutionType                 : Integer;
        Constructor                        Create(AOwner: TComponent); override;
        Destructor                         Destroy; override;

        Property                           BatchMode : Boolean Read FBatchMode Write FSetBatchMode;

        Function                           BookmarkToInteger(Bookmark:TBookmark):Integer;
        Procedure                          IntegerToBookmark(Int : Integer; Var Bookmark : TBookmark);
        Function                           IntegerToString(Int : Integer):String;

        Procedure                          Post; override;
        Procedure                          Resync(Mode: TResyncMode);override;
        Procedure                          RefreshData;
        Procedure                          RefreshDataEx;
        Procedure                          RollbackRefresh;

        Function                           FindGoodIndex(KeyFields:String):String;
        Function                           GetFieldData(Field: TField; Buffer: TValueBuffer): Boolean; override;
        Function                           CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream; override;

        Procedure                          SetKeyFields(const KeyFields: string);
        Function                           GetFieldIndexName(FiledName:String):String;
        Function                           CheckFieldsInIndex(KF:TStringList):Boolean;
        Function                           Find_First(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Last(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Next(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Prior(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Nearest(const KeyValues: array of const):Boolean;
        Function                           Find_NearestEx(const KeyFields: string; const KeyValues: Variant):Boolean;
        Function                           Seek_Nearest(const KeyValues: array of const):Boolean;
        Function                           Seek_NearestEx(const KeyValues: array of const; SeekType:String):Boolean;

        //*******************************  For TTable Compatibility
        Procedure                          FindNearest(const KeyValues: array of const);
        Property                           IndexFieldNames : String Read GetIndexFieldNames Write SetIndexFieldNames;
        Property                           IndexFields[Index: Integer]: TField read GetIndexField write SetIndexField;
        Procedure                          SetFindData(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions);
        Procedure                          LockTable(LockType: TLockType);
        Procedure                          UnlockTable(LockType: TLockType);
        Procedure                          SetLockEdits(LockEdits : Boolean);
        Function                           GetCurrentRecord(Buffer: TRecordBuffer): Boolean; override;

        Function                           Translate(const Src: string; var Dest: string; ToOem: Boolean):Integer; override;

        //*******************************  Key Routines
        Procedure                          SetKey;
        Procedure                          EditKey;
        Procedure                          CancelKey;
        Procedure                          SetKeyParam(const KeyFields: Array of String;const KeyValues: array of const);
        Function                           GotoKey: Boolean;
        Procedure                          GotoNearest;
        Function                           FindKey(const KeyValues: array of const):Boolean;
        Function                           FindKeyEx(const KeyValues: array of const):Boolean;
        //*******************************  Key Routines

        //*******************************  Range Routines
        Procedure                          SetRange(const StartValues, EndValues:array of const);
        Procedure                          SetRangeStart;
        Procedure                          SetRangeEnd;
        Procedure                          EditRangeStart;
        Procedure                          EditRangeEnd;
        Procedure                          ApplyRange;
        Procedure                          CancelRange;
        //*******************************  Range Routines

        //*******************************  For TTable Compatibility
        Function                           Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean; override;
        Function                           Lookup(const KeyFields: string; const KeyValues: Variant; const ResultFields: string): Variant; override;
        Procedure                          RefreshLookups;

        Function                           CreateField(FieldName:String;FieldType:Integer;FiledSize:Integer):Boolean;
        Function                           CreateIndex(FieldName:String;IndexType:Integer):Boolean;
        Function                           DeleteField(FieldName:String):Boolean;
        Function                           DeleteIndex(FieldName:String):Boolean;
        Function                           EmptyTable:Boolean;
        Procedure                          CreateTable;
        Procedure                          AppendTable;

        Function                           CompareBookmarks(Const Bookmark1, Bookmark2: TBookmark): Integer; override;
        Function                           BookmarkValid(const Bookmark: TBookmark): Boolean; override;
        Function                           GetRows(NumRows:Integer):TObject;
        Function                           GetRawFieldData(FieldName : String):TObject;
        Function                           SetRawFieldData(FieldName : String; Value : TObject):Boolean;
        Function                           CopyQueryDef : QueryDef;
        Function                           CopyQueryDefText : String;
        Procedure                          AccessExportToTXT(FileName:String; IncludeBlobs, DeleteOld:Boolean);
        Procedure                          AccessExportToHTML(FileName:String; IncludeBlobs,DeleteOld:Boolean);
        Procedure                          AccessExportToExcel(FileName, SheetName :String; ExcelVersion:Integer; IncludeBlobs, DeleteOld:Boolean);
        Procedure                          AccessExportToParadox(FileName:String; ParadoxVersion:Integer; IncludeBlobs, DeleteOld:Boolean);
        Procedure                          AccessExportToDBase(FileName:String; DBaseVersion:Integer; IncludeBlobs, DeleteOld:Boolean);
        Procedure                          AccessExportToFoxPro(FileName:String; FoxProVersion:Integer; IncludeBlobs, DeleteOld:Boolean);
        Procedure                          AccessExportToMDB(FileName, NewTableName:String; IncludeBlobs, DeleteOld:Boolean);

        Function                           IsFieldUniqueIndex(Table : TKaDaoTable; FieldName : String ) : Boolean;
        Function                           GetUniqueIndexFields(Table : TKaDaoTable) : String;

        Function                           GetGUIDAsString(GUID : String):String;
        Function                           GetStringAsGUID(GUID : String):TGUID;
        Function                           PutGUIDInString(GUID : String):String;

        Function                           EscapeReservedChars(S:String):String;

        Property                           Bookmarkable           : Boolean         Read FBookmarkable;
        Property                           MasterLink             : TMasterDataLink Read FMasterLink;
        Property                           FieldNames             : TStrings        Read FFieldNames;
        Property                           SortFieldNames         : TStrings        Read FSortFieldNames;
        Property                           LinkableFields         : TStrings        Read FMDFieldNames;


        Property                           ParamCount              : Word read GetParamsCount;
        Function                           ExecSQL(SQL:TStrings):Integer;
        Function                           ExecSQLString(SQL:String):Integer;
        Function                           ExecuteSQL:Integer;
        Function                           ExecuteQueryDefSQL:Integer;

        Function                           Requery : Boolean;
        Procedure                          GotoCurrent(Table: TKADaoTable);

        Procedure                          GetIndexNames(List: TStrings);
        Procedure                          GetFieldNames(List: TStrings); Override;
        Function                           PercentPosition:Single;
        Function                           GetSourceFieldName(FieldName:String):String;
        Function                           GetSourceTableName(FieldName:String):String;
        Function                           GetLastDaoError:TDaoErrRec;
        Function                           PropertyExists(PropObject : Properties; PropertyName:String):Boolean;

        Procedure                          GetQueryDefParameters(FQD_ParamNames,FQD_ParamDaoTypes, FQD_ParamBDETypes:TStringList);
        Function                           PromptQueryDefParameters:Boolean;

        Procedure                          Sort;

        //**************************************************** Storage Functions
        Function                           StoreField(X:Integer): Boolean;
        Procedure                          SaveToStream(Stream: TStream);
        Procedure                          SaveToFile(const FileName: String);

        Procedure                          LoadFromStream(Stream: TStream; Mode : TLoadMode);
        Procedure                          LoadFromFile(const FileName: String; Mode : TLoadMode);
        //**********************************************************************
  published
        Property AutoFindIndex           : Boolean Read FAutoFindIndex Write FAutoFindIndex;
        Property ComponentVersion        : String  Read FComponentVersion Write SetComponentVersion;
        Property CacheBlobs              : Boolean Read FCacheBlobs Write SetCacheBlobs;
        Property CacheMemos              : Boolean Read FCacheMemos Write SetCacheMemos;
        Property CacheLookups            : Boolean Read FCacheLookups Write SetCacheLookups;
        Property Database                : TKADaoDatabase Read GetDatabase Write SetDatabase;
        Property Encrypter               : TComponent Read FEncrypter Write SetEncrypter;
        Property ExportMethod            : TExportMethod Read FExportMethod Write FExportMethod;
        Property RefreshSorted           : Boolean Read FRefreshSorted Write FRefreshSorted;
        Property TableName               : String Read GetTableName Write SetTableName;
        Property SortedBy                : TStrings Read FSortedBy Write SetSort;
        Property SortedByText            : TStrings Read FSortedBy Write SetSort;
        Property QueryDefName            : String Read FQueryDefName Write SetQueryDefName;
        Property QueryDefParameters      : TStrings Read FQueryDefParameters Write SetQueryDefParameters;
        Property QueryDefParametersText  : TStrings Read FQueryDefParameters Write SetQueryDefParameters;
        Property QueryDefSQLText         : TStrings Read FQueryDefSQLText Write SetQueryDefSQLText;
        Property QueryDefSQLModify       : Boolean  Read FQueryDefCanModify Write FQueryDefCanModify;
        Property QueryDefODBCMaxRecords  : Integer Read FQueryDefMaxRecords Write FQueryDefMaxRecords;
        Property QueryDefType            : String Read GetQueryDefType Write FQueryDefType;
        Property SQL                     : TStrings Read FSQL Write SetSQL;
        Property ShowGUID                : Boolean Read FShowGUID Write SetShowGUID;
        Property Params                  : TParams read FParams Write SetParamsList Stored False;
        Property TableType               : Integer Read FTableType Write SetTableType;
        Property TableDateCreated        : String Read GetDateCreated Write FDateCreated;
        Property TableLastUpdated        : String Read GetLastUpdated Write FLastUpdated;
        Property Translation             : Boolean Read FTranslation Write FTranslation;
        Property LockType                : Integer Read FLockType Write SetLockType;
        Property OpenOptions             : TOOSet Read  FOpenOptions Write SetOpenOptions;
        Property FieldDefs;
        Property IndexDefs               : TKADaoIndexDefs  Read FIndexDefs Write FIndexDefs;
        Property IndexFieldCount         : Integer Read GetIndexFieldCount Write SetIndexFieldCount;
        Property IndexName               : String Read GetIndexName Write SetIndexName;
        Property ReadOnly                : Boolean Read FReadOnly Write SetReadOnly;
        Property LockEdits               : Boolean Read GetLockEdits Write SetLockEdits;
        Property MasterSource            : TDataSource Read GetMasterSource Write SetMasterSource;
        Property MasterFields            : TStrings Read FMasterFields Write SetMasterFields;
        Property MasterAutoActivate      : Boolean Read FMasterAutoActivate Write FMasterAutoActivate;
        Property DatabaseAutoActivate    : Boolean Read FDatabaseAutoActivate  Write FDatabaseAutoActivate;
        Property UseBrackets             : Boolean Read FUseBrackets Write FUseBrackets;
        Property UseCaptions             : Boolean Read FUseDisplayLabels Write FUseDisplayLabels;
        Property UseDaoProperties        : Boolean Read FUseDaoProperties Write FUseDaoProperties;
        Property UseGetRecNo             : Boolean Read FUseGetRecNo Write FUseGetRecNo;
        Property UseRecordCount          : Boolean Read FUseRecordCountCache Write FUseRecordCountCache;
        Property WarnOnBadDatabase       : Boolean Read FWarnOnBadDatabase Write FWarnOnBadDatabase;
        Property Filtered                : Boolean Read FFiltered Write SetFiltered;
        Property Filter                  : String  Read FFilter Write SetFilterText;
        Property OnExportProgress        : TExportProgressEvent Read FOnExportProgress Write FOnExportProgress;
        Property OnImportProgress        : TImportProgressEvent Read FOnImportProgress Write FOnImportProgress;
        Property OnFilterRecord          : TFilterRecordEvent read FOnFilterRecord write SetOnFilterRecord;
        Property ParamCheck              : Boolean Read FParamCheck Write FParamCheck;
        Property ProcessMessages         : Boolean Read FProcessMessages Write FProcessMessages;
        Property BeforeOpen;
        Property AfterOpen;
        Property BeforeClose;
        Property AfterClose;
        Property BeforeInsert;
        Property AfterInsert;
        Property BeforeEdit;
        Property AfterEdit;
        Property BeforePost;
        Property AfterPost;
        Property BeforeCancel;
        Property AfterCancel;
        Property BeforeDelete;
        Property AfterDelete;
        Property BeforeScroll;
        Property AfterScroll;
        Property OnCalcFields;
        Property OnDeleteError;
        Property OnEditError;
        Property OnNewRecord;
        Property OnPostError;
        Property AutoCalcFields;
        Property Active;
End;


  TKBlobStream = class(TMemoryStream)
  private
    FField      : TBlobField;
    FDataSet    : TKADaoTable;
    FMode       : TBlobStreamMode;
    FOpened     : Boolean;
    FModified   : Boolean;
  public
    constructor Create(Field: TBlobField; Mode: TBlobStreamMode);
    destructor Destroy; override;
    function   Write(const Buffer: array of Byte; Offset, Count: Longint): Longint; override;
    Procedure  Truncate;
  End;



Procedure Register;

implementation
Uses
  Borland.Vcl.Dialogs,
  Borland.Vcl.ActiveX,
  KA.Data.KADao.QueryDefDialogUnit,
  KA.Data.KADao.DaoUtils;

Const
  CRLF                           = #13+#10;
//******************************************************************************
Constructor TKADaoIndexDefs.Create(DataSet: TDataSet);
Begin
  Inherited Create(Dataset);
  FDataSet := Dataset As TKADaoTable;
End;

//******************************************************************************
// Warning!  This Routine temporary closes the KAdaoTable
//******************************************************************************
Procedure TKADaoIndexDefs.CreateIndex(IndexDef : TIndexDef);
Var
  FieldsList     : TStringList;
  DescFieldsList : TStringList;
  NewTable       : TableDef;
  NewField       : Field;
  NewIndex       : Index;
  X              : Integer;
  Reopen         : Boolean;
Begin
 if FDataSet.FTableName='' Then Exit;
 if FDataset.FDatabase.TableNames.IndexOf(FDataSet.FTableName)=-1 Then Exit;
 FieldsList     := TStringList.Create;
 DescFieldsList := TStringList.Create;
 Try
   Reopen := False;
   Try
     FDataSet.StringToList(IndexDef.Fields,FieldsList);
     FDataSet.StringToList(IndexDef.DescFields,DescFieldsList);
     For X := 0 To FieldsList.Count-1 do
         Begin
            If FDataset.FieldNames.IndexOf(FieldsList.Strings[X]) = -1 Then Exit;
         End;
    For X := 0 To DescFieldsList.Count-1 do
         Begin
            If FDataset.FieldNames.IndexOf(DescFieldsList.Strings[X]) = -1 Then Exit;
         End;
    if FDataSet.Active Then
       Begin
          Reopen := True;
          FDataSet.Close;
       End;
    FDataSet.FDatabase.RefreshDefinitions;
    NewTable  := FDataSet.FDatabase.CoreDatabase.TableDefs.Item[FDataSet.FTableName];
    NewIndex  := NewTable.CreateIndex(IndexDef.Name);
    if (ixPrimary in IndexDef.Options) Then NewIndex.Primary  := True;
    if (ixUnique  in IndexDef.Options) Then NewIndex.Unique  := True;
    For X := 0 To FieldsList.Count-1 do
        Begin
          NewField       := FieldClass.Create;
          NewField.Name  := FieldsList.Strings[X];
          IndexFields(NewIndex.Fields).Append(NewField);
        End;
    For X := 0 To DescFieldsList.Count-1 do
        Begin
          NewField            := FieldClass.Create;
          NewField.Name       := DescFieldsList.Strings[X];
          NewField.Attributes := NewField.Attributes OR dbDescending;
          IndexFields(NewIndex.Fields).Append(NewField);
        End;
    NewTable.Indexes.Append(NewIndex);
    FDataSet.FDatabase.RefreshDefinitions;
   Finally
     if Reopen Then FDataSet.Open;
   End;
 Finally
   FieldsList.Free;
   DescFieldsList.Free;
 End;
End;

Procedure TKADaoIndexDefs.UpdateIndexes;
Var
  SL      : TStringList;
  X       : Integer;
Begin
  SL := TStringList.Create;
  Try
    FDataSet.GetIndexNames(SL);
    For X := 0 To Count-1 do
        Begin
          if SL.IndexOf(Items[X].Name) = -1 Then
             Begin
               CreateIndex(Self.Items[X]);
             End;
        End;
    For X := 0 To SL.Count-1 do
        Begin
          if Self.IndexOf(SL.Strings[X])=-1 Then
             Begin
               DeleteIndex(SL.Strings[X]);
             End;
        End;
  Finally
    SL.Free;
    FDataset.InternalInitIndexDefs;
  End;
End;

//******************************************************************************
// Warning!  This Routine temporary closes the KAdaoTable
//******************************************************************************
Function TKADaoIndexDefs.DeleteIndex(const Name : string):Boolean;
Var
  Reopen : Boolean;
Begin
  Result := False;
  if FDataSet.FTableName='' Then Exit;
  Reopen := False;
  Try
    if FDataSet.Active Then
       Begin
         Reopen := True;
         FDataSet.Close;
       End;
    FDataSet.FDatabase.DeleteIndexByName(FDataSet.FTableName,Name);
    Result := True;
  Finally
    if Reopen Then FDataSet.Open;
  End;
End;
//******************************************************************************

constructor TKADaoTable.Create(AOwner: TComponent);
Var
  X        : Integer;
Begin
  inherited Create(AOwner);
  Randomize;               
  MainDatabaseShutdown   := False;
  FComponentVersion     := '9.00.NET';
  FTableName            := '';
  FTableType            := dbOpenDynaset;
  FLockType             := dbOptimistic;
  FEncrypter            := Nil;
  FHasEncoder           := False;
  FOpenOptions          := [];
  FReadOnly             := False;
  FProcessMessages      := False;
  FRefreshSorted        := False;
  FTranslation          := False;
  FQueryDefName         := '';
  FQueryDefSQLText      := TStringList.Create;
  FQueryDefSQLText.Clear;
  FQueryDefMaxRecords   := 0;
  FQueryDefType         := '';
  QueryDefTypeInt        := 0;
  FQueryDefCanModify    := False;
  RecordsAffected        := 0;
  FSQL                  := TStringList.Create;
  FSQL.Clear;
  FSortedBy             := TStringList.Create;
  FSortedBy.Clear;
  FFieldNames           := TStringList.Create;
  FFieldNames.Clear;
  FSortFieldNames       := TStringList.Create;
  FSortFieldNames.Clear;
  FFieldTypeNames       := TStringList.Create;
  FFieldTypeNames.Clear;
  FDefaultValues        := TStringList.Create;
  FDefaultValues.Clear;
  FMDFieldNames         := TStringList.Create;
  FDisplayLabels        := TStringList.Create;
  FMDFieldNames.Clear;
  FDateCreated          := '';
  FLastUpdated          := '';
  //****************************************************************************
  FQD_ParamNames        := TStringList.Create;
  FQD_ParamNames.Clear;
  FQD_ParamDaoTypes     := TStringList.Create;
  FQD_ParamDaoTypes.Clear;
  FQD_ParamBDETypes     := TStringList.Create;
  FQD_ParamBDETypes.Clear;

  FQueryDefParameters   := TStringList.Create;
  FQueryDefParameters.Clear;
  SQLExecutionType      := KA.Data.KADao.DaoApi.dbFailOnError;
  //****************************************************************************
  FFindKeyFields        := '';
  FFindKeyValues        := Null;
  FFindOptions          := [];
  FExportMethod         := VisibleFields;

  FKeyKeyFields         := '';
  FKeyKeyValues         := Null;
  //****************************************************************************
  FMDisabled                   := False;
  FMasterFields                := TStringList.Create;
  FMasterFields.Clear;
  FMasterLink                  := TMasterDataLink.Create(Self);
  FMasterLink.OnMasterChange   := MasterChanged;
  FMasterLink.OnMasterDisable  := MasterDisabled;
  FDetail               := TStringList.Create;
  FDetail.Clear;
  FMaster               := TStringList.Create;
  FMaster.Clear;
  //****************************************************************************

  FKeyFields            := TStringList.Create;
  FKeyFields.Clear;
  FUpdatableFields      := TList.Create;
  FUpdatableFields.Clear;

  FBookmarkRN           := TList.Create;
  FBookmarkRN.Clear;
  FBookmarkID           := TList.Create;
  FBookmarkID.Clear;
  FBookmarkable         := False;
  FPostMade             := False;
  FInPost               := False;
  FBatchMode            := False;

  FUseBrackets          := True;
  FMasterAutoActivate   := True;
  FDatabaseAutoActivate := False;
  FUseRecordCountCache  := True;
  FUseGetRecNo          := True;
  FUseDisplayLabels     := False;
  FUseDaoProperties     := True;
  FAutoFindIndex        := True;

  FFiltered             := False;
  FRangeFiltered        := False;
  //************************************************************
  FDatabase             := Nil;
  FOldValue             := Nil;
  FWarnOnBadDatabase    := False;
  FCacheMemos           := False;
  FCacheBlobs           := False;
  FCacheLookups         := False;
  FShowGUID             := True; 
  //************************************************************
  TStringList(FSQL).OnChange := UpdateParamsList;
  FParamCheck                := True;
  FParams                    := TParams.Create(Self);
  //************************************************************
  FDetailRecordset  := NIL;
  FOnFilterRecord   := Nil;
  FOnExportProgress := Nil;
  FOnImportProgress := Nil;

  //**************************************************************** Com Cashing
  SetLength(DaoFields,0);
  //****************************************************************************
  FIndexDefs := TKADaoIndexDefs.Create(Self);
  //****************************************************************************
  DaoOpenOptions := 0;
  DaoSortString  := '';
  Letters        := '_';
  For X := 32 to 255 do
      Begin
        if IsCharAlphaNumeric(CHR(X)) Then Letters:=Letters+CHR(X);
      End;
  InInternalOpen := False;
End;

destructor TKADaoTable.Destroy;
Begin
  if FActive Then
      Begin
        Close;
        FActive:=False;
      End;
  //**************************************************************** Com Cashing
  SetLength(DaoFields,0);
  //****************************************************************************
  FSQL.Free;
  FSortedBy.Free;
  FFieldNames.Free;
  FSortFieldNames.Free;
  FFieldTypeNames.Free;
  FDefaultValues.Free;
  FMDFieldNames.Free;
  FDisplayLabels.Free;
  FQueryDefParameters.Free;
  FQueryDefSQLText.Free;
  FQD_ParamNames.Free;
  FQD_ParamDaoTypes.Free;
  FQD_ParamBDETypes.Free;
  FMasterLink.Free;
  FMasterFields.Free;
  FDetail.Free;
  FMaster.Free;
  FKeyFields.Free;
  FUpdatableFields.Free;

  FBookmarkRN.Free;
  FBookmarkID.Free;

  //****************************************************************************
  FIndexDefs.Free;
  //****************************************************************************

  FParams.Free;
  FDaoTable  := Nil;
  inherited Destroy;
End;

Function TKADaoTable.GetTickCountEx : Cardinal;
Begin
  Result := Abs(GetTickCount)+Random(10000);
End;

Function  TKADaoTable.GetDaoInfo(Buffer : TRecordBuffer):TDaoInfo;
Begin
 Result := TDaoInfo(Marshal.PtrToStructure(Buffer,TypeOF(TDaoInfo)));
End;

Procedure TKADaoTable.SetDaoInfo(Buffer : TRecordBuffer; Data :TDaoInfo);
Begin
 Marshal.StructureToPtr(Data,Buffer,False);
End;

Procedure TKADaoTable.SetComponentVersion(Value: String);
Begin
 //*************************** ReadOnly
End;

Function TKADaoTable.ExecSQL(SQL:TStrings):Integer;
Begin
 Result:=0;
 RecordsAffected:=Result;
 if Assigned(FDatabase) And (FDatabase.Connected) Then
    Begin
      FDatabase.CoreDatabase.Execute(FComposeSQL(SQL),TObject(SQLExecutionType));
      Result:=FDatabase.CoreDatabase.RecordsAffected;
      RecordsAffected:=Result;
    End
 Else
    DatabaseError(E2002);
End;

Function TKADaoTable.ExecSQLString(SQL:String):Integer;
Var
 SQ : TStringList;
Begin
 Result:=0;
 SQ := TStringList.Create;
 Try
  RecordsAffected:=Result;
  SQ.Text:=SQL;
  if Assigned(FDatabase) And (FDatabase.Connected) Then
    Begin
      FDatabase.CoreDatabase.Execute(FComposeSQL(SQ),TObject(SQLExecutionType));
      Result:=FDatabase.CoreDatabase.RecordsAffected;
      RecordsAffected:=Result;
    End
  Else
    DatabaseError(E2002);
 Finally
  SQ.Free;
 End;
End;

Function TKADaoTable.FRecalculateRecNo(TempRS:Recordset;BK:Integer):Integer;
Var
  FPP : Single;
  CR  : Integer;
  RC  : Integer;
Begin
  //******************************************************************* 2.1.2001
  Result := -1;
  if Not FUseGetRecNo Then Exit;
  //****************************************************************************
  FPP := TempRS.PercentPosition;
  //*************************************************** Decrease for calc errors
  FPP := FPP-2;
  if FPP < 0 Then FPP:=0;
  //****************************************************************************
  RC  := RecordCount;
  CR  := Round((FPP*(RC))/100);
  TempRS.MoveFirst;
  TempRS.Move(CR,Nil);
  //****************************************************************************
  While (NOT TempRS.EOF) And (GetDaoBookmark(TempRS) <> BK) do
    Begin
      TempRS.MoveNext;
      Inc(CR);
    End;
  //*************************************************************** Safety check
  if TempRS.EOF Then
     Begin
       CR  := 0;
       TempRS.MoveFirst;
       While GetDaoBookmark(TempRS) <> BK do
         Begin
          TempRS.MoveNext;
          Inc(CR);
         End;
     End;
  if TempRS.BOF Then
     Begin
       CR := RC;
       TempRS.MoveLast(0);
       While GetDaoBookmark(TempRS) <> BK do
         Begin
          TempRS.MovePrevious;
          Dec(CR);
         End;
     End;
  //****************************************************************************
  Result := CR;
End;

Function TKADaoTable.ExecuteSQL:Integer;
Begin
 Result:=0;
 RecordsAffected:=Result;
 if Assigned(FDatabase) And (FDatabase.Connected) Then
    Begin
      FDatabase.CoreDatabase.Execute(FComposeSQL(SQL),TObject(SQLExecutionType));
      Result:=FDatabase.CoreDatabase.RecordsAffected;
      RecordsAffected:=Result;
    End
 Else
    DatabaseError(E2003);
End;

Function TKADaoTable.ExecuteQueryDefSQL:Integer;
Var
 X         : Integer;
 TabN      : String;
 NRP       : Integer;
 Dir       : Integer;
Begin                                                        
 Result:=0;
 RecordsAffected:=Result;
 if Assigned(FDatabase) And (FDatabase.Connected) And (FQueryDefName <> '') Then
    Begin
      TabN:=FQueryDefName;
      NRP:=0;
      For X:=0 To Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count-1 do
          Begin
            Dir := FDatabase.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[TObject(X)].Direction;
            if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
                Begin
                 Try
                  if FQueryDefParameters.Strings[NRP]='NULL' Then
                     Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[TObject(X)].Value:=NULL
                  Else
                      Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[TObject(X)].Value:=FQueryDefParameters.Strings[NRP];
                  Inc(NRP);
                 Except
                  DatabaseError(E2004);
                 End;
                End;
          End;
      if FDatabase.QueryTimeout <> 60 Then
      FDatabase.CoreDatabase.QueryDefs.Item[FQueryDefName].ODBCTimeout:=FDatabase.QueryTimeout;
      FDatabase.CoreDatabase.QueryDefs.Item[FQueryDefName].Execute(TObject(SQLExecutionType));
      Result:=FDatabase.CoreDatabase.RecordsAffected;
      RecordsAffected:=Result;
      GetQueryDefReturnParams(FQueryDefName);
    End
 Else
    DatabaseError(E2005);
End;

Function  TKADaoTable.Requery : Boolean;
Var
 X         : Integer;
 TabN      : String;
 NRP       : Integer;
 Dir       : Integer;
Begin
  Result:=False;
  If Not FActive Then Exit;
  if Not FDaoTable.Restartable Then Exit;
  if (FQueryDefName <> '') Then
      Begin
        TabN:=FQueryDefName;
        NRP:=0;
        For X:=0 To Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count-1 do
          Begin
            Dir := FDatabase.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[TObject(X)].Direction;
            if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
                Begin
                 Try
                  if FQueryDefParameters.Strings[NRP]='NULL' Then
                     Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[TObject(X)].Value:=NULL
                  Else
                     Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[TObject(X)].Value:=FQueryDefParameters.Strings[NRP];
                  Inc(NRP);
                 Except
                  DatabaseError(E2006);
                 End;
                End;
          End;
      End;
  if (MasterSource <> NIL) And (Not FMDisabled) then
     Begin
       MasterDatasetChanged;
     End
  Else
     Begin
      CheckBrowseMode;
      InternalClearBookmarks;
      ClearBuffers;
      FDaoTable.Requery(Nil);
      FRefreshRC := True;
      ActivateBuffers;
      First;
     End;
  Result:=True;
End;

Procedure TKADaoTable.GotoCurrent(Table: TKADaoTable);
Begin
  CheckBrowseMode;
  Table.CheckBrowseMode;
  if (WideCompareText(FDatabase.Database, Table.Database.Database) <> 0)
  or (WideCompareText(TableName, Table.TableName) <> 0)
  or (WideCompareText(IndexName, Table.IndexName) <> 0) then
     DatabaseError(E2007);
  Table.UpdateCursorPos;
  CheckBrowseMode;
  First;
  MoveBy(Table.RecNo-1);
  Resync([rmExact, rmCenter]);
End;

Procedure TKADaoTable.GetIndexNames(List: TStrings);
Var
 Count,X : Integer;
Begin
  List.Clear;
  Try
    if Assigned(FDatabase) And (FDatabase.Connected) Then
     Begin
      FDatabase.RefreshDefinitions;
      Count :=FDatabase.CoreDatabase.TableDefs.Item[FTableName].Indexes.Count;
      For X := 0 to  Count-1 do
          Begin
            List.Add(FDatabase.CoreDatabase.TableDefs.Item[FTableName].Indexes.Item[TObject(X)].Name);
          End;
     End;
  Except
  End;
End;

Procedure TKADaoTable.GetFieldNames(List: TStrings);
Var
 X      : Integer;
 IsOpen : Boolean;
Begin
  List.Clear;
  IsOpen := Active;
  Try
    Try
      if Not IsOpen Then Open;
      For X := 0 To FieldCount-1 do
          Begin
            List.Add(Self.Fields[X].FieldName)
          End;
    Finally
      if (Not IsOpen) And (Active) Then Close;
    End;
  Except
  End;
End;

Function TKADaoTable.PercentPosition:Single;
Begin
 Result := -1;
 if NOT FActive  Then Exit;
 if FDaoTable.BOF Then Exit;
 if FDaoTable.EOF Then Exit;
 Try
    Result := FDaoTable.PercentPosition;
 Except
 End;
End;

Function  TKADaoTable.GetSourceFieldName(FieldName:String):String;
Begin
 Result :='';
 if Not FActive Then Exit;
 Try
   Result := FDaoTable.Fields.Item[FieldName].SourceField;
 Except
 End;
End;

Function  TKADaoTable.GetSourceTableName(FieldName:String):String;
Begin
 Result :='';
 if Not FActive Then Exit;
 Try
   Result := FDaoTable.Fields.Item[FieldName].SourceTable;
 Except
 End;
End;

Function  TKADaoTable.GetLastDaoError:TDaoErrRec;
Begin
  if Assigned(FDatabase) And (FDatabase.Connected) Then
     Result := FDatabase.GetLastDaoError;
End;

Function TKADaoTable.PropertyExists(PropObject : Properties; PropertyName : String):Boolean;
Var
  X : Integer;
Begin
  Result := False;
  For X := 0 to PropObject.Count-1 do
      Begin
        if WideCompareText(PropObject.Item[TObject(X)].Name,PropertyName)=0 Then
           Begin
             Result := True;
             Exit;
           End;
      End;
End;

Procedure TKADaoTable.GetQueryDefParameters(FQD_ParamNames,FQD_ParamDaoTypes, FQD_ParamBDETypes:TStringList);
Var
  X       : Integer;
  Dir     : Integer;
  NP      : Integer;
  Typ     : Integer;
Begin
  if NOT Assigned(FDatabase) Then Exit;
  if NOT (FDatabase.Connected) Then Exit;
  if FQueryDefName='' Then Exit;
  if Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count=0 Then
     Begin
      if (csDesigning in ComponentState) Then DatabaseError(E2008);
      Exit;
     End;
  FQD_ParamNames.Clear;
  FQD_ParamDaoTypes.Clear;
  FQD_ParamBDETypes.Clear;
  Try
     NP:=0;
     For X := 0 To Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count-1 do
        Begin
          Dir:= Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[TObject(X)].Direction;
          if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
             Begin
              Inc(NP);
              Typ :=Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[TObject(X)].&Type;
              if (Typ=dbDate) Then Typ:=dbTimeStamp;
              FQD_ParamNames.AddObject(Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[TObject(X)].Name,TObject(Typ));
              FQD_ParamDaoTypes.AddObject(GetDaoFieldTypeNames(Typ),TObject(Typ));
              FQD_ParamBDETypes.AddObject(GetBDEFieldTypeNames(DaoToBDE(Typ)),TObject(DaoToBDE(Typ)));
             End;
        End;
     if NP=0 Then
        Begin
           if (csDesigning in ComponentState) Then DatabaseError(E2009);
           Exit;
        End;
  Except
      DatabaseError(E2010);
      Exit;
  End;
End;

Function TKADaoTable.PromptQueryDefParameters:Boolean;
Begin
  Result := False;
  GetQueryDefParameters(FQD_ParamNames ,FQD_ParamDaoTypes, FQD_ParamBDETypes);
  if FQD_ParamNames.Count=0 Then Exit;
  Application.CreateForm(TQueryDefDialog,QueryDefDialog);
  Result := QueryDefDialog.Execute(FQD_ParamNames,FQD_ParamDaoTypes,FQD_ParamBDETypes,FQueryDefParameters);
  QueryDefDialog.Free;
End;

Function TKADaoTable.StoreField(X:Integer): Boolean;
Begin
   Case Fields[X].FieldKind of
        fkData       : Result := True;
        fkCalculated : Result := False;
        fkLookup     : Result := False;
   Else                Result := False;
   End;
   if NOT Fields[X].Visible Then Result := False;
End;


Procedure TKADaoTable.SaveToStream(Stream: TStream);
Var
   X          : Integer;
   Book       : TBookmark;
   Writer     : TWriter;
   Current    : Integer;
   Total      : Integer;
Begin
  if IsEmpty Then Exit;
  Book         := GetBookmark;
  Try
   DisableControls;
   Writer := TWriter.Create(Stream, 16384);
   Writer.WriteSignature;
   Try
   //*************************************************** Write Structure
   Writer.WriteListBegin;
   For X:=0 to FieldCount-1 do
       Begin
        If FProcessMessages Then Application.ProcessMessages;
        if StoreField(X) then
           Begin
            Writer.WriteString(Fields[X].FieldName);
            Writer.WriteString(FieldTypeNames[Fields[X].DataType]);
            Writer.WriteInteger(Fields[X].Size);
            Writer.WriteString(Fields[X].DisplayName);
            Writer.WriteString(Fields[X].EditMask);
            Writer.WriteInteger(Fields[X].DisplayWidth);
            Writer.WriteBoolean(Fields[X].Required);
            Writer.WriteBoolean(Fields[X].ReadOnly);
           End;
       end;
   Writer.WriteListEnd;

   //******************************************************** Write Data
   Total  := RecordCount-1;
   Current:=0;
   Writer.WriteListBegin;
   First;
   While Not EOF do
     Begin
      if Assigned(FOnExportProgress) Then FOnExportProgress(Current,Total);
      For X:=0 to FieldCount-1 do
        Begin
          If FProcessMessages Then Application.ProcessMessages;
          if StoreField(X) Then
             Begin
               Case Fields[X].DataType of
                    ftBoolean   : Writer.WriteBoolean(Fields[X].AsBoolean);
                    ftSmallInt  ,
                    ftInteger   ,
                    ftWord      ,
                    ftAutoInc   : Writer.WriteInteger(Fields[X].AsInteger);
                    ftFloat     : Writer.WriteFloat(Fields[X].AsFloat);
                    ftBCD       ,
                    ftCurrency  : Writer.WriteFloat(Fields[X].AsCurrency);
                    ftDate      ,
                    ftTime      ,
                    ftDateTime  : Writer.WriteFloat(Fields[X].AsFloat);
               Else
                    Writer.WriteString(Fields[X].AsString);
               End;
             End;
        End;
      Inc(Current);
      Next;
      FDatabase.Idle;
     End;
   Writer.WriteListEnd;
   Finally
     Writer.FlushBuffer;
     Writer.Free;
   End;
  Finally
    GotoBookmark(Book);
    EnableControls;
    FreeBookmark(Book);
  End;
End;

Procedure TKADaoTable.SaveToFile(const FileName: String);
Var
 Stream: TStream;
Begin
 Stream := TFileStream.Create(FileName, fmCreate);
 Try
  SaveToStream(Stream);
 Finally
  if Stream.Size=0 Then
     Begin
       Stream.Free;
       DeleteFile(FileName);
     End
  Else
     Begin
       Stream.Free;
     End;
 End;
End;

Procedure TKADaoTable.LoadFromStream(Stream: TStream; Mode : TLoadMode);
Var
  Reader       : TReader;
  FieldName    : String;
  DataTypeName : String;
  DisplayName  : String;
  EditMask     : String;
  DisplayWidth : Integer;
  Required     : Boolean;
  ReadOnly     : Boolean;
  I            : Integer;
  X            : Integer;
  Field        : TField;
  FNames       : TStringList;
  Book         : TBookmark;
  OK           : Boolean;
  Current      : LongInt;
  KbmFileVers  : Integer;
Begin
  if Not Active Then DatabaseError(E2058);
  if Mode = lmEmptyAppend Then EmptyTable;
  Book   := GetBookmark;
  Reader := TReader.Create(Stream, 16384);
  FNames := TStringList.Create;
  Try
   DisableControls;
   Reader.ReadSignature;
   if (Reader.NextValue = vaList) Then
       KbmFileVers := 100 Else
       KbmFileVers := Reader.ReadInteger;
   //************************************************************ Read Structure
   Reader.ReadListBegin;
     While (Not Reader.EndOfList) Do
      Begin
       If FProcessMessages Then Application.ProcessMessages;
       FieldName    := Reader.ReadString;
       DataTypeName := Reader.ReadString;
                       Reader.ReadInteger;
       DisplayName  := Reader.ReadString;
       EditMask     := Reader.ReadString;
       DisplayWidth := Reader.ReadInteger;
       Required     := Reader.ReadBoolean;
       ReadOnly     := Reader.ReadBoolean;
       if (KbmFileVers >= 250) Then Reader.ReadString;
       FNames.Add(FieldName);
       I := FieldDefs.IndexOf(FieldName);
       if I > -1 Then
          Begin
            Field:=FindField(FieldName);
            if Field <> Nil Then
               Begin
                Field.DisplayLabel := DisplayName;
                Field.EditMask     := EditMask;
                Field.DisplayWidth := DisplayWidth;
                Field.Required     := Required;
                Field.ReadOnly     := ReadOnly;
              End
            Else
              DatabaseError(E2059);
          End
       Else
         DatabaseError(E2059);
     End;
   Reader.ReadListEnd;
   //***************************************************************** Read Data
   Last;
   Reader.ReadListBegin;
   Try
     FDatabase.StartTransaction;
   Except
   End;
   Current := 0;
   While (NOT Reader.EndOfList) do
    Begin
     if Assigned(FOnImportProgress) Then FOnImportProgress(Current);
     OK := False;
     For X :=0 to FNames.Count-1 do
         Begin
          If FProcessMessages Then Application.ProcessMessages;
          Field := FindField(FNames.Strings[X]);
          if (Field <> Nil) Then
             Begin
               if NOT OK Then
                  Begin
                    OK := True;
                    Insert;
                  End;
               Case Field.DataType of
                    ftBoolean  : if Not Field.ReadOnly Then Field.AsBoolean  := Reader.ReadBoolean Else Reader.ReadBoolean;
                    ftSmallInt ,
                    ftInteger  ,
                    ftWord     ,
                    ftAutoInc  : if Not Field.ReadOnly Then Field.AsInteger  := Reader.ReadInteger Else Reader.ReadInteger;
                    ftFloat    : if Not Field.ReadOnly Then Field.AsFloat    := Reader.ReadFloat   Else Reader.ReadFloat;
                    ftBCD,
                    ftCurrency : if Not Field.ReadOnly Then Field.AsCurrency := Reader.ReadFloat   Else Reader.ReadFloat;
                    ftDate     ,
                    ftTime     ,
                    ftDateTime : if Not Field.ReadOnly Then Field.AsFloat    := Reader.ReadFloat   Else Reader.ReadFloat;
               Else
                    Begin
                      if Not Field.ReadOnly Then            Field.AsString   := Reader.ReadString  Else Reader.ReadString;
                    End;
               End;
             End;
         End;
     if OK Then Post;
     FDatabase.Idle;
     Inc(Current);
    End;
   Try
     FDatabase.Commit;
   Except
   End;
   Reader.ReadListEnd;
  Finally
   Reader.Free;
   FNames.Free;
   if Mode = lmAppend Then GotoBookmark(Book);
   EnableControls;
   FreeBookmark(Book);
  End;
End;


Procedure TKADaoTable.LoadFromFile(const FileName: String; Mode : TLoadMode);
Var
 Stream: TStream;
Begin
 if Not Active Then DatabaseError(E2058);
 Stream := TFileStream.Create(FileName, fmOpenRead);
 Try
  LoadFromStream(Stream, Mode);
 Finally
  Stream.Free;
 End;
End;

Function TKADaoTable.GetDatabase:TKADaoDatabase;
Begin
 Result:=FDatabase;
End;

Procedure TKADaoTable.SetDatabase(Value:TKADaoDatabase);
Begin
 if Active Then DatabaseError(E2011);
 if Assigned(FDatabase) Then FDatabase.RemoveFreeNotification(Self);
 FDatabase := Value;
 if Assigned(FDatabase) Then FDatabase.FreeNotification(Self);
End;

Function TKADaoTable.GetDateCreated:String;
Begin
 Result := '';
 if FActive Then
    Begin
     Try
      if TableType=dbOpenTable Then Result := FDaoTable.DateCreated.ToString
      Else
      if FQueryDefName <> '' then Result:=Database.CoreDatabase.QueryDefs.Item[FQueryDefName].DateCreated.ToString;
     Except
     End;
    End;
End;

Function TKADaoTable.GetLastUpdated:String;
Begin
 Result := '';
 if FActive Then
    Begin
     Try
      if TableType=dbOpenTable Then Result:=FDaoTable.LastUpdated.ToString
      Else
      if FQueryDefName <> '' then Result:=Database.CoreDatabase.QueryDefs.Item[FQueryDefName].LastUpdated.ToString;
     Except
     End;
    End;
End;

Function TKADaoTable.GetTableName:String;
Begin
 Result:= FTableName;
End;

Procedure TKADaoTable.SetTableName(Value:String);
Begin
  if Active Then DatabaseError(E2012);
  FTableName:=Value;
  if Value <> '' Then
     Begin
      FIndexName:='';
      FSQL.Clear;
      FQueryDefName:='';
      FQueryDefSQLText.Clear;
      FQueryDefParameters.Clear;
      FSortedBy.Clear;
      FDisplayLabels.Clear;
      FieldDefs.Clear;
      IndexDefs.Clear;
     End;
End;

Procedure TKADaoTable.SetSQL(Value:TStrings);
Begin
 FSQL.Assign(Value);
 if Length(Value.Text) > 0 Then
    Begin
     FQueryDefParameters.Clear;
     FQueryDefSQLText.Clear;
     FQueryDefName:='';
     FIndexName:='';;
     FTableName:='';
     FDisplayLabels.Clear;
     FieldDefs.Clear;
     IndexDefs.Clear;
    End;
End;

Procedure TKADaoTable.SetQueryDefName(Value:String);
Begin
  if FActive Then DatabaseError(E2065);
  Try
    if Assigned(FDatabase) And (FDatabase.Connected) Then
       Begin
         FQueryDefSQLText.Clear;
         if Value <> '' Then FQueryDefSQLText.Text := FDatabase.GetQueryDefSQLText(Value);
       End;
  Except
  End;
  FQueryDefName:=Value;
  FQueryDefType:=GetQueryDefType;
  if Value <> '' Then
     Begin
      FIndexName:='';
      FTableName:='';
      FSQL.Clear;
      FQueryDefParameters.Clear;
      FMaster.Clear;
      FDetail.Clear;
      FMasterFields.Clear;
      FDisplayLabels.Clear;
      FieldDefs.Clear;
      IndexDefs.Clear;
      if (FTableType=dbOpenTable)
      Or (FTableType=dbOpenDynamic) Then FTableType:=dbOpenDynaset;
     End;
End;



Function TKADaoTable.GetIndexName:String;
Begin
 Result:= FIndexName;
End;

Procedure TKADaoTable.SetIndexName(Value:String);
Begin
  if Active Then
     Begin
       if (TableType=dbOpenTable) Then
          Begin
             FSortedBy.Clear;
             FDaoTable.Index  := Value;
             CheckBrowseMode;
             ClearBuffers;
             FRefreshRC := True;
             ActivateBuffers;
             First;
          End
       Else if Value <> '' Then DatabaseError(E2013);
     End
   Else
     Begin
       if (TableType=dbOpenTable) And (Value <> '') Then
          Begin
            FSortedBy.Clear;
          End
       Else
          Begin
            if Value <> '' Then DatabaseError(E2013);
          End;
     End;
  FIndexName:=Value;
End;

Function  TKADaoTable.GetIndexFieldNames:String;
Var
  X     : Integer;
  Count : Integer;
Begin
  Result := '';
  if FIndexName='' Then Exit;
  Try
    Count := KA.Data.Dao360.IndexFields(FDatabase.CoreDatabase.TableDefs.Item[FTableName].Indexes.Item[FIndexName].Fields).Count-1;
    For X := 0 To Count do
      Begin
        if X = Count Then
           Result := Result + Field(KA.Data.Dao360.IndexFields(FDatabase.CoreDatabase.TableDefs.Item[FTableName].Indexes.Item[FIndexName].Fields).Item[TObject(X)]).Name
        Else
           Result := Result + Field(KA.Data.Dao360.IndexFields(FDatabase.CoreDatabase.TableDefs.Item[FTableName].Indexes.Item[FIndexName].Fields).Item[TObject(X)]).Name+';';
      End;
  Except
  End;
End;

Function  TKADaoTable.GetIndexFieldCount:Integer;
Begin
 FIndexFieldCount := 0;
 if  (TableType=dbOpenTable)
 And (Assigned(FDatabase))
 And (FDatabase.Connected)
 And (FTableName <> '')
 And (FIndexName <> '') Then
     Begin
      Try
       FIndexFieldCount := KA.Data.Dao360.IndexFields(FDatabase.CoreDatabase.TableDefs.Item[FTableName].Indexes.Item[FIndexName].Fields).Count;
      Except
       On E:Exception do
          Begin
            FIndexFieldCount := 0;
          End;
      End;
     End;
 Result := FIndexFieldCount;
End;

Procedure TKADaoTable.SetIndexFieldCount(Value:Integer);
Begin
 //******************************************************************* Read Only
End;

Function  TKADaoTable.FindGoodIndex(KeyFields:String):String;
Var
  KFL    :  TStringList;
  IFL    :  TStringList;
  X,Y    :  Integer;
  BR     :  Integer;
  Exact  :  Boolean;
  Value  :  String;
Begin
  Result := '';
  //****************************************************************************
  if IndexDefs.Count=0 Then Exit;
  if TableType <> dbOpenTable then Exit;
  if KeyFields='' Then Exit;
  Value := KeyFields;
  if Value[1]='!' Then
     Begin
      Exact:=True;
      Borland.Delphi.System.Delete(Value,1,1);
     End
  Else
     Begin
       Exact:=False;
     End;
  if Value = '' Then Exit;
  //****************************************************************************

  KFL := TStringList.Create;
  IFL := TStringList.Create;
  Try
    StringToList(Value,KFL);
    For X := 0 To IndexDefs.Count-1 Do
      Begin
        StringToList(IndexDefs.Items[X].Fields,IFL);
        if Exact Then
           Begin
             if IFL.Count = KFL.Count Then
                Begin
                  BR:=0;
                  For Y := 0 to KFL.Count-1 do
                    Begin
                      if NOT (IFL.IndexOf(KFL.Strings[Y]) < 0) Then Inc(BR);
                    End;
                  if BR=KFL.Count Then
                     Begin
                      Result := IndexDefs.Items[X].Name;
                      Exit;
                     End;
                End;
           End
        Else
           Begin
             if IFL.Count >= KFL.Count Then
                Begin
                   BR:=0;
                   For Y := 0 to KFL.Count-1 do
                    Begin
                      if NOT (IFL.IndexOf(KFL.Strings[Y]) < 0) Then Inc(BR);
                    End;
                   if BR=KFL.Count Then
                      Begin
                       Result:=IndexDefs.Items[X].Name;
                       if KFL.IndexOf(IFL.Strings[0]) <> -1 Then Exit;
                      End;
                 End;
           End;
      End;
  Finally
    KFL.Free;
    IFL.Free;
  End;
End;

Procedure TKADaoTable.SetIndexFieldNames(Value:String);
Var
  S : String;
Begin
  if TableType <> dbOpenTable then Exit;
  if Value='' Then
     Begin
       SetIndexName(Value);
       Exit;
     End;
  S:=FindGoodIndex(Value);
  if S <> '' Then SetIndexName(S);
End;

Function TKADaoTable.GetIndexField(Index: Integer): TField;
Var
 FieldName : String;
Begin
 Result := Nil;
 if NOT Active Then DatabaseError(E2014);
 if FIndexName='' Then Exit;
 Try
   FieldName  := Field(KA.Data.Dao360.IndexFields(FDatabase.CoreDatabase.TableDefs.Item[FTableName].Indexes.Item[FIndexName].Fields).Item[TObject(Index)]).Name;
 Except
  Exit;
 End;
 Result := FindField(FieldName);
End;

Procedure TKADaoTable.SetIndexField(Index: Integer; Value: TField);
Begin
 //******************************************************************* Read Only
End;

Procedure TKADaoTable.FSetBatchMode(Value:Boolean);
Begin
 FBatchMode := Value;
 if Value Then DisableControls Else EnableControls; 
 if Not Value Then
    Begin
      Resync([]); //************************************** 3.1.2002
      if FUseGetRecNo Then GetRecNo;  
    End;
End;

Procedure TKADaoTable.SetTableType(Value:Integer);
Begin
  if Active Then DatabaseError(E2015);
  FTableType:=Value;
  if FTableType=dbOpenTable Then
     Begin
       FSortedBy.Clear;
     End
  Else
     Begin
       FIndexName:='';
       IndexDefs.Clear;
     End;
  if FTableType=dbOpenForwardOnly Then FSortedBy.Clear;
End;

Procedure TKADaoTable.SetLockType(Value:Integer);
Begin
  if Active Then DatabaseError(E2016);
  FLockType:=Value;
End;

Procedure TKADaoTable.SetOpenOptions(Value:TOOSet);
Begin
  FOpenOptions:=Value;
  if FActive Then
     Begin
       CheckBrowseMode;
       ClearBuffers;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
End;

Procedure TKADaoTable.LockTable(LockType: TLockType);
Var
  OO:TOOSet;
Begin
  if LockType = ltReadLock  Then OO := FOpenOptions+[dbDenyRead];
  if LockType = ltWriteLock Then OO := FOpenOptions+[dbDenyWrite];
  if Active Then SetOpenOptions(OO);
End;

Procedure TKADaoTable.UnlockTable(LockType: TLockType);
Var
  OO:TOOSet;
Begin
  if LockType = ltReadLock  Then OO := FOpenOptions-[dbDenyRead];
  if LockType = ltWriteLock Then OO := FOpenOptions-[dbDenyWrite];
  if Active Then SetOpenOptions(OO);
End;

Procedure TKADaoTable.SetReadOnly(Value:Boolean);
Begin
  if Assigned(FDatabase) And (FDatabase.Connected) and (FDatabase.ReadOnly) And (NOT Value) Then
     Begin
       Value := True;
     End;
  FReadOnly:=Value;
End;

Procedure TKADaoTable.SetLockEdits(LockEdits : Boolean);
Begin
  if  (Active)
  And (FDatabase.DatabaseType <> 'ODBC')
  And (NOT FDatabase.ReadOnly)
  And (NOT FReadOnly)
  And ((FTableType = dbOpenTable) Or (FTableType = dbOpenDynaset)) Then
      Begin
        FDaoTable.LockEdits := LockEdits;
      End;
End;

Function TKADaoTable.GetLockEdits:Boolean;
Begin
  Result := False;
  if  (Active)
  And (FDatabase.DatabaseType <> 'ODBC')
  And (NOT FDatabase.ReadOnly)
  And (NOT FReadOnly)
  And ((FTableType = dbOpenTable) Or (FTableType = dbOpenDynaset)) Then
      Begin
        Result := FDaoTable.LockEdits;
      End;
End;

Procedure TKADaoTable.SetSort(Value:TStrings);
Begin
 FSortedBy.Assign(Value);
 FIndexName:='';
 if FActive Then
    Begin
     CheckBrowseMode;
     ClearBuffers;
     CloseDaoRecordset;
     OpenDaoRecordset;
     ActivateBuffers;
     First;
    End;
End;

Procedure TKADaoTable.Sort;
Begin
 if FActive Then
    Begin
     CheckBrowseMode;
     ClearBuffers;
     CloseDaoRecordset;
     OpenDaoRecordset;
     ActivateBuffers;
     First;
    End;
End;

Procedure TKADaoTable.SetQueryDefParameters(Value:TStrings);
Begin
 FQueryDefParameters.Assign(Value);
End;

Procedure TKADaoTable.SetQueryDefSQLText(Value:TStrings);
Begin
 if  (Assigned(FDatabase))
 And (FDatabase.Connected)
 And (Not FActive)
 And (FQueryDefName <> '')
 And (FQueryDefCanModify)
 And (Not (csLoading in ComponentState)) Then
     Begin
      if FDatabase.QueryDefNames.IndexOf(FQueryDefName) <> -1 Then
         FDatabase.ModifyQueryDef(FQueryDefName,FComposeSQL(Value))
      Else
         FDatabase.CreateQueryDef(FQueryDefName,FComposeSQL(Value));
      FDatabase.RefreshDefinitions;
      QueryDefName := FQueryDefName;
     End;
End;

Function TKADaoTable.GetQueryDefType:String;
Var
 QDType : Integer;
Begin
 Result:='';
 QueryDefTypeInt:=0;
 Try
  if Assigned(FDatabase) And (FDatabase.Connected) And (FQueryDefName <> '') Then
    Begin
      QDType:=Database.CoreDatabase.QueryDefs.Item[FQueryDefName].&Type;
      if QDType=dbQSelect         Then Begin Result := 'dbQSelect'        ; QueryDefTypeInt := dbQSelect         ; End;
      if QDType=dbQProcedure      Then Begin Result := 'dbQProcedure'     ; QueryDefTypeInt := dbQProcedure      ; End;
      if QDType=dbQAction         Then Begin Result := 'dbQAction'        ; QueryDefTypeInt := dbQAction         ; End;
      if QDType=dbQCrosstab       Then Begin Result := 'dbQCrosstab'      ; QueryDefTypeInt := dbQCrosstab       ; End;
      if QDType=dbQDelete         Then Begin Result := 'dbQDelete'        ; QueryDefTypeInt := dbQDelete         ; End;
      if QDType=dbQUpdate         Then Begin Result := 'dbQUpdate'        ; QueryDefTypeInt := dbQUpdate         ; End;
      if QDType=dbQAppend         Then Begin Result := 'dbQAppend'        ; QueryDefTypeInt := dbQAppend         ; End;
      if QDType=dbQMakeTable      Then Begin Result := 'dbQMakeTable'     ; QueryDefTypeInt := dbQMakeTable      ; End;
      if QDType=dbQDDL            Then Begin Result := 'dbQDDL'           ; QueryDefTypeInt := dbQDDL            ; End;
      if QDType=dbQSQLPassThrough Then Begin Result := 'dbQSQLPassThrough'; QueryDefTypeInt := dbQSQLPassThrough ; End;
      if QDType=dbQSetOperation   Then Begin Result := 'dbQSetOperation'  ; QueryDefTypeInt := dbQSetOperation   ; End;
      if QDType=dbQSPTBulk        Then Begin Result := 'dbQSPTBulk'       ; QueryDefTypeInt := dbQSPTBulk        ; End;
      if QDType=dbQCompound       Then Begin Result := 'dbQCompound'      ; QueryDefTypeInt := dbQCompound       ; End;
    End;
 Except
 End;
End;

Function TKADaoTable.WWStringReplace(Src,Pattern,Repl:String):String;
Var
  S  : String;
  Pat: String;
  L  : Integer;
  P  : Integer;
  PR : Integer;
Begin
  Result := Src;
  L := Length(Result);
  if L=0 Then Exit;
  Result := '';
  S   := ' '+WideLowerCase(Src)+' ';
  Pat := WideLowerCase(Pattern);
  L   := Length(Pat);
  Repeat
    P := Pos(Pat,S);
    if P > 0 Then
       Begin
        PR := P-1;
        if  (Pos(S[P-1],Letters) = 0)
        And (Pos(S[P+L],Letters) = 0) Then
          Begin
            Result := Result+Borland.Delphi.System.Copy(Src,1,PR-1);
            Result := Result+Repl;
          End
        Else
          Begin
           Result := Result+Borland.Delphi.System.Copy(Src,1,PR+L-1);
          End;
        Borland.Delphi.System.Delete(S,1,P+L-1);
        Borland.Delphi.System.Delete(Src,1,PR+L-1);
        S:=' '+S;
       End;
  Until P =0;
  Result := Result+Src;
End;

Function TKADaoTable.ChangeOnlyQuotes(S:String):String;
Var
 X, L : Integer;
Begin
 Result := '';
 L      := Length(S);
 if L   =  0 Then Exit;
 For X := 1 To L do
     Begin
       Result := Result+S[X];
       if S[X]='"'   Then Result := Result+'"';
     End;
End;

Function TKADaoTable.ChangeQuotes(S:String):String;
Var
 X, L : Integer;
Begin
 Result := '';
 L      := Length(S);
 if L   =  0 Then Exit;
 For X := 1 To L do
     Begin
       if (S[X]='*')
       Or (S[X]='?')
       Or (S[X]='#')
       Or (S[X]='[')
       Or (S[X]=']')
       Or (S[X]='!')
       Or (S[X]='-') Then Result := Result+'[';
       Result := Result+S[X];
       if (S[X]='*')
       Or (S[X]='?')
       Or (S[X]='#')
       Or (S[X]='[')
       Or (S[X]=']')
       Or (S[X]='!')
       Or (S[X]='-') Then Result := Result+']';
     End;
End;

Function TKADaoTable.ChangeCommas(S:String):String;
Var
 X, L : Integer;
Begin
 Result := '';
 L      := Length(S);
 if L   =  0 Then Exit;
 For X := 1 To L do
     Begin
       if S[X]=DecimalSeparator Then
          Result := Result+'.'
       Else
       if S[X]<> ThousandSeparator Then Result := Result+S[X];
     End;
End;

Function TKADaoTable.EscapeReservedChars(S:String):String;
Begin
  Result := ChangeQuotes(S);
End;

Function TKADaoTable.FComposeSQL(SQL:TStrings):String;
Var
 X       : Integer;
 S, Sep  : String;
Begin
 Result := SQL.Text;
 if FParamCheck then
    Begin
      For X := 0 to FParams.Count - 1 do
        Begin
            if FParams[X].IsNull Then
               Begin
                 S := ' IS NULL';
               End
            Else
               Begin
                 Case FParams[X].DataType of
                      ftDateTime   ,
                      ftDate       ,
                      ftTime       : Sep := '#';
                      ftUnknown    : Sep := '';
                      ftBlob       ,
                      ftMemo       ,
                      ftString     : Sep := '"';
                 Else
                      Sep := '';
                 end;
                 //******************************************************* 04.10.2001
                 Case FParams[X].DataType of
                      ftBytes   : Begin
                                    S:= Sep + '{guid '+GetGUIDAsString(FParams[X].AsString)+'}'   + Sep;
                                  End;
                      ftDate    : Begin
                                    S:= Sep + FormatDateTime('mm"/"dd"/"yyyy', FParams[X].AsDate) + Sep;
                                  End;
                      ftTime    : Begin
                                    S:= Sep + FormatDateTime('hh":"nn":"ss', FParams[X].AsTime)   + Sep;
                                  End;
                      ftDateTime: Begin
                                    S:= Sep + FormatDateTime('mm"/"dd"/"yyyy hh":"nn":"ss', FParams[X].AsDateTime) + Sep;
                                  End;
                      ftBlob    ,
                      ftMemo    ,
                      ftString  : Begin
                                    S := Sep + ChangeOnlyQuotes(FParams[X].AsString) + Sep;
                                  End;
                      ftBCD     ,
                      ftCurrency,
   		      ftFloat   :  Begin
                                    S := Sep + ChangeCommas(FParams[X].AsString) + Sep;
                                  End;
                      Else
                         S := Sep + FParams[X].AsString + Sep;
                 End;
                //******************************************************************
               End;
            Result := WWStringReplace(Result, ':' + FParams[X].Name, S);
        end;
    End;
End;

Function TKADaoTable.ComposeFilter:String;
Begin
   if FFiltered Then Result := FFilter Else Result := '';
   if (MasterSource <> NIL) And (Not(FMDisabled)) And (MasterSource.Enabled)  then
       Begin
         FProcessMasterFields(FMasterFields);
         if (FMaster.Count > 0) Then
             Begin
               Result := BuildDetailSQL;
               Result := InsertSQLString(Result);
              End;
       End;
End;

Procedure TKADaoTable.SetFiltered(Value:Boolean);
var
  Old_Filtered : Boolean;
Begin
  Old_Filtered := FFiltered;
  Try
    FFiltered:=Value;
    if FFiltered=Old_Filtered Then Exit;
    if FActive Then
       Begin
         CheckBrowseMode;
         ClearBuffers;
         CloseDaoRecordset;
         OpenDaoRecordset;
         ActivateBuffers;
         if Not IsEmpty Then First;
       End;
  Except
    FFiltered := Old_Filtered;
    Raise;
  End;
  Inherited SetFiltered(FFiltered);
End;

Procedure TKADaoTable.SetFilterText(Const Value:String);
Begin
  FFilter:=Value;
  if (FActive) And (FFiltered) Then
     Begin
       CheckBrowseMode;
       ClearBuffers;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       if Not IsEmpty Then First;
     End;
  Inherited SetFilterText(FFilter);
End;

Procedure TKADaoTable.SetCacheMemos(Value:Boolean);
Begin
  FCacheMemos:=Value;
  if (csLoading in ComponentState) Then Exit;
  if (FActive) Then
     Begin
       Close;
       Open;
       First;
     End;
End;

Procedure TKADaoTable.SetCacheBlobs(Value:Boolean);
Begin
  FCacheBlobs:=Value;
  if (csLoading in ComponentState) Then Exit;
  if (FActive) Then
     Begin
       Close;
       Open;
       First;
     End;
End;

Procedure TKADaoTable.SetShowGUID(Value:Boolean);
Begin
  FShowGUID:=Value;
  if (csLoading in ComponentState) Then Exit;
  if (FActive) Then
     Begin
       Close;
       Open;
       First;
     End;
End;

Procedure TKADaoTable.SetCacheLookups(Value:Boolean);
Begin
  FCacheLookups:=Value;
  if (csLoading in ComponentState) Then Exit;
  if (FActive) Then
     Begin
       Close;
       Open;
       First;
     End;
End;

Procedure TKADaoTable.SetEncrypter(Value:TComponent);
Begin
  FEncrypter := Value;
  if (csLoading in ComponentState) Then Exit;
  if (FActive) Then
     Begin
       Close;
       Open;
       First;
     End;
End;


Procedure TKADaoTable.SetOnFilterRecord(Const Value: TFilterRecordEvent);
Begin
  FOnFilterRecord := Value;
  if (FActive) And (FFiltered) Then
     Begin
       CheckBrowseMode;
       ClearBuffers;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
  Inherited SetOnFilterRecord(Value);
End;

//******************************************************************************
Function TKADaoTable.CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream;
Begin
  Result := TKBlobStream.Create(TBlobField(Field),Mode);
End;

Function TKADaoTable.InternalCalcRecordSize:Integer;
Begin
 FRecordSize := 0;
 Result      := FRecordSize;
End;


Procedure TKADaoTable.GetQueryDefReturnParams(QueryDefName:String);
Var
  X, Dir, NRP : Integer;
Begin
  if (NOT Assigned(FDatabase)) OR (NOT FDatabase.Connected) Then Exit;
  if Assigned(QueryDefReturnParams) Then QueryDefReturnParams := Nil;
  NRP:=0;
 Try
  For X:=0 To FDatabase.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count-1 do
      Begin
        Dir := FDatabase.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[TObject(X)].Direction;
        if (Dir=dbParamOutput) Or (Dir=dbParamInputOutput) Or (Dir=dbParamReturnValue) Then Inc(NRP);
      End;
  if NRP=0 Then Exit;
  if NRP=1 Then
      Begin
       SetLength(QueryDefReturnParams,NRP);
       For X:=0 To FDatabase.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count-1 do
           Begin
            Dir := FDatabase.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[TObject(X)].Direction;
            if (Dir=dbParamOutput) Or (Dir=dbParamInputOutput) Or (Dir=dbParamReturnValue) Then
               Begin
                 QueryDefReturnParams[0] := FDatabase.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[TObject(X)].Value;
                 Exit;
               End;
           End;
      End
  Else
      Begin
        SetLength(QueryDefReturnParams,NRP);
        For X:=0 To FDatabase.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count-1 do
           Begin
             Dir := FDatabase.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[TObject(X)].Direction;
             if (Dir=dbParamOutput) Or (Dir=dbParamInputOutput) Or (Dir=dbParamReturnValue) Then
                QueryDefReturnParams[X] := FDatabase.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[TObject(X)].Value;
           End;
     End;
 Except
 End;
End;

Function TKADaoTable.ProcessDTDefault(S:String):String;
Var
 P         : Integer;
 M,D,Y     : Integer;
 Ho,Mi,
 Se,Ms     : Integer;
 DT        : TDateTime;
 DTS       : TTimeStamp;
Begin
 Result := '';
 if S = '' Then Exit;
 Try
 Ho := 0;
 Mi := 0;
 Se := 0;
 Ms := 0;
 P := Pos('/',S);
 //********************************** Mesec
 M :=0;
 if P > 0 Then
    Begin
     M := StrToInt(Copy(S,1,P-1));
     Borland.Delphi.System.Delete(S,1,P);
    End;
  //********************************** Den
  D := 0;
  P := Pos('/',S);
  if P > 0 Then
     Begin
      D := StrToInt(Copy(S,1,P-1));
      Borland.Delphi.System.Delete(S,1,P);
     End;
  //********************************** Godina
  P := Pos(' ',S);
  if P=0 Then
     Begin
       Y := StrToInt(S);
       DT:=EncodeDate(Y,M,D);
       DTS:=DateTimeToTimeStamp(DT);
       S:=IntToStr(DTS.Date)+' '+IntToStr(DTS.Time);
     End
  Else
     Begin
       Y := StrToInt(Copy(S,1,P-1));
       Borland.Delphi.System.Delete(S,1,P);

       //********************************** Chasove
       Ho :=0;
       P := Pos(':',S);
       if P > 0 Then
          Begin
           Ho := StrToInt(Copy(S,1,P-1));
           Borland.Delphi.System.Delete(S,1,P);
           //************************************ 17.01.2002
           P := Pos(' AM', S);
           if P > 0 Then Borland.Delphi.System.Delete(S, P, 3);
           P := Pos(' PM', S);
           if P > 0 Then
              Begin
               Ho := Ho + 12;
               Borland.Delphi.System.Delete(S, P, 3);
              End;
           //************************************ 17.01.2002   
          End;
       //********************************** Minuti
       Mi := 0;
       P := Pos(':',S);
       if P > 0 Then
          Begin
           Mi := StrToInt(Copy(S,1,P-1));
           Borland.Delphi.System.Delete(S,1,P);
          End;
       //********************************** Secundi
       Se :=0;
       if S <> '' Then Se := StrToInt(S);
       //********************************** MiliSecundi
       Ms := 0;
     End;

  //********************************** Encode All
  DT:=EncodeTime(Ho,Mi,Se,Ms);
  DTS:=DateTimeToTimeStamp(DT);
  S:=IntToStr(DTS.Time);
  DT:=EncodeDate(Y,M,D);
  DTS:=DateTimeToTimeStamp(DT);
  //********************************** Compose Result
  S:=IntToStr(DTS.Date)+' '+S;
  Except
   S:='';
  End;
  Result := S;
End;                           

Procedure TKADaoTable.OpenDaoRecordset;
Var
 X         : Integer;
 L         : Integer;
 S         : String;
 FldType   : Integer;
 FldAttr   : Integer;
 FldCount  : Integer;
 TabType   : Integer;
 LoType    : Integer;
 Options   : Integer;
 TempRS    : Recordset;
 TabN      : String;
 TempSort  : String;
 NRP, Dir  : Integer;
Begin
        if Not Assigned(FDatabase) Then
           Begin
             DatabaseError(E2018);
           End;
        if (TableName='') And
           (SQL.Count=0)  And
           (QueryDefName='')
        Then DatabaseError(E2019);

        if Not FDatabaseAutoActivate Then
           Begin
             if FDatabase.Connected=False Then DatabaseError(E2020);
           End
        Else
           Begin
             if FDatabase.Connected=False Then FDatabase.Connected:=True;
           End;

        if (FTableType=dbOpenDynamic) And (FDatabase.DatabaseType <> 'ODBC') Then DatabaseError(E2021);
        TabType:=FTableType;
        LoType:=FLockType;

        if (FDatabase.ReadOnly) And (NOT FReadOnly) Then FReadOnly:=True;
        if FTableType=dbOpenForwardOnly Then FReadOnly:=True;
        if FTableType=dbOpenSnapshot Then FReadOnly:=True;

        Options:=0;
        if dbDenyWrite      in FOpenOptions Then Options:=Options + KA.Data.KADao.DAOApi.dbDenyWrite;
        if dbDenyRead       in FOpenOptions Then Options:=Options + KA.Data.KADao.DAOApi.dbDenyRead;
        if dbReadOnly       in FOpenOptions Then Options:=Options + KA.Data.KADao.DAOApi.dbReadOnly;
        if dbAppendOnly     in FOpenOptions Then Options:=Options + KA.Data.KADao.DAOApi.dbAppendOnly;
        if dbInconsistent   in FOpenOptions Then Options:=Options + KA.Data.KADao.DAOApi.dbInconsistent;
        if dbConsistent     in FOpenOptions Then Options:=Options + KA.Data.KADao.DAOApi.dbConsistent;
        if dbSQLPassThrough in FOpenOptions Then Options:=Options + KA.Data.KADao.DAOApi.dbSQLPassThrough;
        if dbFailOnError    in FOpenOptions Then Options:=Options + KA.Data.KADao.DAOApi.dbFailOnError;
        if dbForwardOnly    in FOpenOptions Then Options:=Options + KA.Data.KADao.DAOApi.dbOpenForwardOnly;
        if dbSeeChanges     in FOpenOptions Then Options:=Options + KA.Data.KADao.DAOApi.dbSeeChanges;
        if dbRunAsync       in FOpenOptions Then Options:=Options + KA.Data.KADao.DAOApi.dbRunAsync;
        if dbExecDirect     in FOpenOptions Then Options:=Options + KA.Data.KADao.DAOApi.dbExecDirect;

        DaoOpenOptions := Options;



        if FDetailRecordset <> NIL Then FDetailRecordset.Close;
        FDetailRecordset:=NIL;

        RecordsAffected:=0;
        TabN:=TableName;
        if FSQL.Count > 0 Then
           Begin
             if (MasterSource <> NIL) Then RefreshQueryParams;
             TabN:=FComposeSQL(FSQL);
           End;
        if FQueryDefName <> '' Then
           Begin
             TabN:=FQueryDefName;
             NRP:=0;
               For X:=0 To Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count-1 do
                 Begin
                   Dir := FDatabase.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[TObject(X)].Direction;
                   if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
                       Begin
                        Try
                         if FQueryDefParameters.Strings[NRP]='NULL' Then
                            Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[TObject(X)].Value:=NULL
                         Else
                            Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[TObject(X)].Value:=FQueryDefParameters.Strings[NRP];
                         Inc(NRP);
                        Except
                         DatabaseError(E2022);
                        End;
                       End;
                 End;
           End;
        if (FQueryDefName <> '') And (Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count > 0) Then
            Begin
                FQueryDefSQLText.Clear;
                if Assigned(FDatabase) And (FDatabase.Connected) Then
                   FQueryDefSQLText.Text := FDatabase.GetQueryDefSQLText(TabN);
                Database.CoreDatabase.QueryDefs.Item[TabN].MaxRecords:=FQueryDefMaxRecords;
                if FDatabase.QueryTimeout <> 60 Then
                FDatabase.CoreDatabase.QueryDefs.Item[TabN].ODBCTimeout:=FDatabase.QueryTimeout;
                FDaoTable:=Database.CoreDatabase.QueryDefs.Item[TabN].OpenRecordset(TObject(TabType),TObject(Options),TObject(LoType));
                GetQueryDefReturnParams(TabN);
            End
        Else
            Begin
               FQueryDefSQLText.Clear;
               if (FQueryDefName <> '') Then
                   Begin
                     FQueryDefSQLText.Text := FDatabase.GetQueryDefSQLText(TabN);
                     Database.CoreDatabase.QueryDefs.Item[TabN].MaxRecords:=FQueryDefMaxRecords;
                     if FDatabase.QueryTimeout <> 60 Then
                     FDatabase.CoreDatabase.QueryDefs.Item[TabN].ODBCTimeout:=FDatabase.QueryTimeout;
                     FDaoTable:=Database.CoreDatabase.QueryDefs.Item[TabN].OpenRecordset(TObject(TabType),TObject(Options),TObject(LoType));
                   End
               Else
                   Begin
                     FDaoTable:=Database.CoreDatabase.OpenRecordset(TabN,TObject(TabType),TObject(Options),TObject(LoType));
                   End;
            End;

        FDatabase.Idle;
        if NOT FDaoTable.Updatable Then FReadOnly:=True;
        FBookmarkable := FDaoTable.Bookmarkable;
        InternalClearBookmarks;
        FDatabase.RefreshDefinitions;
        RecordsAffected:=FDatabase.CoreDatabase.RecordsAffected;



        //******************************************************** Setting Index
        if FIndexName <> '' Then
           Begin
             Try
               FDaoTable.Index:=FIndexName;
             Except
               //******** May raise exception when table is empty
             End;
           End;
        //**********************************************************************
        FldCount := FDaoTable.Fields.Count;
        //******************************************* Default Values
        FUpdatableFields.Clear;
        FDefaultValues.Clear;
        //********************************* Fast Open without quering properties
        For X :=0 To FldCount-1 do
         Begin
           FDefaultValues.Add('');
           FUpdatableFields.Add(TObject(True));
         End;
        //**********************************************************************
        if (NOT FReadOnly) And (FUseDaoProperties) Then
         Begin
          FUpdatableFields.Clear;
          FDefaultValues.Clear;
          For X :=0 To FldCount-1 do
            Begin
             FldType := FDaoTable.Fields.Item[TObject(X)].&Type;
             FldAttr := FDaoTable.Fields.Item[TObject(X)].Attributes;
             FUpdatableFields.Add(TObject(False));
             if (FldAttr And dbUpdatableField) > 0 Then
                Begin
                 if (FldAttr And dbAutoIncrField) = 0 Then
                    Begin
                      if (FldAttr And dbSystemField) = 0 Then
                          Begin
                           FUpdatableFields.Items[X]:=TObject(True);
                          End;
                    End;
                End;
             Try
                //**************************************************************
                S:='';
                if FDatabase.EngineType=dbUseJet Then
                   S  := FDaoTable.Fields.Item[TObject(X)].DefaultValue.ToString;
                //**************************************************************
                if (FldType=dbText) or (FldType=dbMemo) Then
                   Begin
                     L := Length(S);
                     if (L > 1) And (S[1]='"') And (S[L]='"') Then
                        Begin
                          Borland.Delphi.System.Delete(S,L,1);
                          Borland.Delphi.System.Delete(S,1,1);
                        End;
                   End;
                if (FldType=dbDate) Then
                   Begin
                     L := Length(S);
                     if (L > 1) And (S[1]='#') And (S[L]='#') Then
                        Begin
                          Borland.Delphi.System.Delete(S,L,1);
                          Borland.Delphi.System.Delete(S,1,1);
                          S:=ProcessDTDefault(S);
                        End
                      Else
                        S := '';
                   End;
                FDefaultValues.Add(S);
                if WideCompareText(FDefaultValues.Strings[X],'Null')=0 Then FDefaultValues.Strings[X] := '';
              Except
                FDefaultValues.Add('');
              End;
            End;
         End;
        if FSortedBy.Count > 0 Then
           Begin
             TempSort:='';
             For X:=0 To FSortedBy.Count-1 Do
                Begin
                  TempSort:=TempSort+FSortedBy.Strings[X];
                  if X < FSortedBy.Count-1 Then TempSort:=TempSort+',';
                  TempSort:=TempSort+' ';
                End;
             DaoSortString:=TempSort;
             FDaoTable.Sort:=TempSort;
             TempRS:=FDaoTable;
             FDaoTable:=TempRS.OpenRecordset(TObject(TabType),TObject(Options));
             TempRS.Close;
             TempRS:=Nil;
           End;
        if FFiltered Then
           Begin
             if Filter<>'' Then
                Begin
                 FDaoTable.Filter:=Filter;
                 TempRS:=FDaoTable;
                 FDaoTable:=TempRS.OpenRecordset(TObject(TabType),TObject(Options));
                 TempRS.Close;
                 TempRS:=Nil;
                End;
           End;
        if (MasterSource <> NIL) And (Assigned(FMasterLink.DataSet)) Then
           Begin
             FMDisabled := Not (FMasterLink.Active);
             if (NOT FMasterLink.DataSet.Active) And (FMasterAutoActivate) Then
                Begin
                  Try
                    FMasterLink.DataSet.Active := True;
                  Finally
                    FMDisabled := Not (FMasterLink.Active);
                  End;
                End;
           End
        Else
           Begin
             FMDisabled := True;
           End;
        if (MasterSource <> NIL) And (Not(FMDisabled)) And (MasterSource.Enabled) then
            Begin
              FProcessMasterFields(FMasterFields);
              if (FMaster.Count > 0) Then
                  Begin
                   TabN:=BuildDetailSQL;
                   TabN:=InsertSQLString(TabN);
                   FDaoTable.Filter:=TabN;
                   if (FTableName <> '') Then
                      Begin
                        FDaoTable.Close;
                        if DaoSortString <> '' Then
                           FDaoTable:=FDatabase.CoreDatabase.OpenRecordset('Select * From ['+FTableName+'] Where '+TabN+' Order By '+DaoSortString+';',TObject(TabType),TObject(Options),TObject(FLockType))
                        Else
                           FDaoTable:=FDatabase.CoreDatabase.OpenRecordset('Select * From ['+FTableName+'] Where '+TabN+';',TObject(TabType),TObject(Options),TObject(FLockType));
                      End
                   Else
                      Begin
                        FDetailRecordset := FDaoTable;
                        FDaoTable        := FDetailRecordset.OpenRecordset(TObject(TabType),TObject(Options));
                      End;
                  End;
            End;
        //********************************************************** COM Cashing
        SetLength(DaoFields,FldCount);
        For X := 0 To FldCount-1 do
            Begin
              DaoFields[X] := FDaoTable.Fields[TObject(X)];
            End;
        //********************************************************** COM Cashing
        CoreRecordset := FDaoTable;
        FRefreshRC := True;
        FOldRC:=-1;
        FRecNo:=-1;
        FLastRecord:=-1;
        FDatabase.Idle; //****************************************** 12.03.2002
End;

Procedure TKADaoTable.ReOpenDaoRecordset;
Var
  TabN     : String;
  X        : Integer;
Begin
  InternalClearBookmarks;
  TabN:=BuildDetailSQL;
  if (FTableName <> '')  Then
     Begin
       TabN:=InsertSQLString(TabN);
       if DaoSortString <> '' Then
          FDaoTable:=FDatabase.CoreDatabase.OpenRecordset('Select * From ['+FTableName+'] Where '+TabN+' Order By '+DaoSortString+';',TObject(FTableType),TObject(DaoOpenOptions),TObject(FLockType))
       Else
          FDaoTable:=FDatabase.CoreDatabase.OpenRecordset('Select * From ['+FTableName+'] Where '+TabN+';',TObject(FTableType),TObject(DaoOpenOptions),TObject(FLockType));
     End
  Else
     Begin
       FDetailRecordset.Requery(Nil);
       FDetailRecordset.Filter:=TabN;
       FDaoTable:=FDetailRecordset.OpenRecordset(Nil,TObject(dbSeeChanges))
     End;
  CoreRecordset := FDaoTable;
  //**************************************************************** COM Cashing
  SetLength(DaoFields,FDaoTable.Fields.Count-1);
  For X := 0 To FDaoTable.Fields.Count-1 do
      Begin
        DaoFields[X] := FDaoTable.Fields[TObject(X)];
      End;
  //****************************************************************************
  FRefreshRC := True;
  FOldRC:=-1;
  FRecNo:=-1;
  FLastRecord:=-1;
  GetRecordCount;
  FDatabase.Idle; //************************************************ 12.03.2002
End;

Procedure TKADaoTable.Loaded;
begin
  try
    inherited Loaded;
  except
    Application.HandleException(Self)
  end;
end;

Procedure TKADaoTable.Notification(AComponent: TComponent; Operation: TOperation);
Begin
 If (Operation = opRemove) And (AComponent = FDatabase) Then FDatabase := Nil;
 If (Operation = opRemove) And (AComponent = FEncrypter) Then
     Begin
      if FActive Then Close;
      FHasEncoder := False;
      FEncrypter  := Nil;
     End;
 Inherited Notification(AComponent, Operation);
End;

Function TKADaoTable.UnquoteString(S:String):String;
Var
 L: Integer;
Begin
 Result := S;
 L:=Length(Result);
 if L=0 Then Exit;
 if Result[1]='''' Then Borland.Delphi.System.Delete(Result,1,1);
 L:=Length(Result);
 if L=0 Then Exit;
 if Result[L]='''' Then Borland.Delphi.System.Delete(Result,L,1);
End;

Procedure TKADaoTable.InternalOpen;
Var
   X       : Integer;
   TempMD  : Boolean;
   FF      : TField;
   Prop    : TPropInfo;
Begin

        OpenDaoRecordset;
        if Self.Name='' Then Self.Name:='KADaoTable_'+IntToStr(Abs(GetTickCountEx));

        InInternalOpen:=True;
        InternalInitFieldDefs;
        InInternalOpen:=False;
        if DefaultFields then CreateFields;

        if FCacheLookups Then
           Begin
            For X := 0 To FieldCount-1 do
                Begin
                  if Fields[X].FieldKind=fkLookup Then Fields[X].LookupCache:=True;
                End;
           End;
        BindFields(True);
        if FUseDisplayLabels Then InternalSetDisplayLabels;
        if FBookmarkable Then BookmarkSize := MYBOOKMARKSIZE Else BookmarkSize := 0;
        FStartMyInfo := InternalCalcRecordSize;
        FStartCalc   := FStartMyInfo+SizeOf(TDaoInfo);
        FBufferSize  := FRecordSize+Sizeof(TDaoInfo)+CalcFieldsSize;
        //****************************************************************
        TempMD       := FMDisabled;
        FMDisabled:= True;
        FFieldNames.Clear;
        FSortFieldNames.Clear;
        FMDFieldNames.Clear;
        For X:=0 to FieldDefs.Count-1 do
            Begin
             FF  :=FindField(FieldDefs.Items[X].Name);
             if (FF <> Nil) Then
                Begin
                  if Boolean(FUpdatableFields.Items[X])=False Then
                     Begin
                       FF.ReadOnly:=True;
                     End;
                  if FF.DefaultExpression <> '' Then
                     Begin
                       FDefaultValues.Strings[X]:=UnQuoteString(FF.DefaultExpression);
                     End;
                 If (NOT FF.IsBlob) Then
                    Begin
                      FSortFieldNames.Add(FieldDefs.Items[X].Name);
                    End;
                 FFieldNames.Add(FieldDefs.Items[X].Name);
                 FFieldTypeNames.Add(GetBDEFieldTypeNames(FieldDefs.Items[X].DataType));
                 if (NOT (FF.DataType=ftBlob)) Then
                    Begin
                     FMDFieldNames.Add(FieldDefs.Items[X].Name);
                    End;
                 if (FF.DataType=ftDateTime) Then
                     if (DefaultFields) And (FF.DisplayWidth < 20) Then FF.DisplayWidth:=20;
                 if (FF.DataType=ftMemo) Then
                    Begin
                      if FCacheMemos Then
                         Begin
                           if (DefaultFields) And  (FF.DisplayWidth < 30) Then FF.DisplayWidth:=30;
                           FF.OnGetText:=FOnGetMemoText;
                         End;
                    End;
                  if (FF.DataType=ftFloat) Then TFloatField(FF).Precision := 7;
                  if (FF.DataType=ftBytes) And (FieldDefs.Items[X].Precision=GUID_ID) Then
                     Begin
                      FF.ValidChars := GUID_VALID_CHARS;
                      if FShowGUID Then
                         Begin
                          if (DefaultFields) And (FF.DisplayWidth < 38) Then  FF.DisplayWidth := 38;
                          FF.OnGetText    := FOnGetGUIDText;
                          FF.OnSetText    := FOnSetGUIDText;
                         End;
                     End;
                End;
            End;
        FMDisabled:=TempMD;

        FOldValue          := Nil;
        FKeyBuffer         := AllocRecordBuffer;
        FRangeStartBuffer  := AllocRecordBuffer;
        FRangeEndBuffer    := AllocRecordBuffer;

        FHasEncoder        := False;
        if Assigned(FEncrypter) Then
           Begin
             Prop := GetPropInfo(FEncrypter.ClassInfo, 'EncodedString');
             if Prop <> Nil Then
                Begin
                  FEncodedString:=Prop;
                  Prop := GetPropInfo(FEncrypter.ClassInfo, 'DecodedString');
                  If Prop <> Nil Then
                     Begin
                      FDecodedString := Prop;
                      FHasEncoder := True;
                     End;
                End;
           End;
        FActive:=True;
        Try
          if FTableType=dbOpenTable Then GetRecordCount; //*********** 5.1.2002
        Except
        End;
        InternalFirst;
        //****************************************************************
        FDatabase.ActiveTableNames.AddObject(Self.Name,Self);
        if (FDatabase.TrackTransactions) And (FDatabase.GetTransactionCount > 0) Then
           Begin
             FDatabase.AddRNToTransaction(Self.Name,1)
           End;
        FDatabase.Idle; //****************************************** 12.03.2002
End;

Procedure TKADaoTable.CloseDaoRecordset;
Var
 X : Integer;
Begin
 //****************************************** Com Cashing
 For X :=0 To FDaoTable.Fields.Count-1 do
     Begin
       DaoFields[X]:=NULL;
     End;          
 //******************************************
 Try                                          
   FDaoTable.Close;
   FDaoTable := Nil;
 Except
 End;  
End;

Procedure TKADaoTable.InternalClose;
Var
  I : Integer;
Begin
        if Not FActive Then Exit;
        Try
         if State=dsEdit Then FDaoTable.CancelUpdate(dbUpdateRegular);
        Except
        End;
        //************************************************** Changed 16.11.2000
        FActive:=False;
        //************************************************** Changed 16.11.2000
        DaoOpenOptions := 0;
        DaoSortString  := '';
        BindFields(False);
        if DefaultFields then DestroyFields;
        CloseDaoRecordset;
        if FDetailRecordset <> Nil Then FDetailRecordset.Close;
        FDetailRecordset := NIL;
        if Assigned(FDatabase) And (Not MainDatabaseShutdown) Then
           Begin
              I := FDatabase.ActiveTableNames.IndexOfObject(Self);
              if I <> -1 Then  FDatabase.ActiveTableNames.Delete(I);
           End
        Else
           MainDatabaseShutdown  := False;
        if FOldValue <> Nil then FreeRecordBuffer(FOldValue);
        FreeRecordBuffer(FKeyBuffer);
        FreeRecordBuffer(FRangeStartBuffer);
        FreeRecordBuffer(FRangeEndBuffer);
End;

//*********************************************************** BOOKMARK Functions
Procedure TKADaoTable.InternalClearBookmarks;
Begin
  FBookmarkRN.Clear;
  FBookmarkID.Clear;
End;

Function TKADaoTable.BookmarkToInteger(Bookmark:TBookmark):Integer;
Begin
  Result := Marshal.ReadInt32(Bookmark);
End;

Procedure TKADaoTable.IntegerToBookmark(Int : Integer; Var Bookmark : TBookmark);
Begin
  Marshal.WriteInt32(Bookmark,Int);
End;

Function  TKADaoTable.IntegerToString(Int : Integer):String;
Var
  PStr : IntPtr;
Begin
  PStr := Marshal.AllocHGlobal(SizeOf(Int));
  Try
    Marshal.WriteInt32(PStr,Int);
    Result := Marshal.PtrToStringAnsi(PStr,SizeOf(Int));
  Finally
    Marshal.FreeHGlobal(PStr);
  End;
End;

Procedure TKADaoTable.InternalGotoBookmark(const Bookmark: TBookmark);
Var
  I       : Integer;
  BK      : Integer;
  Invalid : Boolean;
Begin
  Invalid := False;
  if NOT FActive Then DatabaseError(E2023);
  if Bookmark=Nil Then DatabaseError(E2024);
  //***************************************************** 30.04.2001
  if IsEmpty Then Exit;
  //***************************************************** 30.04.2001
  BK := BookMarkToInteger(Bookmark);
  if (FBookmarkable) And (BK <> 0) Then
     Begin
       Try
        I:= FBookmarkID.IndexOf(TObject(BK));
        if I = -1 Then
           Begin
             Invalid := True;
             DatabaseError(E2024);
           End
        Else
           Begin
             InternalMoveToBookmark(BK);
             FRecNo  := Integer(FBookmarkRN.Items[I]);
           End;
       Except
        if Invalid Then Raise;
        if GetLastDaoError.ErrNo=3167 Then
           Begin
             DaoInternalRefresh;
             InternalFirst;
             Raise;
           End;
       End;
     End
  Else
     Begin
       DatabaseError(E2025);
     End;
End;

Function TKADaoTable.BookmarkValid(Const Bookmark: TBookmark): Boolean;
Var
  TmpBookmark : TBookmark;
  BK          : Integer;
Begin
  Result := False;
  //***************************************************** 30.04.2001
  if IsEmpty Then Exit;
  //***************************************************** 30.04.2001
  If (FActive) And (FBookmarkable) And (Assigned(Bookmark)) then
  Begin
   //**************************************************** 26.01.2002
   BK := BookmarkToInteger(Bookmark);
   if (BK <> 0) Then
   Begin
      if FBookmarkID.IndexOf(TObject(BK)) = -1 Then Exit;
   End;
   //**************************************************** 26.01.2002
   TmpBookmark := GetBookmark;
   Try
    InternalGotoBookmark(Bookmark);
    CursorPosChanged;
    Result := True;
   Except
    if Assigned(TmpBookmark) Then
       Begin
        InternalGotoBookmark(TmpBookmark);
        CursorPosChanged;
       End;
   End;
   FreeBookmark(TmpBookMark);
  End;
End;

Function TKADaoTable.GetBookmarkFlag(Buffer: TRecordBuffer): TBookmarkFlag;
Var
  DI : TDaoInfo;
Begin
  DI     := GetDaoInfo(Buffer);
  Result := DI.BookmarkFlag;
End;

Procedure TKADaoTable.SetBookmarkFlag(Buffer: TRecordBuffer; Value: TBookmarkFlag);
Var
  DI : TDaoInfo;
Begin
  DI := GetDaoInfo(Buffer);
  DI.BookmarkFlag := Value;
  SetDaoInfo(Buffer, DI);
  if (FBatchMode) And (ControlsDisabled) Then
     Begin
       if (Value=bfEOF) or (Value=bfInserted) Then FInPost := True;
     End;
End;

Function TKADaoTable.GetBookmarkStr: TBookmarkStr;
Var
 Buffer : TRecordBuffer;
 RN     : Integer;
 I      : Integer;
 PIN    : IntPtr;
 DI     : TDaoInfo;
Begin
  Try
    if FBookmarkable Then
       Begin
         Buffer := GetActiveRecordBuffer;
         if (Buffer <> Nil) Then
             Begin
               DI  := GetDaoInfo(Buffer);
               PIN := Marshal.AllocHGlobal(BookmarkSize);
               Try
                 Marshal.WriteInt32(PIN,DI.BookmarkData);
                 Result := Marshal.PtrToStringAnsi(PIN,BookmarkSize);
               Finally
                 Marshal.FreeHGlobal(PIN);
               End;
               RN     := DI.RecordNo;
               I      := FBookmarkRN.IndexOf(TObject(RN));
               if I=-1 Then
                  Begin
                   FBookmarkRN.Add(TObject(RN));
                   FBookmarkID.Add(TObject(DI.BookmarkData));
                  End
               Else
                  Begin
                   FBookmarkID.Items[I] := TObject(DI.BookmarkData);
                  End;
             End;
       End;
  Except
    PIN := Marshal.AllocHGlobal(BookmarkSize);
    Try
      Marshal.WriteInt32(PIN,0);
      Result := Marshal.PtrToStringAnsi(PIN,BookmarkSize);
    Finally
      Marshal.FreeHGlobal(PIN);
    End;
  End;
End;

Procedure TKADaoTable.SetBookmarkStr(const Value: TBookmarkStr);
Var
 PBI : IntPtr;
Begin
 //***************************************************** 30.04.2001
 if IsEmpty Then Exit;
 //***************************************************** 30.04.2001
 if (FBookmarkable) And (Value <> '') Then
     Begin
      PBI := Marshal.AllocHGlobal(BookmarkSize);
      Try
        Marshal.Copy(AnsiEncoding.GetBytes(Value),0,PBI,BookmarkSize);
        InternalGotoBookmark(PBI);
      Finally
        Marshal.FreeHGlobal(PBI);
      End;
      //***************************************************** 14.09.2002
      Resync([rmExact,rmCenter]);  //Resync([]);
      //***************************************************** 14.09.2002
     End;
End;

Procedure TKADaoTable.GetBookmarkData(Buffer: TRecordBuffer;  var Bookmark: TBookmark);
Var
  I  : Integer;
  RN : Integer;
  DI : TDaoInfo;
Begin
  if (FBookmarkable) And (Buffer <> Nil) And (Bookmark <> Nil) Then
    Begin
     DI := GetDaoInfo(Buffer);
     IntegerToBookmark(DI.BookmarkData, Bookmark);
     RN              := DI.RecordNo;
     I               := FBookmarkRN.IndexOf(TObject(RN));
     if I=-1 Then
        Begin
          FBookmarkRN.Add(TObject(RN));
          FBookmarkID.Add(TObject(DI.BookmarkData));
        End
      Else
        Begin
          FBookmarkID.Items[I] := TObject(DI.BookmarkData);
        End;
    End
  Else
    Begin
     if Bookmark <> Nil Then IntegerToBookmark(0,Bookmark);
    End;
End;

Procedure TKADaoTable.SetBookmarkData(Buffer: TRecordBuffer; Const Bookmark: TBookmark);
Var
  DI : TDaoInfo;
Begin
  if (Buffer <> Nil) And (Bookmark <> Nil) Then
      Begin
        DI := GetDaoInfo(Buffer);
        DI.BookmarkData := BookmarkToInteger(Bookmark);
        SetDaoInfo(Buffer,DI);
      End;
End;

Function TKADaoTable.CompareBookmarks(Const Bookmark1, Bookmark2: TBookmark): Integer;
Const
  ResultCodes     : array[Boolean, Boolean] of ShortInt = ((2,-1),(1,0));
Begin
  Result := ResultCodes[Bookmark1 = nil, Bookmark2 = nil];
  If Result = 2 then
     Begin
       Result := 0;
       if BookmarkToInteger(Bookmark1) < BookmarkToInteger(Bookmark2) Then Result := -1;
       if BookmarkToInteger(Bookmark1) > BookmarkToInteger(Bookmark2) Then Result :=  1;
     End;
End;
//*********************************************************** BOOKMARK Functions

Function TKADaoTable.GetRawFieldData(FieldName : String):TObject;
Var
  Buffer : TRecordBuffer;
  FF     : TField;
Begin
  Result := NULL;
  if (FActive) And (FBookmarkable) Then
     Begin
      FF := FindField(FieldName);
      if FF=Nil Then Exit;
      Buffer := GetActiveRecordBuffer;
      if (Buffer = Nil) Then Exit;
      InternalSetToRecord(Buffer);
      Result := FDaoTable.Fields.Item[FieldName].Value;
     End;
End;

Function TKADaoTable.SetRawFieldData(FieldName : String; Value : TObject):Boolean;
Var
  Buffer : TRecordBuffer;
  FF     : TField;
Begin
  Result := False;
  if (FActive) And (FBookmarkable) Then
     Begin
      FF := FindField(FieldName);
      if FF=Nil Then Exit;
      Buffer:=GetActiveRecordBuffer;
      if (Buffer = Nil) Then Exit;
      InternalSetToRecord(Buffer);
      Try
        FDaoTable.Edit;
      Except
        if FDaoTable.EditMode <>  KA.Data.KADao.DAOApi.dbEditInProgress Then FDaoTable.Move(0,Nil);
        DaoInternalRefresh;
      End;
      FDaoTable.Fields.Item[FieldName].Value:=Value;
      FDaoTable.Update(0,False);
      Result := True;
     End;
End;


Function TKADaoTable.GetRows(NumRows:Integer):TObject;
Var
  Buffer : TRecordBuffer;
Begin
  Result:=NULL;
  if (FActive) And (FBookmarkable) Then
     Begin
      if (FFiltered) And (Assigned(FOnFilterRecord)) Then DatabaseError(E2063);
      Buffer := GetActiveRecordBuffer;
      if (Buffer = Nil) Then Exit;
      InternalSetToRecord(Buffer);
      Result := FDaoTable.GetRows(TObject(NumRows));
      if FRecNo < RecordCount Then Inc(FRecNo,NumRows);
      Try
        Resync([]);
      Except
        InternalFirst;
        Resync([]);
        Raise;
      End;
     End;
End;

Function  TKADaoTable.CopyQueryDef : QueryDef;
Begin
  Result := FDaoTable.CopyQueryDef;
End;

Function  TKADaoTable.CopyQueryDefText : String;
Var
  QD : QueryDef;
Begin
  QD     := FDaoTable.CopyQueryDef;
  Result := QD.SQL;
End;

Procedure TKADaoTable.AccessExportToTXT(FileName:String; IncludeBlobs, DeleteOld:Boolean);
Var
 SQL : TStringList;
 FN  : String;
 FP  : String;
 L   : Integer;
 SS  : String;
 X   : Integer;
 FC  : Integer;
 TN  : String;
Begin
 If Not FActive Then DatabaseError('Table must be open in order to export data!');
 TN := '';
 //*****************************************************************************
 Try
 if (DeleteOld) And FileExists(FileName) Then DeleteFile(FileName);
 if FTableName='' Then
    Begin
      if FQueryDefName='' Then
         Begin
           TN := 'Query'+IntToStr(Integer(Abs(GetTickCountEx)));
           Try
             FDatabase.CoreDatabase.BeginTrans;
           Except
           End;
           FDatabase.CreateQueryDef(TN,FComposeSQL(FSQL));
         End
      Else
         Begin
          TN := FQueryDefName;
         End;
    End
 Else
    Begin
      TN := FTableName;
    End;
 FN := ExtractFileName(FileName);
 FP := ExtractFilePath(FileName);
 if FP='' Then FP:='.';
 L  := Length(FN);
 If L=0 Then DatabaseError('FileName is empty!');
 For X :=1 To L do If FN[X]='.' Then FN[X]:='#';
 SS:='';
 FC := FieldCount-1;
 For X := 0 To FC do
     Begin
      if StoreField(X) Then
       Begin
        if IncludeBlobs Then
          Begin
            if FUseBrackets Then
               Begin
                 SS := SS+' '+BracketField(Fields[X].FieldName);
                 if X < FC Then SS := SS+',';
               End
            Else
               Begin
                 if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
               End;
          End
        Else
          Begin
           if Fields[X].DataType<>ftBlob Then
              Begin
               if FUseBrackets Then
                  Begin
                    SS := SS+' '+BracketField(Fields[X].FieldName);
                    if X < FC Then SS := SS+',';
                  End
               Else
                  Begin
                    if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
                  End;
              End;
          End;
       End;
     End;
 if SS[Length(SS)]=',' Then Borland.Delphi.System.Delete(SS,Length(SS),1);
 if FExportMethod = AllFields Then SS :='*';
 SQL := TStringList.Create;
 Try
   SQL.Add(Format('Select %s INTO [%s] IN "%s"[Text;] FROM [%s]',[SS,FN,FP,TN]));
   if (FFiltered) And (FFilter <> '') Then SQL.Add(' WHERE '+FFilter);
   SQL.Add(';');
   ExecSQL(SQL);
 Finally
   SQL.Free;
 End;
 Finally
   if (FTableName='') And (FQueryDefName='') And (TN <> '') Then
       Begin
         FDatabase.DeleteQueryDef(TN);
         Try
           FDatabase.CoreDatabase.Rollback;
         Except
         End;
       End;
 End;
 //*****************************************************************************
End;

Procedure TKADaoTable.AccessExportToHTML(FileName:String; IncludeBlobs, DeleteOld:Boolean);
Var
 SQL : TStringList;
 FN  : String;
 FP  : String;
 SS  : String;
 X   : Integer;
 FC  : Integer;
 TN  : String;
Begin
 If Not FActive Then DatabaseError('Table must be open in order to export data!');
 TN := '';
 //*****************************************************************************
 Try
 if (DeleteOld) And FileExists(FileName) Then DeleteFile(FileName);
 if FTableName='' Then
    Begin
      if FQueryDefName='' Then
         Begin
           TN := 'Query'+IntToStr(Integer(Abs(GetTickCountEx)));
           Try
             FDatabase.CoreDatabase.BeginTrans;
           Except
           End;
           FDatabase.CreateQueryDef(TN,FComposeSQL(FSQL));
         End
      Else
         Begin
          TN := FQueryDefName;
         End;
    End
 Else
    Begin
      TN := FTableName;
    End;
 FN := ExtractFileName(FileName);
 FP := ExtractFilePath(FileName);
 if FP='' Then FP:='.';
 SS:='';
 FC := FieldCount-1;
 For X := 0 To FC do
     Begin
      if StoreField(X) Then
       Begin
        if IncludeBlobs Then
          Begin
            if FUseBrackets Then
               Begin
                 SS := SS+' '+BracketField(Fields[X].FieldName);
                 if X < FC Then SS := SS+',';
               End
            Else
               Begin
                 if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
               End;
          End
        Else
          Begin
           if Fields[X].DataType<>ftBlob Then
              Begin
               if FUseBrackets Then
                  Begin
                    SS := SS+' '+BracketField(Fields[X].FieldName);
                    if X < FC Then SS := SS+',';
                  End
               Else
                  Begin
                    if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
                  End;
              End;
          End;
       End;
     End;
 if SS[Length(SS)]=',' Then Borland.Delphi.System.Delete(SS,Length(SS),1);
 if FExportMethod = AllFields Then SS :='*';
 SQL := TStringList.Create;
 Try
   SQL.Add(Format('Select %s INTO [%s] IN "%s"[HTML Export;] FROM [%s]',[SS,FN,FP,TN]));
   if (FFiltered) And (FFilter <> '') Then SQL.Add(' WHERE '+FFilter);
   SQL.Add(';');
   ExecSQL(SQL);
 Finally
   SQL.Free;
 End;
 Finally
   if (FTableName='') And (FQueryDefName='') And (TN <> '') Then
       Begin
         FDatabase.DeleteQueryDef(TN);
         Try
           FDatabase.CoreDatabase.Rollback;
         Except
         End;
       End;
 End;
 //*****************************************************************************
End;

Procedure TKADaoTable.AccessExportToExcel(FileName, SheetName :String; ExcelVersion:Integer; IncludeBlobs, DeleteOld:Boolean);
Var
 SQL : TStringList;
 EV  : String;
 SS  : String;
 X   : Integer;
 FC  : Integer;
 TN  : String;
Begin
 If Not FActive Then DatabaseError('Table must be open in order to export data!');
 TN :='';
 //*****************************************************************************
 Try
 if (DeleteOld) And FileExists(FileName) Then DeleteFile(FileName);
 if FTableName='' Then
    Begin
      if FQueryDefName='' Then
         Begin
           TN := 'Query'+IntToStr(Integer(Abs(GetTickCountEx)));
           Try
             FDatabase.CoreDatabase.BeginTrans;
           Except
           End;
           FDatabase.CreateQueryDef(TN,FComposeSQL(FSQL));
         End
      Else
         Begin
          TN := FQueryDefName;
         End;
    End
 Else
    Begin
      TN := FTableName;
    End;
 EV := 'Excel 8.0;';
 Case ExcelVersion of
      3 : EV := 'Excel 3.0;';
      4 : EV := 'Excel 4.0;';
      5 : EV := 'Excel 5.0;';
      8 : EV := 'Excel 8.0;';
 End;
 SS:='';
 FC := FieldCount-1;
 For X := 0 To FC do
     Begin
      if StoreField(X) Then
       Begin
        if IncludeBlobs Then
          Begin
            if FUseBrackets Then
               Begin
                 SS := SS+' '+BracketField(Fields[X].FieldName);
                 if X < FC Then SS := SS+',';
               End
            Else
               Begin
                 if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
               End;
          End
        Else
          Begin
           if Fields[X].DataType<>ftBlob Then
              Begin
               if FUseBrackets Then
                  Begin
                    SS := SS+' '+BracketField(Fields[X].FieldName);
                    if X < FC Then SS := SS+',';
                  End
               Else
                  Begin
                    if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
                  End;
              End;
          End;
       End;
     End;
 if SS[Length(SS)]=',' Then Borland.Delphi.System.Delete(SS,Length(SS),1);
 if FExportMethod = AllFields Then SS :='*';
 SQL := TStringList.Create;
 Try
   SQL.Add(Format('Select %s INTO [%s] IN "%s"[%s] FROM [%s]',[SS,SheetName,FileName,EV,TN]));
   if (FFiltered) And (FFilter <> '') Then SQL.Add(' WHERE '+FFilter);
   SQL.Add(';');
   ExecSQL(SQL);
 Finally
   SQL.Free;
 End;
 Finally
   if (FTableName='') And (FQueryDefName='') And (TN <> '') Then
       Begin
         FDatabase.DeleteQueryDef(TN);
         Try
           FDatabase.CoreDatabase.Rollback;
         Except
         End;
       End;
 End;
 //*****************************************************************************
End;

Procedure TKADaoTable.AccessExportToParadox(FileName:String; ParadoxVersion:Integer; IncludeBlobs, DeleteOld:Boolean);
Var
 SQL          : TStringList;
 FN           : String;
 FP           : String;
 SS           : String;
 X            : Integer;
 FC           : Integer;
 PV           : String;
 P            : Integer;
 TN           : String;
 IncludeMemos : Boolean;
Begin
 If Not FActive Then DatabaseError('Table must be open in order to export data!');
 TN := '';
 //*****************************************************************************
 Try
 if FTableName='' Then
    Begin
      if FQueryDefName='' Then
         Begin
           TN := 'Query'+IntToStr(Integer(Abs(GetTickCountEx)));
           Try
             FDatabase.CoreDatabase.BeginTrans;
           Except
           End;
           FDatabase.CreateQueryDef(TN,FComposeSQL(FSQL));
         End
      Else
         Begin
          TN := FQueryDefName;
         End;
    End
 Else
    Begin
      TN := FTableName;
    End;
 FN := ExtractFileName(FileName);
 FP := ExtractFilePath(FileName);
 if (DeleteOld) Then
    Begin
     P := FN.LastIndexOf('.');
     if P > -1 Then  FN := Borland.Delphi.System.Copy(FN,1,P);
     DeleteFile(FP+FN+'.db');
     DeleteFile(FP+FN+'.mb');
     DeleteFile(FP+FN+'.px');
     DeleteFile(FP+FN+'.val');
    End;
 FN := ExtractFileName(FileName);
 if FP='' Then FP:='.';
 SS           := '';
 FC           := FieldCount-1;
 //****************************************************************** 28.02.2003
 IncludeMemos := True;
 if  (FDatabase.Version='3.5')
 And (ParadoxVersion=3) Then IncludeMemos := False;
 //****************************************************************** 28.02.2003
 For X := 0 To FC do
     Begin
      if StoreField(X) Then
       Begin
        if IncludeBlobs Then
          Begin
            if FUseBrackets Then
               Begin
                 SS := SS+' '+BracketField(Fields[X].FieldName);
                 if X < FC Then SS := SS+',';
               End
            Else
               Begin
                 if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
               End;
          End
        Else
          Begin
           //******************************************************** 28.02.2003
           if Fields[X].DataType=ftMemo Then
              Begin
                if IncludeMemos Then
                   Begin
                     if FUseBrackets Then
                        Begin
                         SS := SS+' '+BracketField(Fields[X].FieldName);
                         if X < FC Then SS := SS+',';
                        End
                     Else
                         Begin
                           if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
                         End;
                   End;
              End
           Else
           //******************************************************** 28.02.2003
           if Fields[X].DataType<>ftBlob Then
              Begin
               if FUseBrackets Then
                  Begin
                    SS := SS+' '+BracketField(Fields[X].FieldName);
                    if X < FC Then SS := SS+',';
                  End
               Else
                  Begin
                    if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
                  End;
              End;
          End;
       End;
     End;
 Case ParadoxVersion of
      3 : PV := 'Paradox 3.X;';
      4 : PV := 'Paradox 4.X;';
      5 : PV := 'Paradox 5.X;';
      7 : PV := 'Paradox 7.X;';
 End;
 if SS[Length(SS)]=',' Then Borland.Delphi.System.Delete(SS,Length(SS),1);
 if FExportMethod = AllFields Then SS :='*';
 SQL := TStringList.Create;
 Try
   SQL.Add(Format('Select %s INTO [%s] IN "%s"[%s] FROM [%s]',[SS,FN,FP,PV,TN]));
   if (FFiltered) And (FFilter <> '') Then SQL.Add(' WHERE '+FFilter);
   SQL.Add(';');
   ExecSQL(SQL);
 Finally
   SQL.Free;
 End;
 Finally
   if (FTableName='') And (FQueryDefName='') And (TN <> '') Then
       Begin
         FDatabase.DeleteQueryDef(TN);
         Try
           FDatabase.CoreDatabase.Rollback;
         Except
         End;
       End;
 End;
 //*****************************************************************************
End;

Procedure TKADaoTable.AccessExportToDBase(FileName:String; DBaseVersion:Integer; IncludeBlobs, DeleteOld:Boolean);
Var
 SQL : TStringList;
 FN  : String;
 FP  : String;
 SS  : String;
 X   : Integer;
 FC  : Integer;
 DV  : String;
 P   : Integer;
 TN  : String;
Begin
 If Not FActive Then DatabaseError('Table must be open in order to export data!');
 TN := '';
 //*****************************************************************************
 Try
 if FTableName='' Then
    Begin
      if FQueryDefName='' Then
         Begin
           TN := 'Query'+IntToStr(Integer(Abs(GetTickCountEx)));
           Try
             FDatabase.CoreDatabase.BeginTrans;
           Except
           End;
           FDatabase.CreateQueryDef(TN,FComposeSQL(FSQL));
         End
      Else
         Begin
          TN := FQueryDefName;
         End;
    End
 Else
    Begin
      TN := FTableName;
    End;
 FN := ExtractFileName(FileName);
 FP := ExtractFilePath(FileName);
 if (DeleteOld) Then
    Begin
     P := FN.LastIndexOf('.');
     if P > -1 Then  FN := Borland.Delphi.System.Copy(FN,1,P);
     DeleteFile(FP+FN+'.dbf');
     DeleteFile(FP+FN+'.dbt');
     DeleteFile(FP+FN+'.ndx');
     DeleteFile(FP+FN+'.ntx');
     DeleteFile(FP+FN+'.mdx');
    End;
 FN := ExtractFileName(FileName);
 if FP='' Then FP:='.';
 SS:='';
 FC := FieldCount-1;
 For X := 0 To FC do
     Begin
      if StoreField(X) Then
       Begin
        if IncludeBlobs Then
          Begin
            if FUseBrackets Then
               Begin
                 SS := SS+' '+BracketField(Fields[X].FieldName);
                 if X < FC Then SS := SS+',';
               End
            Else
               Begin
                 if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
               End;
          End
        Else
          Begin
           if Fields[X].DataType<>ftBlob Then
              Begin
               if FUseBrackets Then
                  Begin
                    SS := SS+' '+BracketField(Fields[X].FieldName);
                    if X < FC Then SS := SS+',';
                  End
               Else
                  Begin
                    if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
                  End;
              End;
          End;
       End;
     End;
 Case DBaseVersion of
      3 : DV := 'dBase III;';
      4 : DV := 'dBase IV;';
      5 : DV := 'dBase 5.0;';
 End;
 if SS[Length(SS)]=',' Then Borland.Delphi.System.Delete(SS,Length(SS),1);
 if FExportMethod = AllFields Then SS :='*';
 SQL := TStringList.Create;
 Try
   SQL.Add(Format('Select %s INTO [%s] IN "%s"[%s] FROM [%s]',[SS,FN,FP,DV,TN]));
   if (FFiltered) And (FFilter <> '') Then SQL.Add(' WHERE '+FFilter);
   SQL.Add(';');
   ExecSQL(SQL);
 Finally
   SQL.Free;
 End;
 Finally
   if (FTableName='') And (FQueryDefName='') And (TN <> '') Then
       Begin
         FDatabase.DeleteQueryDef(TN);
         Try
           FDatabase.CoreDatabase.Rollback;
         Except
         End;
       End;
 End;
 //*****************************************************************************
End;


Procedure TKADaoTable.AccessExportToFoxPro(FileName:String; FoxProVersion:Integer; IncludeBlobs, DeleteOld:Boolean);
Var
 SQL : TStringList;
 FN  : String;
 FP  : String;
 SS  : String;
 X   : Integer;
 FC  : Integer;
 DV  : String;
 P   : Integer;
 TN  : String;
Begin
 If Not FActive Then DatabaseError('Table must be open in order to export data!');
 TN := '';
 //*****************************************************************************
 Try
 if FTableName='' Then
    Begin
      if FQueryDefName='' Then
         Begin
           TN := 'Query'+IntToStr(Integer(Abs(GetTickCountEx)));
           Try
             FDatabase.CoreDatabase.BeginTrans;
           Except
           End;
           FDatabase.CreateQueryDef(TN,FComposeSQL(FSQL));
         End
      Else
         Begin
          TN := FQueryDefName;
         End;
    End
 Else
    Begin
      TN := FTableName;
    End;
 FN := ExtractFileName(FileName);
 FP := ExtractFilePath(FileName);
 if (DeleteOld) Then
    Begin
     P := FN.LastIndexOf('.');
     if P > -1 Then  FN := Borland.Delphi.System.Copy(FN,1,P);
     DeleteFile(FP+FN+'.dbf');
     DeleteFile(FP+FN+'.fpt');
     DeleteFile(FP+FN+'.cdx');
    End;
 FN := ExtractFileName(FileName);
 if FP='' Then FP:='.';
 SS:='';
 FC := FieldCount-1;
 For X := 0 To FC do
     Begin
      if StoreField(X) Then
       Begin
        if IncludeBlobs Then
          Begin
            if FUseBrackets Then
               Begin
                 SS := SS+' '+BracketField(Fields[X].FieldName);
                 if X < FC Then SS := SS+',';
               End
            Else
               Begin
                 if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
               End;
          End
        Else
          Begin
           if Fields[X].DataType<>ftBlob Then
              Begin
               if FUseBrackets Then
                  Begin
                    SS := SS+' '+BracketField(Fields[X].FieldName);
                    if X < FC Then SS := SS+',';
                  End
               Else
                  Begin
                    if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
                  End;
              End;
          End;
       End;
     End;
 Case FoxProVersion of
      20 : DV := 'FoxPro 2.0;';
      25 : DV := 'FoxPro 2.5;';
      26 : DV := 'FoxPro 2.6;';
      30 : DV := 'FoxPro 3.0;';
 End;
 if SS[Length(SS)]=',' Then Borland.Delphi.System.Delete(SS,Length(SS),1);
 if FExportMethod = AllFields Then SS :='*';
 SQL := TStringList.Create;
 Try
   SQL.Add(Format('Select %s INTO [%s] IN "%s"[%s] FROM [%s]',[SS,FN,FP,DV,TN]));
   if (FFiltered) And (FFilter <> '') Then SQL.Add(' WHERE '+FFilter);
   SQL.Add(';');
   ExecSQL(SQL);
 Finally
   SQL.Free;
 End;
 Finally
   if (FTableName='') And (FQueryDefName='') And (TN <> '') Then
       Begin
         FDatabase.DeleteQueryDef(TN);
         Try
           FDatabase.CoreDatabase.Rollback;
         Except
         End;
       End;
 End;
 //*****************************************************************************
End;

Procedure TKADaoTable.AccessExportToMDB(FileName,NewTableName:String; IncludeBlobs, DeleteOld:Boolean);
Var
 SQL : TStringList;
 SS  : String;
 X   : Integer;
 FC  : Integer;
 TN  : String;
Begin
 If Not FActive Then DatabaseError('Table must be open in order to export data!');
 TN := '';
 //*****************************************************************************
 Try
 if (DeleteOld) Then
     Begin
       SQL := TStringList.Create;
       Try
        SQL.Add('DROP TABLE ['+FileName+'].['+NewTableName+'];');
        ExecSQL(SQL);
       Except
       End;
       SQL.Free;
     End;
 if FTableName='' Then
    Begin
      if FQueryDefName='' Then
         Begin
           TN := 'Query'+IntToStr(Integer(Abs(GetTickCountEx)));
           FDatabase.CreateQueryDef(TN,FComposeSQL(FSQL));
         End
      Else
         Begin
          TN := FQueryDefName;
         End;
    End
 Else
    Begin
      TN := FTableName;
    End;
 SS:='';
 FC := FieldCount-1;
 For X := 0 To FC do
     Begin
      if StoreField(X) Then
       Begin
        if IncludeBlobs Then
          Begin
            if FUseBrackets Then
               Begin
                 SS := SS+' '+BracketField(Fields[X].FieldName);
                 if X < FC Then SS := SS+',';
               End
            Else
               Begin
                 if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
               End;
          End
        Else
          Begin
           if Fields[X].DataType<>ftBlob Then
              Begin
               if FUseBrackets Then
                  Begin
                    SS := SS+' '+BracketField(Fields[X].FieldName);
                    if X < FC Then SS := SS+',';
                  End
               Else
                  Begin
                    if X < FC Then SS := SS+' '+Fields[X].FieldName+',' Else SS := SS+' '+Fields[X].FieldName;
                  End;
              End;
          End;
       End;
     End;
 if SS[Length(SS)]=',' Then Borland.Delphi.System.Delete(SS,Length(SS),1);
 if FExportMethod = AllFields Then SS :='*';
 SQL := TStringList.Create;
 Try
   SQL.Add(Format('Select %s INTO [%s].[%s] FROM [%s]',[SS,FileName,NewTableName,TN]));
   if (FFiltered) And (FFilter <> '') Then SQL.Add(' WHERE '+FFilter);
   SQL.Add(';');
   ExecSQL(SQL);
 Finally
   SQL.Free;
 End;
 Finally
   if (FTableName='') And (FQueryDefName='') And (TN <> '') Then FDatabase.DeleteQueryDef(TN);
 End;
 //*****************************************************************************
End;


Procedure TKADaoTable.InternalInitIndexDefs;
Var
  ID         : Indexes;
  IndexCount : Integer;
  FieldCount : Integer;
  X          : Integer;
  Y          : Integer;
  IName      : String;
  IFields    : String;
  IPrimary   : Boolean;
  IUnique    : Boolean;
  IDesc      : Boolean;
  IDescFields: String;
  Options    : TIndexOptions;
Begin
 FIndexDefs.Clear;
 if FTableName='' Then Exit;
 if FTableType <> KA.Data.KADao.DaoApi.dbOpenTable Then Exit;
 if FDatabase.EngineType=dbUseODBC Then Exit;
 ID := FDatabase.CoreDatabase.TableDefs.Item[FTableName].Indexes;
 //****************************************************************** 13.02.2002
 Try
   FDatabase.ComWrapper.Call(ID,'Refresh');
 Except
 End;
 //****************************************************************** 13.02.2002
 IndexCount := ID.Count;
 For X := 0 To IndexCount-1 do
     Begin
       IName       := '';
       IPrimary    := False;
       IUnique     := False;
       Try
        IName       := ID.Item[TObject(X)].Name;
        IPrimary    := ID.Item[TObject(X)].Primary;
        IUnique     := ID.Item[TObject(X)].Unique;
       Except
       End;
       IDesc       := False;
       IFields     := '';
       IDescFields := '';
       FieldCount  := KA.Data.Dao360.IndexFields(ID.Item[TObject(X)].Fields).Count;
       For Y := 0 To FieldCount-1 Do
           Begin
             if (Field(KA.Data.Dao360.IndexFields(ID.Item[TObject(X)].Fields).Item[TObject(Y)]).Attributes and dbDescending) = 0 Then
                Begin
                 IFields := IFields+Field(KA.Data.Dao360.IndexFields(ID.Item[TObject(X)].Fields).Item[TObject(Y)]).Name+';'
                End
             Else
                Begin
                  IDescFields := IDescFields+Field(KA.Data.Dao360.IndexFields(ID.Item[TObject(X)].Fields).Item[TObject(Y)]).Name+';';
                  IDesc       := True;
                End;
           End;
       Options  := [];
       if IPrimary Then Options:=Options+[ixPrimary];
       if IUnique  Then Options:=Options+[ixUnique];
       if IDesc    Then Options:=Options+[ixDescending];
       FIndexDefs.Add(IName,IFields,Options);
       if Length(IDescFields) > 0 Then Borland.Delphi.System.Delete(IDescFields,Length(IDescFields),1);
       if Length(IFields)     > 0 Then Borland.Delphi.System.Delete(IFields,Length(IFields),1);
       FIndexDefs.Items[FIndexDefs.Count-1].DescFields:=IDescFields;
     End;
End;

Procedure TKADaoTable.UpdateIndexDefs;
Begin
  FIndexDefs.UpdateIndexes;
End;

Procedure TKADaoTable.InternalInitFieldDefs;
Var
  X        : Integer;
  Sz       : Integer;
  Typ      : Integer;
  ResTyp   : TFieldType;
  Nam      : String;
  FFormat : String;
Begin
        FieldDefs.Clear;
        FDisplayLabels.Clear;
        if Not InInternalOpen Then
           Begin
            if Not FActive Then OpenDaoRecordset;
           End;
        with FieldDefs do
        Begin
          For X:=0 To FDaoTable.Fields.Count-1 do
              Begin
                Typ  := Field(DaoFields[X]).&Type;
                Nam  := Field(DaoFields[X]).Name;
                Sz   := DaoSizeToBDESize(Typ,Field(DaoFields[X]).Size);
                if (Typ=dbDate) And (PropertyExists(Field(DaoFields[X]).Properties,'Format')) Then
                   Begin
                     FFormat  := Field(DaoFields[X]).Properties.Item['Format'].Value.ToString;
                     if WideCompareText(FFormat,'Long Time')=0    Then Typ:=dbTime
                        Else
                        if WideCompareText(FFormat,'Medium Time')=0  Then Typ:=dbTime
                           Else
                           if WideCompareText(FFormat,'Short Time')=0   Then Typ:=dbTime
                              Else
                                if WideCompareText(FFormat,'General Date')=0   Then Typ:=dbTimeStamp;
                   End
                Else
                   if (Typ=dbDate) Then Typ := dbTimeStamp;
                   if (Typ=dbText) And (Sz=0) Then Sz:=255;
                   if (Typ=dbLong) And ((Field(DaoFields[X]).Attributes And dbAutoIncrField) > 0) Then Typ := dbAutoIncInteger;
                   //************************************************ 26.01.2002
                   if FDatabase.EngineType=dbUseJet Then
                      Begin
                        if (Typ=dbAutoIncInteger) Then
                           Begin
                             FDefaultValues.Strings[X] := '';
                           End;
                        if ((Typ=dbFloat) or (Typ=dbLong) or (Typ=dbInteger) or (Typ=dbCurrency) or (Typ=dbSingle) or (Typ=dbDouble) or (Typ=dbBigInt) or (Typ=dbNumeric) or (Typ=dbDecimal))
                        And (Pos('genuniqueid',WideLowercase(Field(DaoFields[X]).DefaultValue.ToString))>0) Then
                            Begin
                              FDefaultValues.Strings[X] := '';
                            End;
                        if (Typ=dbGUID) And (Pos('genguid',WideLowercase(Field(DaoFields[X]).DefaultValue.ToString))>0) Then
                            Begin
                              FDefaultValues.Strings[X] := '';
                            End;
                      End;
                   //************************************************ 26.01.2002
                   //***********************************************************
                   ResTyp := DaoToBDE(Typ);
                   if FReadOnly Then
                      Add(Nam,ResTyp,Sz,False)
                   Else
                      if (FUseDaoProperties) Then
                          Add(Nam,ResTyp,Sz,Field(DaoFields[X]).Required)
                      Else
                          Add(Nam,ResTyp,Sz,False);
                   //***********************************************************
                   if ResTyp=ftBlob Then FDefaultValues.Strings[X] := '';
                   //***********************************************************
                if (FUseDisplayLabels) And (PropertyExists(Field(DaoFields[X]).Properties,'Caption')) Then
                   FDisplayLabels.Add(Field(DaoFields[X]).Properties['Caption'].Value.ToString)
                Else
                   FDisplayLabels.Add(Nam);
                //**************************************************************
                // Tricky way to check out GUID
                //**************************************************************
                if (Typ=dbGUID) Then Items[Count-1].Precision := GUID_ID;
                //**************************************************************
              End;
        End;
        InternalInitIndexDefs;
        if Not InInternalOpen Then
           Begin
            if Not FActive Then CloseDaoRecordset;
           End;
End;

Procedure TKADaoTable.InternalSetDisplayLabels;
Var
  X  : Integer;
  FF : TField;
Begin
 For X:=0 To FieldDefs.Count-1 do
  Begin
   FF := FindField(FieldDefs.Items[X].Name);
   if FF <> Nil Then FF.DisplayLabel:=FDisplayLabels.Strings[X];
  End;
End;

Function TKADaoTable.GetActiveRecordBuffer:  TRecordBuffer;
Begin
        case State of
             dsBlockRead   ,
             dsBrowse      : if IsEmpty Then
                                Result := Nil
                             Else
                                Result := ActiveBuffer;
             dsCalcFields  : Result    := CalcBuffer;
             dsFilter      : Result    := FFilterBuffer;
             dsEdit        ,
             dsInsert      ,
             dsNewValue    ,
             dsCurValue    : Result    := ActiveBuffer;
             dsOldValue:     if FOldValue=Nil then
                              Result   := ActiveBuffer
                           Else
                              Result   := FOldValue;
             dsSetKey      :  Result   := FActiveKeyBuffer;
        Else Result:=Nil;
        End;
End;


Procedure TKADaoTable.InternalHandleException;
Begin
     Application.HandleException(Self);
End;

Procedure TKADaoTable.ClearCalcFields(Buffer: TRecordBuffer);
Var
  X : Integer;
Begin
  For X := 0 To CalcFieldsSize-1 do
      Begin
        Marshal.WriteByte(Buffer,FStartCalc+X,0);
      End;
End;

Procedure TKADaoTable.FOnGetMemoText(Sender: TField; var Text: String; DisplayText: Boolean);
Var
 P      : Integer;
 Buffer : TRecordBuffer;
 DI     : TDaoInfo;
Begin
   if FCacheMemos Then
      Begin
        Buffer := GetActiveRecordBuffer;
        if Buffer=Nil Then Exit;
        DI := GetDaoInfo(Buffer);
        P := Pos(#13,TStringList(DI.RecordData).Strings[Sender.FieldNo-1]);
        if P > 0 Then
           Text := Copy(TStringList(DI.RecordData).Strings[Sender.FieldNo-1],1,P-1)
        Else
           Text := TStringList(DI.RecordData).Strings[Sender.FieldNo-1];
      End;
End;


Procedure TKADaoTable.FOnGetGUIDText(Sender: TField; var Text: String; DisplayText: Boolean);
Var
 P      : Integer;
 Buffer : TRecordBuffer;
 DInfo  : TDaoInfo;
Begin
   if FShowGUID Then
      Begin
       Buffer := GetActiveRecordBuffer;
       if Buffer=Nil Then Exit;
       DInfo := GetDaoInfo(Buffer);
       Text  := TStringList(DInfo.RecordData).Strings[Sender.FieldNo-1];
       P := Pos('{guid ',Text);
       if P = 1 Then
          Begin
            Borland.Delphi.System.Delete(Text,1,6);
            P := Pos('}}',Text);
            if P = Length(Text)-1 Then Borland.Delphi.System.Delete(Text,P,1);
          End;
      End;

End;

Procedure TKADaoTable.FOnSetGUIDText(Sender: TField; const Text: string);
Var
 SGUID : String;
Begin
  if FShowGUID Then
     Begin
       if Length(Text) = 38 Then
          Begin
            SGUID := PutGUIDInString(Text);
            Sender.AsString := SGUID;
          End;
     End;
End;

Function TKADaoTable.GetFieldData(Field: TField; Buffer: TValueBuffer): Boolean;
var
  SourceBuffer : TRecordBuffer;
  Value        : TStringList;
  FieldNumber  : Integer;
  TempString   : String;
  Bytes        : TBytes;
  BA           : Array of Byte;
  DI           : TDaoInfo;
  SB0          : Byte;
  X            : Integer;
Begin
        Result:=False;
        SourceBuffer := GetActiveRecordBuffer;
        if (not FActive) or (SourceBuffer=nil) then
           Begin
              Exit;
           End;
        if (Field.FieldKind=fkCalculated) or (Field.FieldKind=fkLookup) then
          Begin
                SB0 := Marshal.ReadByte(SourceBuffer,FStartCalc+Field.Offset);
                if (SB0=0) or (Buffer=nil) then
                  Begin
                    if SB0 <> 0 Then Result := True;
                    Exit;
                  End
                Else
                  Begin
                    SetLength(BA,Field.DataSize);
                    For X := 1 To Field.DataSize do
                        Begin
                         BA[X-1] := Marshal.ReadByte(SourceBuffer,FStartCalc+Field.Offset+X);
                        End;
                    Marshal.Copy(BA,0,Buffer,Field.DataSize);
                    Result:=True;
                  End;
          end
        else
          Begin
           Try
             DI    := GetDaoInfo(SourceBuffer);
             Value := TStringList(DI.RecordData);
           Except
             Exit;
           End;
           FieldNumber:=Field.FieldNo-1;
           if (Value=Nil) Then Exit;
           if (Buffer = Nil)  Then
            Begin
              Result:=(Value.Strings[FieldNumber] <> '');
            End
               Else
            Begin
              Case Field.DataType of
                ftBytes     : Begin
                               //***********************************************
                               If Field.ValidChars = GUID_VALID_CHARS Then
                                  Begin
                                    //******************************* GUID
                                    Result := GUIDToBuffer(Buffer,Value.Strings[FieldNumber])
                                  End
                               Else
                                  Begin
                                    //******************************* BYTE ARRAY
                                    TempString := Value.Strings[FieldNumber];
                                    TempString := TempString+#0;
                                    Bytes      := AnsiEncoding.GetBytes(TempString);
                                    Marshal.Copy(Bytes, 0, Buffer, Length(Bytes));
                                    Result := Value.Strings[FieldNumber] <> '';
                                  End;
                               //***********************************************
                              End;
                ftCurrency  : Result := FloatToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftFloat     : Result := FloatToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftAutoInc   : Result := IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftSmallint  : Result := Int16ToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftWord      : Result := Int16ToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftInteger   : Result := IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftString    : Begin
                                TempString := Value.Strings[FieldNumber];
                                TempString := TempString+#0;
                                Bytes      := AnsiEncoding.GetBytes(TempString);
                                Marshal.Copy(Bytes, 0, Buffer, Length(Bytes));
                                Result := Value.Strings[FieldNumber] <> '';
                              End;
                ftDate      : Result := DateToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftTime      : Result := TimeToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftDateTime  : Result := DateTimeToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftBoolean   : Result := BooleanToBuffer(Buffer,Value.Strings[FieldNumber]);
              End;
            End;
          End;
End;

Procedure TKADaoTable.SetFieldData(Field: TField; Buffer: TValueBuffer);
var
        DestinationBuffer: TRecordBuffer;
        Tmp              : String;
        BTmp             : WordBool;
        BBTmp            : Boolean;
        B0               : Byte;
        BA               : Array of Byte;
        Res              : ByteBool;
        Bytes            : TBytes;
        SB               : StringBuilder;
        DI               : TDaoInfo;
        X                : Integer;
Begin
        DestinationBuffer := GetActiveRecordBuffer;
        if DestinationBuffer=Nil Then Exit;
        if (Field.FieldKind=fkCalculated) or (Field.FieldKind=fkLookup) then
           Begin
             Res := ByteBool(Buffer<>nil);
             B0  := Byte(Res);
             Marshal.WriteByte(DestinationBuffer,FStartCalc+Field.Offset,B0);
             if Res then
                Begin
                  SetLength(BA,Field.DataSize);
                  Marshal.Copy(IntPtr(Buffer),BA,0,Field.DataSize);
                  For X := 1 To Field.DataSize do
                      Begin
                        Marshal.WriteByte(DestinationBuffer,FStartCalc+Field.Offset+X,BA[X-1]);
                      End;
                End;
           End
        Else
          Begin
            //************************************** Field Checking And Validation
            if Field.FieldKind in [fkData, fkInternalCalc] then Field.Validate(Buffer);
            if (Field.ReadOnly) And (State <> dsSetKey) Then Exit; // 19.02.2003
            //********************************************************************
            Tmp:='';
            if Buffer <> Nil Then
               Begin
                 Case Field.DataType of
                  ftBytes      : Begin
                                   //*******************************************
                                   If Field.ValidChars = GUID_VALID_CHARS Then
                                      Begin
                                        //*************************** GUID
                                        Tmp := BufferToGUID(Buffer);
                                      End
                                   Else
                                      Begin
                                        //*************************** BYTE ARRAY
                                        SetLength(Bytes,Field.Size);
                                        Marshal.Copy(Buffer,Bytes,0,Field.Size);
                                        SB     := StringBuilder.Create(Bytes,Field.Size);
                                        Try
                                          Tmp    := SB.ToString;
                                        Finally
                                          SB.Free;
                                        End;
                                      End;
                                   //*******************************************
                                 End;
                  ftString     : Tmp := Marshal.PtrToStringAnsi(Buffer);
                  ftMemo       : Begin
                                   Tmp := Marshal.PtrToStringAnsi(Buffer,Field.Tag);
                                 End;
                  ftBlob       : Begin
                                   Tmp := Marshal.PtrToStringAnsi(Buffer,Field.Tag);
                                 End;
                  ftSmallint   : Tmp := Marshal.ReadInt16(Buffer).ToString;
                  ftWord       : Tmp := UInt16(Marshal.ReadInt16(Buffer)).ToString;
                  ftInteger    : Tmp := Marshal.ReadInt32(Buffer).ToString;
                  ftAutoInc    : Tmp := Marshal.ReadInt32(Buffer).ToString;

                  ftBCD        : Tmp := BufferToFloat(Buffer);
                  ftCurrency   : Tmp := BufferToFloat(Buffer);
                  ftFloat      : Tmp := BufferToFloat(Buffer);

                  ftDate       : Tmp := BufferToDate(Buffer);
                  ftTime       : Tmp := BufferToTime(Buffer);
                  ftDateTime   : Tmp := BufferToDateTime(Buffer);
                  ftBoolean    : Begin
                                   BTmp  := WordBool(Marshal.ReadInt16(Buffer));
                                   BBTmp := Boolean(BTmp);
                                   Case BBTmp Of
                                     True   : Tmp:= 'True';
                                     False  : Tmp:= 'False';
                                   End;
                                 End;
                 End;
               End;
            DI := GetDaoInfo(DestinationBuffer);
            TStringList(DI.RecordData).Strings[Field.FieldNo-1] := Tmp;
            TStringList(DI.RecordData).Objects[Field.FieldNo-1] := TObject(True);
            SetDaoInfo(DestinationBuffer,DI)
         End;
        if not (State in [dsInternalCalc, dsCalcFields, dsFilter, dsNewValue]) then DataEvent(deFieldChange, TObject(Field));
End;

Procedure TKADaoTable.InternalFirst;
Begin
  FRecNo:=-1;
  FRecPos:=-1;
  if (FDaoTable.BOF) And (FDaoTable.EOF) Then Exit;
  if FTableType = dbOpenForwardOnly Then Exit;
  Try
   FDaoTable.MoveFirst;
   FDaoTable.MovePrevious;
  Except
  End;
End;

Procedure TKADaoTable.InternalLast;
Var
 TmpRS        : Recordset;
 DoRaise      : Boolean;
 OldR         : Integer;
Begin
     if (FDaoTable.BOF) And (FDaoTable.EOF) Then Begin FRecNo:=-1; Exit; End;
     DoRaise := False;
     Try
      if FTableType = dbOpenForwardOnly Then
        Begin
         if NOT FDaoTable.EOF Then
           Begin
            While NOT FDaoTable.EOF Do
              Begin
                FDaoTable.MoveNext;
                Inc(FRecPos);
                FRecNo:=FRecPos;
              End;
             Dec(FRecPos);
           End;
          FRecNo:=FRecPos;
        End
      Else
        Begin
         FDaoTable.MoveLast(0);
         FDaoTable.MoveNext;
         OldR    := FRecNo;
         FRecNo := FDaoTable.RecordCount;
         if FTableType = dbOpenTable Then
           Begin
            if (FRecNo > FLastRecord) Or (OldR > FRecNo) Then
                Begin
                 TmpRS := FDaoTable.OpenRecordset(TObject(dbOpenSnapShot),Nil);
                 TmpRS.MoveLast(0);
                 FRecNo:=TmpRS.RecordCount;
                 TmpRS.Close;
                 FLastRecord:=FRecNo;
                 if (FRecNo <> FDaoTable.RecordCount) And (FWarnOnBadDatabase) Then
                    Begin
                      DoRaise := True;
                      DatabaseError(Format(E2026,[FDatabase.Database]));
                    End;
                End;
           End;
        End;
     Except
       if DoRaise Then Raise;
     End;
End;

Procedure TKADaoTable.InternalMoveToBookmark(Bookmark: Integer);
Var
  PBK : IntPtr;
  BK  : Array[0..3] of Byte;
Begin
   Try
     PBK := Marshal.AllocHGlobal(SizeOf(Bookmark));
     Try
       Marshal.WriteInt32(PBK,Bookmark);
       Marshal.Copy(PBK,TBytes(BK),0,SizeOf(Bookmark));
       FDaoTable.Bookmark := BK;
     Finally
       Marshal.FreeHGlobal(PBK);
     End;
   Except
     On E:Exception do
        Begin
          if GetLastDaoError.ErrNo=3167 Then First;
          Raise;
        End;
   End;
End;

Procedure TKADaoTable.InternalSetToRecord(Buffer: TRecordBuffer);
Var
  RN     : Integer;
  Delta  : Integer;
  Err    : String;
  DI     : TDaoInfo;
Begin
  if (FDaoTable.BOF) And (FDaoTable.EOF) Then Exit;
  if Buffer=Nil Then Exit;
  DI := GetDaoInfo(Buffer);
  IF DI.BookmarkFlag in [bfCurrent, bfInserted] Then
     Begin
       RN           := FRecNo;
       FRecNo       := DI.RecordNo;
       if FTableType = dbOpenForwardOnly Then Exit;
       if State      = dsSetKey Then Exit;
       if FBookmarkable Then
          Begin
            Try
             if (State <> dsEdit) And (State <> dsInsert) Then
                Begin
                  InternalMoveToBookmark(DI.BookmarkData);
                End;
            Except
              //****************************************** HANDLE DELETED RECORD
              Err := GetLastDaoError.Description;
              Try
                InternalFirst;
                Resync([rmCenter]);
                DatabaseError(Err);
              Finally
              End;
              //****************************************** HANDLE DELETED RECORD
            End;
          End
       Else
          Begin
           Delta  := FRecNo-RN;
           if Delta=0 Then Exit;
           Try
             If ((FFiltered) And (Assigned(FOnFilterRecord))) Or (FRangeFiltered) Then
                 Begin
                  FDaoTable.MoveFirst;
                  FDaoTable.Move(FRecNo,Nil);
                 End
             Else
                 Begin
                   FDaoTable.Move(Delta,Nil);
                 End;
           Except
             FDaoTable.MoveFirst;
             FDaoTable.Move(FRecNo,Nil);
           End;
          End;
    End;
End;

Procedure TKADaoTable.InternalInsert;
Begin
  inherited InternalInsert;
End;

Procedure TKADaoTable.InternalEdit;
Label Again;
Var
  PS       : TRecordBuffer;
  PT       : TRecordBuffer;
  JumpAgain: Boolean;
  Action   : TDataAction;
  LDE      : TDaoErrRec;
  SDI      : TDaoInfo;
  TDI      : TDaoInfo;
Begin
     if FOldValue <> Nil then FreeRecordBuffer(FOldValue);
     FOldValue := AllocRecordBuffer;
     PT        := FOldValue;
     PS        := GetActiveRecordBuffer;
     if PS <> Nil Then
        Begin
         SDI              := GetDaoInfo(PS);
         TDI              := GetDaoInfo(PT);
         TDI.BookmarkData := SDI.BookmarkData;
         TDI.BookmarkFlag := SDI.BookmarkFlag;
         TDI.RecordNo     := SDI.RecordNo;
         TStringList(TDI.RecordData).Assign(TStringList(SDI.RecordData));
         SetDaoInfo(PT,TDI)
        End;
Again:
     JumpAgain:= False;
     Try
       if FDaoTable.EditMode <> KA.Data.KADao.DaoApi.dbEditInProgress Then FDaoTable.Edit;
     Except
       On E:Exception do
          Begin
           LDE:=GetLastDaoError;
           //******************************************************** 04.02.2002
           if FDaoTable.EditMode <> KA.Data.KADao.DaoApi.dbEditInProgress Then
              Begin
               FDaoTable.Move(0,Nil);
               Resync([]);
              End;
           //******************************************************** 04.02.2002
           if Assigned(OnEditError) Then
              Begin
                E.HelpContext := LDE.HelpContext;
                OnEditError(Self,EDatabaseError(E),Action);
                if Action=daRetry  Then JumpAgain:=True;
                if Action=daAbort  Then Exit;
                if Action=daFail   Then Raise;
              End
           Else
              Begin
                Raise;
              End;
          End;
     End;
     if JumpAgain Then Goto Again;
     inherited InternalEdit;
     //*************************************************************************
     if PS <> Nil Then
        Begin
          InternalFillRecordData(FDaoTable, True, PS);
        End;
     //*************************************************************************
End;

Procedure TKADaoTable.InternalCancel;
Begin
     Try
       If (FDaoTable.EditMode = KA.Data.KADao.DAOApi.dbEditInProgress) Then
          FDaoTable.CancelUpdate(KA.Data.KADao.DAOApi.dbUpdateRegular);
     Except
     End;
     if FOldValue <> Nil Then FreeRecordBuffer(FOldValue);
     FDatabase.Idle;   //******************************************* 27.01.2002
     inherited InternalCancel;
End;

Procedure TKADaoTable.InternalPost;
Label Again;
Var
 Buffer    : TRecordBuffer;
 DI        : TDaoInfo;
 X         : Integer;
 RData     : TStringList;
 S         : String;
 DTSV      : OleVariant;
 FF        : TField;
 Action    : TDataAction;
 JumpAgain : Boolean;
 LDE       : TDaoErrRec;
Begin
 FPostMade := False;
 CheckActive;
 //*************************************************************** Special Check
 If (State=dsEdit) And (FDaoTable.EditMode <> KA.Data.KADao.DAOApi.DbEditInProgress) Then
     Begin
       Try
        FDaoTable.Edit;
       Except
        if FDaoTable.EditMode <> KA.Data.KADao.DAOApi.dbEditInProgress Then FDaoTable.Move(0,Nil);
        DaoInternalRefresh;
        Raise;
       End;
     End;
 //*****************************************************************************
 Again:
 JumpAgain := False;
 if State = dsEdit then //************************************* EDITING A RECORD
  Begin
    Buffer := GetActiveRecordBuffer;
    DI     := GetDaoInfo(Buffer);
    RData  := TStringList(DI.RecordData);
    For X:=0 to RData.Count-1 do
        Begin
        FF:=FindField(FieldDefs.Items[X].Name);
        if (Boolean(RData.Objects[X])) And (FF <> Nil) Then
         Begin
          S:=RData.Strings[X];
          if Boolean(FUpdatableFields.Items[X]) Then
             Begin
               if S='' Then
                  Begin
                    Field(DaoFields[X]).Value := Nil
                  End
               Else
                  Begin
                    //*********************************************** Byte Array
                    if  (FF.DataType=ftBytes)
                    And (FF.ValidChars <> GUID_VALID_CHARS) Then
                        Begin
                          DTSV := StringToBlob(TBlobField(FF), S);
                          Field(DaoFields[X]).Value:=DTSV;
                        End
                    Else
                    //*********************************************** GUID
                    if  (FF.DataType=ftBytes)
                    And (FF.ValidChars = GUID_VALID_CHARS) Then
                        Begin
                          Field(DaoFields[X]).Value := S;
                        End
                    Else
                    //*********************************************** Date/Time
                    if (FF.DataType=ftDate) or
                       (FF.DataType=ftTime) or
                       (FF.DataType=ftDateTime) Then
                       Begin
                         DTSV  := ComposeDateTimeVariant(S);
                         if DTSV <> NULL Then Field(DaoFields[X]).Value := DTSV;
                         DTSV:=NULL;
                       End
                    Else
                       Begin
                         if (FF.IsBlob) Then
                            Begin
                              if FHasEncoder Then
                                  Begin
                                   //*******************************************
                                   // Perform Encoding here
                                   //*******************************************
                                   SetStrProp(FEncrypter, FDecodedString,S);
                                   S:=GetStrProp(FEncrypter, FEncodedString);
                                  End;
                              DTSV := StringToBlob(TBlobField(FF), S);
                              Field(DaoFields[X]).Value:=DTSV;
                              DTSV:=NULL;
                            End
                         Else
                            Begin
                              if (FHasEncoder) And (FF.DataType=ftString) Then
                                 Begin
                                   //*******************************************
                                   // Perform Encoding here
                                   //*******************************************
                                   SetStrProp(FEncrypter, FDecodedString,S);
                                   S:=GetStrProp(FEncrypter, FEncodedString);
                                 End;
                              Field(DaoFields[X]).Value := S;
                            End;
                       End;
                  End;
             End;
         End;
        End;
    Try
      FDaoTable.Update(dbUpdateRegular,False);
    Except
      On E:Exception do
           Begin
            If Assigned(OnPostError) Then
               Begin
                   LDE := GetLastDaoError;
                   OnPostError(Self,EDatabaseError(E),Action);
                   if Action = daRetry Then
                      Begin
                        JumpAgain := True;
                        If (FDaoTable.EditMode <> dbEditInProgress) Then FDaoTable.Move(0,Nil);
                      End
                   Else
                   if Action = daAbort Then
                      Begin
                        If  (FDaoTable.LockEdits=False)
                        And (FDaoTable.EditMode = dbEditInProgress) Then FDaoTable.CancelUpdate(dbUpdateRegular);
                        If (FDaoTable.EditMode <> dbEditInProgress) Then FDaoTable.Move(0,Nil);
                        Exit;
                      End
                   Else
                   if Action = daFail  Then
                      Begin
                        If  (FDaoTable.LockEdits=False)
                        And (FDaoTable.EditMode = dbEditInProgress) Then FDaoTable.CancelUpdate(dbUpdateRegular);
                        If (FDaoTable.EditMode <> dbEditInProgress) Then FDaoTable.Move(0,Nil);
                        Raise;
                      End;
               End
            Else
               Begin
                 If  (FDaoTable.LockEdits=False)
                 And (FDaoTable.EditMode = dbEditInProgress) Then FDaoTable.CancelUpdate(dbUpdateRegular);
                 If (FDaoTable.EditMode <> dbEditInProgress) Then FDaoTable.Move(0,Nil);
                 Raise;
               End;
           End;
    End;
    if JumpAgain Then Goto Again;
  End
 Else
  Begin //************************************************** ADDING A NEW RECORD
    Buffer := GetActiveRecordBuffer;
    DI     := GetDaoInfo(Buffer);
    RData  := TStringList(DI.RecordData);
    FDaoTable.AddNew;
    For X:=0 to RData.Count-1 do
        Begin
         FF:=FindField(FieldDefs.Items[X].Name);
         if (Boolean(RData.Objects[X])) And (FF <> Nil) Then
         Begin
          S:=RData.Strings[X];
          if Boolean(FUpdatableFields.Items[X]) Then
             Begin
               if S='' Then
                  Begin
                    Field(DaoFields[X]).Value := Nil;
                  End
               Else
                  Begin
                    //*********************************************** Byte Array
                    if  (FF.DataType=ftBytes)
                    And (FF.ValidChars <> GUID_VALID_CHARS) Then
                        Begin
                          DTSV := StringToBlob(TBlobField(FF), S);
                          Field(DaoFields[X]).Value := DTSV;
                          DTSV := NULL;
                        End
                    Else
                    //*********************************************** GUID
                    if  (FF.DataType=ftBytes)
                    And (FF.ValidChars = GUID_VALID_CHARS) Then
                        Begin
                          Field(DaoFields[X]).Value := S;
                        End
                    Else
                    //*********************************************** Date/Time
                    if (FF.DataType=ftDate) or
                       (FF.DataType=ftTime) or
                       (FF.DataType=ftDateTime) Then
                        Begin
                          DTSV:=ComposeDateTimeVariant(S);
                          if DTSV <> NULL Then Field(DaoFields[X]).Value := DTSV;
                          DTSV:=NULL;
                        End
                    Else
                        Begin
                          if (FF.IsBlob) Then
                             Begin
                               if FHasEncoder Then
                                  Begin
                                   //*******************************************
                                   // Perform Encoding here
                                   //*******************************************
                                   SetStrProp(FEncrypter, FDecodedString,S);
                                   S:=GetStrProp(FEncrypter, FEncodedString);
                                  End;
                               DTSV := StringToBlob(TBlobField(FF), S);
                               Field(DaoFields[X]).Value:=DTSV;
                               DTSV:=NULL;
                             End
                          Else
                             Begin
                               if (FHasEncoder) And (FF.DataType=ftString) Then
                                  Begin
                                   //*******************************************
                                   // Perform Encoding here
                                   //*******************************************
                                   SetStrProp(FEncrypter, FDecodedString,S);
                                   S:=GetStrProp(FEncrypter, FEncodedString);
                                  End;
                               Field(DaoFields[X]).Value:=S;
                             End;
                         End;
                  End;
             End;
          End;
        End;
      Try
        FDaoTable.Update(dbUpdateRegular,False);
      Except
        On E:Exception do
           Begin
            If Assigned(OnPostError) Then
               Begin
                   LDE := GetLastDaoError;
                   OnPostError(Self,EDatabaseError(E),Action);
                   if Action = daRetry Then
                      Begin
                        JumpAgain := True;
                      End
                   Else
                   if Action = daAbort Then
                      Begin
                        If FDaoTable.EditMode = dbEditAdd Then FDaoTable.CancelUpdate(dbUpdateRegular);
                        Exit;
                      End
                   Else
                   if Action = daFail Then
                      Begin
                        Raise;
                      End;
               End
            Else
               Begin
                 If FDaoTable.EditMode = dbEditAdd Then FDaoTable.CancelUpdate(dbUpdateRegular);
                 Raise;
               End;
           End;
      End;
      if JumpAgain Then Goto Again;
      Try
       //************************************************* CHANGED AT 06.01.2001
       FRefreshRC := True;
       Inc(FLastRecord);
       Inc(FRecNo);
       If Not FBookmarkable Then
          Begin
           InternalLast;
           DI.RecordNo := FRecNo-1;
           SetDaoInfo(Buffer,DI);
          End;
       //***********************************************************************
      Except
      End;
  End;
  if State <> dsEdit then InternalLast; //10.10.2004 BETA TEST TCHANGE
  If FBookmarkable Then
     Begin
       if FDatabase.EngineType=dbUseJet Then
          Begin
            DI.BookmarkData  := GetDaoLastModifiedBookMark(FDaoTable);
            SetDaoInfo(Buffer,DI);
            InternalMoveToBookmark(DI.BookmarkData);
          End
       Else
          Begin
            If State=dsEdit Then
               Begin
                 DI.BookmarkData:=GetDaoLastModifiedBookMark(FDaoTable)
               End
            Else
               Begin
                 DI.BookmarkData:=GetDaoBookmark(FDaoTable);
               End;
            SetDaoInfo(Buffer,DI);
            InternalMoveToBookmark(DI.BookmarkData);
          End;
     End;
  if FOldValue <> Nil Then FreeRecordBuffer(FOldValue);
  FDatabase.Idle;   //********************************************** 27.01.2002
  FPostMade := True;
End;

Procedure TKADaoTable.Post;
Begin
  FInPost   := True;
  Try
    Inherited Post;
  Finally
    FInPost := False;
  End;
  If (FSortedBy.Count > 0) And (FRefreshSorted) Then
     Begin
       CheckBrowseMode;
       InternalClearBookmarks;
       ClearBuffers;
       FDaoTable.Requery(Nil);
       FRefreshRC := True;
       ActivateBuffers;
       First;
     End;
End;

Procedure TKADaoTable.Resync(Mode: TResyncMode);
Begin
  Inherited Resync(Mode);
End;

Procedure TKADaoTable.InternalAddRecord(Buffer: TRecordBuffer; Append: Boolean);
Begin
    if Append Then
       Begin
         InternalLast;
         SetBookmarkFlag(Buffer, bfEOF);
       End;
    InternalPost;
End;

Procedure TKADaoTable.InternalDelete;
Label Again;
Var
  Buffer   : TRecordBuffer;
  X        : Integer;
  I        : Integer;
  DI       : TDaoInfo;
  RN       : Integer;
  RR       : Integer;
  Action   : TDataAction;
  LDE      : TDaoErrRec;
  JumpAgain: Boolean;
Begin
  Buffer := GetActiveRecordBuffer;
  if Buffer=Nil Then Exit;
  DI     := GetDaoInfo(Buffer);
  RN     := DI.RecordNo;
  I      := FBookmarkRN.IndexOf(TObject(RN));
  if I > -1 Then
     Begin
       FBookmarkRN.Delete(I);
       FBookmarkID.Delete(I);
     End;
  For X:=0 to FBookmarkRN.Count-1 do
      Begin
       RR := Integer(FBookmarkRN.Items[X]);
       if RR > RN Then
          Begin
            Dec(RR);
            FBookmarkRN.Items[X] := TObject(RR);
          End;
      End;
Again:
  JumpAgain:=False;
  Try
    FDaoTable.Delete;
  Except
    On E:Exception do
     Begin
       LDE:=GetLastDaoError;
       if Assigned(OnDeleteError) Then
          Begin
           OnDeleteError(Self,EDatabaseError(E),Action);
           if Action = daRetry Then
              Begin
               JumpAgain := True;
              End
           Else
           if Action = daAbort Then
              Begin
               FRefreshRC := True;
               DaoInternalRefresh;
               FRefreshRC := True;
               Exit;
              End
           Else
           if Action = daFail  Then
              Begin
                if LDE.ErrNo=3167 Then
                   Begin
                    FRefreshRC := True;
                    DaoInternalRefresh;
                   End;
                Raise;
              End;
          End
       Else
          Begin
           if LDE.ErrNo=3167 Then
              Begin
               FRefreshRC := True;
               DaoInternalRefresh;
               Exit;
              End;
          End;
       if Not JumpAgain Then Raise; //******************************* 15.01.2002
     End;
  End;
  if JumpAgain Then Goto Again;
  FDatabase.Idle;   //********************************************** 27.01.2002
  FRefreshRC := True;
  IF (FDaoTable.EOF) then
     FDaoTable.MoveLast(0)
  Else
     FDaoTable.MoveNext;
End;


Procedure TKADaoTable.RollbackRefresh;
Begin
 FRefreshRC := True;
 ClearBuffers;
 ActivateBuffers;
End;

Procedure TKADaoTable.DaoInternalRefresh;
Var
  TempRecNo:Integer;
Begin
    Try
     FRefreshRC := True;
     Resync([rmExact, rmCenter]);
    Except
     TempRecNo:=FRecNo;
     CheckBrowseMode;
     ClearBuffers;
     CloseDaoRecordset;
     OpenDaoRecordset;
     ActivateBuffers;
     First;
     if TempRecNo < RecordCount Then MoveBy(TempRecNo) Else Last;
    End;
End;

Procedure TKADaoTable.InternalRefresh;
Var
  TempRecNo : Integer;
Begin
    Try
     FRefreshRC := True;
     if NOT Self.ControlsDisabled Then Resync([rmExact, rmCenter]);
    Except
     TempRecNo:=FRecNo;
     CheckBrowseMode;
     ClearBuffers;
     CloseDaoRecordset;
     OpenDaoRecordset;
     ActivateBuffers;
     First;
     if TempRecNo < RecordCount Then MoveBy(TempRecNo) Else Last;
    End;
End;

Procedure TKADaoTable.RefreshDataEx;
Var
  TempRecNo : Integer;
Begin
  Try
    CheckBrowseMode;
  Except
  End;
  TempRecNo := FRecNo;
  CheckBrowseMode;
  ClearBuffers;
  CloseDaoRecordset;
  OpenDaoRecordset;
  ActivateBuffers;
  First;
  if TempRecNo < RecordCount Then MoveBy(TempRecNo) Else Last;
End;

Procedure TKADaoTable.RefreshData;
Var
 BK     : TBookmarkStr;
 FD     : TObject;
 Exists : Boolean;
Begin
  //************************************************************* 28.03.2002
  Try
    CheckBrowseMode;
  Except
  End;
  //*************************************************************
  if FDaoTable.Restartable Then
     Begin
      InternalClearBookmarks;
      if FBookmarkable Then BK := Bookmark;
      ClearBuffers;
      Exists := True;
      //************************** Check if record is not deleted *** 28.03.2002
      Try
       If Not ISEmpty Then FD := Field(FDaoTable.Fields[Tobject(0)]).Value;
      Except
       Exists := False;
      End;
      //************************** Check if table is empty ********** 20.08.2002
      if Exists Then Exists := NOT ((FDaoTable.EOF) And (FDaoTable.BOF));
      //********************************************************************
      FDaoTable.Requery(Nil);
      FRefreshRC := True;
      ActivateBuffers;
      If Not ISEmpty Then First;
      //********************************** If Record exists then we reposition
      if (FBookmarkable) And (Exists) Then
         Begin
           Bookmark := BK;
           Resync([rmExact, rmCenter]);
         End;
      //************************************************************* 28.03.2002
     End
  Else
     Begin
       //************************************************************ 28.03.2002
       Close;
       Open;
       If Not ISEmpty Then First;
       //*******************************************************************
     End;
End;

Function TKADaoTable.IsCursorOpen: Boolean;
Begin
  Result:=FActive;
End;

Function TKADaoTable.GetCanModify: Boolean;
Begin
 Result := (FActive) And (NOT FReadOnly);
End;

Function TKADaoTable.GetRecordSize: Word;
Begin
  Result:=FBufferSize;
End;

Function TKADaoTable.AllocRecordBuffer: TRecordBuffer;
Var
  X  : Integer;
  DI : TDaoInfo;
Begin
  Result := Marshal.AllocHGlobal(FBufferSize);
  InitializeBuffer(Result, FBufferSize, 0);
  DI.RecordData:=TStringList.Create;
  For X :=0 To FieldDefs.Count-1 do
       Begin
         TStringList(DI.RecordData).AddObject('',TObject(False));
       End;
  SetDaoInfo(Result,DI);
End;

Procedure TKADaoTable.FreeRecordBuffer(var Buffer: TRecordBuffer);
Var
  DI : TDaoInfo;
Begin
   if Buffer=Nil Then Exit;
   DI := GetDaoInfo(Buffer);
   DI.RecordData.Free;
   DI.RecordData:=Nil;
   Marshal.FreeHGlobal(Buffer);
   Buffer:=Nil;
End;

Procedure TKADaoTable.InternalInitRecord(Buffer : TRecordBuffer);
Var
  X          : Integer;
  PT         : TRecordBuffer;
  PS         : TRecordBuffer;
  DI         : TDaoInfo;
  FF         : TField;
Begin
     if Buffer=Nil Then Exit;
     //*************************************************************************
     if FOldValue <> Nil Then FreeRecordBuffer(FOldValue);
     FOldValue := AllocRecordBuffer;
     PT        := FOldValue;
     PS        := GetActiveRecordBuffer;
     if PS <> Nil Then
        Begin
         DI     := GetDaoInfo(PS);
         SetDaoInfo(PT,DI);
        End;
     //*************************************************************************
     DI     := GetDaoInfo(Buffer);
     For X := 0 To FieldDefs.Count-1 do
          Begin
            TStringList(DI.RecordData).Objects[X]:=TObject(False);
            FF := FindField(FieldDefs.Items[X].Name);
            if (FF <> Nil) And  (FF.DefaultExpression <> '') Then
               Begin
                 FDefaultValues.Strings[X] := UnQuoteString(FF.DefaultExpression);
                 TStringList(DI.RecordData).Objects[X]  := TObject(True);
               End;
            TStringList(DI.RecordData).Strings[X] := FDefaultValues.Strings[X];
          End;
     DI.BookmarkFlag := bfInserted;
     DI.BookmarkData := 0;
     DI.RecordNo     := -1;
     SetDaoInfo(Buffer,DI);
End;

Function TKADaoTable.GetCurrentRecord(Buffer: TRecordBuffer): Boolean;
Var
  AB : TRecordBuffer;
  BA : Array of Byte;
begin
  Result    := FActive;
  if Result Then
     Result := Not IsEmpty;
  AB        := GetActiveRecordBuffer;
  if AB <> Nil Then
     Begin
        SetLength(BA,FBufferSize);
        Marshal.Copy(AB,BA,0,FBufferSize);
        Marshal.Copy(BA,0,Buffer,FBufferSize);
        Result := True;
     End;
end;

Function  TKADaoTable.Translate(const Src: string; var Dest: string; ToOem: Boolean):Integer;
Var
  DST : StringBuilder;
Begin
  Result := Inherited Translate(Src, Dest, ToOem);
  if FTranslation Then
     Begin
      Result := 0;
      if (Src <> Dest) then
         Begin
           DST := StringBuilder.Create(Length(Src));
           Try
             if ToOem Then CharToOem(Src, DST) Else OemToChar(Src,DST);
             Dest := DST.ToString;
           Finally
             DST.Free;
           End;
           Result := Length(Dest);
         End;
     End;
End;

Function TKADaoTable.InternalFillRecordData(RS : Recordset; MainTable : Boolean; Buffer : TRecordBuffer):Boolean;
Var
 X          : Integer;
 DI         : TDaoInfo;
 RD         : OleVariant;
 DTS        : TTimeStamp;
 FF         : TField;
 SZ         : Integer;
 ReadData   : Boolean;
Begin
 Result := True;
 FDatabase.Idle;   //*********************************************** 27.01.2002
 DI := GetDaoInfo(Buffer);
 With DI do
   Begin
    if FBookmarkable Then BookmarkData:=GetDaoBookmark(RS) Else  BookmarkData:=0;
    RecordNo     := FRecNo;
    BookmarkFlag := bfCurrent;
    For X:=0 To FieldDefs.Count-1 do
        Begin
         FF := FindField(FieldDefs.Items[X].Name);
         if FF <> Nil Then
            Begin
              ReadData := True;
              //****************************************************************
              if (FF.IsBlob) Then
                 Begin
                   ReadData := False;
                   if  (FF.DataType = ftMemo) And (FCacheMemos) Then ReadData := True;
                   if  (FF.DataType = ftBlob) And (FCacheBlobs) Then ReadData := True;
                 End;
              //****************************************************************
              if ReadData Then
                 Begin
                  Try
                   if MainTable Then
                      RD := OleVariant(Field(DaoFields[X]).Value)
                   Else
                      RD := OleVariant(Field(RS.Fields.Item[TObject(X)]).Value);
                  Except
                   RD:=NULL;
                   //********** Edit Conflict with other user.
                   if GetLastDaoError.ErrNo=3167 Then
                      Begin
                        Result:=False;
                        Exit;
                      End;
                    //****************************************
                  End;
                 End
              Else
                 Begin
                   RD:='';
                 End;
              //****************************************************************
              if VarType(RD) = varNull then
                 Begin
                  RD := ''
                 End
              Else
                 Begin
                  //********************************************* Array Handling
                  if  (NOT (FF.IsBlob))
                  And (VarISArray(RD)) Then
                     Begin
                       RD := BlobToString(TBlobField(FF),RD,(VarArrayHighBound(RD,1)-VarArrayLowBound(RD,1))+1);
                     End;
                  //********************************************* Date/Time Handling
                  if (FF.DataType=ftDateTime)
                  Or (FF.DataType=ftDate)
                  Or (FF.DataType=ftTime) Then
                     Begin
                       DTS := DateTimeToTimeStamp(VarAsType(RD,varDate));
                       RD  := IntToStr(DTS.Date)+' '+IntToStr(DTS.Time);
                     End;
                  //********************************************* Boolean Handling
                  if (FF.DataType=ftBoolean) Then
                     Begin
                       if RD Then RD := 'True' Else RD := 'False';
                     End;
                 End;
              //****************************************************************
              if ReadData Then
                 Begin
                   if (FF.DataType = ftBlob) Then
                      Begin
                        If MainTable Then SZ := Field(DaoFields[X]).FieldSize Else SZ := Field(RS.Fields.Item[TObject(X)]).FieldSize;
                        TStringList(RecordData).Strings[X]:=BlobToString((TBlobField(FF)),RD,SZ);
                      End
                   Else
                      Begin
                        TStringList(RecordData).Strings[X]:=RD;
                      End;
                 End
              Else
                 Begin
                  //************************************************* 01.02.2002
                  If MainTable Then SZ := Field(DaoFields[X]).FieldSize Else SZ := Field(RS.Fields.Item[TObject(X)]).FieldSize;
                  if SZ=0 Then
                     TStringList(RecordData).Strings[X]:=''
                  Else
                     TStringList(RecordData).Strings[X]:=IntToStr(SZ);
                  //************************************************* 01.02.2002
                 End;
              //****************************************************************
              if (FHasEncoder) And (ReadData) Then
                 Begin
                  //*******************************************
                  // Perform Decoding here
                  //*******************************************
                  if  (FF.DataType=ftString)
                  OR  (FF.IsBlob) Then
                    Begin
                     SetStrProp(FEncrypter, FEncodedString,TStringList(RecordData).Strings[X]);
                     TStringList(RecordData).Strings[X]:=GetStrProp(FEncrypter, FDecodedString);
                    End;
                 End;
              //*************************************************************
              TStringList(RecordData).Objects[X]:=TObject(False);
              RD:=NULL;
            End;
        End;
   End;
 SetDaoInfo(Buffer,DI);
End;

Function TKADaoTable.GetRecord(Buffer: TRecordBuffer; GetMode: TGetMode; DoCheck: Boolean): TGetResult;
var
 Acceptable : Boolean;
Begin
   Result:=grOK;
   Acceptable:=False;
   //********************************************************* SKIP UNUSUAL READ
   if (ControlsDisabled) And
      (FInPost)         And
      (FBatchMode)      And
      (GetMode <> gmCurrent) Then
      Begin
         if NOT (FFiltered And Assigned(FOnFilterRecord)) Then
            Begin
             Result:=grEOF;
             Exit;
            End;
      End;
   //***************************************************************************
   if State=dsInsert Then
      Begin
        //*********************************************************** 25.01.2002
        if NOT ((FDaoTable.BOF) AND (FDaoTable.EOF)) Then CheckBrowseMode;
        Result := grError;
        Exit;
        //*********************************************************** 25.01.2002
      End;
   if State=dsEdit Then
      Begin
        //*********************************************************** 25.01.2002
        if FDaoTable.EditMode = KA.Data.KADao.DAOApi.dbEditInProgress Then CheckBrowseMode;
        Result := grError;
        Exit;
        //*********************************************************** 25.01.2002
      End;
   //***************************************************************************
   Repeat
    Case GetMode of
       gmNext:
        Begin
          if (FTableType = dbOpenForwardOnly) And (FRecNo=-1) Then
             Begin
               //******************* Do not call MoveNext at first record
             End
          Else
             Begin
               if Not FDaoTable.EOF Then FDaoTable.MoveNext;
             End;
          if FDaoTable.EOF Then
             Begin
               Result := grEOF;
             End;
          if Result=grOK Then
             Begin
               Inc(FRecNo);
               Inc(FRecPos);
             End;
        End;
      gmPrior:
        Begin
          if FTableType = dbOpenForwardOnly Then
             Begin
               Result   := grBOF;
             End
          Else
             Begin
               if Not FDaoTable.BOF Then FDaoTable.MovePrevious;
               if FDaoTable.BOF Then Result := grBOF;
             End;
          if Result=grOK Then
             Begin
               Dec(FRecNo);
               Dec(FRecPos);
             End;
        End;
      gmCurrent:
        Begin
          if FDaoTable.BOF Then Result := grBOF;
          if FDaoTable.EOF Then Result := grEOF;
        End;
    End;
    //**************************************************************************
    if Result=grEOF Then
       Begin
         FLastRecord := FRecNo+1; /// +1 **************************** 5.1.2002
       End
    Else
       Begin
         if FLastRecord < FRecNo Then FLastRecord := FRecNo;
       End;
    //**************************************************************************
    if Result=grOk then
       Begin
        if Not InternalFillRecordData(FDaoTable, True, Buffer) Then
           Begin
             Result:=grError;
             Exit;
           End;
        Acceptable:=FilterRecord(Buffer);
        if (GetMode=gmCurrent) And (Not Acceptable) Then Result:=grError;
       End;
   Until (Result <> grOk) or (Acceptable);
End;

Function TKADaoTable.FilterRecord(Buffer: TRecordBuffer): Boolean;
var
  SaveState: TDatasetState;
Begin
 Result:=True;
 SaveState:=SetTempState(dsFilter);
 ClearCalcFields(Buffer);
 GetCalcFields(Buffer);
 if FRangeFiltered Then Result:=FilterRange(Buffer);
 if (FFiltered) And (Result) And (Assigned(FOnFilterRecord)) Then
    Begin
      FFilterBuffer:=Buffer;
      OnFilterRecord(Self,Result);
    End;
 RestoreState(SaveState);
End;

Function TKADaoTable.GetRecordCount: Integer;
var
  SaveState    : TDataSetState;
  SavePosition : Integer;
  TempBuffer   : TRecordBuffer;
  TmpRS        : Recordset;
  DoRaise      : Boolean;
  DI           : TDaoInfo;
Begin
 Result:=-1;
 if FTableType=dbOpenForwardOnly Then Exit;
 if FUseRecordCountCache Then
    Begin
     if NOT FRefreshRC Then
        Begin
         Result := FOldRC;
         FLastRecord:=Result;
         Exit;
        End;
    End;

 DoRaise     := False;
 FRefreshRC := False;
 if (FDaoTable.BOF) And (FDaoTable.EOF) Then
    Begin
      Result:=0;
      FOldRC:=Result;
      FLastRecord:=Result;
      FRecNo := -1;
      Exit;
    End;
 If ((FFiltered) And (Assigned(FOnFilterRecord))) Or (FRangeFiltered) Then
     Begin
       Result:=0;
       SaveState:=SetTempState(dsBrowse);
       SavePosition:=FRecNo;
       Try
         TempBuffer:=AllocRecordBuffer;
         InternalFirst;
         While GetRecord(TempBuffer,gmNext,True)=grOk do Inc(Result);
       Finally
         RestoreState(SaveState);
         FRecNo:=SavePosition;
         FreeRecordBuffer(TempBuffer);
       End;                                                  
     End
 Else
     Begin
      if FTableType=dbOpenTable Then
         Begin
           Try
            Result:=FDaoTable.RecordCount;
            if (Result > FLastRecord) Then
               Begin
                TmpRS:=FDaoTable.OpenRecordset(TObject(dbOpenSnapShot),Nil);
                TmpRS.MoveLast(0);
                Result:=TmpRS.RecordCount;
                TmpRS.Close;
                if (Result <> FDaoTable.RecordCount) And (FWarnOnBadDatabase) Then
                   Begin
                     DoRaise := True;
                     DatabaseError(Format(E2026,[FDatabase.Database]));
                   End;
               End;
           Except
             if DoRaise Then Raise;
           End;
         End
      Else
         Begin
          Try
           FDaoTable.MoveFirst;
           FDaoTable.MoveLast(0);
           Result:=FDaoTable.RecordCount;
           Except
           End;
          End; 
       if FBookmarkable Then                                                  
         Begin
           TempBuffer := GetActiveRecordBuffer;
           if TempBuffer <> Nil Then
              Begin
                DI := GetDaoInfo(TempBuffer);
                if DI.BookmarkData <> 0 Then
                   InternalMoveToBookmark(DI.BookmarkData);
              End;
         End
       Else
         Begin
           FDaoTable.MoveFirst;
           if FRecNo=-1 Then
            Begin
             FDaoTable.MovePrevious;
            End
           Else
            Begin
             if (FRecNo < Result) Then FDaoTable.Move(FRecNo,Nil);
            End;
         End;
     End;                                     
     FOldRC:=Result;
     FLastRecord:=Result;
End;

Function  TKADaoTable.GetRecNo: Integer;
var
  SaveState     : TDataSetState;
  SavePosition  : Integer;
  TempBuffer    : TRecordBuffer;
  BK            : Integer;
  DI            : TDaoInfo;
Begin
  UpdateCursorPos;
  //******************************************************************* 1.1.2002
  TempBuffer:=GetActiveRecordBuffer;
  if TempBuffer <> Nil Then InternalSetToRecord(TempBuffer);
  //****************************************************************************

  if NOT FUseGetRecNo Then
     Begin
       Result := -1;
       Exit;
     End;

  if FRecNo<-1 Then FPostMade:=True;

  if (FTableType = dbOpenForwardOnly) Then
     Begin
       Result := FRecNo+1;
       Exit;
     End;

  if FDaoTable.BOF Then
     Begin
       Result := -1;
       Exit;
     End;

  If ((FFiltered) And (Assigned(FOnFilterRecord)))  Or (FRangeFiltered) Then
    Begin
     Result     := -1;
     SaveState  := SetTempState(dsBrowse);
     TempBuffer := GetActiveRecordBuffer;
     if TempBuffer <> Nil Then
        Begin
          DI := GetDaoInfo(TempBuffer);
          SavePosition := DI.BookmarkData;
          Try
           TempBuffer := AllocRecordBuffer;
           InternalFirst;
           Result := 0;
           While (GetRecord(TempBuffer,gmNext,True)=grOk) And
                 (DI.BookmarkData <> SavePosition)
                 do Inc(Result);
          Finally
           if (DI.BookmarkData <> SavePosition) Then
              Begin
               InternalSetToRecord(GetActiveRecordBuffer);
              End;
           FreeRecordBuffer(TempBuffer);
          End;
        End;
     RestoreState(SaveState);
     if Result=-1 Then Exit;
    End
 Else
    Begin
      if FPostMade Then
         Begin
          TempBuffer:=GetActiveRecordBuffer;
          if TempBuffer <> Nil Then
             Begin
              FRecNo:=-1;
              if (FTableType=dbOpenDynaset)
              OR (FTableType=dbOpenSnapshot)
              OR (FTableType=dbOpenDynamic) Then
                 Begin
                   FRecNo := FDaoTable.AbsolutePosition;
                 End
              Else
                 Begin
                   //***********************************************************
                   // If we are at the end of the table then we can easy calc
                   // the RecNo
                   Try
                    FDaoTable.MoveNext;
                    if FDaoTable.EOF Then FRecNo := FDaoTable.RecordCount-1;
                   Except
                   End;
                   FDaoTable.MovePrevious;
                   //***********************************************************
                   // if Previous test does not work then
                   if FRecNo = -1 Then
                      Begin
                        if FBookmarkable Then
                           Begin
                             BK     := GetDaoLastModifiedBookMark(FDaoTable);
                             FRecNo := FRecalculateRecNo(FDaoTable,BK);
                           End
                        Else
                           Begin
                             //**************************************** TOO Slow
                             While Not FDaoTable.BOF Do
                               Begin
                                Inc(FRecNo);
                                FDaoTable.MovePrevious;
                               End;
                           End;
                      End;
                   //***********************************************************
                   DI := GetDaoInfo(TempBuffer);
                   DI.RecordNo:=FRecNo;
                   SetDaoInfo(TempBuffer,DI);
                   if FBookmarkable Then
                      Begin
                       InternalMoveToBookmark(DI.BookmarkData);
                      End
                   Else
                      Begin
                       FDaoTable.MoveFirst;
                       FDaoTable.Move(FRecNo,Nil);
                      End;
                 End;
              FPostMade:=False;
             End;
         End
      Else
         Begin
           //********************************************************** 2.1.2002
           if (FTableType=dbOpenDynaset)
           OR (FTableType=dbOpenSnapshot)
           OR (FTableType=dbOpenDynamic) Then
              Begin
                 FRecNo := FDaoTable.AbsolutePosition;
              End;
           //*******************************************************************
         End;
      Result:=FRecNo;
    End;
 Inc(Result);
End;


Procedure TKADaoTable.SetRecNo(Value: Integer);
Var
 SaveState      : TDataSetState;
 SavePosition   : Integer;
 TempBuffer     : TRecordBuffer;
Begin
  CheckBrowseMode;
  CursorPosChanged;
  DoBeforeScroll;
  If ((FFiltered) And (Assigned(FOnFilterRecord))) Or (FRangeFiltered) Then
     Begin
       SaveState:=SetTempState(dsBrowse);
       SavePosition:=FRecNo;
       try
         TempBuffer:=AllocRecordBuffer;
         InternalFirst;
         Repeat
           Begin
             if GetRecord(TempBuffer,gmNext,True)=grOk Then
               Begin
                Dec(Value);
               End
             Else
               Begin
                 FRecNo  := SavePosition;
                 Break;
               End;
           End;
         Until Value=0;
       Finally
         RestoreState(SaveState);
         FreeRecordBuffer(TempBuffer);
       End;
     End
  Else
     Begin
      FRecNo := (Value-1);
      FDaoTable.MoveFirst;
      FDaoTable.Move(FRecNo,Nil);
     End;
  Resync([rmExact,rmCenter]);
  DoAfterScroll;
end;

Procedure TKADaoTable.StringToList(Items: String; List: TStringList);
var
  X: Integer;
Begin
  Items := StringReplace(Items,';',#13#10,[rfReplaceAll]);
  List.Clear;
  List.Text:=Items;
  For X:= 0 To List.Count - 1 Do List[X]:= Trim(List[X]);
End;

Procedure TKADaoTable.VariantToList(Items: Variant; List: TStringList);
Var
   X    : Integer;
   V    : Variant;
   Count: Integer;
Begin
   List.Clear;
   if VarIsArray(Items) Then
      Begin
        Count:=(VarArrayHighBound(Items, 1) - VarArrayLowBound(Items, 1))+1;
        For X:=0 to Count-1 do
            Begin
             V:=Items[VarArrayLowBound(Items, 1) + X];
             if VarIsNull(V) Then
                List.Add('NULL')                         
             Else
                List.Add(VarAsType(V,VarString));
            End;
      End
   Else
      Begin
         V:=Items;
         if VarIsNull(V) Then
            List.Add('NULL')
         Else
            List.Add(VarAsType(V,VarString));
      End;
End;


Function  TKADaoTable.BuildKeySQL(KN,KV:TStringList):String;
Var
 X  : Integer;
 S  : String;
 FT : TField;
Begin
S:='';
Result:='';
if KN.Count > 0 Then
     Begin
      For X:=0 To KN.Count-1 do
         Begin
          S:=S+'(';
          if FUseBrackets Then
             S:=S+BracketField(KN.Strings[X])
          Else
             S:=S+KN.Strings[X];
          S:=S+' ';
          FT :=FieldByName(KN.Strings[X]);
          if KV.Strings[X]='NULL' Then S:= S + 'IS NULL'
          Else
          Case FT.DataType of
             ftBytes    :  Begin
                             if KV.Strings[X] = '' Then
                                Begin
                                  S := S + ' IS NULL';
                                End
                             Else
                                Begin
                                  if FT.ValidChars = GUID_VALID_CHARS Then
                                     S := S + ' = {guid '+KV.Strings[X]+'}'
                                  Else
                                     S := S + ' = "' + KV.Strings[X] + '"';
                                End;
                           End;
             ftString   ,
             ftBlob     ,
             ftMemo     : S := S + ' = "' + ChangeOnlyQuotes(KV.Strings[X]) + '"';
             ftBoolean  ,
             ftBCD      ,
             ftCurrency ,
             ftFloat    ,
             ftSmallint ,
             ftWord     ,
             ftAutoInc  ,
             ftInteger : Begin
                          if KV.Strings[X]='' Then
                             S := S + ' IS NULL'
                          Else
                             S := S + ' = ' + ChangeCommas(KV.Strings[X]);
                         End;
             ftDate    : Begin
                           if KV.Strings[X]='' Then
                             Begin
                               S := S + ' IS NULL';
                             End
                          Else
                             Begin
                               KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                               S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy', StrToDateTime(KV.Strings[X])) + '#';
                             End;
                         End;
             ftTime    : Begin
                           if KV.Strings[X]='' Then
                             Begin
                               S := S + ' IS NULL';
                             End
                          Else
                             Begin
                               KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                               S:= S + ' = #' + FormatDateTime('hh":"nn":"ss', StrToDateTime(KV.Strings[X])) + '#';
                             End;
                         End;
             ftDateTime: Begin
                           if KV.Strings[X]='' Then
                             Begin
                               S := S + ' IS NULL';
                             End
                          Else
                             Begin
                               KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                               S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy hh":"nn":"ss', StrToDateTime(KV.Strings[X])) + '#';
                             End;
                         End;

             Else
             DatabaseError(E2028)
          End;
          S:=S+')';
          if (X < KN.Count-1) Then S:=S+' AND ';
         End;
     End;
 Result := S;
End;

Function  TKADaoTable.BuildLocateSQL(KN,KV:TStringList;Options: TLocateOptions):String;
Var
 X  : Integer;
 S  : String;
 FT : TField;
Begin
S:='';
Result:='';
if KN.Count > 0 Then
     Begin
      For X:=0 To KN.Count-1 do
         Begin
          S:=S+'(';
          FT :=FieldByName(KN.Strings[X]);
          if FUseBrackets Then
             S:=S+BracketField(KN.Strings[X])
          Else
             S:=S+KN.Strings[X];
          S:=S+' ';
          if KV.Strings[X]='NULL' Then S:= S + 'IS NULL'
          Else
          Case FT.DataType of
             ftBytes    :  Begin
                             if KV.Strings[X] = '' Then
                                Begin
                                  S := S + ' IS NULL';
                                End
                             Else
                                Begin
                                  if FT.ValidChars = GUID_VALID_CHARS Then
                                     S := S + ' = {guid '+KV.Strings[X]+'}'
                                  Else
                                     S := S + ' = "' + KV.Strings[X] + '"';
                                End;
                           End;
             ftString   ,
             ftBlob     ,
             ftMemo     :  Begin
                             if loCaseInsensitive in Options Then KV.Strings[X]:=WideLowerCase(KV.Strings[X]);
                             If loPartialKey in Options Then
                                Begin
                                  if loCaseInsensitive in Options Then
                                     Begin
                                       S:= S + ' LIKE LCASE("' + ChangeOnlyQuotes(ChangeQuotes(KV.Strings[X])) + '*")';
                                     End
                                  Else
                                     Begin
                                       S:= S + ' LIKE "' + ChangeOnlyQuotes(ChangeQuotes(KV.Strings[X])) + '*"';
                                     End;
                                End
                             Else
                                Begin
                                  if loCaseInsensitive in Options Then
                                     Begin
                                       S:= S + ' = LCASE("' + ChangeOnlyQuotes(KV.Strings[X]) + '")';
                                     End
                                   Else
                                     Begin
                                       S:= S + ' = "' + ChangeOnlyQuotes(KV.Strings[X]) + '"';
                                     End;
                                End;
                           End;
             ftBoolean  ,
             ftCurrency ,
             ftFloat    ,
             ftBCD      ,
             ftSmallint ,
             ftWord     ,
             ftAutoInc  ,
             ftInteger : Begin
                          if KV.Strings[X]='' Then
                             S := S + ' IS NULL'
                          Else
                             S := S + ' = ' + ChangeCommas(KV.Strings[X]);
                         End;
             ftDate    : Begin
                           if KV.Strings[X]='' Then
                              Begin
                                 S := S + ' IS NULL'
                              End
                           Else
                              Begin
                                KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                                S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy', StrToDateTime(KV.Strings[X])) + '#';
                              End;
                         End;
             ftTime    : Begin
                            if KV.Strings[X]='' Then
                              Begin
                                 S := S + ' IS NULL'
                              End
                           Else
                              Begin
                               KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                               S:= S + ' = #' + FormatDateTime('hh":"nn":"ss', StrToDateTime(KV.Strings[X])) + '#';
                              End;
                         End;
             ftDateTime: Begin
                            if KV.Strings[X]='' Then
                              Begin
                                 S := S + ' IS NULL'
                              End
                           Else
                              Begin
                               KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                               S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy hh":"nn":"ss', StrToDateTime(KV.Strings[X])) + '#';
                              End;
                         End;
             Else
             DatabaseError(E2029)
          End;
          S:=S+')';
          if (X < KN.Count-1) Then S:=S+' AND ';
         End;
     End;
 Result := S;
End;

Function  TKADaoTable.BuildDetailSQL:String;
Var
 X  : Integer;
 S  : String;
 FT : TField;
Begin
S:='';
Result:='';
if FMaster.Count <> FDetail.Count Then
     Begin
       DatabaseError(E2030);
     End;
if FMaster.Count > 0 Then
     Begin
      For X:=0 To FMaster.Count-1 do
         Begin
          S:=S+'(';
          if FUseBrackets Then
             S:=S+BracketField(FDetail.Strings[X])
          Else
             S:=S+FDetail.Strings[X];
          S:=S+' ';
          FT :=FMasterLink.Dataset.FieldByName(FMaster.Strings[X]);
          if FT.IsNull then S:= S + 'IS NULL'
          Else
          Case FT.DataType of
             ftBytes    :  Begin
                             if FT.AsString = '' Then
                                Begin
                                  S := S + ' IS NULL';
                                End
                             Else
                                Begin
                                  if FT.ValidChars = GUID_VALID_CHARS Then
                                     S := S + ' = {guid '+GetGUIDAsString(FT.AsString)+'}'
                                  Else
                                     S := S + ' = "' + FT.AsString + '"';
                                End;
                           End;
             ftString  ,
             ftBlob    ,
             ftMemo    : S := S + ' = "' + ChangeOnlyQuotes(FT.AsString) + '"';
             ftCurrency,
             ftFloat   ,
             ftBCD     ,
             ftSmallint,
             ftWord    ,
             ftAutoInc ,
             ftInteger : Begin
                           if FT.AsString='' Then
                              S := S + ' IS NULL'
                           Else
                              S := S + ' = ' + ChangeCommas(FT.AsString);
                         End;
             ftBoolean : Begin
                           if FT.AsString='' Then
                              S := S + ' IS NULL'
                           Else
                              If FT.AsBoolean then S:= S + ' = True' Else S:= S + ' = False';
                         End;
             ftDate    : Begin
                           if FT.AsString='' Then
                              S := S + ' IS NULL'
                           Else
                              S := S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy', FT.AsDateTime) + '#';
                         End;
             ftTime    : Begin
                           if FT.AsString='' Then
                              S := S + ' IS NULL'
                           Else
                              S := S + ' = #' + FormatDateTime('hh":"nn":"ss', FT.AsDateTime) + '#';
                         End;
             ftDateTime: Begin
                           if FT.AsString='' Then
                              S := S + ' IS NULL'
                           Else
                              S := S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy hh":"nn":"ss', FT.AsDateTime) + '#';
                         End;
             Else
                DatabaseError(E2031)
          End;
          S:=S+')';
          if (X < FMaster.Count-1) Then S:=S+' AND ';
         End;
     End;
 Result := S;
End;

//***************************************************************************************
Function TKADaoTable.GetDaoLastModifiedBookMark(RS:Recordset):Integer;
Var
 PBK     : IntPtr;
 L       : Integer;
Begin
 Result:=0;
 if (RS.BOF) And (RS.EOF) Then Exit;
 if FBookmarkable Then
    Begin
      L   := Length(RS.LastModified);
      if L > 0 Then
         Begin
           PBK := Marshal.AllocHGlobal(L);
           Try
             Marshal.Copy(RS.LastModified,0,PBK,L);
             Result := Marshal.ReadInt32(PBK);
           Finally
             Marshal.FreeHGlobal(PBK);
           End;
         End
      Else
         Begin
           Result := GetDaoBookMark(RS);
         End;
    End
 Else
    Begin
      Result := 0;
    End;
End;


Function  TKADaoTable.GetDaoBookMark(RS:Recordset):Integer;
Var
 PBK     : IntPtr;
 L       : Integer;
Begin
 Result:=0;
 if (RS.BOF) Or (RS.EOF) Then Exit;
 Try
  if FBookmarkable Then
    Begin
       L   := Length(RS.Bookmark);
       PBK := Marshal.AllocHGlobal(L);
       Try
         Marshal.Copy(RS.Bookmark,0,PBK,L);
         Result := Marshal.ReadInt32(PBK);
       Finally
         Marshal.FreeHGlobal(PBK);
       End;
    End
  Else
    Begin
      Result := 0;
    End;
  Except
    InternalFirst;
  End;
End;


Function TKADaoTable.GetFieldIndexName(FiledName:String):String;
Var
  X,Y : Integer;
Begin
 if Assigned(FDatabase) And (FDatabase.Connected) Then
 Begin
 Try
  For X :=0 To FDatabase.CoreDatabase.TableDefs[FTableName].Indexes.Count-1 do
      Begin
        For Y := 0 To KA.Data.Dao360.IndexFields(FDatabase.CoreDatabase.TableDefs[FTableName].Indexes.Item[TObject(X)].Fields).Count-1 do
            Begin
              if WideCompareText(FiledName,KA.Data.Dao360.Field(KA.Data.Dao360.IndexFields(FDatabase.CoreDatabase.TableDefs[FTableName].Indexes.Item[TObject(X)].Fields).Item[TObject(Y)]).Name)=0 Then
                 Begin
                  Result := FDatabase.CoreDatabase.TableDefs[FTableName].Indexes.Item[TObject(X)].Name;
                  Exit;
                 End;
            End;
      End;
  Except
  End;
  End;
  Result := '';
End;

Function TKADaoTable.CheckFieldsInIndex(KF:TStringList):Boolean;
Var
  X,Y  : Integer;
  OK   : Boolean;
Begin
  Result := False;
  if FIndexName='' Then Exit;
  if (NOT Assigned(FDatabase))  Or (NOT FDatabase.Connected) Then Exit;
  For X :=0 To KF.Count-1 do
      Begin
        OK :=False;
        For Y:=0 To KA.Data.Dao360.IndexFields(FDatabase.CoreDatabase.TableDefs[FTableName].Indexes.Item[FIndexName].Fields).Count-1 do
            Begin
             if WideCompareText(KF.Strings[X],KA.Data.Dao360.Field(KA.Data.Dao360.IndexFields(FDatabase.CoreDatabase.TableDefs[FTableName].Indexes.Item[FIndexName].Fields).Item[TObject(Y)]).Name)=0 Then OK :=True;
            End;
        if Not OK Then Exit;
      End;
  Result := True;
End;

//******************************************************************* 31.01.2002
Function TKADaoTable.GetUniqueIndexFields(Table : TKaDaoTable) : String;
Var
  X : integer;
Begin
  Result := '';
  Table.IndexDefs.Update;
  For X := 0 to Table.IndexDefs.Count - 1 do
      Begin
       if ixUnique in Table.IndexDefs.Items[X].Options then
          Begin
           Result := Table.IndexDefs.Items[X].Fields;
           Break;
          End;
      End;
End;

Function TKADaoTable.IsFieldUniqueIndex(Table : TKaDaoTable; FieldName : String ) : Boolean;
Var
  X : Integer;
Begin
  Result := False;
  Table.IndexDefs.Update;
  for X := 0 to Table.IndexDefs.Count -1 do
      Begin
  	if  (Table.IndexDefs.Items[X].Fields = FieldName)
        And (ixUnique in Table.IndexDefs.Items[X].Options ) Then
            Begin
             Result := true;
             Break;
            End;
      End;
end;
//******************************************************************* 31.01.2002



Function  TKADaoTable.Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean;
Var
 KF       : TStringList;
 KV       : TStringList;
 X        : Integer;
 CR       : Integer;
 RI       : Integer;
 FN       : Integer;
 Find     : Boolean;
 S1,S2    : String;
 L        : Integer;
 Filter   : String;
 KVV      : Array[0..12] of OleVariant;
 IdxC     : Integer;
 IdxCT    : Integer;
 IndexOK  : Boolean;
 CompText : String;
 //*************************************
 BK       : Integer;
 TempRS   : Recordset;
 APOK     : Boolean;
 IdxName  : String;
 //*************************************
Begin
 Result:=False;
 if IsEmpty Then Exit;
 if FBatchMode  Then Exit;
 If ((FFiltered) And (Assigned(FOnFilterRecord))) Or (FRangeFiltered) Then Exit;
 if (NOT Assigned(FDatabase))  Or (NOT FDatabase.Connected) Then Exit;
 KF :=  TStringList.Create;
 KV :=  TStringList.Create;
 Try
  StringToList(KeyFields,KF);
  VariantToList(KeyValues,KV);
  If (KF.Count <> KV.Count)  Then DatabaseError(E2032);
  //****************************************************************************
  APOK := False;
  if     (FTableType=dbOpenDynaset)
      OR (FTableType=dbOpenSnapshot)
      OR (FTableType=dbOpenDynamic) Then APOK:=True;
  //****************************************************************************
  InternalSetToRecord(GetActiveRecordBuffer);
  CR:=FRecNo;
  if FBookmarkable Then
     Begin
       //************************************************************ 13.02.2002
       if FAutoFindIndex Then
          Begin
            IdxName   := FindGoodIndex('!'+KeyFields);
            if IdxName = '' Then IdxName := FindGoodIndex(KeyFields);
            if IdxName = '' Then IdxName := FIndexName;
          End
       Else
          Begin
            IdxName := FIndexName;
            if IdxName='' Then
               Begin
                IdxName   := FindGoodIndex('!'+KeyFields);
                if IdxName = '' Then IdxName := FindGoodIndex(KeyFields);
               End;
          End;
       //************************************************************ 13.02.2002
       IndexOK := (IdxName<>'');
       if (TableType=dbOpenTable) And (IndexOK) Then
          Begin
            //******************************************************************
            For X := 0 to 12 do KVV[X]:=NULL;
            IdxC  := KA.Data.Dao360.IndexFields(FDatabase.CoreDatabase.TableDefs[FTableName].Indexes[IdxName].Fields).Count;
            IdxCT := 0;
            For X:=0 to IdxC-1 do
                Begin
                  L:=KF.IndexOf(KA.Data.Dao360.Field(KA.Data.Dao360.IndexFields(FDatabase.CoreDatabase.TableDefs[FTableName].Indexes[IdxName].Fields).Item[TOBject(X)]).Name);
                  if L <> -1 Then
                     Begin
                       KVV[X]:=KV.Strings[L];
                       IdxCT:=X+1;
                     End;
                End;
            //******************************************************************
            if IdxCT > 0 Then IdxC:=IdxCT;
            CompText := '=';
            if KF.Count <> KA.Data.Dao360.IndexFields(FDatabase.CoreDatabase.TableDefs[FTableName].Indexes.Item[IdxName].Fields).Count Then CompText := '>=';
            if loPartialKey in Options then CompText := '>=';
            TempRS:=FDaoTable.Clone;
            TempRS.Index:=IdxName;
            TempRS.MoveFirst;
            if IdxC=1 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0]])
            Else
            if IdxC=2 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0],KVV[1]])
            Else
            if IdxC=3 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0],KVV[1],KVV[2]])
            Else
            if IdxC=4 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0],KVV[1],KVV[2],KVV[3]])
            Else
            if IdxC=5 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4]])
            Else
            if IdxC=6 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5]])
            Else
            if IdxC=7 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6]])
            Else
            if IdxC=8 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7]])
            Else
            if IdxC=9 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8]])
            Else
            if IdxC=10 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8],KVV[9]])
            Else
            if IdxC=11 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8],KVV[9],KVV[10]])
            Else
            if IdxC=12 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8],KVV[9],KVV[10],KVV[11]])
            Else
            if IdxC=13 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8],KVV[9],KVV[10],KVV[11],KVV[12]]);
          End
       Else
          Begin
            if (TableType=dbOpenTable) Then DatabaseError(E2062);
            //******************************************************************
            Filter:=BuildLocateSQL(KF,KV,Options);
            TempRS:=FDaoTable.Clone;
            TempRS.MoveFirst;
            TempRS.Move(CR,Nil);
            TempRS.FindFirst(Filter);
            //******************************************************************
          End;
       Find:=NOT TempRS.NoMatch;
       if (Find) Then
           Begin
             Result:= True;
             BK:=GetDaoBookMark(TempRS);
             CheckBrowseMode;
             CursorPosChanged;
             DoBeforeScroll;
             if APOK Then
                Begin
                  CR := TempRS.AbsolutePosition;
                End
             Else
                Begin
                   CR:=FRecalculateRecNo(TempRS,BK);
                End;
             InternalMoveToBookmark(BK);
             FRecNo:=CR;
             //******************************* ClearBuffers;
             Resync([]);
             DoAfterScroll;
           End;
       TempRS.Close;
     End
  Else
     Begin
       CheckBrowseMode;
       CursorPosChanged;
       DoBeforeScroll;
       FDaoTable.MoveFirst;
       Find:=False;
       RI:=0;
       While Not (FDaoTable.EOF) Do
             Begin
              Find:=True;
              For X:=0 to KF.Count-1 do
                  Begin
                   FN:=Integer(KF.Objects[X])-1;
                   S1:=KV[X];
                   S2:=FDaoTable.Fields.Item[TObject(FN)].Value.ToString;
                   if loCaseInsensitive in Options Then
                       Begin
                        S1:=WideLowerCase(S1);
                        S2:=WideLowerCase(S2);
                       End;
                   if loPartialKey in Options Then
                       Begin
                        L:=Length(S1);
                        if S1[L]='*' Then Borland.Delphi.System.Delete(S1,L,1);
                        if S1[1]='*' Then Borland.Delphi.System.Delete(S1,1,1);
                        if Pos(S1,S2) = 0 Then Find:=False;
                       End
                   Else
                       Begin
                        if S1 <> S2 Then Find:=False;
                       End;
                   if NOT Find Then Break;
                  End;
              If Find Then
                 Begin
                  DoBeforeScroll;
                  FRecNo:=RI;
                  Result:= True;
                  //******************************* ClearBuffers;
                  Resync([]);
                  DoAfterScroll;
                  Break;
                 End
              Else
                 Begin
                  Inc(RI);
                  FDaoTable.MoveNext;
                 End;
             End;
       if Not(Find) Then
          Begin
            FDaoTable.MoveFirst;
            FDaoTable.Move(CR,Nil);
            //************************************** ClearBuffers;
            Resync([rmExact, rmCenter]);
          End;
       DoAfterScroll;
     End;
 Finally
  KV.Free;
  KF.Free;
 End;
End;


Function  TKADaoTable.Find(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions;FindType:Integer): Boolean;
Var
 KF       : TStringList;
 KV       : TStringList;
 X        : Integer;
 CR       : Integer;
 Filter   : String;
 //*************************************
 BK       : Integer;
 TempRS   : Recordset;
 APOK     : Boolean;
 //*************************************
Begin
 Result:=False;
 if IsEmpty Then Exit;
 If ((FFiltered) And (Assigned(FOnFilterRecord))) Or (FRangeFiltered) Then Exit;
 KF :=  TStringList.Create;
 KV :=  TStringList.Create;
 Try
  StringToList(KeyFields,KF);
  VariantToList(KeyValues,KV);
  If (KF.Count <> KV.Count)  Then DatabaseError(E2032);
  For X:=0 To KF.Count-1 do KF.Objects[X]:=TObject(FieldByName(KF[X]).FieldNo);
  //*****************************************************************************
  APOK := False;
  if     (FTableType=dbOpenDynaset)
     OR (FTableType=dbOpenSnapshot)
     OR (FTableType=dbOpenDynamic) Then APOK:=True;
  //*****************************************************************************
  InternalSetToRecord(GetActiveRecordBuffer);
  CR:=FRecNo;
  if FBookmarkable Then
    Begin
      Filter:=BuildLocateSQL(KF,KV,Options);
      TempRS:=FDaoTable.Clone;
      TempRS.MoveFirst;
      TempRS.Move(CR,Nil);
      Case FindType of
           1 : TempRS.FindFirst(Filter);
           2 : TempRS.FindLast(Filter);
           3 : TempRS.FindNext(Filter);
           4 : TempRS.FindPrevious(Filter);
      End;
      if (Not TempRS.NoMatch) Then
          Begin
            Result:= True;
            BK:=GetDaoBookMark(TempRS);
            CheckBrowseMode;
            CursorPosChanged;
            DoBeforeScroll;
            if APOK Then
               Begin
                 CR := TempRS.AbsolutePosition;
               End
            Else
               Begin
                  CR:=FRecalculateRecNo(TempRS,BK);
               End;
            InternalMoveToBookmark(BK);
            FRecNo:=CR;
            //************************************* ClearBuffers;
            Resync([rmExact, rmCenter]);
            DoAfterScroll;
          End;
      TempRS.Close;
    End
  Else
    Result:=False;
 Finally
  KV.Free;
  KF.Free;
 End;
End;

Procedure TKADaoTable.SetKeyFields(const KeyFields: string);
Begin
 StringToList(KeyFields,FKeyFields);
End;

Function TKADaoTable.Find_First(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,1);
End;

Function TKADaoTable.Find_Last(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,2);
End;

Function TKADaoTable.Find_Next(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,3);
End;

Function TKADaoTable.Find_Prior(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,4);
End;

Procedure TKADaoTable.SetFindData(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions);
Begin
 FFindKeyFields:=KeyFields;
 FFindKeyValues:=KeyValues;
 FFindOptions:=Options;
End;

Function TKADaoTable.FindRecord(Restart, GoForward: Boolean): Boolean;
Begin
   Result:=False;
   if FFindKeyFields='' Then Exit;
   if VarIsNull(FFindKeyValues) Then Exit;
   if (Restart) And (GoForward)         Then Result:=Find_First(FFindKeyFields,FFindKeyValues,FFindOptions);
   if (Restart) And (NOT GoForward)     Then Result:=Find_Last(FFindKeyFields,FFindKeyValues,FFindOptions);
   if (NOT Restart) And (GoForward)     Then Result:=Find_Next(FFindKeyFields,FFindKeyValues,FFindOptions);
   if (NOT Restart) And (NOT GoForward) Then Result:=Find_Prior(FFindKeyFields,FFindKeyValues,FFindOptions);
End;

//*************************************************************** Range Routines
Function TKADaoTable.CompareFieldsRange(B1, B2: String; FieldType: TFieldType):Integer;
Var
  BOOL1, BOOL2 : WordBool;
  DOUB1, DOUB2 : Double;
  SMAL1, SMAL2 : SmallInt;
  WORD1, WORD2 : Word;
  INTE1, INTE2 : Integer;
Begin
 Result := 0;
 Case FieldType of
      ftString,
      ftMemo     :       Begin
                           Result := WideCompareText(B1, B2);
                         End;
      ftBoolean  :       Begin
                           if WideLowerCase(B1) = 'true' Then BOOL1 := True Else BOOL1 := False;
                           if WideLowerCase(B2) = 'true' Then BOOL2 := True Else BOOL2 := False;
                           if BOOL1 > BOOL2 Then Result:=1
                           Else
                           if BOOL1 < BOOL2 Then Result:=-1;
                         End;
      ftCurrency,
      ftFloat    :       Begin
                           Try
                            DOUB1 := StrToFloat(B1);
                            DOUB2 := StrToFloat(B2);
                            if DOUB1 > DOUB2 Then Result:=1
                            Else
                            if DOUB1 < DOUB2 Then Result:=-1;
                           Except
                           End;
                         End;

      ftSmallInt :       Begin
                           Try
                            SMAL1 := SmallInt(StrToInt(B1));
                            SMAL2 := SmallInt(StrToInt(B2));
                            Result:=SMAL1-SMAL2;
                           Except
                           End;
                         End;

      ftWord     :       Begin
                           Try
                            WORD1 := Word(StrToInt(B1));
                            WORD2 := Word(StrToInt(B2));
                            Result:=WORD1-WORD2;
                           Except
                           End;
                         End;
      ftAutoInc,
      ftInteger  :       Begin
                           Try
                            INTE1 := LongInt(StrToInt(B1));
                            INTE2 := LongInt(StrToInt(B2));
                            Result:=INTE1-INTE2;
                           Except
                           End;
                         End;
      ftDate     :       Begin
                           Result := WideCompareText(B1, B2);
                         End;
      ftTime     :       Begin
                           Result := WideCompareText(B1, B2);
                         End;
      ftDateTime :       Begin
                           Result := WideCompareText(B1, B2);
                         End;
 End;
End;

Function TKADaoTable.CompareRecordsRange(B1,B2 : TRecordBuffer; CT : Integer) : Integer;
Var
 X       : Integer;
 F1,F2   : String;
 DI1,DI2 : TDaoInfo;
Begin
 Result := 0;
 If (B1=Nil) Or (B2=nil) then Exit;
 DI1 := GetDaoInfo(B1);
 DI2 := GetDaoInfo(B2);
 For X := 0  to FieldCount-1 do
     Begin
       F1  := TStringList(DI1.RecordData).Strings[X];
       F2  := TStringList(DI2.RecordData).Strings[X];
       if (F1 <> '') And (F2 <> '') Then
          Begin
            Result := CompareFieldsRange(F1,F2,Fields[X].DataType);
          End
       Else
          Begin
            //*************** SET OUTSIDE RANGE IF THERE ARE NO VALUE TO COMPARE
            if F2 <> '' Then
               Begin
                 if (CT=1) Then Result:=-1
                 Else
                 if (CT=2) Then Result:=1;
               End;
          End;
       if (Result < 0) And (CT=1) Then Break;
       if (Result > 0) And (CT=2) Then Break;
     End;
End;

Function TKADaoTable.FilterRange(Buffer:TRecordBuffer): Boolean;
Var
 R1,R2 : Integer;
Begin
 R1 := CompareRecordsRange(Buffer,FRangeStartBuffer,1);
 R2 := CompareRecordsRange(Buffer,FRangeEndBuffer,2);
 Result := (R1 >=0) And (R2 <=0);
End;

Procedure TKADaoTable.ClearRange(Var Buffer:TRecordBuffer);
Var
  X  : Integer;
  DI : TDaoInfo;
Begin
 DI := GetDaoInfo(Buffer);
 TStringList(DI.RecordData).Clear;
 For X := 0 To FieldDefs.Count-1 do
      Begin
       TStringList(DI.RecordData).AddObject('',TObject(False));
      End;
  SetDaoInfo(Buffer,DI);
  SetState(dsBrowse);
  //******************************************* 29.08.2001
  DataEvent(deDataSetChange, TObject(0));
  //******************************************* 29.08.2001
End;

Procedure TKADaoTable.ApplyRange;
Var
 B1  : String;
 B2  : String;
 DI1 : TDaoInfo;
 DI2 : TDaoInfo;
Begin
 DI1 := GetDaoInfo(FRangeStartBuffer);
 DI2 := GetDaoInfo(FRangeEndBuffer);
 B1  := TStringList(DI1.RecordData).Text;
 B2  := TStringList(DI1.RecordData).Text;
 B1 :=Trim(B1);
 B2 :=Trim(B2);
 FRangeFiltered := (B1 <> '') And (B2 <> '');
 FRefreshRC     := True;
 SetState(dsBrowse);
 //******************************************* 29.08.2001
 DataEvent(deDataSetChange, TObject(0));
 //******************************************* 29.08.2001
 First;
End;

Procedure TKADaoTable.CancelRange;
Begin
  FRangeFiltered   := False;
  FActiveKeyBuffer := Nil;
  FRefreshRC       := True;
  First;
  Resync([rmExact]);
End;

Procedure TKADaoTable.SetRange(const StartValues, EndValues : Array of Const);
var
   Maks  : Integer;
   Mini  : Integer;
   X     : Integer;
   DIS   : TDaoInfo;
   DIE   : TDaoInfo;
Begin
     CheckBrowseMode;
     //***************************************************** Setting Start Range
     SetRangeStart;
     Mini := High(StartValues);
     DIS  := GetDaoInfo(FRangeStartBuffer);
     Maks := TStringList(DIS.RecordData).Count;
     if Maks > Mini Then Maks := Mini;
     For X := 0 to Maks do IndexFields[X].AssignValue(Variant(StartValues[X]));
     //******************************************************* Setting End Range
     SetRangeEnd;
     Mini := High(StartValues);
     DIE  := GetDaoInfo(FRangeEndBuffer);
     Maks := TStringList(DIE.RecordData).Count;
     if Maks > Mini Then Maks := Mini;
     For X := 0 to Maks do IndexFields[X].AssignValue(Variant(EndValues[X]));
     //****************************************************** Applying the Range
     ApplyRange;
End;

Procedure TKADaoTable.SetRangeStart;
Begin
  ClearRange(FRangeStartBuffer);
  FActiveKeyBuffer := FRangeStartBuffer;
  SetState(dsSetKey);
  DataEvent(deDataSetChange, TObject(0));
End;

Procedure TKADaoTable.SetRangeEnd;
Begin
  ClearRange(FRangeEndBuffer);
  FActiveKeyBuffer := FRangeEndBuffer;
  SetState(dsSetKey);
  DataEvent(deDataSetChange, TObject(0));
End;

Procedure TKADaoTable.EditRangeStart;
Begin
 FActiveKeyBuffer := FRangeStartBuffer;
 SetState(dsSetKey);
 DataEvent(deDataSetChange, TObject(0));
End;

Procedure TKADaoTable.EditRangeEnd;
Begin
  FActiveKeyBuffer := FRangeEndBuffer;
  SetState(dsSetKey);
  DataEvent(deDataSetChange, TObject(0));
End;
//***************************************************************** Key Routines

Procedure TKADaoTable.SetKeyParam(const KeyFields: Array of String;const KeyValues: array of const);
Var
  X : Integer;
Begin
  FKeyKeyFields:='';
  FKeyKeyValues:=Null;
  For X:=0 to High(KeyFields) do
      Begin
        if X < High(KeyValues) Then
           FKeyKeyFields := FKeyKeyFields+KeyFields[X]+';'
        Else
           FKeyKeyFields := FKeyKeyFields+KeyFields[X];
       End;
  if High(KeyValues)=0 then
    Begin
      FKeyKeyValues := Variant(KeyValues[0]);
    End
  Else
     Begin
       FKeyKeyValues:=VarArrayCreate([0,High(KeyValues)],varObject);
       For X:=0 to High(KeyFields) do FKeyKeyValues[X] := Variant(KeyValues[X]);
     End;
End;

Procedure TKADaoTable.CancelKey;
Var
  Buffer : TRecordBuffer;
  X      : Integer;
  DI     : TDaoInfo;
begin
     Buffer := FKeyBuffer;
     DI     := GetDaoInfo(Buffer);
     TStringList(DI.RecordData).Clear;
     For X := 0 To FieldDefs.Count-1 do
          Begin
            TStringList(DI.RecordData).AddObject('',TObject(False));
          End;
     SetDaoInfo(Buffer,DI);
     FActiveKeyBuffer := Nil;
     FKeyKeyFields    := '';
     FKeyKeyValues    := Null;
     SetState(dsBrowse);
     //******************************************* 29.08.2001
     DataEvent(deDataSetChange, TObject(0));
     //******************************************* 29.08.2001
     Resync([rmExact]);
end;

Procedure TKADaoTable.ClearKey;
Var
  Buffer : TRecordBuffer;
  X      : Integer;
  DI     : TDaoInfo;
begin
     Buffer := FKeyBuffer;
     DI     := GetDaoInfo(Buffer);
     TStringList(DI.RecordData).Clear;
     For X := 0 To FieldDefs.Count-1 do
          Begin
            TStringList(DI.RecordData).AddObject('',TObject(False));
          End;
     SetDaoInfo(Buffer,DI);
     SetState(dsBrowse);
     //******************************************* 29.08.2001
     DataEvent(deDataSetChange, TObject(0));
     //******************************************* 29.08.2001
end;

Procedure TKADaoTable.SetKey;
begin
     ClearKey;
     FActiveKeyBuffer := FKeyBuffer;
     SetState(dsSetKey);
     DataEvent(deDataSetChange, TObject(0));
end;

Procedure TKADaoTable.EditKey;
begin
     FActiveKeyBuffer := FKeyBuffer;
     SetState(dsSetKey);
     DataEvent(deDataSetChange, TObject(0));
end;

Function  TKADaoTable.GotoKey: Boolean;
Var
  Buffer    : TRecordBuffer;
  X         : Integer;
  Count     : Integer;
  NumFields : Integer;
  NF        : Integer;
  FF        : TField;
  DI        : TDaoInfo;
Begin
  Result := False;
  if State=dsSetKey Then
     Begin
      Buffer := GetActiveRecordBuffer;
      if Buffer=Nil Then Exit;
      FKeyKeyFields:='';
      FKeyKeyValues:=Null;
      DI    := GetDaoInfo(Buffer);
      Count := TStringList(DI.RecordData).Count-1;
      NumFields := 0;
      For X := 0 To Count Do
          Begin
            if TStringList(DI.RecordData).Strings[X] <> '' Then
               Begin
                 FKeyKeyFields := FKeyKeyFields+FieldDefs[X].Name+';';
                 Inc(NumFields);
               End;
          End;
       if NumFields > 1 Then FKeyKeyValues:=VarArrayCreate([0,NumFields-1],varObject);
       NF:=0;
       For X := 0 To Count Do
          Begin
            if TStringList(DI.RecordData).Strings[X] <> '' Then
               Begin
                 if NumFields > 1 Then FKeyKeyValues[NF] := TStringList(DI.RecordData).Strings[X]
                 Else FKeyKeyValues := TStringList(DI.RecordData).Strings[X];
                 //************************************************** 29.08.2001
                 FF:=FindField(FieldDefs[X].Name);
                 if (FF <> Nil) And ((FF.DataType=ftDateTime) or (FF.DataType=ftDate) or (FF.DataType=ftTime)) Then
                    Begin
                     if NumFields > 1 Then
                        FKeyKeyValues[NF] := ComposeDateTimeVariant(TStringList(DI.RecordData).Strings[X])
                     Else
                        FKeyKeyValues := ComposeDateTimeVariant(TStringList(DI.RecordData).Strings[X]);
                    End;
                 //************************************************** 29.08.2001
                 Inc(NF);
               End;
          End;
      SetState(dsBrowse);
      DataEvent(deDataSetChange, TObject(0));
      if (TableType=dbOpenDynaset) or (TableType=dbOpenSnapshot) Then
         Begin
            Result := Find(FKeyKeyFields,FKeyKeyValues,[],3);
            if Not Result Then
               Result := Find(FKeyKeyFields,FKeyKeyValues,[],1);
         End;
      if (TableType=dbOpenTable) And (FIndexName <> '') Then
          Begin
            Result := Locate(FKeyKeyFields,FKeyKeyValues,[]);
          End;
      if (Not Result) And (Not ISEmpty) Then Resync([]);
     End
  Else
     Begin
       if FKeyKeyFields = '' Then Exit;
       if (TableType=dbOpenDynaset) or (TableType=dbOpenSnapshot) Then
         Begin
          Result := Find(FKeyKeyFields,FKeyKeyValues,[],3);
          if Not Result Then
             Result := Find(FKeyKeyFields,FKeyKeyValues,[],1);
         End;
       if (TableType=dbOpenTable) And (FIndexName <> '') Then
          Begin
            Result := Locate(FKeyKeyFields,FKeyKeyValues,[]);
          End;
     End;
  FKeyKeyValues:=Null;
End;

Procedure  TKADaoTable.GotoNearest;
Var
  Buffer    : TRecordBuffer;
  X         : Integer;
  Count     : Integer;
  NumFields : Integer;
  NF        : Integer;
  FF        : TField;
  DI        : TDaoInfo;
Begin
  if State=dsSetKey Then
     Begin
      Buffer := GetActiveRecordBuffer;
      if Buffer=Nil Then Exit;
      FKeyKeyFields:='';
      FKeyKeyValues:=Null;
      DI    := GetDaoInfo(Buffer);
      Count := TStringList(DI.RecordData).Count-1;
      NumFields := 0;
      For X := 0 To Count Do
          Begin
            if TStringList(DI.RecordData).Strings[X] <> '' Then
               Begin
                 if X < Count Then
                    FKeyKeyFields := FKeyKeyFields+FieldDefs[X].Name+';'
                 Else
                    FKeyKeyFields := FKeyKeyFields+FieldDefs[X].Name;
                 Inc(NumFields);
               End;
          End;
       if NumFields > 1 Then FKeyKeyValues:=VarArrayCreate([0,NumFields-1],varObject);
       NF:=0;
       For X := 0 To Count Do
          Begin
            if TStringList(DI.RecordData).Strings[X] <> '' Then
               Begin
                 if NumFields > 1 Then FKeyKeyValues[NF] := TStringList(DI.RecordData).Strings[X]
                 Else FKeyKeyValues := TStringList(DI.RecordData).Strings[X];
                 //************************************************** 29.08.2001
                 FF:=FindField(FieldDefs[X].Name);
                 if (FF <> Nil) And ((FF.DataType=ftDateTime) or (FF.DataType=ftDate) or (FF.DataType=ftTime)) Then
                    Begin
                     if NumFields > 1 Then
                        FKeyKeyValues[NF]:=ComposeDateTimeVariant(TStringList(DI.RecordData).Strings[X])
                     Else
                        FKeyKeyValues:=ComposeDateTimeVariant(TStringList(DI.RecordData).Strings[X]);
                    End;
                 //************************************************** 29.08.2001
                 Inc(NF);
               End;
          End;
      SetState(dsBrowse);
      DataEvent(deDataSetChange, TObject(0));
      Find_NearestEx(FKeyKeyFields,FKeyKeyValues);
     End
  Else
     Begin
       if FKeyKeyFields = '' Then Exit;
       Find_NearestEx(FKeyKeyFields,FKeyKeyValues);
     End;
  VarClear(FKeyKeyValues);
  FKeyKeyValues:=Null;
End;

Function TKADaoTable.FindKey(const KeyValues: array of const):Boolean;
Begin
 Result:=Seek_NearestEx(KeyValues,'=');
End;

Function TKADaoTable.FindKeyEx(const KeyValues: array of const):Boolean;
Begin
 Result:=Seek_NearestEx(KeyValues,'>=');
End;

//******************************************************************************

Function TKADaoTable.Find_NearestEx(const KeyFields: string; const KeyValues: Variant):Boolean;
Var
  Options:TLocateOptions;
Begin
  Options:=[loCaseInsensitive,loPartialKey];
  Result:=Find(KeyFields,KeyValues,Options,1);
  if Not Result Then Result:=Find(KeyFields,KeyValues,Options,3);
End;

Function TKADaoTable.Find_Nearest(const KeyValues: array of const):Boolean;
Var
  KF         : String;
  KV         : Variant;
  X          : Integer;
Begin
  KF:='';
  For X:=0 to High(KeyValues) do
      Begin
        if X < High(KeyValues) Then KF := KF+FKeyFields.Strings[X]+';' Else  KF := KF+FKeyFields.Strings[X];
       End;
  if High(KeyValues)=0 then
    Begin
      KV := Variant(KeyValues[0]);
    End
  Else
     Begin
       KV:=VarArrayCreate([0,High(KeyValues)],varObject);
       For X:=0 to High(KeyValues) do
           Begin
            KV[X] := Variant(KeyValues[X]);
           End;
     End;
  Result := Find_NearestEx(KF,KV);
  KV     := NULL;
End;


Function TKADaoTable.Seek_NearestEx(const KeyValues: array of const; SeekType:String):Boolean;
Var
 KV     : Variant;
 X      : Integer;
 CR     : Integer;
 NumVals: Integer;
 //*************************************
 BK       : Integer;
 TempRS   : Recordset;
 //*************************************
Begin
 Result:=False;
 if FIndexName='' Then Exit;
 if IsEmpty Then Exit;
 If ((FFiltered) And (Assigned(FOnFilterRecord))) Or (FRangeFiltered) Then Exit;
 if High(KeyValues)=0 then
    Begin
      NumVals:=1;
      KV := Variant(KeyValues[0]);
    End
  Else
     Begin
       KV:=VarArrayCreate([0,High(KeyValues)],varObject);
       NumVals:=High(KeyValues)+1;
       For X:=0 to High(KeyValues) do
           Begin
            KV[X] := Variant(KeyValues[X]);
           End;
     End;
     InternalSetToRecord(GetActiveRecordBuffer);
     CR:=FRecNo;
     TempRS:=FDaoTable.Clone;
     TempRS.Index:=FIndexName;
     TempRS.MoveFirst;
     TempRS.Move(CR,Nil);
     if NumVals=1 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0]])
     Else
     if NumVals=2 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0],KV[1]])
     Else
     if NumVals=3 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0],KV[1],KV[2]])
     Else
     if NumVals=4 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0],KV[1],KV[2],KV[3]])
     Else
     if NumVals=5 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0],KV[1],KV[2],KV[3],KV[4]])
     Else
     if NumVals=6 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5]])
     Else
     if NumVals=7 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6]])
     Else
     if NumVals=8 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7]])
     Else
     if NumVals=9 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8]])
     Else
     if NumVals=10 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8],KV[9]])
     Else
     if NumVals=11 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8],KV[9],KV[10]])
     Else
     if NumVals=12 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8],KV[9],KV[10],KV[11]])
     Else
     if NumVals=13 Then FDatabase.ComWrapper.Call(TempRS,'Seek',[SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8],KV[9],KV[10],KV[11],KV[12]])
     Else
     DatabaseError(E2033);
     VarClear(KV);
     KV := NULL;
     if (Not TempRS.NoMatch) Then
          Begin
            Result:= True;
            BK:=GetDaoBookMark(TempRS);
            CheckBrowseMode;
            CursorPosChanged;
            DoBeforeScroll;
            CR:=FRecalculateRecNo(TempRS,BK);
            InternalMoveToBookmark(BK);
            FRecNo:=CR;
            //************************************ ClearBuffers;
            Resync([rmExact, rmCenter]);
            DoAfterScroll;
          End;
     TempRS.Close;
End;

Function TKADaoTable.Seek_Nearest(const KeyValues: array of const):Boolean;
Begin
 Result:=Seek_NearestEx(KeyValues,'>=');
End;

Procedure TKADaoTable.FindNearest(const KeyValues: array of const);
Begin
 if Seek_NearestEx(KeyValues,'>=')=False Then
    Begin
    End;
End;


Function  TKADaoTable.Lookup(const KeyFields: string; const KeyValues: Variant; const ResultFields: string): Variant;
Var
 KF     : TStringList;
 KV     : TStringList;
 RF     : TStringList;
 RS     : Recordset;
 TempRS : Recordset;
 FT      : String;
 X       : Integer;
 FN      : Integer;
 FF      : TField;
 HasLKF  : Boolean;
Begin
 Result := NULL;
 if IsEmpty Then Exit;
 if FBatchMode  Then Exit;
 KF := TStringList.Create;
 KV := TStringList.Create;
 RF := TStringList.Create;
 Try
  StringToList(KeyFields,KF);
  VariantToList(KeyValues,KV);
  StringToList(ResultFields,RF);
  if (KF.Count <> KV.Count)  Then DatabaseError(E2032);
  if (RF.Count=0) Or (ResultFields='') Then DatabaseError(E2034);
  HasLKF := False;
  For X:=0 To RF.Count-1 do
     Begin
       FF := FindField(RF.Strings[X]);
       if FF <> Nil Then
          Begin
           FN := FF.FieldNo;
           RF.Objects[X]:=TObject(FN);
           if (FF.FieldKind<>fkData) Then HasLKF := True;
          End
       Else
          Begin
            DatabaseError(E2070+RF.Strings[X]);
          End;
     End;
  RS:=FDaoTable;
  FT:=FDaoTable.Filter;
  RS.Filter:=BuildKeySQL(KF,KV);
  FDatabase.Idle;
  TempRS:=RS.OpenRecordset(TObject(dbOpenSnapshot),TObject(dbReadOnly));
  If Not(TempRS.EOF and TempRS.BOF) then
    Begin
       TempRS.MoveFirst;
       if HasLKF Then
           Begin
             //*********************************** We have Calc or Lookup fields
             InternalFillRecordData(TempRS,False, TempBuffer);
             SetTempState(dsCalcFields);
             Try
              CalculateFields(TempBuffer);
              Result := FieldValues[ResultFields];
             Finally
              RestoreState(dsBrowse);
             End;
           End
       Else
           Begin
            //************************************* Only DAO Fields so go faster
            if RF.Count=1 Then
               Begin
                 FN:=Integer(RF.Objects[0])-1;
                 Result:=OleVariant(TempRS.Fields.Item[TObject(FN)].Value);
               End
            Else
               Begin
                 Result:= VarArrayCreate([0,RF.Count - 1], varObject);
                 For X:=0 To RF.Count-1 do
                     Begin
                      FN:=Integer(RF.Objects[X])-1;
                      Result[X]:=OleVariant(TempRS.Fields.Item[TObject(FN)].Value)
                    End;
               End;
           End;
    End;
  TempRS.Close;
  TempRS:=Nil;
  RS.Filter:=FT;
 Finally
  RF.Free;
  KV.Free;
  KF.Free;
 End;
End;

Procedure TKADaoTable.RefreshLookups;
Var
  X : Integer;
Begin
  if NOT FActive then Exit;
  For X := 0 to FieldCount-1 do
     Begin
       if (Fields[X].FieldKind=fkLookup) And (Fields[X].LookupCache) Then
          Fields[X].RefreshLookupList;
     End;
End;

{*************************************************************** DAO FIELD TYPES
  dbBoolean = 1;
  dbByte = 2;
  dbInteger = 3;
  dbLong = 4;
  dbCurrency = 5;
  dbSingle = 6;
  dbDouble = 7;
  dbDate = 8;
  dbBinary = 9;
  dbText = 10;
  dbLongBinary = 11;
  dbMemo = 12;
  dbGUID = 15;
  dbBigInt = 16;
  dbVarBinary = 17;
  dbChar = 18;
  dbNumeric = 19;
  dbDecimal = 20;
  dbFloat = 21;
  dbTime = 22;
  dbTimeStamp = 23;
//******************************************************************************
}

Function TKADaoTable.CreateField(FieldName:String;FieldType:Integer;FiledSize:Integer):Boolean;
Var
  FN,FT,FS,FI,FR:Variant;
Begin
  Result:=False;
  if FTableName='' Then
     Begin
       DatabaseError(E2035);
       Exit;
     End;
  if Not Assigned(FDatabase) Then
         Begin
           DatabaseError(E2036);
           Exit;
         End;
   if Not (FDatabase.Connected) Then
         Begin
           DatabaseError(E2037);
           Exit;
         End;
  if FActive Then
     Begin
      DatabaseError(E2038);
      Exit;
     End;
  FN:=VarArrayCreate([0, 0], varString);
  FT:=VarArrayCreate([0, 0], varInteger);
  FS:=VarArrayCreate([0, 0], varInteger);
  FI:=VarArrayCreate([0, 0], varInteger);
  FR:=VarArrayCreate([0, 0], varInteger);
  FN[0]:=FieldName;
  FT[0]:=FieldType;
  FS[0]:=DaoSizeToBDESize(FieldType,FiledSize);
  FI[0]:=0;
  FR[0]:=0;
  Try
    Result:=FDatabase.AddFieldsToTable(FTableName,FN,FT,FS,FI,FR);
  Except
    Exit;
  End;
  VarClear(FN);FN:=NULL;
  VarClear(FT);FT:=NULL;
  VarClear(FS);FS:=NULL;
  VarClear(FI);FI:=NULL;
  VarClear(FR);FR:=NULL;
End;

Function TKADaoTable.CreateIndex(FieldName:String;IndexType:Integer):Boolean;
Begin
  Result:=False;
  if FTableName='' Then
     Begin
       DatabaseError(E2039);
       Exit;
     End;
  if Not Assigned(FDatabase) Then
     Begin
       DatabaseError(E2040);
       Exit;
     End;
   if Not (FDatabase.Connected) Then
         Begin
           DatabaseError(E2041);
           Exit;
         End;
  if FActive Then
     Begin
       DatabaseError(E2042);
       Exit;
     End;
  Result:=FDatabase.CreateIndex(FTableName,FieldName,IndexType);
End;

Function TKADaoTable.DeleteField(FieldName:String):Boolean;
Begin
  Result:=False;
  if FTableName='' Then
     Begin
       DatabaseError(E2043);
       Exit;
     End;
  if Not Assigned(FDatabase) Then
     Begin
       DatabaseError(E2044);
       Exit;
     End;
  if Not (FDatabase.Connected) Then
     Begin
       DatabaseError(E2045);
       Exit;
     End;
  if FActive Then
     Begin
       DatabaseError(E2046);
       Exit;
     End;
  Try
    FDatabase.DeleteField(FTableName,FieldName);
  Except
    Exit;
  End;
  Result:=True;
End;

Function TKADaoTable.DeleteIndex(FieldName:String):Boolean;
Begin
  Result:=False;
  if FTableName='' Then
     Begin
       DatabaseError(E2047);
       Exit;
     End;
  if Not Assigned(FDatabase) Then
     Begin
       DatabaseError(E2048);
       Exit;
     End;
  if FActive Then
     Begin
       DatabaseError(E2049);
       Exit;
     End;
  if Not (FDatabase.Connected) Then
     Begin
       DatabaseError(E2050);
       Exit;
     End;

  Try
    FDatabase.DeleteIndexByFieldName(FTableName,FieldName);
  Except
    Exit;
  End;
  Result:=True;
End;

Function TKADaoTable.EmptyTable:Boolean;
Begin
 Result := True;
 if IsEmpty Then Exit;
 if FReadOnly Then DatabaseError(E2064);
 BatchMode := True;
 Try
   First;
   While NOT EOF do
     Begin
       FInPost := True;
       Delete;
       FInPost := False;
     End;
  CursorPosChanged;
  Resync([]);
 Finally
   BatchMode:=False;
   FInPost := False;
   Result := Not IsEmpty;
 End;
End;

//******************************************************************************
Procedure TKADaoTable.CreateTable;
Var
 TM : TKadaoTableManager;
Begin
 if FActive Then DatabaseError(E2066);
 if FTableName='' Then DatabaseError(E2067);
 TM := TKADaoTableManager.Create(FDatabase);
 Try
  TM.TableName:=FTableName;
  TM.FieldDefs.Assign(Self.FieldDefs);
  TM.IndexDefs.Assign(Self.IndexDefs);
  TM.CreateTable;
 Finally
  TM.Free;
 End;
End;

Procedure TKADaoTable.AppendTable;
Var
 TM : TKadaoTableManager;
Begin
 if FActive Then DatabaseError(E2068);
 if FTableName='' Then DatabaseError(E2069);
 TM := TKADaoTableManager.Create(FDatabase);
 Try
  TM.TableName:=FTableName;
  TM.FieldDefs.Assign(Self.FieldDefs);
  TM.IndexDefs.Assign(Self.IndexDefs);
  TM.AppendTable;
 Finally
  TM.Free;
 End;
End; 
//******************************************************************************

Function TKADaoTable.InsertSQLString(MDString: String): String;
Begin
  Result:='';
  if FFiltered Then Result:= Filter;
  if MDString <> '' then
    Begin
      if Result <> '' Then
         Result := '('+MDString+') AND ('+Result+')'
      Else
         Result := MDString;
    End;
End;

//******************************************************************************
//*                  Master/Detail Handling
//******************************************************************************
Function  TKADaoTable.GetMasterSource : TDataSource;
Begin
 Result:= FMasterLink.DataSource;
End;

Procedure TKADaoTable.SetMasterSource(Value: TDataSource);
Begin
 if IsLinkedTo(Value) then DatabaseError(E2057);
 if (Value=Nil) Then MasterFields.Clear;
 FMasterLink.DataSource:= Value;
 if (Active) Then
     Begin
       CheckBrowseMode;
       ClearBuffers;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
End;

Procedure TKADaoTable.FProcessMasterFields(Value:TStrings);
Var
  X                       : Integer;
  I                       : Integer;
  S                       : String;
  MasterField,DetailField : String;
  FieldNames              : String;
Begin
  FDetail.Clear;
  FMaster.Clear;
  if (Value.Count=1) And (Pos(';',Value.Strings[0]) > 0) Then
     Begin
       S := Value.Strings[0];
       Repeat
        I := Pos(';',S);
        if I > 0 Then
           Begin
            DetailField:=Copy(S,1,I-1);
            Borland.Delphi.System.Delete(S,1,I);
           End
        Else
           Begin
            DetailField:=S;
           End;
        if Length(DetailField) > 0 Then
           Begin
            MasterField:=DetailField;
            FDetail.Add(DetailField);
            FMaster.Add(MasterField);
           End;
       Until I = 0;
     End
  Else
  For X:=0 to Value.Count-1 do
      Begin
        S := Value.Strings[X];
        I := Pos(' -> ',S);
        if I > 0 Then
        Begin
         DetailField:=Copy(S,1,I-1);
         Borland.Delphi.System.Delete(S,1,I+Length(' -> ')-1);
         MasterField:=S;
         FDetail.Add(DetailField);
         FMaster.Add(MasterField);
        End;
      End;
  FieldNames:='';
  For X := 0 To FDetail.Count-1 do
      Begin
        if X < FDetail.Count-1 Then
           FieldNames:=FieldNames+FMaster.Strings[X]+';'
        Else
           FieldNames:=FieldNames+FMaster.Strings[X];
      End;
  FMasterLink.FieldNames:=FieldNames;
End;

Procedure TKADaoTable.SetMasterFields(Value:TStrings);
Begin
 FMasterFields.Assign(Value);
 if (Active) Then
     Begin
       CheckBrowseMode;
       ClearBuffers;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
End;

Procedure TKADaoTable.SetMaster(Value:TStrings);
Begin
 FMaster.Assign(Value);
End;

Procedure TKADaoTable.SetDetail(Value:TStrings);
Begin
 FDetail.Assign(Value);
End;


Procedure TKADaoTable.MasterDatasetChanged;
Begin
  if csDestroying in ComponentState then EXIT;
  FMDisabled := Not (FMasterLink.Active);
  if  (MasterSource <> NIL)
  And (Not MasterSource.DataSet.ControlsDisabled)
  And (Not ControlsDisabled)
  And (Not FMDisabled) then
  Begin
  //***************************************************************** 28.01.2002
  if NOT MasterSource.Enabled    Then Exit;
  if MasterSource.State = dsEdit Then Exit;
  //***************************************************************** 28.01.2002
  if FMaster.Count > 0 Then
     Begin
      //*************************************************
      CheckBrowseMode;
      ClearBuffers;
      //*************************************************
      CloseDaoRecordset;
      if FSQL.Count > 0 Then
         Begin
           OpenDaoRecordset
         End
       Else
         Begin
           Try
             ReOpenDaoRecordset;
           Except
             OpenDaoRecordset;
           End;
          End;
      ActivateBuffers;
      //*************************************************
      First;
      //*************************************************
     End;
  End;
End;


Procedure TKADaoTable.RefreshQueryParams;
var
  DataSet   : TDataSet;
  X         : Integer;
  TempParam : TParam;
Begin
  Try
    if FMasterLink.DataSource <> nil then
       Begin
        DataSet := FMasterLink.DataSource.DataSet;
        if (DataSet <> Nil)
            And (DataSet.Active)
            And (DataSet.State <> dsSetKey) Then
              Begin
                If ((FParamCheck) And (FParams.Count > 0)) Then
                    Begin
                      For X := 0 to FMasterLink.DataSource.DataSet.Fields.Count - 1 do
                        Begin
                          TempParam := FParams.FindParam(FMasterLink.DataSource.DataSet.Fields[X].FieldName);
                          if TempParam <> Nil Then
                             Begin
                               if TempParam.DataType=ftUnknown Then TempParam.DataType:=FMasterLink.DataSource.DataSet.Fields[X].DataType;
                               TempParam.Assign(FMasterLink.DataSource.DataSet.Fields[X]);
                             End;
                        End;
                    End;
              End;
       End;
  Finally
  End;
End;


Procedure TKADaoTable.UpdateFromMaster;
Var
  X         : Integer;
  TempField : TField;
Begin
  For X := 0 to FMasterLink.Fields.Count - 1 do
      Begin
       TempField := FieldByName(FDetail.Strings[X]);
       TempField.Assign(TField(FMasterLink.Fields[X]));
      End;
End;

Procedure TKADaoTable.DoOnNewRecord;
begin
  If (FMasterLink.Active) And (FMasterLink.Fields.Count>0) Then
     Begin
      UpdateFromMaster;
     End;
  inherited DoOnNewRecord;
end;

Procedure TKADaoTable.MasterChanged(Sender: TObject);
Begin
 if not Active then Exit;
 CheckBrowseMode;
 If (FMasterLink.Active) And (FMasterLink.Fields.Count>0)  Then
     Begin
      if (FSQL.Count > 0) Then RefreshQueryParams;
      MasterDatasetChanged;
     End;
End;

Procedure TKADaoTable.MasterDisabled(Sender: TObject);
Begin
 CheckBrowseMode;
 FMDisabled := Not (FMasterLink.Active);
End;
//******************************************************************************
//*                         Blob Stream Handling
//******************************************************************************
Function TKADaoTable.BlobToString(Field:TBlobField; Data : OleVariant; DataSize:Integer):String;
Var
  P  : IntPtr;
Begin
  //***************************************************************** 22.09.2001
  Result := '';
  if VarIsNull(Data)  Then Exit;
  if VarIsEmpty(Data) Then Exit;
  if DataSize=0       Then Exit;
  //****************************************************************************
  if Field.BlobType=ftMemo Then
     Begin
       Result := Data;
     End
  Else
     Begin
       P := Marshal.AllocHGlobal(DataSize);
       Try
         Marshal.Copy(Data,0,P,DataSize);
         Result := Marshal.PtrToStringAnsi(P,DataSize);
       Finally
         Marshal.FreeHGlobal(P);
       End;
     End;
End;

Function TKADaoTable.StringToBlob(Field:TBlobField; Data:String) : OleVariant;
Begin
   if Field.DataType=ftMemo Then
      Begin
        Result := Data;
      End
   Else
      Begin
        Result   := OleVariant(AnsiEncoding.GetBytes(Data));
     End;
End;

procedure TKADaoTable.ProcDataEvent(Event: TDataEvent; Info: TObject);
Begin
  DataEvent(Event, Info);
End;

Constructor TKBlobStream.Create(Field: TBlobField; Mode: TBlobStreamMode);
Var
   RD        : OleVariant;
   RS        : Integer;
   DInfo     : TDaoInfo;
   TempBK    : Integer;
   FBuffer   : TRecordBuffer;
   FBlobData : TBlobData;
   FBlobSize : Integer;
Begin
     Inherited Create;
     FBlobData   := '';
     FModified   := False;
     FMode       := Mode;
     FField      := Field;
     FOpened     := True;
     FDataSet    := FField.DataSet as TKADaoTable;
     FBuffer     := FDataSet.GetActiveRecordBuffer;
     //************************************************** Table is empty so exit
     if FBuffer = Nil Then Exit;
     //*************************************************************************
     if Mode = bmWrite then
        Begin
          if FDataSet.ReadOnly Then DatabaseError(E2056);
          Truncate;
        End
     Else
     if Not FField.Modified Then
        Begin
           DInfo := FDataset.GetDaoInfo(FBuffer);
           //*******************************************************************
           //              CACHED MEMOS HANDLING
           //*******************************************************************
           if  (Field.DataType = ftMemo)
           And (FDataset.FCacheMemos)  Then
               Begin
                 FBlobData:=TStringList(DInfo.RecordData).Strings[FField.FieldNo-1];
                 if (DInfo.RecordNo=-1) And (FBlobData='') Then
                    FBlobData := FDataSet.FDefaultValues.Strings[FField.FieldNo-1];
                 FBlobSize := Length(FBlobData);
               End
           Else
           //*******************************************************************
           //              CACHED BLOBS HANDLING
           //*******************************************************************
           if  (Field.DataType = ftBlob)
           And (FDataset.FCacheBlobs)  Then
               Begin
                 FBlobData:=TStringList(DInfo.RecordData).Strings[FField.FieldNo-1];
                 if (DInfo.RecordNo=-1) And (FBlobData='') Then
                    FBlobData := FDataSet.FDefaultValues.Strings[FField.FieldNo-1];
                 FBlobSize:=Length(FBlobData);
               End
           Else
              Begin
                //*******************************************************************
                //            Save Current Position and go to the desired row
                //*******************************************************************
                TempBK := FDataSet.GetDaoBookmark(FDataSet.FDaoTable);
                if DInfo.BookmarkData > 0 Then
                   FDataSet.InternalMoveToBookmark(DInfo.BookmarkData);
                //*******************************************************************
                //   UNIQUE CODE TO SUPPORT BOTH VIEW OF BLOBS IN GRIDS
                //   AND DEFAULT VALUES FOR BLOBS
                //*******************************************************************
                if (FDataSet.State = dsInsert) And (DInfo.RecordNo=-1) Then
                   Begin
                     FBlobData := '';
                     FBlobData := TStringList(DInfo.RecordData).Strings[FField.FieldNo-1];
                     if (FBlobData='') And
                        (FDataSet.FDefaultValues.Strings[FField.FieldNo-1] <> '') Then
                           Begin
                             FBlobData := FDataSet.FDefaultValues.Strings[FField.FieldNo-1];
                           End;
                   End
                Else
                   Begin
                     Try
                      //************************************************* 01.02.2002
                      RD := OleVariant(FDataSet.FDaoTable.Fields.Item[TObject(FField.FieldNo-1)].Value);
                      RS := FDataSet.FDaoTable.Fields.Item[TObject(FField.FieldNo-1)].FieldSize;
                      if VarType(RD) = varNull Then
                         FBlobData := ''
                      Else
                         FBlobData:=FDataSet.BlobToString(FField,RD,RS);
                      if FDataSet.FHasEncoder Then
                         Begin
                           //*******************************************
                           // Perform Decoding here
                           //*******************************************
                           SetStrProp(FDataSet.FEncrypter, FDataSet.FEncodedString,FBlobData);
                           FBlobData:=GetStrProp(FDataSet.FEncrypter, FDataSet.FDecodedString);
                         End;
                          //************************************************* 01.02.2002
                     Except
                       FBlobData:='';
                       if FDataSet.FTableType <> dbOpenForwardOnly Then FDataSet.DaoInternalRefresh;
                     End;
                   End;
                FBlobSize := Length(FBlobData);
                //******************************************************** Reposition
                if TempBK > 0 Then
                   Begin
                    FDataSet.InternalMoveToBookmark(TempBK);
                   End;
                //*******************************************************************
              End;
          if FBlobSize > 0 Then
             Begin
               Size        := FBlobSize;
               System.Array.Copy(System.Array(AnsiEncoding.GetBytes(String(FBlobData))), Memory, FBlobSize);
             End;
           FBlobData := '';
        End;
End;


Destructor TKBlobStream.Destroy;
Var
  Buffer : TRecordBuffer;
  TmpTag : TTag;
Begin
 if FModified then
    Begin
      TmpTag     := FField.Tag;
      try
        FOpened   := False;
        Buffer    := Marshal.AllocHGlobal(Size);
        try
          if Size > 0 Then Marshal.Copy(Memory,0,Buffer,Size);
          FField.Tag := Size;
          FDataSet.SetFieldData(FField, Buffer);
        Finally
          FField.Tag := TmpTag;
          Marshal.FreeHGlobal(Buffer);
        End;
        FField.Modified := True;
        FDataSet.ProcDataEvent(deFieldChange, TObject(FField));
      Except
        Application.HandleException(Self);
      End;
    End;
 inherited Destroy;
End;


function TKBlobStream.Write(const Buffer: array of Byte; Offset, Count: Integer): Longint;
begin
  Result      := inherited Write(Buffer, Offset, Count);
  FModified   := True;
end;

Procedure TKBlobStream.Truncate;
Begin
 Self.Size := Self.Position;
 FModified := True;
End;

//***********************************************************************************
Function TKADaoTable.Int16ToBuffer(Buffer: TValueBuffer; S: String): Boolean;
Begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     if S = '' then S := '0';
     Try
       Marshal.WriteInt16(Buffer,StrToInt(S));
     Except
       Try
         Marshal.WriteInt16(Buffer,Round(StrToFloat(S)));
       Except
       End;
     End;
End;

Function TKADaoTable.IntegerToBuffer(Buffer: TValueBuffer; S: String): Boolean;
Begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     if S = '' then S := '0';
     Try
       Marshal.WriteInt32(Buffer,StrToInt(S));
     Except
       Try
         Marshal.WriteInt32(Buffer,Round(StrToFloat(S)));
       Except
       End;
     End;
End;


Function TKADaoTable.FloatToBuffer(Buffer: TValueBuffer; S: String): Boolean;
Var
 Float : Double;
Begin
     Result := False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     if S = '' then S := '0';
     Try
       Float := StrToFloat(S);
       Marshal.WriteInt64(Buffer,BitConverter.DoubleToInt64Bits(Float));
     Except
     End;
End;

Function TKADaoTable.BooleanToBuffer(Buffer: TValueBuffer; S: String): Boolean;
Var
 WB : WordBool;
Begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     //************************************************************** 25.01.2002
     if Result Then
        Begin
         if S[1]='=' Then Borland.Delphi.System.Delete(S,1,1);
         if WideLowerCase(S)='false' Then S := '0'
         Else
         if WideLowerCase(S)='true'  Then S := '1'
         Else
         if WideLowerCase(S)='no'    Then S := '0'
         Else
         if WideLowerCase(S)='yes'   Then S := '1'
         Else
         if WideLowerCase(S)='on'    Then S := '1'
         Else
         if WideLowerCase(S)='off'   Then S := '0'
         Else
         if S = ''    Then S := '0'
         Else
         if S = '-1'  Then S := '1';
         Try
          WB := WordBool(StrToInt(S));
          Marshal.WriteInt16(Buffer,Int16(WB));
         Except
         End;
        End;
End;

//************************************************************************** OK
Function TKADaoTable.DateToBuffer(Buffer: TValueBuffer; S: String): Boolean;
var
   Ttmp : TTimeStamp;
   Dtmp : TDateTimeRec;
   P    : Integer;
Begin
 Result:=False;
 if Buffer=Nil Then Exit;
 P := Pos(' ',S);
 if P=0 Then Exit;
 Try
  Ttmp.Date  := StrToInt(Copy(S,1,P-1));
  Borland.Delphi.System.Delete(S,1,P);
  Ttmp.Time  := StrToInt(S);

  Dtmp.Date  := Ttmp.Date;
  Marshal.WriteInt64(Buffer,BitConverter.DoubleToInt64Bits(Dtmp.DateTime));
  Result:=True;
 Except
 End;
End;


//************************************************************************** OK
Function TKADaoTable.TimeToBuffer(Buffer: TValueBuffer; S: String): Boolean;
var
   Ttmp : TTimeStamp;
   Dtmp : TDateTimeRec;
   P    : Integer;
Begin
 Result:=False;
 if Buffer=Nil Then Exit;
 P := Pos(' ',S);
 if P=0 Then Exit;
 Try
  Ttmp.Date := StrToInt(Copy(S,1,P-1));
  Borland.Delphi.System.Delete(S,1,P);
  Ttmp.Time := StrToInt(S);

  Dtmp.Date := 0;
  Dtmp.Time := Ttmp.Time;
  Marshal.WriteInt64(Buffer,BitConverter.DoubleToInt64Bits(Dtmp.DateTime));
  Result:=True;
 Except
 End;
End;

//************************************************************************** OK
Function TKADaoTable.DateTimeToBuffer(Buffer: TValueBuffer; S: String): Boolean;
var
   Ttmp : TTimeStamp;
   Dtmp : Double;
   P    : Integer;
Begin
 Result:=False;
 if Buffer=Nil Then Exit;
 P := Pos(' ',S);
 if P=0 Then Exit;
 Try
  Ttmp.Date     := StrToInt(Copy(S,1,P-1));
  Borland.Delphi.System.Delete(S,1,P);
  Ttmp.Time     := StrToInt(S);

  Dtmp          := TimeStampToMSecs(Ttmp);
  Marshal.WriteInt64(Buffer,BitConverter.DoubleToInt64Bits(Dtmp));
  Result:=True;
 Except
 End;
End;

//************************************************************************** OK
Function TKADaoTable.GUIDToBuffer(Buffer: TValueBuffer; S: String): Boolean;
Var
  BGUID : TGUID;
  SGUID : String;
  P     : Integer;
Begin
  Result:=False;
  if Buffer=Nil Then Exit;
  Result := (S <> '');
  if S = '' Then Exit;
  SGUID  := S;
  P := Pos('{guid ',SGUID);
  if P = 1 Then
     Begin
       Borland.Delphi.System.Delete(SGUID,1,6);
       P := Pos('}}',SGUID);
       if P = Length(SGUID)-1 Then Borland.Delphi.System.Delete(SGUID,P,1);
     End;
  BGUID := StringToGUID(WideUpperCase(SGUID));
  Marshal.StructureToPtr(BGUID,Buffer,True);
End;

//************************************************************************** OK
Function TKADaoTable.BufferToGUID(Buffer:TValueBuffer):String;
Var
 S  : String;
Begin
 Result := '';
 S      := WideUpperCase(GUIDToString(TGUID(Marshal.PtrToStructure(Buffer,TypeOf(TGUID)))));
 if S    = GUID_NULL Then Exit;
 Result := '{guid {'+S+'}}';
End;

//************************************************************************** OK
Function  TKADaoTable.GetGUIDAsString(GUID : String):String;
Var
  BGUID : TGUID;
  PGUID : IntPtr;
  SGUID : String;
Begin
  Result  := '';
  if Length(GUID) <> SizeOF(TGUID) Then Exit;
  SGUID  := GUID;
  PGUID := Marshal.AllocHGlobal(SizeOf(TGUID));
  Try
    Marshal.Copy(AnsiEncoding.GetBytes(GUID),0,PGUID,SizeOf(TGUID));
    BGUID  := TGUID(Marshal.PtrToStructure(PGUID,TypeOf(TGUID)));
    Result := '{'+GUIDToString(BGUID)+'}';
  Finally
    Marshal.FreeHGlobal(PGUID);
  End;
  If Result=GUID_NULL Then Result:='';
End;

//************************************************************************** OK
Function  TKADaoTable.GetStringAsGUID(GUID : String) : TGUID;
Begin
 Result := StringToGUID(GUID);
End;

//************************************************************************** OK
Function  TKADaoTable.PutGUIDInString(GUID : String):String;
Var
 BGUID : TGUID;
 PGUID : IntPtr;
Begin
 BGUID  := StringToGUID(GUID);
 PGUID := Marshal.AllocHGlobal(SizeOf(TGUID));
  Try
    Marshal.StructureToPtr(BGUID,PGUID,True);
    Result := Marshal.PtrToStringAnsi(PGUID,SizeOf(TGUID));
  Finally
    Marshal.FreeHGlobal(PGUID);
  End;
End;

//************************************************************************** OK
Function TKADaoTable.BufferToFloat(Buffer: TValueBuffer): String;
Var
 BA    : Array[0..7] of Byte;
Begin
  Try
    Marshal.Copy(Buffer,TBytes(BA),0,8);
    Result := BitConverter.ToDouble(BA,0).ToString;
  Except
    Result := '';
  End;
End;

Function TKADaoTable.BufferToDate(Buffer: TValueBuffer): String;
var
   Dtmp : TDateTimeRec;
Begin
     Result := '';
     Dtmp   := TDateTimeRec(Marshal.PtrToStructure(Buffer,TypeOf(TDateTimeRec)));
     Try
       Result := IntToStr(Dtmp.Date)+' '+IntToStr(0);
     Except
      Result := '';
     End;
End;

//************************************************************************** OK
Function TKADaoTable.BufferToDateTime(Buffer: TValueBuffer): String;
var
   Dtmp  : TTimeStamp;
Begin
     Result := '';
     Try
       Dtmp   := MSecsToTimeStamp(Trunc(BitConverter.Int64BitsToDouble(Marshal.ReadInt64(Buffer))));
       Result := IntToStr(Dtmp.Date)+' '+IntToStr(Dtmp.Time);
     Except
       Result := '';
     End;
End;

//************************************************************************** OK
Function TKADaoTable.BufferToTime(Buffer: TValueBuffer): String;
var
   Dtmp : TDateTimeRec;
Begin
     Result := '';
     Dtmp   := TDateTimeRec(Marshal.PtrToStructure(Buffer,TypeOf(TDateTimeRec)));
     Try
       Result := IntToStr(693594)+' '+IntToStr(Dtmp.Time);
     Except
       Result := '';
     End;
End;

//***************************************************************** TPARAMETERS
Procedure TKADaoTable.SetParamsList(Value: TParams);
begin
    FParams.AssignValues(Value);
end;

Procedure TKADaoTable.UpdateParamsList(Sender: TObject);
var
    List: TParams;
begin
    if not (csReading in ComponentState) then
        if ParamCheck or (csDesigning in ComponentState) then
        begin
            List := TParams.Create(Self);
            try
                List.ParseSQL(SQL.Text, True);
                List.AssignValues(FParams);
                FParams.Clear;
                FParams.Assign(List);
            finally
                List.Free;
            end;
        end;
end;

Function TKADaoTable.GetParamsCount: Word;
begin
    Result := FParams.Count;
end;

Procedure TKADaoTable.DefineProperties(Filer: TFiler);

    Function WriteData: Boolean;
    begin
        if Filer.Ancestor <> nil then
            Result := not FParams.IsEqual(TKADaoTable(Filer.Ancestor).FParams)
        else
            Result := FParams.Count > 0;
    end;

begin
    inherited DefineProperties(Filer);
    Filer.DefineProperty('ParamData', ReadParamData, WriteParamData, WriteData);
end;

Procedure TKADaoTable.ReadParamData(Reader: TReader);
begin
    Reader.ReadValue;
    Reader.ReadCollection(FParams);
end;

Procedure TKADaoTable.WriteParamData(Writer: TWriter);
begin
    Writer.WriteCollection(Params);
end;
//************************************************************** TPARAMETERS END

Procedure Register;
Begin
    RegisterComponents('KA Dao', [TKADaoTable]);
End;


end.


