unit KA.Data.KADao.DummyDataset;
//******************************************************************************
//                    Delphi Dao Project Version 2.40
//                 Copyright (c) 2000 by Kiril Antonov
//******************************************************************************
interface
uses
 Borland.Vcl.Classes,
 Borland.Vcl.Db,
 Borland.Vcl.Forms,
 Borland.Vcl.Variants;

Type
TDummyDataset = class(TDataSet)
private
protected
        Procedure       InternalOpen; override;
        Procedure       InternalClose; override;
        Function        IsCursorOpen: Boolean; override;
        Function        GetCanModify: Boolean; override;
        Function        GetRecordSize: Word;override;
        Function        AllocRecordBuffer: TRecordBuffer; override;
        Procedure       FreeRecordBuffer(var Buffer: TRecordBuffer); override;
        Procedure       InternalFirst;override;
        Procedure       InternalLast;override;
        Procedure       InternalInitFieldDefs; override;
        Procedure       InternalInitRecord(Buffer: TRecordBuffer); override;
        Procedure       SetFieldData(Field: TField; Buffer: TValueBuffer);override;
        Procedure       InternalEdit; override;
        Procedure       InternalAddRecord(Buffer: TValueBuffer; Append: Boolean); override;
        Procedure       InternalPost; override;
        Procedure       InternalDelete; override;
        Function        GetRecord(Buffer: TRecordBuffer; GetMode: TGetMode; DoCheck: Boolean): TGetResult; override;
        Procedure       InternalSetToRecord(Buffer: TRecordBuffer); override;
        Procedure       InternalRefresh; override;
        Procedure       InternalGotoBookmark(Const Bookmark: TBookmark); override;
        Function        GetBookmarkFlag(Buffer: TRecordBuffer): TBookmarkFlag; override;
        Procedure       SetBookmarkFlag(Buffer: TRecordBuffer; Value: TBookmarkFlag); override;
        Function        GetBookmarkStr: TBookmarkStr; override;
        Procedure       SetBookmarkStr(const Value: TBookmarkStr); override;
        Procedure       GetBookmarkData(Buffer: TRecordBuffer;  var Bookmark: TBookmark); override;
        Procedure       SetBookmarkData(Buffer: TRecordBuffer;  const Bookmark: TBookmark); override;
        Procedure       InternalHandleException; override;
        Procedure       DataEvent(Event: TDataEvent; Info: TObject); override;
        Function        GetRecordCount  : Integer; override;
        Function        GetRecNo        : Integer; override;
  public
        Constructor                        Create(AOwner: TComponent); override;
        Destructor                         Destroy; override;
        Function                           GetFieldData(Field: TField; Buffer: TValueBuffer): Boolean; override;
        Function                           CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream; override;
        Function                           Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean; override;
        Function                           Lookup(const KeyFields: string; const KeyValues: Variant; const ResultFields: string): Variant; override;
        Function                           CompareBookmarks(const Bookmark1, Bookmark2: TBookmark): Integer; override;
  published
end;



implementation
//****************************************************************************
constructor TDummyDataset.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

destructor TDummyDataset.Destroy;
begin
  inherited Destroy;
end;

Procedure TDummyDataset.InternalOpen;
Begin
//******************************************************************************
end;

Procedure TDummyDataset.InternalClose;
begin
//******************************************************************************
end;

Procedure TDummyDataset.InternalFirst;
begin
//******************************************************************************
end;

Procedure TDummyDataset.InternalLast;
begin
//******************************************************************************
end;

Procedure TDummyDataset.InternalSetToRecord(Buffer: TRecordBuffer);
begin
//******************************************************************************
end;

Procedure TDummyDataset.InternalRefresh;
begin
//******************************************************************************
end;

procedure TDummyDataset.InternalGotoBookmark(Const Bookmark: TBookmark);
begin
//******************************************************************************
end;

Function TDummyDataset.GetBookmarkFlag(Buffer: TRecordBuffer): TBookmarkFlag;
begin
Result:=bfCurrent;
//******************************************************************************
end;

procedure TDummyDataset.SetBookmarkFlag(Buffer: TRecordBuffer; Value: TBookmarkFlag);
begin
//******************************************************************************
end;

Function TDummyDataset.GetBookmarkStr: TBookmarkStr;
Begin
  Result := '';
  //****************************************************************************
End;

Procedure TDummyDataset.SetBookmarkStr(const Value: TBookmarkStr);
Begin
//******************************************************************************
End;

procedure TDummyDataset.GetBookmarkData(Buffer: TRecordBuffer;  var Bookmark: TBookmark);
begin                                                                                                    
//******************************************************************************
end;

procedure TDummyDataset.SetBookmarkData(Buffer: TRecordBuffer;  const Bookmark: TBookmark);
begin
//******************************************************************************
end;

Function TDummyDataset.CompareBookmarks(const Bookmark1, Bookmark2: TBookmark): Integer;
Begin
  Result := 0;
  //****************************************************************************
End;

Function TDummyDataset.CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream;
Begin
  Result:=Nil;
End;


Procedure TDummyDataset.InternalInitFieldDefs;
begin
//******************************************************************************
end;


Procedure TDummyDataset.InternalHandleException;
begin
  Application.HandleException(Self);
  //****************************************************************************
end;


procedure TDummyDataset.DataEvent(Event: TDataEvent; Info: TObject);
begin
//******************************************************************************
end;


Function TDummyDataset.GetFieldData(Field: TField; Buffer: TValueBuffer): Boolean;
begin
 Result :=False;
//******************************************************************************
end;

Procedure TDummyDataset.SetFieldData(Field: TField; Buffer: TValueBuffer);
begin
//******************************************************************************
end;

procedure TDummyDataset.InternalEdit;
begin
   inherited InternalEdit;
   //***************************************************************************
end;

procedure TDummyDataset.InternalAddRecord(Buffer: TValueBuffer; Append: Boolean);
begin
//******************************************************************************
end;

procedure TDummyDataset.InternalPost;
Begin
//******************************************************************************
End;


Procedure TDummyDataset.InternalDelete;
Begin
//******************************************************************************
End;

Function TDummyDataset.IsCursorOpen: Boolean;
begin
 Result:=False;
//******************************************************************************
end;

Function TDummyDataset.GetCanModify: Boolean;
begin
 Result:=False;
//******************************************************************************
end;

Function TDummyDataset.GetRecordSize: Word;
begin
 Result:=0;
//******************************************************************************
end;

Function TDummyDataset.AllocRecordBuffer: TRecordBuffer;
begin
 Result :=Nil;
//******************************************************************************
end;

procedure TDummyDataset.InternalInitRecord(Buffer: TRecordBuffer);
begin
//******************************************************************************
end;

Procedure TDummyDataset.FreeRecordBuffer(var Buffer: TRecordBuffer);
begin
//******************************************************************************
end;

Function TDummyDataset.GetRecord(Buffer: TRecordBuffer; GetMode: TGetMode; DoCheck: Boolean): TGetResult;
begin
 Result := grOK;
 //*****************************************************************************
end;

Function TDummyDataset.GetRecordCount: Integer;
Begin
 Result:=-1;
//******************************************************************************
End;

Function  TDummyDataset.GetRecNo: Integer;
Begin
  Result := -1;
 //*****************************************************************************
End;


Function  TDummyDataset.Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean;
Begin
 Result:=False;
//******************************************************************************
End;

Function  TDummyDataset.Lookup(const KeyFields: string; const KeyValues: Variant; const ResultFields: string): Variant;
Begin
 Result:= NULL;
//******************************************************************************
End;
end.

