unit KA.Utilities.KAOle;

interface
Uses
  Borland.Vcl.SysUtils,
  Borland.Vcl.Classes,
  System.Reflection;

type
  TKAOle = Class(TComponent)
  private
    { Private declarations }
    FComList         : TStringList;
    FType            : System.Type;
    FTypeCom         : TObject;
    FCacheComObjects : Boolean;
    Procedure SetCacheComObjects(const Value: Boolean);
    Procedure Init(ComServerName:String);
    Function  GetObject(ComPropertyName : String) : TObject;Overload;
    Function  GetObject(ComObject : TObject; ComPropertyName : String; Parameters : Array of TObject):TObject;Overload;
    Function  AddToObjects(ComObject : TObject; ComPropertyName : String; Parameters : Array of TObject):TObject;
  public
    procedure SetTypeCom(const Value: TObject);
    { Public declarations }
    function    GetProp(ComObject : TObject; ComPropertyName: String; Parameters : Array of TObject): TObject;Overload;
    function    GetProp(ComObject : TObject; ComPropertyName: String): TObject;Overload;
    Function    GetProp(ComPropertyName:String; Parameters : Array of TObject):TObject;Overload;
    Function    GetProp(ComPropertyName:String):TObject;Overload;


    Function    SetProp(ComObject : TObject; ComPropertyName : String; Value : Array of TObject):TObject;Overload;
    Function    SetProp(ComPropertyName : String; Value : Array of TObject):TObject;Overload;

    function    Call(ComObject : TObject; ComObjectMethodName : String; Parameters : Array of TObject): TObject;Overload;
    function    Call(ComObject : TObject; ComObjectMethodName : String): TObject;Overload;
    function    Call(ComObjectMethodName : String; Parameters: Array of TObject): TObject;Overload;
    function    Call(ComObjectMethodName : String): TObject;Overload;
    Procedure   ClearCache;

    Property    ComObject        : TObject Read FTypeCom Write SetTypeCom;
    Property    CacheComObjects  : Boolean read FCacheComObjects write SetCacheComObjects;
    Procedure   Assign(Source: TPersistent);Override;
    Constructor Create(AOwner : TComponent);Override;
    Destructor  Destroy;Override;
  End;

  Function CreateOleObject(ComServerName : String): TKAOle;
  
implementation
{ TKAOle }

constructor TKAOle.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FComList         := TStringList.Create;
  FType            := Nil;
  FTypeCom         := Nil;
  FCacheComObjects := True;
end;

destructor TKAOle.Destroy;
Var
  X : Integer;
begin
  For X := 0 To FComList.Count-1 do FComList.Objects[X] := Nil;
  FComList.Free;
  FType := Nil;
  FTypeCom.Free;
  inherited Destroy;
end;

procedure TKAOle.Assign(Source: TPersistent);
Var
  X : Integer;
begin
  if Source is TKAOle Then
     Begin
       FType            := Nil;
       FTypeCom         := Nil;
       FType            := TKAOle(Source).FType;
       FTypeCom         := TKAOle(Source).FTypeCom;
       FCacheComObjects := TKAOle(Source).FCacheComObjects;
       For X := 0 To FComList.Count-1 do FComList.Objects[X] := Nil;
       FComList.Clear;
       FComList.Assign(TKAOle(Source).FComList);
     End
  Else
     Begin
       Inherited Assign(Source);
     End;
end;


Procedure TKAOle.ClearCache;
Var
  X : Integer;
Begin
  For X := 0 To FComList.Count-1 do FComList.Objects[X] := Nil;
  FComList.Clear;
End;

procedure TKAOle.SetCacheComObjects(const Value: Boolean);
begin
  FCacheComObjects := Value;
end;

procedure TKAOle.Init(ComServerName:String);
begin
  FType    := System.Type.GetTypeFromProgID(ComServerName);
  if FType = Nil Then Raise Exception.Create('Class not registered '+ComServerName);
  FTypeCom  := Activator.CreateInstance(FType);
end;

function TKAOle.GetObject(ComPropertyName: String): TObject;
Var
  I : Integer;
begin
  Result := Nil;
  I := FComList.IndexOf(ComPropertyName);
  if I <> -1 Then
     Begin
       Result := FComList.Objects[I];
     End;
end;

Function  TKAOle.GetObject(ComObject : TObject; ComPropertyName : String; Parameters : Array of TObject):TObject;
Var
  SL  : TStringList;
  X   : Integer;
  Com : TObject;
Begin
  SL := TStringList.Create;
  Try
    SL.Text := StringReplace(ComPropertyName,'.',#13#10,[rfReplaceAll]);
    Com     := ComObject;
    For X   := 0 To SL.Count-1 do
       Begin
         Com := Com.GetType.InvokeMember(SL.Strings[X],BindingFlags.GetProperty, nil, Com, Nil);
       End;
    Result := Com;
  Finally
    SL.Free;
  End;
end;

function TKAOle.AddToObjects(ComObject : TObject; ComPropertyName: String; Parameters : Array of TObject): TObject;
Var
  SL  : TStringList;
  S   : String;
  X   : Integer;
  Com : TObject;
begin
  SL := TStringList.Create;
  S  := '';
  Try
    SL.Text := StringReplace(ComPropertyName,'.',#13#10,[rfReplaceAll]);
    Com     := ComObject;
    if SL.Count=1 Then
       Begin
         S   := S+SL.Strings[0];
         if (Length(Parameters)=1) And (Parameters[0]=Nil) Then
            Begin
              Com := Com.GetType.InvokeMember(SL.Strings[0],BindingFlags.GetProperty, nil, Com, Nil);
              if (FCacheComObjects) AND (Com.GetType.ToString='System.__ComObject') Then FComList.AddObject(S,Com);
            End
         Else
            Begin
              Com := Com.GetType.InvokeMember(SL.Strings[0],BindingFlags.GetProperty, nil, Com, Parameters);
            End;
       End
    Else
       Begin
         For X := 0 To SL.Count-1 do
             Begin
               S   := S+SL.Strings[X];
               if X < SL.Count-1 Then
                  Begin
                    Com := Com.GetType.InvokeMember(SL.Strings[X],BindingFlags.GetProperty, nil, Com, Nil);
                    if Com=Nil Then Break;
                    if (FCacheComObjects) AND (Com.GetType.ToString='System.__ComObject') Then FComList.AddObject(S,Com);
                    S := S+'.';
                  End
               Else
                  Begin
                    if (Length(Parameters)=1) And (Parameters[0]=Nil) Then
                       Begin
                         Com := Com.GetType.InvokeMember(SL.Strings[X],BindingFlags.GetProperty, nil, Com, Nil);
                         if Com=Nil Then Break;
                         if (FCacheComObjects) AND (Com.GetType.ToString='System.__ComObject') Then FComList.AddObject(S,Com);
                       End
                    Else
                       Begin
                         Com := Com.GetType.InvokeMember(SL.Strings[X],BindingFlags.GetProperty, nil, Com, Parameters);
                         if Com=Nil Then Break;
                       End;
                  End;
             End;
       End;
    Result := Com;
  Finally
    SL.Free;
  End;
end;

function TKAOle.GetProp(ComObject : TObject; ComPropertyName: String; Parameters : Array of TObject): TObject;
Begin
  Result := AddToObjects(ComObject, ComPropertyName, Parameters);
End;

function TKAOle.GetProp(ComPropertyName: String; Parameters: array of TObject): TObject;
begin
  Result    := GetObject(ComPropertyName);
  if Not Assigned(Result) Then
     Result := AddToObjects(FTypeCom, ComPropertyName, Parameters);
end;

function TKAOle.GetProp(ComObject : TObject; ComPropertyName: String): TObject;
Var
  Obj : TObject;
begin
  Obj    := Nil;
  Result := GetObject(ComObject, ComPropertyName, Obj);
end;

function TKAOle.GetProp(ComPropertyName: String): TObject;
Var
  Obj : TObject;
begin
  Obj     := Nil;
  Result  := GetObject(ComPropertyName);
  if Not Assigned(Result) Then
     Result := AddToObjects(FTypeCom, ComPropertyName, Obj);
end;


function TKAOle.SetProp(ComPropertyName: String; Value : Array of TObject): TObject;
Var
  Com : TObject;
  Obj : TObject;
  SL  : TStringList;
  X   : Integer;
  P   : Integer;
begin
  Result := Nil;
  Obj    := Nil;
  P := Pos('.',ComPropertyName);
  if P = 0 Then
     Begin
       Com    := FTypeCom;
       Result := Com.GetType.InvokeMember(ComPropertyName,BindingFlags.SetProperty, nil, Com, Value);
     End
  Else
     Begin
        SL := TStringList.Create;
        Try
          SL.Text := StringReplace(ComPropertyName,'.',#13#10,[rfReplaceAll]);
          ComPropertyName := SL.Strings[SL.Count-1];
          SL.Delete(SL.Count-1);
          Com := FTypeCom;
          For X := 0 To SL.Count-1 do
              Begin
                Com := Com.GetType.InvokeMember(SL.Strings[X],BindingFlags.GetProperty, nil, Com, Nil);
                if Com=Nil Then
                   Begin
                     Result := Nil;
                     Exit;
                   End;
              End;
          Result := Com.GetType.InvokeMember(ComPropertyName,BindingFlags.SetProperty, nil, Com, Value);
        Finally
          SL.Free;
        End;
     End;
end;


Function TKAOle.SetProp(ComObject : TObject; ComPropertyName : String; Value : Array of TObject):TObject;
Var
  Com : TObject;
  Obj : TObject;
  SL  : TStringList;
  X   : Integer;
  P   : Integer;
begin
  Result := Nil;
  Obj    := Nil;
  P := Pos('.',ComPropertyName);
  if P = 0 Then
     Begin
       Com    := ComObject;
       Result := Com.GetType.InvokeMember(ComPropertyName,BindingFlags.SetProperty, nil, Com, Value);
     End
  Else
     Begin
        SL := TStringList.Create;
        Try
          SL.Text := StringReplace(ComPropertyName,'.',#13#10,[rfReplaceAll]);
          ComPropertyName := SL.Strings[SL.Count-1];
          SL.Delete(SL.Count-1);
          Com := ComObject;
          For X := 0 To SL.Count-1 do
              Begin
                Com := Com.GetType.InvokeMember(SL.Strings[X],BindingFlags.GetProperty, nil, Com, Nil);
                if Com=Nil Then
                   Begin
                     Result := Nil;
                     Exit;
                   End;
              End;
          Result := Com.GetType.InvokeMember(ComPropertyName,BindingFlags.SetProperty, nil, Com, Value);
        Finally
          SL.Free;
        End;
     End;
end;

function TKAOle.Call(ComObject : TObject; ComObjectMethodName : String; Parameters : Array of TObject): TObject;
Var
  Com       : TObject;
  Obj       : TObject;
  P         : Integer;
  X         : Integer;
  SL        : TStringList;
  ComMethod : String;
begin
  Result     := Nil;
  Obj        := Nil;
  Com        := ComObject;
  ComMethod  := ComObjectMethodName;
  P := Pos('.',ComObjectMethodName);
  if P > 0 Then
     Begin
        SL := TStringList.Create;
        Try
          SL.Text   := StringReplace(ComObjectMethodName,'.',#13#10,[rfReplaceAll]);
          ComMethod := SL.Strings[SL.Count-1];
          SL.Delete(SL.Count-1);
          For X := 0 To SL.Count-1 do
              Begin
                Com := Com.GetType.InvokeMember(SL.Strings[X],BindingFlags.GetProperty, nil, Com, Nil);
                if Com=Nil Then
                   Begin
                     Result := Nil;
                     Exit;
                   End;
              End;
        Finally
          SL.Free;
        End;
     End;
  if (Length(Parameters)=1) And (Parameters[0]=Nil) Then
     Begin
       Result := Com.GetType.InvokeMember(ComMethod,BindingFlags.InvokeMethod, nil, Com, Nil);
     End
   Else
     Begin
       Result := Com.GetType.InvokeMember(ComMethod,BindingFlags.InvokeMethod, nil, Com, Parameters);
     End;
end;


function TKAOle.Call(ComObject : TObject; ComObjectMethodName : String): TObject;
Var
  Obj : TObject;
Begin
  Obj    := Nil;
  Result := Call(ComObject,ComObjectMethodName,Obj);
End;

function TKAOle.Call(ComObjectMethodName : String; Parameters: Array of TObject): TObject;
begin
  Result := Call(FTypeCom,ComObjectMethodName,Parameters);
end;

function TKAOle.Call(ComObjectMethodName: String): TObject;
Var
  Obj : TObject;
begin
  Obj    := Nil;
  Result := Call(FTypeCom,ComObjectMethodName,Obj);
end;

procedure TKAOle.SetTypeCom(const Value: TObject);
begin
  ClearCache;
  FTypeCom.Free;
  FTypeCom := Value;
end;

Function CreateOleObject(ComServerName : String): TKAOle;
Begin
  Result := TKAOle.Create(Nil);
  Result.Init(ComServerName);
End;




end.
