unit KA.Utilities.CharsetReg;
interface

Uses
   Borland.Vcl.Classes,
   Borland.Vcl.Design.DesignIntf,
   Borland.Vcl.Design.DesignEditors;


Type
//******************************************************************************
//                           EDITOR DEFINITIONS - KACharset
//******************************************************************************
TCharsetEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

//******************************************************************************

procedure Register;

Implementation
Uses KA.Utilities.Charset;


function TCharsetEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList];
end;

procedure TCharsetEditor.GetValues(Proc: TGetStrProc);
Var
  CS    : TKACharset;
  X      : Integer;
begin
 if GetComponent(0) is TKACharset then
  Begin
    CS := TKACharset(GetComponent(0));
    For X := 0 To CS.Charsets.Count-1 do Proc(CS.Charsets.Strings[X]);
  End;
end;


//******************************************************************************
procedure Register;
begin
 RegisterPropertyEditor(TypeInfo(String),TKACharset,   'BaseCharset',      TCharsetEditor);
 RegisterPropertyEditor(TypeInfo(String),TKACharset,   'ConvertToCharset', TCharsetEditor);
end;
end.
