unit KA.Utilities.Charset;

interface

uses
  Borland.Vcl.Windows,
  Borland.Vcl.SysUtils,
  Borland.Vcl.Classes;

const
  adTypeBinary                 =  $00000001;
  adTypeText                   =  $00000002;

  adStateClosed                =  $00000000;
  adStateOpen                  =  $00000001;
  adStateConnecting            =  $00000002;
  adStateExecuting             =  $00000004;
  adStateFetching              =  $00000008;

type
  TKACharset = class(TComponent)
  private
    { Private declarations }
    F_Charsets         : TStringList;
    F_BaseText         : TStrings;
    F_ConvertedText    : TStrings;
    F_BaseCharset      : String;
    F_ConvertToCharset : String;
    Function  F_Get_ConvertedText: TStrings;
    Procedure F_Set_ConvertedText(Value : TStrings);
    Function  F_Get_BaseText: TStrings;
    Procedure F_Set_BaseText(Value : TStrings);
    Procedure F_Set_BaseCharset(Value:String);
    Procedure F_Set_ConvertToCharset(Value:String);
  protected
    { Protected declarations }
    Procedure FillCharsets;
  public
    { Public declarations }
    Function          DoConvertToCharset(Text, SrcCharset, DstCharset : String):WideString;
    Constructor       Create(AOwner:TComponent); override;
    Destructor        Destroy; override;
    Property          Charsets : TStringList Read F_Charsets;
  published
    { Published declarations }
    Property  BaseText         : TStrings    Read F_Get_BaseText      Write F_Set_BaseText;
    Property  ConvertedText    : TStrings    Read F_Get_ConvertedText Write F_Set_ConvertedText;
    Property  BaseCharset      : String      Read F_BaseCharset       Write F_Set_BaseCharset;
    Property  ConvertToCharset : String      Read F_ConvertToCharset  Write F_Set_ConvertToCharset;
  end;

procedure Register;

implementation
{$R 'KA.Utilities.Charset.TKACharset.bmp'}
Uses
  Borland.Vcl.Registry,
  KA.Utilities.KAOle;

procedure Register;
begin
  RegisterComponents('KA', [TKACharset]);
end;

{ TKACharset }

constructor TKACharset.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  F_Charsets         := TStringList.Create;
  F_BaseText         := TStringList.Create;
  F_ConvertedText    := TStringList.Create;
  F_BaseCharset      := '';
  F_ConvertToCharset := F_BaseCharset;
  FillCharsets;
end;

destructor TKACharset.Destroy;
begin
  F_Charsets.Free;
  F_BaseText.Free;
  F_ConvertedText.Free;
  inherited Destroy;
end;

procedure TKACharset.FillCharsets;
Var
 Reg     : TRegistry;
begin
 Reg     := TRegistry.Create(KEY_READ);
 Try
  Reg.RootKey := HKEY_CLASSES_ROOT;
  if Reg.OpenKeyReadOnly('\MIME\Database\Charset') Then
     Begin
      Reg.GetKeyNames(F_Charsets);
      Reg.CloseKey;
     End;
  if Reg.OpenKeyReadOnly('\MIME\Database\Codepage\'+IntToStr(GetACP)) Then
     Begin
      F_BaseCharset      := Reg.ReadString('WebCharset');
      F_ConvertToCharset := F_BaseCharset;
     End
 Finally
  Reg.Free;
 End;
end;

Function TKACharset.DoConvertToCharset(Text, SrcCharset, DstCharset : String):WideString;
Var
  OleStream : TKAOle;
  L         : Integer;
  Sz        : Integer;
Begin
 Result := '';
 L      := Length(Text);
 if L=0 Then Exit;
 OleStream    := CreateOleObject('ADODB.Stream');
 Try
  OleStream.SetProp('Type',TObject(adTypeText));
  OleStream.SetProp('Charset',TObject(DstCharset));
  OleStream.Call('Open');
  OleStream.Call('WriteText',TObject(Text));
  OleStream.SetProp('Position',TObject(0));
  OleStream.SetProp('Charset',TObject(SrcCharset));
  OleStream.SetProp('Position',TObject(0));
  Sz := Integer(OleStream.GetProp('Size'));
  Result := OleStream.Call('ReadText',TObject(SZ)).ToString;
  if Result ='' Then Result := Text;
 Finally
  Try
    if Integer(OleStream.GetProp('State')) <> adStateClosed Then OleStream.Call('Close');
  Except
  End;
  OleStream.Free;
 End;
End;

function TKACharset.F_Get_BaseText: TStrings;
begin
 Result := F_BaseText;
end;

procedure TKACharset.F_Set_BaseText(Value: TStrings);
begin
  F_BaseText.BeginUpdate;
  Try
    F_BaseText.Assign(Value);
  Finally
   F_BaseText.EndUpdate;
  End;
end;

function TKACharset.F_Get_ConvertedText: TStrings;
begin
 Result := F_ConvertedText;
 Result.Clear;
 Result.Text := DoConvertToCharset(F_BaseText.Text,F_BaseCharset,F_ConvertToCharset);
end;

procedure TKACharset.F_Set_ConvertedText(Value: TStrings);
begin
 //***************************************** ReadOnly
end;

procedure TKACharset.F_Set_BaseCharset(Value: String);
begin
 F_BaseCharset := Value;
end;

procedure TKACharset.F_Set_ConvertToCharset(Value: String);
begin
 F_ConvertToCharset := Value;
end;



end.
