unit Option;

interface

uses
  Commons.Settings,
  System.Collections,
  System.ComponentModel,
  System.Drawing,
  System.Windows.Forms,
  System.Xml.Serialization,
  Visibles.BorderExtender,
  Visibles.ButtonEx;

type
  [Serializable]
  TKnownType = class (TObject)
  public
    NETName: string;
    DelphiName: string;
    Exclude: Boolean;
  end;
  [XmlInclude(typeof(TKnownType))]
  [Serializable]
  TKnownNamespace = class (TObject)
  public
    Name: string;
    Prefix: string;
    Exclude: Boolean;
  end;
  [XmlInclude(typeof(TKnownNamespace))]
  TOptions = class(TSettingsObject)
  private
    class function Load: TOptions;
    procedure Store;
  public
    ClassPrefix: string;
    RecordPrefix: string;
    EnumeratedPrefix: string;
    ExceptionPrefix: string;
    RemoveExceptionPostfix: Boolean;
    RemoveClassPostfix: Boolean;
    KnownTypes: ArrayList;
    KnownNamespaces: ArrayList;
    procedure SetKnownType(NETName,DelphiName: string; Exclude: Boolean);
    procedure SetKnownNamespace(Name,Prefix: string; Exclude: Boolean);
    function GetHashedKnownTypes: HashTable;
    function GetHashedKnownNamespaces: HashTable;
    constructor Create; virtual;
  end;
  TFormOption = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: System.ComponentModel.IContainer;
    Panel: System.Windows.Forms.Panel;
    BorderExtender: Visibles.BorderExtender.TBorderExtender;
    BtnOk: Visibles.ButtonEx.TButtonEx;
    BtnCancel: Visibles.ButtonEx.TButtonEx;
    TextClassPrefix: System.Windows.Forms.TextBox;
    TextExceptionPrefix: System.Windows.Forms.TextBox;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    CheckException: System.Windows.Forms.CheckBox;
    CheckClass: System.Windows.Forms.CheckBox;
    Label3: System.Windows.Forms.Label;
    TextRecordPrefix: System.Windows.Forms.TextBox;
    BtnReload: Visibles.ButtonEx.TButtonEx;
    Label4: System.Windows.Forms.Label;
    TextEnumeratedPrefix: System.Windows.Forms.TextBox;
    ListNamespacePrefixes: System.Windows.Forms.CheckedListBox;
    LabelCustomNamePrefix: System.Windows.Forms.Label;
    TextCustomNamePrefix: System.Windows.Forms.TextBox;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure BtnOk_Click(sender: System.Object; e: System.EventArgs);
    procedure BtnReload_Click(sender: System.Object; e: System.EventArgs);
    procedure ListNamespacePrefixes_ItemCheck(sender: System.Object; e: System.Windows.Forms.ItemCheckEventArgs);
    procedure TextCustomNamePrefix_KeyDown(sender: System.Object; e: System.Windows.Forms.KeyEventArgs);
  {$ENDREGION}
  strict private
    FOptions: TOptions;
    SelectedName: string;
    SelectedExclude: Boolean;
    procedure OptionsToControls(Options: TOptions);
    procedure ControlsToOptions(Options: TOptions);
  strict protected
    procedure Dispose(Disposing: Boolean); override;
  public
    function get_Options: TOptions;
    procedure set_Options(const Value: TOptions);
  public
    property Options: TOptions read get_Options write set_Options;
    function ShowDialogNamespace(Namespace,CustomPrefix: string; Exclude_: Boolean): System.Windows.Forms.DialogResult;
    function ShowDialogName(Name,CustomName: string; Exclude: Boolean): System.Windows.Forms.DialogResult;
    function ShowDialog: System.Windows.Forms.DialogResult;
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFormOption))]

implementation

uses
  System.IO,
  System.Text;

{ TOptions }

constructor TOptions.Create;
begin
  inherited Create;
  KnownTypes := ArrayList.Create;
  KnownNamespaces := ArrayList.Create;
  ClassPrefix := 'T';
  RecordPrefix := 'R';
  EnumeratedPrefix := 'T';
  ExceptionPrefix := 'E';
  RemoveExceptionPostfix := true;
  RemoveClassPostfix := true;
end;

procedure TOptions.SetKnownType(NETName,DelphiName: string; Exclude: Boolean);
var
  I,J: Integer;
  KnownType: TKnownType;
begin
  I := -1;
  J := 0;
  while (I < 0) and (J < KnownTypes.Count) do
    if System.string.Compare((KnownTypes.Item[J] as TKnownType).NETName,NETName,true) = 0 then
      I := J
    else
      Inc(J);
  if (DelphiName <> '') or Exclude then begin
    KnownType := TKnownType.Create;
    KnownType.NETName := NETName;
    KnownType.DelphiName := DelphiName;
    KnownType.Exclude := Exclude;
  end;
  if I >= 0 then begin
    if (DelphiName <> '') or Exclude then
      KnownTypes.Item[I] := KnownType
    else
      KnownTypes.RemoveAt(I)
  end
  else if (DelphiName <> '') or Exclude then
    KnownTypes.Add(KnownType);
end;

procedure TOptions.SetKnownNamespace(Name,Prefix: string; Exclude: Boolean);
var
  I,J: Integer;
  KnownNamespace: TKnownNamespace;
begin
  I := -1;
  J := 0;
  while (I < 0) and (J < KnownNamespaces.Count) do
    if System.string.Compare((KnownNamespaces.Item[J] as TKnownNamespace).Name,Name,true) = 0 then
      I := J
    else
      Inc(J);
  if (Prefix <> '') or Exclude then begin
    KnownNamespace := TKnownNamespace.Create;
    KnownNamespace.Name := Name;
    KnownNamespace.Prefix := Prefix;
    KnownNamespace.Exclude := Exclude;
  end;
  if I >= 0 then begin
    if (Prefix <> '') or Exclude then
      KnownNamespaces.Item[I] := KnownNamespace
    else
      KnownNamespaces.RemoveAt(I)
  end
  else if (Prefix <> '') or Exclude then
    KnownNamespaces.Add(KnownNamespace);
end;

function TOptions.GetHashedKnownTypes: HashTable;
var
  I: Integer;
begin
  Result := HashTable.Create;
  for I := 0 to Pred(KnownTypes.Count) do
    Result.Add((KnownTypes[I] as TKnownType).NETName.ToUpper,KnownTypes[I]);
end;

function TOptions.GetHashedKnownNamespaces: HashTable;
var
  I: Integer;
begin
  Result := HashTable.Create;
  for I := 0 to Pred(KnownNamespaces.Count) do
    Result.Add((KnownNamespaces[I] as TKnownNamespace).Name.ToUpper,KnownNamespaces[I]);
end;

class function TOptions.Load: TOptions;
begin
  Result := TOptions.LoadFrom(Path.ChangeExtension(Application.ExecutablePath,'.xml')) as TOptions;
end;

procedure TOptions.Store;
begin
  StoreTo(Path.ChangeExtension(Application.ExecutablePath,'.xml'));
end;

{ TFormOption }

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFormOption.InitializeComponent;
begin
  Self.components := System.ComponentModel.Container.Create;
  Self.Panel := System.Windows.Forms.Panel.Create;
  Self.TextCustomNamePrefix := System.Windows.Forms.TextBox.Create;
  Self.LabelCustomNamePrefix := System.Windows.Forms.Label.Create;
  Self.ListNamespacePrefixes := System.Windows.Forms.CheckedListBox.Create;
  Self.Label4 := System.Windows.Forms.Label.Create;
  Self.TextEnumeratedPrefix := System.Windows.Forms.TextBox.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.TextRecordPrefix := System.Windows.Forms.TextBox.Create;
  Self.CheckClass := System.Windows.Forms.CheckBox.Create;
  Self.CheckException := System.Windows.Forms.CheckBox.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.TextExceptionPrefix := System.Windows.Forms.TextBox.Create;
  Self.TextClassPrefix := System.Windows.Forms.TextBox.Create;
  Self.BorderExtender := Visibles.BorderExtender.TBorderExtender.Create;
  Self.BtnOk := Visibles.ButtonEx.TButtonEx.Create(Self.components);
  Self.BtnCancel := Visibles.ButtonEx.TButtonEx.Create(Self.components);
  Self.BtnReload := Visibles.ButtonEx.TButtonEx.Create(Self.components);
  Self.Panel.SuspendLayout;
  Self.SuspendLayout;
  // 
  // Panel
  // 
  Self.Panel.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Panel, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.Panel.Controls.Add(Self.TextCustomNamePrefix);
  Self.Panel.Controls.Add(Self.LabelCustomNamePrefix);
  Self.Panel.Controls.Add(Self.ListNamespacePrefixes);
  Self.Panel.Controls.Add(Self.Label4);
  Self.Panel.Controls.Add(Self.TextEnumeratedPrefix);
  Self.Panel.Controls.Add(Self.Label3);
  Self.Panel.Controls.Add(Self.TextRecordPrefix);
  Self.Panel.Controls.Add(Self.CheckClass);
  Self.Panel.Controls.Add(Self.CheckException);
  Self.Panel.Controls.Add(Self.Label2);
  Self.Panel.Controls.Add(Self.Label1);
  Self.Panel.Controls.Add(Self.TextExceptionPrefix);
  Self.Panel.Controls.Add(Self.TextClassPrefix);
  Self.Panel.DockPadding.All := 1;
  Self.Panel.Location := System.Drawing.Point.Create(0, 0);
  Self.Panel.Name := 'Panel';
  Self.Panel.Size := System.Drawing.Size.Create(374, 153);
  Self.Panel.TabIndex := 0;
  // 
  // TextCustomNamePrefix
  // 
  Self.TextCustomNamePrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextCustomNamePrefix.AutoSize := False;
  Self.TextCustomNamePrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextCustomNamePrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextCustomNamePrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextCustomNamePrefix.Location := System.Drawing.Point.Create(12, 126);
  Self.TextCustomNamePrefix.Name := 'TextCustomNamePrefix';
  Self.TextCustomNamePrefix.Size := System.Drawing.Size.Create(148, 18);
  Self.TextCustomNamePrefix.TabIndex := 11;
  Self.TextCustomNamePrefix.Text := '';
  Self.TextCustomNamePrefix.WordWrap := False;
  Include(Self.TextCustomNamePrefix.KeyDown, Self.TextCustomNamePrefix_KeyDown);
  // 
  // LabelCustomNamePrefix
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.LabelCustomNamePrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.LabelCustomNamePrefix.Location := System.Drawing.Point.Create(12, 14);
  Self.LabelCustomNamePrefix.Name := 'LabelCustomNamePrefix';
  Self.LabelCustomNamePrefix.Size := System.Drawing.Size.Create(124, 16);
  Self.LabelCustomNamePrefix.TabIndex := 10;
  Self.LabelCustomNamePrefix.Text := 'Custom Name / Prefix';
  // 
  // ListNamespacePrefixes
  // 
  Self.ListNamespacePrefixes.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.ListNamespacePrefixes, System.Windows.Forms.Border3DStyle.Adjust);
  Self.ListNamespacePrefixes.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.ListNamespacePrefixes.CheckOnClick := True;
  Self.ListNamespacePrefixes.IntegralHeight := False;
  Self.ListNamespacePrefixes.Location := System.Drawing.Point.Create(12, 36);
  Self.ListNamespacePrefixes.Name := 'ListNamespacePrefixes';
  Self.ListNamespacePrefixes.Size := System.Drawing.Size.Create(148, 84);
  Self.ListNamespacePrefixes.TabIndex := 9;
  Include(Self.ListNamespacePrefixes.ItemCheck, Self.ListNamespacePrefixes_ItemCheck);
  // 
  // Label4
  // 
  Self.Label4.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Label4, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label4.Location := System.Drawing.Point.Create(188, 62);
  Self.Label4.Name := 'Label4';
  Self.Label4.Size := System.Drawing.Size.Create(104, 16);
  Self.Label4.TabIndex := 8;
  Self.Label4.Text := 'Enumerated Prefix';
  Self.Label4.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // TextEnumeratedPrefix
  // 
  Self.TextEnumeratedPrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextEnumeratedPrefix.AutoSize := False;
  Self.TextEnumeratedPrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextEnumeratedPrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextEnumeratedPrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextEnumeratedPrefix.Location := System.Drawing.Point.Create(296, 60);
  Self.TextEnumeratedPrefix.Name := 'TextEnumeratedPrefix';
  Self.TextEnumeratedPrefix.Size := System.Drawing.Size.Create(64, 18);
  Self.TextEnumeratedPrefix.TabIndex := 2;
  Self.TextEnumeratedPrefix.Text := 'T';
  Self.TextEnumeratedPrefix.WordWrap := False;
  // 
  // Label3
  // 
  Self.Label3.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Label3, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label3.Location := System.Drawing.Point.Create(204, 38);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(88, 16);
  Self.Label3.TabIndex := 6;
  Self.Label3.Text := 'Record Prefix';
  Self.Label3.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // TextRecordPrefix
  // 
  Self.TextRecordPrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextRecordPrefix.AutoSize := False;
  Self.TextRecordPrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextRecordPrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextRecordPrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextRecordPrefix.Location := System.Drawing.Point.Create(296, 36);
  Self.TextRecordPrefix.Name := 'TextRecordPrefix';
  Self.TextRecordPrefix.Size := System.Drawing.Size.Create(64, 18);
  Self.TextRecordPrefix.TabIndex := 1;
  Self.TextRecordPrefix.Text := 'R';
  Self.TextRecordPrefix.WordWrap := False;
  // 
  // CheckClass
  // 
  Self.CheckClass.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.CheckClass, System.Windows.Forms.Border3DStyle.Adjust);
  Self.CheckClass.CheckAlign := System.Drawing.ContentAlignment.MiddleRight;
  Self.CheckClass.FlatStyle := System.Windows.Forms.FlatStyle.Flat;
  Self.CheckClass.Location := System.Drawing.Point.Create(168, 128);
  Self.CheckClass.Name := 'CheckClass';
  Self.CheckClass.Size := System.Drawing.Size.Create(139, 16);
  Self.CheckClass.TabIndex := 5;
  Self.CheckClass.Text := 'No COM Class Postfix';
  Self.CheckClass.TextAlign := System.Drawing.ContentAlignment.MiddleRight;
  // 
  // CheckException
  // 
  Self.CheckException.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.CheckException, System.Windows.Forms.Border3DStyle.Adjust);
  Self.CheckException.CheckAlign := System.Drawing.ContentAlignment.MiddleRight;
  Self.CheckException.FlatStyle := System.Windows.Forms.FlatStyle.Flat;
  Self.CheckException.Location := System.Drawing.Point.Create(168, 108);
  Self.CheckException.Name := 'CheckException';
  Self.CheckException.Size := System.Drawing.Size.Create(139, 16);
  Self.CheckException.TabIndex := 4;
  Self.CheckException.Text := 'No Exception Postfix';
  Self.CheckException.TextAlign := System.Drawing.ContentAlignment.MiddleRight;
  // 
  // Label2
  // 
  Self.Label2.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Label2, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label2.Location := System.Drawing.Point.Create(202, 85);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(88, 16);
  Self.Label2.TabIndex := 3;
  Self.Label2.Text := 'Exception Prefix';
  Self.Label2.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // Label1
  // 
  Self.Label1.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Label1, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label1.Location := System.Drawing.Point.Create(202, 14);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(88, 16);
  Self.Label1.TabIndex := 2;
  Self.Label1.Text := 'Class Prefix';
  Self.Label1.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // TextExceptionPrefix
  // 
  Self.TextExceptionPrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextExceptionPrefix.AutoSize := False;
  Self.TextExceptionPrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextExceptionPrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextExceptionPrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextExceptionPrefix.Location := System.Drawing.Point.Create(296, 84);
  Self.TextExceptionPrefix.Name := 'TextExceptionPrefix';
  Self.TextExceptionPrefix.Size := System.Drawing.Size.Create(64, 18);
  Self.TextExceptionPrefix.TabIndex := 3;
  Self.TextExceptionPrefix.Text := 'E';
  Self.TextExceptionPrefix.WordWrap := False;
  // 
  // TextClassPrefix
  // 
  Self.TextClassPrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextClassPrefix.AutoSize := False;
  Self.TextClassPrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextClassPrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextClassPrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextClassPrefix.Location := System.Drawing.Point.Create(296, 12);
  Self.TextClassPrefix.Name := 'TextClassPrefix';
  Self.TextClassPrefix.Size := System.Drawing.Size.Create(64, 18);
  Self.TextClassPrefix.TabIndex := 0;
  Self.TextClassPrefix.Text := 'T';
  Self.TextClassPrefix.WordWrap := False;
  // 
  // BtnOk
  // 
  Self.BtnOk.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BtnOk.BackColor := System.Drawing.Color.LightSteelBlue;
  Self.BorderExtender.SetBorder3DStyle(Self.BtnOk, System.Windows.Forms.Border3DStyle.Adjust);
  Self.BtnOk.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.BtnOk.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.BtnOk.Location := System.Drawing.Point.Create(214, 160);
  Self.BtnOk.Name := 'BtnOk';
  Self.BtnOk.TabIndex := 1;
  Self.BtnOk.Text := '&Ok';
  Include(Self.BtnOk.Click, Self.BtnOk_Click);
  // 
  // BtnCancel
  // 
  Self.BtnCancel.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BtnCancel.BackColor := System.Drawing.Color.LightSteelBlue;
  Self.BorderExtender.SetBorder3DStyle(Self.BtnCancel, System.Windows.Forms.Border3DStyle.Adjust);
  Self.BtnCancel.DialogResult := System.Windows.Forms.DialogResult.Cancel;
  Self.BtnCancel.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.BtnCancel.Location := System.Drawing.Point.Create(294, 160);
  Self.BtnCancel.Name := 'BtnCancel';
  Self.BtnCancel.TabIndex := 2;
  Self.BtnCancel.Text := '&Cancel';
  // 
  // BtnReload
  // 
  Self.BtnReload.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Left)));
  Self.BtnReload.BackColor := System.Drawing.Color.LightSteelBlue;
  Self.BorderExtender.SetBorder3DStyle(Self.BtnReload, System.Windows.Forms.Border3DStyle.Adjust);
  Self.BtnReload.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.BtnReload.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.BtnReload.Location := System.Drawing.Point.Create(5, 160);
  Self.BtnReload.Name := 'BtnReload';
  Self.BtnReload.TabIndex := 3;
  Self.BtnReload.Text := '&Reload';
  Include(Self.BtnReload.Click, Self.BtnReload_Click);
  // 
  // TFormOption
  // 
  Self.AcceptButton := Self.BtnOk;
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.CancelButton := Self.BtnCancel;
  Self.ClientSize := System.Drawing.Size.Create(374, 189);
  Self.Controls.Add(Self.BtnReload);
  Self.Controls.Add(Self.BtnCancel);
  Self.Controls.Add(Self.BtnOk);
  Self.Controls.Add(Self.Panel);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedDialog;
  Self.MaximizeBox := False;
  Self.MinimizeBox := False;
  Self.Name := 'TFormOption';
  Self.ShowInTaskbar := False;
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterParent;
  Self.Panel.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFormOption.Dispose(Disposing: Boolean);
begin
  if Disposing then begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TFormOption.Create;
begin
  inherited Create;
  InitializeComponent;
  Text := System.String.Format('{0} {1}',[Application.ProductName,'Options']);
  try
    FOptions := TOptions.Load;
  except
    FOptions := TOptions.Create;
  end;
end;

procedure TFormOption.BtnReload_Click(sender: System.Object; e: System.EventArgs);
begin
  try
    FOptions := TOptions.Load;
  except
    ;
  end;
end;

procedure TFormOption.BtnOk_Click(sender: System.Object; e: System.EventArgs);
begin
  ControlsToOptions(FOptions);
  if ListNamespacePrefixes.Enabled then
    FOptions.SetKnownNamespace(SelectedName,TextCustomNamePrefix.Text.Trim,SelectedExclude)
  else if TextCustomNamePrefix.Enabled then
    FOptions.SetKnownType(SelectedName,TextCustomNamePrefix.Text.Trim,SelectedExclude);
  FOptions.Store;
end;

procedure TFormOption.ListNamespacePrefixes_ItemCheck(sender: System.Object; e: System.Windows.Forms.ItemCheckEventArgs);
var
  I: Integer;
  Prefix: StringBuilder;
begin
  Prefix := StringBuilder.Create;
  for I := 0 to Pred(ListNamespacePrefixes.Items.Count) do
    if ListNamespacePrefixes.GetItemChecked(I) xor (I = e.Index) then begin
      Prefix.Append(string(ListNamespacePrefixes.Items[I]));
      Prefix.Append('.');
    end;
  Prefix.Length := Math.Max(Prefix.Length - 1,0);
  TextCustomNamePrefix.Text := Prefix.ToString;
end;

procedure TFormOption.TextCustomNamePrefix_KeyDown(sender: System.Object; e: System.Windows.Forms.KeyEventArgs);
var
  I: Integer;
begin
  if ListNamespacePrefixes.Enabled then begin
    Exclude(ListNamespacePrefixes.ItemCheck,ListNamespacePrefixes_ItemCheck);
    for I := 0 to Pred(ListNamespacePrefixes.Items.Count) do
      ListNamespacePrefixes.SetItemChecked(I,false);
    Include(ListNamespacePrefixes.ItemCheck,ListNamespacePrefixes_ItemCheck);
  end;
end;

procedure TFormOption.ControlsToOptions(Options: TOptions);
begin
  with Options do begin
    ClassPrefix := TextClassPrefix.Text.Trim;
    RecordPrefix := TextRecordPrefix.Text.Trim;
    EnumeratedPrefix := TextEnumeratedPrefix.Text.Trim;
    ExceptionPrefix := TextExceptionPrefix.Text.Trim;
    RemoveExceptionPostfix := CheckException.Checked;
    RemoveClassPostfix := CheckClass.Checked;
  end;
end;

procedure TFormOption.OptionsToControls(Options: TOptions);
begin
  with Options do begin
    TextClassPrefix.Text := ClassPrefix;
    TextRecordPrefix.Text := RecordPrefix;
    TextEnumeratedPrefix.Text := EnumeratedPrefix;
    TextExceptionPrefix.Text := ExceptionPrefix;
    CheckException.Checked := RemoveExceptionPostfix;
    CheckClass.Checked := RemoveClassPostfix;
  end;
end;

function TFormOption.get_Options: TOptions;
begin
  Result := FOptions.Clone as TOptions;
end;

procedure TFormOption.set_Options(const Value: TOptions);
begin
  FOptions := Value.Clone as TOptions;
  FOptions.Store;
end;

function TFormOption.ShowDialog: System.Windows.Forms.DialogResult;
begin
  ListNamespacePrefixes.Enabled := false;
  TextCustomNamePrefix.Enabled := false;
  ListNamespacePrefixes.BackColor := BorderExtender.TweakColor(BackColor,10);
  TextCustomNamePrefix.BackColor := ListNamespacePrefixes.BackColor;
  SelectedName := '';
  SelectedExclude := false;
  ListNamespacePrefixes.Items.Clear;
  TextCustomNamePrefix.Text := '';
  OptionsToControls(FOptions);
  Result := inherited ShowDialog;
end;

function TFormOption.ShowDialogNamespace(Namespace,CustomPrefix: string; Exclude_: Boolean): System.Windows.Forms.DialogResult;
var
  Tokens: array of string;
  KnownNamespace: TKnownNamespace;
  I,J: Integer;
begin
  ListNamespacePrefixes.Enabled := true;
  TextCustomNamePrefix.Enabled := true;
  ListNamespacePrefixes.BackColor := Color.FromKnownColor(KnownColor.Window);
  TextCustomNamePrefix.BackColor := Color.FromKnownColor(KnownColor.Window);
  SelectedName := Namespace;
  SelectedExclude := Exclude_;
  ListNamespacePrefixes.Items.Clear;
  TextCustomNamePrefix.Text := CustomPrefix;
  Exclude(ListNamespacePrefixes.ItemCheck,ListNamespacePrefixes_ItemCheck);
  Tokens := Namespace.Split(['.']);
  for I := 0 to Pred(Length(Tokens)) do
    ListNamespacePrefixes.Items.Add(Tokens[I]);
  with FOptions.GetHashedKnownNamespaces do begin
    KnownNamespace := TKnownNamespace(Item[Namespace.ToUpper]);
    if Assigned(KnownNamespace) then
      if KnownNamespace.Prefix <> '' then begin
        Tokens := KnownNamespace.Prefix.Split(['.']);
        for I := 0 to Pred(Length(Tokens)) do begin
          J := ListNamespacePrefixes.Items.IndexOf(Tokens[I]);
          if J >= 0 then
            ListNamespacePrefixes.SetItemChecked(J,true);
        end;
      end;
  end;
  Include(ListNamespacePrefixes.ItemCheck,ListNamespacePrefixes_ItemCheck);
  OptionsToControls(FOptions);
  Result := inherited ShowDialog;
end;

function TFormOption.ShowDialogName(Name,CustomName: string; Exclude: Boolean): System.Windows.Forms.DialogResult;
begin
  ListNamespacePrefixes.Enabled := false;
  TextCustomNamePrefix.Enabled := true;
  ListNamespacePrefixes.BackColor := BorderExtender.TweakColor(BackColor,10);
  TextCustomNamePrefix.BackColor := Color.FromKnownColor(KnownColor.Window);
  SelectedName := Name;
  SelectedExclude := Exclude;
  ListNamespacePrefixes.Items.Clear;
  TextCustomNamePrefix.Text := CustomName;
  OptionsToControls(FOptions);
  Result := inherited ShowDialog;
end;

end.
