unit Main;

interface

uses
  Invisibles.ExceptionHandler,
  Option,
  System.Collections,
  System.ComponentModel,
  System.Drawing,
  System.Reflection,
  System.Resources,
  System.Text,
  System.Windows.Forms,
  Visibles.BorderExtender;

type
  TFormMain = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: System.ComponentModel.IContainer;
    DialogLoad: System.Windows.Forms.OpenFileDialog;
    BorderExtender: Visibles.BorderExtender.TBorderExtender;
    MainMenu: System.Windows.Forms.MainMenu;
    ItemAssembly: System.Windows.Forms.MenuItem;
    ItemLoad: System.Windows.Forms.MenuItem;
    ItemPrefixUnit: System.Windows.Forms.MenuItem;
    ItemGenerate: System.Windows.Forms.MenuItem;
    ItemOptions: System.Windows.Forms.MenuItem;
    ItemExit: System.Windows.Forms.MenuItem;
    ExceptionHandler: Invisibles.ExceptionHandler.TExceptionHandler;
    ItemAbout: System.Windows.Forms.MenuItem;
    ContextMenuNamespaces: System.Windows.Forms.ContextMenu;
    ItemNamespacesUncheckAll: System.Windows.Forms.MenuItem;
    ItemNamespacesCheckAll: System.Windows.Forms.MenuItem;
    ContextMenuNames: System.Windows.Forms.ContextMenu;
    ItemNamesUncheckAll: System.Windows.Forms.MenuItem;
    ItemNamesCheckAll: System.Windows.Forms.MenuItem;
    ImageList: System.Windows.Forms.ImageList;
    ItemMerge: System.Windows.Forms.MenuItem;
    Panel1: System.Windows.Forms.Panel;
    StatusBar: System.Windows.Forms.StatusBar;
    Splitter1: System.Windows.Forms.Splitter;
    Panel2: System.Windows.Forms.Panel;
    Panel3: System.Windows.Forms.Panel;
    Splitter2: System.Windows.Forms.Splitter;
    Panel4: System.Windows.Forms.Panel;
    ListNames: System.Windows.Forms.ListView;
    ColumnFCLName: System.Windows.Forms.ColumnHeader;
    ColumnTName: System.Windows.Forms.ColumnHeader;
    ListNamespaces: System.Windows.Forms.ListView;
    ColumnNamespaceName: System.Windows.Forms.ColumnHeader;
    ColumnNamespacePrefix: System.Windows.Forms.ColumnHeader;
    ListAssemblies: System.Windows.Forms.ListView;
    ColumnAssemblyName: System.Windows.Forms.ColumnHeader;
    ColumnAssemblyLocation: System.Windows.Forms.ColumnHeader;
    StatusBarAssemblies: System.Windows.Forms.StatusBarPanel;
    ItemMergeAll: System.Windows.Forms.MenuItem;
    ItemClear: System.Windows.Forms.MenuItem;
    MenuItem1: System.Windows.Forms.MenuItem;
    ItemNamesSave: System.Windows.Forms.MenuItem;
    MenuItem3: System.Windows.Forms.MenuItem;
    ItemNamespacesSave: System.Windows.Forms.MenuItem;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure ItemLoad_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemGenerate_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemOptions_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemExit_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemAbout_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamespacesUncheckAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamespacesCheckAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamesCheckAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamesUncheckAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ContextMenuNames_Popup(sender: System.Object; e: System.EventArgs);
    procedure ContextMenuNamespaces_Popup(sender: System.Object; e: System.EventArgs);
    procedure ItemMerge_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemMergeAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemClear_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamesSave_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamespacesSave_Click(sender: System.Object; e: System.EventArgs);
    procedure ListNamespaces_ItemCheck(sender: System.Object; e: System.Windows.Forms.ItemCheckEventArgs);
    procedure ListNames_ItemCheck(sender: System.Object; e: System.Windows.Forms.ItemCheckEventArgs);
  {$ENDREGION}
  strict protected
    procedure Dispose(Disposing: Boolean); override;
  strict private
    DialogFolder: FolderBrowserDialog;
    FormOption: TFormOption;
    Options: TOptions;
    Names,Namespaces: HashTable;
    procedure AllCheckedTo(Value: Boolean; List: ListView);
    function GetSubitem(Subitems: ListViewItem.ListViewSubItemCollection; Index: Integer): ListViewItem.ListViewSubItem;
    procedure ReflectAssembly(AAssembly: Assembly; Refresh: Boolean);
    procedure Generate(StoreFolderPath: string);
  public
    constructor Create;
  end;

implementation

uses
  About,
  System.IO,
  System.Runtime.InteropServices;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFormMain.InitializeComponent;
type
  TArrayOfSystem_Windows_Forms_StatusBarPanel = array of System.Windows.Forms.StatusBarPanel;
  TArrayOfSystem_Windows_Forms_ColumnHeader = array of System.Windows.Forms.ColumnHeader;
  TArrayOfSystem_Windows_Forms_MenuItem = array of System.Windows.Forms.MenuItem;
var
  resources: System.Resources.ResourceManager;
begin
  Self.components := System.ComponentModel.Container.Create;
  resources := System.Resources.ResourceManager.Create(TypeOf(TFormMain));
  Self.DialogLoad := System.Windows.Forms.OpenFileDialog.Create;
  Self.BorderExtender := Visibles.BorderExtender.TBorderExtender.Create;
  Self.StatusBar := System.Windows.Forms.StatusBar.Create;
  Self.StatusBarAssemblies := System.Windows.Forms.StatusBarPanel.Create;
  Self.Panel1 := System.Windows.Forms.Panel.Create;
  Self.ListAssemblies := System.Windows.Forms.ListView.Create;
  Self.ColumnAssemblyName := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnAssemblyLocation := System.Windows.Forms.ColumnHeader.Create;
  Self.ImageList := System.Windows.Forms.ImageList.Create(Self.components);
  Self.Splitter1 := System.Windows.Forms.Splitter.Create;
  Self.Panel2 := System.Windows.Forms.Panel.Create;
  Self.Panel4 := System.Windows.Forms.Panel.Create;
  Self.ListNames := System.Windows.Forms.ListView.Create;
  Self.ColumnFCLName := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnTName := System.Windows.Forms.ColumnHeader.Create;
  Self.ContextMenuNames := System.Windows.Forms.ContextMenu.Create;
  Self.ItemNamesUncheckAll := System.Windows.Forms.MenuItem.Create;
  Self.ItemNamesCheckAll := System.Windows.Forms.MenuItem.Create;
  Self.MenuItem1 := System.Windows.Forms.MenuItem.Create;
  Self.ItemNamesSave := System.Windows.Forms.MenuItem.Create;
  Self.Splitter2 := System.Windows.Forms.Splitter.Create;
  Self.Panel3 := System.Windows.Forms.Panel.Create;
  Self.ListNamespaces := System.Windows.Forms.ListView.Create;
  Self.ColumnNamespaceName := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnNamespacePrefix := System.Windows.Forms.ColumnHeader.Create;
  Self.ContextMenuNamespaces := System.Windows.Forms.ContextMenu.Create;
  Self.ItemNamespacesUncheckAll := System.Windows.Forms.MenuItem.Create;
  Self.ItemNamespacesCheckAll := System.Windows.Forms.MenuItem.Create;
  Self.MenuItem3 := System.Windows.Forms.MenuItem.Create;
  Self.ItemNamespacesSave := System.Windows.Forms.MenuItem.Create;
  Self.MainMenu := System.Windows.Forms.MainMenu.Create;
  Self.ItemAssembly := System.Windows.Forms.MenuItem.Create;
  Self.ItemLoad := System.Windows.Forms.MenuItem.Create;
  Self.ItemMerge := System.Windows.Forms.MenuItem.Create;
  Self.ItemClear := System.Windows.Forms.MenuItem.Create;
  Self.ItemMergeAll := System.Windows.Forms.MenuItem.Create;
  Self.ItemExit := System.Windows.Forms.MenuItem.Create;
  Self.ItemPrefixUnit := System.Windows.Forms.MenuItem.Create;
  Self.ItemGenerate := System.Windows.Forms.MenuItem.Create;
  Self.ItemOptions := System.Windows.Forms.MenuItem.Create;
  Self.ItemAbout := System.Windows.Forms.MenuItem.Create;
  Self.ExceptionHandler := Invisibles.ExceptionHandler.TExceptionHandler.Create;
  (System.ComponentModel.ISupportInitialize(Self.StatusBarAssemblies)).BeginInit;
  Self.Panel1.SuspendLayout;
  Self.Panel2.SuspendLayout;
  Self.Panel4.SuspendLayout;
  Self.Panel3.SuspendLayout;
  Self.SuspendLayout;
  // 
  // DialogLoad
  // 
  Self.DialogLoad.DefaultExt := '*.dll';
  Self.DialogLoad.Filter := 'Libraries (*.dll)|*.dll|Apps (*.exe)|*.exe';
  Self.DialogLoad.InitialDirectory := '.';
  Self.DialogLoad.Title := 'Load Assembly';
  // 
  // StatusBar
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.StatusBar, System.Windows.Forms.Border3DStyle.Adjust);
  Self.StatusBar.Location := System.Drawing.Point.Create(1, 507);
  Self.StatusBar.Name := 'StatusBar';
  Self.StatusBar.Panels.AddRange(TArrayOfSystem_Windows_Forms_StatusBarPanel.Create(Self.StatusBarAssemblies));
  Self.StatusBar.ShowPanels := True;
  Self.StatusBar.Size := System.Drawing.Size.Create(646, 22);
  Self.StatusBar.TabIndex := 0;
  // 
  // StatusBarAssemblies
  // 
  Self.StatusBarAssemblies.AutoSize := System.Windows.Forms.StatusBarPanelAutoSize.Spring;
  Self.StatusBarAssemblies.Width := 630;
  // 
  // Panel1
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.Panel1, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.Panel1.Controls.Add(Self.ListAssemblies);
  Self.Panel1.Dock := System.Windows.Forms.DockStyle.Top;
  Self.Panel1.Location := System.Drawing.Point.Create(1, 1);
  Self.Panel1.Name := 'Panel1';
  Self.Panel1.Size := System.Drawing.Size.Create(646, 56);
  Self.Panel1.TabIndex := 1;
  // 
  // ListAssemblies
  // 
  Self.ListAssemblies.BackColor := System.Drawing.SystemColors.Control;
  Self.BorderExtender.SetBorder3DStyle(Self.ListAssemblies, System.Windows.Forms.Border3DStyle.Adjust);
  Self.ListAssemblies.BorderStyle := System.Windows.Forms.BorderStyle.None;
  Self.ListAssemblies.Columns.AddRange(TArrayOfSystem_Windows_Forms_ColumnHeader.Create(Self.ColumnAssemblyName, 
          Self.ColumnAssemblyLocation));
  Self.ListAssemblies.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListAssemblies.HeaderStyle := System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
  Self.ListAssemblies.Location := System.Drawing.Point.Create(0, 0);
  Self.ListAssemblies.Name := 'ListAssemblies';
  Self.ListAssemblies.Size := System.Drawing.Size.Create(646, 56);
  Self.ListAssemblies.SmallImageList := Self.ImageList;
  Self.ListAssemblies.StateImageList := Self.ImageList;
  Self.ListAssemblies.TabIndex := 8;
  Self.ListAssemblies.View := System.Windows.Forms.View.Details;
  // 
  // ColumnAssemblyName
  // 
  Self.ColumnAssemblyName.Text := 'Assemblies';
  Self.ColumnAssemblyName.Width := 366;
  // 
  // ColumnAssemblyLocation
  // 
  Self.ColumnAssemblyLocation.Text := 'Locations';
  Self.ColumnAssemblyLocation.Width := 280;
  // 
  // ImageList
  // 
  Self.ImageList.ImageSize := System.Drawing.Size.Create(16, 16);
  Self.ImageList.ImageStream := (System.Windows.Forms.ImageListStreamer(resources.GetObject('ImageList.ImageStream')));
  Self.ImageList.TransparentColor := System.Drawing.Color.Transparent;
  // 
  // Splitter1
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.Splitter1, System.Windows.Forms.Border3DStyle.RaisedInner);
  Self.Splitter1.Dock := System.Windows.Forms.DockStyle.Top;
  Self.Splitter1.Location := System.Drawing.Point.Create(1, 57);
  Self.Splitter1.MinExtra := 150;
  Self.Splitter1.MinSize := 50;
  Self.Splitter1.Name := 'Splitter1';
  Self.Splitter1.Size := System.Drawing.Size.Create(646, 3);
  Self.Splitter1.TabIndex := 2;
  Self.Splitter1.TabStop := False;
  // 
  // Panel2
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.Panel2, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Panel2.Controls.Add(Self.Panel4);
  Self.Panel2.Controls.Add(Self.Splitter2);
  Self.Panel2.Controls.Add(Self.Panel3);
  Self.Panel2.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.Panel2.DockPadding.All := 1;
  Self.Panel2.Location := System.Drawing.Point.Create(1, 60);
  Self.Panel2.Name := 'Panel2';
  Self.Panel2.Size := System.Drawing.Size.Create(646, 447);
  Self.Panel2.TabIndex := 3;
  // 
  // Panel4
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.Panel4, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.Panel4.Controls.Add(Self.ListNames);
  Self.Panel4.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.Panel4.Location := System.Drawing.Point.Create(1, 128);
  Self.Panel4.Name := 'Panel4';
  Self.Panel4.Size := System.Drawing.Size.Create(644, 318);
  Self.Panel4.TabIndex := 2;
  // 
  // ListNames
  // 
  Self.ListNames.AutoArrange := False;
  Self.ListNames.BackColor := System.Drawing.SystemColors.Control;
  Self.BorderExtender.SetBorder3DStyle(Self.ListNames, System.Windows.Forms.Border3DStyle.Adjust);
  Self.ListNames.BorderStyle := System.Windows.Forms.BorderStyle.None;
  Self.ListNames.CheckBoxes := True;
  Self.ListNames.Columns.AddRange(TArrayOfSystem_Windows_Forms_ColumnHeader.Create(Self.ColumnFCLName, 
          Self.ColumnTName));
  Self.ListNames.ContextMenu := Self.ContextMenuNames;
  Self.ListNames.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListNames.HeaderStyle := System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
  Self.ListNames.HideSelection := False;
  Self.ListNames.Location := System.Drawing.Point.Create(0, 0);
  Self.ListNames.Name := 'ListNames';
  Self.ListNames.Size := System.Drawing.Size.Create(644, 318);
  Self.ListNames.SmallImageList := Self.ImageList;
  Self.ListNames.Sorting := System.Windows.Forms.SortOrder.Ascending;
  Self.ListNames.TabIndex := 5;
  Self.ListNames.View := System.Windows.Forms.View.Details;
  Include(Self.ListNames.ItemCheck, Self.ListNames_ItemCheck);
  // 
  // ColumnFCLName
  // 
  Self.ColumnFCLName.Text := '.NET Names';
  Self.ColumnFCLName.Width := 366;
  // 
  // ColumnTName
  // 
  Self.ColumnTName.Text := 'Delphi Names';
  Self.ColumnTName.Width := 280;
  // 
  // ContextMenuNames
  // 
  Self.ContextMenuNames.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.ItemNamesUncheckAll, 
          Self.ItemNamesCheckAll, Self.MenuItem1, Self.ItemNamesSave));
  Include(Self.ContextMenuNames.Popup, Self.ContextMenuNames_Popup);
  // 
  // ItemNamesUncheckAll
  // 
  Self.ItemNamesUncheckAll.Index := 0;
  Self.ItemNamesUncheckAll.Text := '&Uncheck All';
  Include(Self.ItemNamesUncheckAll.Click, Self.ItemNamesUncheckAll_Click);
  // 
  // ItemNamesCheckAll
  // 
  Self.ItemNamesCheckAll.Index := 1;
  Self.ItemNamesCheckAll.Text := '&Check All';
  Include(Self.ItemNamesCheckAll.Click, Self.ItemNamesCheckAll_Click);
  // 
  // MenuItem1
  // 
  Self.MenuItem1.Index := 2;
  Self.MenuItem1.Text := '-';
  // 
  // ItemNamesSave
  // 
  Self.ItemNamesSave.Index := 3;
  Self.ItemNamesSave.Text := '&Save';
  Include(Self.ItemNamesSave.Click, Self.ItemNamesSave_Click);
  // 
  // Splitter2
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.Splitter2, System.Windows.Forms.Border3DStyle.RaisedInner);
  Self.Splitter2.Dock := System.Windows.Forms.DockStyle.Top;
  Self.Splitter2.Location := System.Drawing.Point.Create(1, 125);
  Self.Splitter2.MinExtra := 150;
  Self.Splitter2.MinSize := 100;
  Self.Splitter2.Name := 'Splitter2';
  Self.Splitter2.Size := System.Drawing.Size.Create(644, 3);
  Self.Splitter2.TabIndex := 1;
  Self.Splitter2.TabStop := False;
  // 
  // Panel3
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.Panel3, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.Panel3.Controls.Add(Self.ListNamespaces);
  Self.Panel3.Dock := System.Windows.Forms.DockStyle.Top;
  Self.Panel3.Location := System.Drawing.Point.Create(1, 1);
  Self.Panel3.Name := 'Panel3';
  Self.Panel3.Size := System.Drawing.Size.Create(644, 124);
  Self.Panel3.TabIndex := 0;
  // 
  // ListNamespaces
  // 
  Self.ListNamespaces.AutoArrange := False;
  Self.ListNamespaces.BackColor := System.Drawing.SystemColors.Control;
  Self.BorderExtender.SetBorder3DStyle(Self.ListNamespaces, System.Windows.Forms.Border3DStyle.Adjust);
  Self.ListNamespaces.BorderStyle := System.Windows.Forms.BorderStyle.None;
  Self.ListNamespaces.CheckBoxes := True;
  Self.ListNamespaces.Columns.AddRange(TArrayOfSystem_Windows_Forms_ColumnHeader.Create(Self.ColumnNamespaceName, 
          Self.ColumnNamespacePrefix));
  Self.ListNamespaces.ContextMenu := Self.ContextMenuNamespaces;
  Self.ListNamespaces.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListNamespaces.HeaderStyle := System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
  Self.ListNamespaces.HideSelection := False;
  Self.ListNamespaces.Location := System.Drawing.Point.Create(0, 0);
  Self.ListNamespaces.Name := 'ListNamespaces';
  Self.ListNamespaces.Size := System.Drawing.Size.Create(644, 124);
  Self.ListNamespaces.SmallImageList := Self.ImageList;
  Self.ListNamespaces.Sorting := System.Windows.Forms.SortOrder.Ascending;
  Self.ListNamespaces.TabIndex := 7;
  Self.ListNamespaces.View := System.Windows.Forms.View.Details;
  Include(Self.ListNamespaces.ItemCheck, Self.ListNamespaces_ItemCheck);
  // 
  // ColumnNamespaceName
  // 
  Self.ColumnNamespaceName.Text := 'Namespaces';
  Self.ColumnNamespaceName.Width := 366;
  // 
  // ColumnNamespacePrefix
  // 
  Self.ColumnNamespacePrefix.Text := 'Prefixes';
  Self.ColumnNamespacePrefix.Width := 280;
  // 
  // ContextMenuNamespaces
  // 
  Self.ContextMenuNamespaces.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.ItemNamespacesUncheckAll, 
          Self.ItemNamespacesCheckAll, Self.MenuItem3, Self.ItemNamespacesSave));
  Include(Self.ContextMenuNamespaces.Popup, Self.ContextMenuNamespaces_Popup);
  // 
  // ItemNamespacesUncheckAll
  // 
  Self.ItemNamespacesUncheckAll.Index := 0;
  Self.ItemNamespacesUncheckAll.Text := '&Uncheck All';
  Include(Self.ItemNamespacesUncheckAll.Click, Self.ItemNamespacesUncheckAll_Click);
  // 
  // ItemNamespacesCheckAll
  // 
  Self.ItemNamespacesCheckAll.Index := 1;
  Self.ItemNamespacesCheckAll.Text := '&Check All';
  Include(Self.ItemNamespacesCheckAll.Click, Self.ItemNamespacesCheckAll_Click);
  // 
  // MenuItem3
  // 
  Self.MenuItem3.Index := 2;
  Self.MenuItem3.Text := '-';
  // 
  // ItemNamespacesSave
  // 
  Self.ItemNamespacesSave.Index := 3;
  Self.ItemNamespacesSave.Text := '&Save';
  Include(Self.ItemNamespacesSave.Click, Self.ItemNamespacesSave_Click);
  // 
  // MainMenu
  // 
  Self.MainMenu.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.ItemAssembly, 
          Self.ItemPrefixUnit, Self.ItemOptions, Self.ItemAbout));
  // 
  // ItemAssembly
  // 
  Self.ItemAssembly.Index := 0;
  Self.ItemAssembly.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.ItemLoad, 
          Self.ItemMerge, Self.ItemClear, Self.ItemMergeAll, Self.ItemExit));
  Self.ItemAssembly.Text := '&Assembly';
  // 
  // ItemLoad
  // 
  Self.ItemLoad.Index := 0;
  Self.ItemLoad.Text := 'Load...';
  Include(Self.ItemLoad.Click, Self.ItemLoad_Click);
  // 
  // ItemMerge
  // 
  Self.ItemMerge.Enabled := False;
  Self.ItemMerge.Index := 1;
  Self.ItemMerge.Text := 'Merge...';
  Include(Self.ItemMerge.Click, Self.ItemMerge_Click);
  // 
  // ItemClear
  // 
  Self.ItemClear.Enabled := False;
  Self.ItemClear.Index := 2;
  Self.ItemClear.Text := '&Clear';
  Include(Self.ItemClear.Click, Self.ItemClear_Click);
  // 
  // ItemMergeAll
  // 
  Self.ItemMergeAll.Index := 3;
  Self.ItemMergeAll.Text := 'Merge &All';
  Include(Self.ItemMergeAll.Click, Self.ItemMergeAll_Click);
  // 
  // ItemExit
  // 
  Self.ItemExit.Index := 4;
  Self.ItemExit.Text := '&Exit';
  Include(Self.ItemExit.Click, Self.ItemExit_Click);
  // 
  // ItemPrefixUnit
  // 
  Self.ItemPrefixUnit.Index := 1;
  Self.ItemPrefixUnit.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.ItemGenerate));
  Self.ItemPrefixUnit.Text := '&Prefix Units';
  // 
  // ItemGenerate
  // 
  Self.ItemGenerate.Index := 0;
  Self.ItemGenerate.Text := '&Generate...';
  Include(Self.ItemGenerate.Click, Self.ItemGenerate_Click);
  // 
  // ItemOptions
  // 
  Self.ItemOptions.Index := 2;
  Self.ItemOptions.Text := '&Options...';
  Include(Self.ItemOptions.Click, Self.ItemOptions_Click);
  // 
  // ItemAbout
  // 
  Self.ItemAbout.Index := 3;
  Self.ItemAbout.Text := 'About...';
  Include(Self.ItemAbout.Click, Self.ItemAbout_Click);
  // 
  // ExceptionHandler
  // 
  Self.ExceptionHandler.ExitOnError := False;
  Self.ExceptionHandler.SimpleMessageBox := False;
  // 
  // TFormMain
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(648, 530);
  Self.Controls.Add(Self.Panel2);
  Self.Controls.Add(Self.Splitter1);
  Self.Controls.Add(Self.Panel1);
  Self.Controls.Add(Self.StatusBar);
  Self.DockPadding.All := 1;
  Self.Icon := (System.Drawing.Icon(resources.GetObject('$this.Icon')));
  Self.Menu := Self.MainMenu;
  Self.MinimumSize := System.Drawing.Size.Create(500, 300);
  Self.Name := 'TFormMain';
  (System.ComponentModel.ISupportInitialize(Self.StatusBarAssemblies)).EndInit;
  Self.Panel1.ResumeLayout(False);
  Self.Panel2.ResumeLayout(False);
  Self.Panel4.ResumeLayout(False);
  Self.Panel3.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFormMain.Dispose(Disposing: Boolean);
begin
  if Disposing then begin
    ItemNamespacesSave_Click(nil,nil);
    ItemNamesSave_Click(nil,nil);
    FormOption.Free;
    DialogFolder.Free;
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TFormMain.Create;
begin
  inherited Create;
  InitializeComponent;
  Text := Application.ProductName;
  ListNamespaces.BackColor := BorderExtender.TweakColor(ListNamespaces.BackColor,10);
  ListNames.BackColor := ListNamespaces.BackColor;
  ListAssemblies.BackColor := ListNamespaces.BackColor;
  DockPadding.All := 0;
  Panel2.DockPadding.All := 0;
  DialogFolder := FolderBrowserDialog.Create;
  FormOption := TFormOption.Create;
  Options := FormOption.Options;
  Names := HashTable.Create;
  Namespaces := HashTable.Create;
  StatusBarAssemblies.Text := 'No assembly loaded';
  ItemNamespacesSave.Enabled := false;
  ItemNamesSave.Enabled := false;
end;

procedure TFormMain.ListNamespaces_ItemCheck(sender: System.Object; e: System.Windows.Forms.ItemCheckEventArgs);
begin
  ItemNamespacesSave.Enabled := true;
end;

procedure TFormMain.ListNames_ItemCheck(sender: System.Object; e: System.Windows.Forms.ItemCheckEventArgs);
begin
  ItemNamesSave.Enabled := true;
end;

procedure TFormMain.ContextMenuNamespaces_Popup(sender: System.Object; e: System.EventArgs);
begin
  ItemNamespacesCheckAll.Enabled := (ListNamespaces.Items.Count > 0);
  ItemNamespacesUncheckAll.Enabled := ItemNamespacesCheckAll.Enabled;
end;

procedure TFormMain.ContextMenuNames_Popup(sender: System.Object; e: System.EventArgs);
begin
  ItemNamesCheckAll.Enabled := (ListNames.Items.Count > 0);
  ItemNamesUncheckAll.Enabled := ItemNamesCheckAll.Enabled;
end;

procedure TFormMain.ItemNamesUncheckAll_Click(sender: System.Object; e: System.EventArgs);
begin
  AllCheckedTo(false,ListNames);
end;

procedure TFormMain.ItemNamesCheckAll_Click(sender: System.Object; e: System.EventArgs);
begin
  AllCheckedTo(true,ListNames);
end;

procedure TFormMain.ItemNamesSave_Click(sender: System.Object; e: System.EventArgs);
var
  I: Integer;
begin
  for I := 0 to Pred(ListNames.Items.Count) do
    if (ListNames.Items[I].Checked and Assigned(ListNames.Items[I].Tag)) or
       (not ListNames.Items[I].Checked and not Assigned(ListNames.Items[I].Tag)) then begin
      if (ListNames.Items[I].ImageIndex = 1) then
        Options.SetKnownType(ListNames.Items[I].Text,GetSubitem(ListNames.Items[I].SubItems,1).Text,not ListNames.Items[I].Checked)
      else
        Options.SetKnownType(ListNames.Items[I].Text,'',not ListNames.Items[I].Checked);
      if ListNames.Items[I].Checked then
        ListNames.Items[I].Tag := nil
      else
        ListNames.Items[I].Tag := TObject(1);
    end;
  FormOption.Options := Options;
  ItemNamesSave.Enabled := false;
end;

procedure TFormMain.ItemNamespacesUncheckAll_Click(sender: System.Object; e: System.EventArgs);
begin
  AllCheckedTo(false,ListNamespaces);
end;

procedure TFormMain.ItemNamespacesCheckAll_Click(sender: System.Object; e: System.EventArgs);
begin
  AllCheckedTo(true,ListNamespaces);
end;

procedure TFormMain.ItemNamespacesSave_Click(sender: System.Object; e: System.EventArgs);
var
  I: Integer;
begin
  for I := 0 to Pred(ListNamespaces.Items.Count) do
    if (ListNamespaces.Items[I].Checked and Assigned(ListNamespaces.Items[I].Tag)) or
       (not ListNamespaces.Items[I].Checked and not Assigned(ListNamespaces.Items[I].Tag)) then begin
      Options.SetKnownNamespace(ListNamespaces.Items[I].Text,GetSubitem(ListNamespaces.Items[I].SubItems,1).Text,not ListNamespaces.Items[I].Checked);
      if ListNamespaces.Items[I].Checked then
        ListNamespaces.Items[I].Tag := nil
      else
        ListNamespaces.Items[I].Tag := TObject(1);
    end;
  FormOption.Options := Options;
  ItemNamespacesSave.Enabled := false;
end;

procedure TFormMain.ItemAbout_Click(sender: System.Object; e: System.EventArgs);
begin
  with TFormAbout.Create do begin
    ShowDialog;
    Free;
  end;
end;

procedure TFormMain.ItemOptions_Click(sender: System.Object; e: System.EventArgs);
var
  DialogResult: System.Windows.Forms.DialogResult;
  I: Integer;
begin
  if ListNamespaces.Focused and (ListNamespaces.SelectedIndices.Count = 1) then
    DialogResult := FormOption.ShowDialogNamespace(ListNamespaces.SelectedItems.Item[0].Text,GetSubitem(ListNamespaces.SelectedItems.Item[0].SubItems,1).Text,not ListNamespaces.SelectedItems.Item[0].Checked)
  else if ListNames.Focused and (ListNames.SelectedIndices.Count = 1) then begin
    if ListNames.SelectedItems.Item[0].ImageIndex = 1 then
      DialogResult := FormOption.ShowDialogName(ListNames.SelectedItems.Item[0].Text,GetSubitem(ListNames.SelectedItems.Item[0].SubItems,1).Text,not ListNames.SelectedItems.Item[0].Checked)
    else
      DialogResult := FormOption.ShowDialogName(ListNames.SelectedItems.Item[0].Text,'',not ListNames.SelectedItems.Item[0].Checked);
  end
  else
    DialogResult := FormOption.ShowDialog;
  if DialogResult = System.Windows.Forms.DialogResult.OK then begin
    Options := FormOption.Options;
    ItemNamespacesSave_Click(nil,nil);
    ItemNamesSave_Click(nil,nil);
    if ListAssemblies.Items.Count > 0 then begin
      Cursor.Current := Cursors.WaitCursor;
      Exclude(ListNames.ItemCheck,ListNames_ItemCheck);
      Exclude(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
      ListNames.BeginUpdate;
      ListNamespaces.BeginUpdate;
      try
        for I := 0 to Pred(ListAssemblies.Items.Count) do
          ReflectAssembly(ListAssemblies.Items[I].Tag as Assembly,true);
      finally
        ListNames.EndUpdate;
        ListNamespaces.EndUpdate;
        Include(ListNames.ItemCheck,ListNames_ItemCheck);
        Include(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
        Cursor.Current := Cursors.Default;
      end;
    end;
  end;
end;

procedure TFormMain.ItemGenerate_Click(sender: System.Object; e: System.EventArgs);
begin
  DialogFolder.Description := 'Prefix Units Store Folder';
  if DialogFolder.ShowDialog = System.Windows.Forms.DialogResult.OK then begin
    Cursor.Current := Cursors.WaitCursor;
    try
      Generate(DialogFolder.SelectedPath);
    finally
      Cursor.Current := Cursors.Default;
    end;
  end;
end;

procedure TFormMain.ItemLoad_Click(sender: System.Object; e: System.EventArgs);
begin
  ItemClear_Click(nil,nil);
  Application.DoEvents;
  ItemMerge_Click(nil,nil);
end;

procedure TFormMain.ItemMerge_Click(sender: System.Object; e: System.EventArgs);
var
  AAssembly: Assembly;
  I: Integer;
begin
  if (DialogLoad.ShowDialog = System.Windows.Forms.DialogResult.OK) then begin
    Cursor.Current := Cursors.WaitCursor;
    Exclude(ListNames.ItemCheck,ListNames_ItemCheck);
    Exclude(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
    ListNames.BeginUpdate;
    ListNamespaces.BeginUpdate;
    try
      AAssembly := Assembly.LoadFrom(DialogLoad.FileName);
      for I := 0 to Pred(ListAssemblies.Items.Count) do
        if System.string.Compare((ListAssemblies.Items[I].Tag as Assembly).FullName,AAssembly.FullName,true) = 0 then
          Exit;
      with ListAssemblies.Items.Add(AAssembly.FullName) do begin
        Tag := AAssembly;
        SubItems.Add(AAssembly.Location);
      end;
      if ListAssemblies.Items.Count <= 1 then
        StatusBarAssemblies.Text := System.string.Format('Assebly: {0}',[AAssembly.GetName.Name])
      else
        StatusBarAssemblies.Text := System.string.Format('{0} Assemblies, {1} Namespaces, {2} Types',
                                                         [ListAssemblies.Items.Count,ListNamespaces.Items.Count,ListNames.Items.Count]);
      ReflectAssembly(AAssembly,false);
      ListNames.Sort;
      ListNamespaces.Sort;
      if ListAssemblies.Items.Count <= 1 then
        StatusBarAssemblies.Text := System.string.Format('Assebly: {0}, {1} Namespaces, {2} Types',
                                                         [AAssembly.GetName.Name,ListNamespaces.Items.Count,ListNames.Items.Count])
      else
        StatusBarAssemblies.Text := System.string.Format('{0} Assemblies, {1} Namespaces, {2} Types',
                                                         [ListAssemblies.Items.Count,ListNamespaces.Items.Count,ListNames.Items.Count]);
      ItemMerge.Enabled := true;
      ItemClear.Enabled := true;
    finally
      ListNames.EndUpdate;
      ListNamespaces.EndUpdate;
      Include(ListNames.ItemCheck,ListNames_ItemCheck);
      Include(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
      Cursor.Current := Cursors.Default;
    end;
  end;
end;

procedure TFormMain.ItemClear_Click(sender: System.Object; e: System.EventArgs);
begin
  ItemMerge.Enabled := false;
  ItemClear.Enabled := false;
  Names.Clear;
  Namespaces.Clear;
  ListAssemblies.Items.Clear;
  ListNames.Items.Clear;
  ListNamespaces.Items.Clear;
  ItemNamespacesSave.Enabled := false;
  ItemNamesSave.Enabled := false;
  StatusBarAssemblies.Text := 'No assembly loaded';
end;

procedure TFormMain.ItemMergeAll_Click(sender: System.Object; e: System.EventArgs);
var
  AssemblyFiles: array of string;
  AAssembly: Assembly;
  I,J: Integer;
begin
  DialogFolder.Description := 'Assemblies Folder';
  DialogFolder.SelectedPath := Directory.GetCurrentDirectory;
  if DialogFolder.ShowDialog = System.Windows.Forms.DialogResult.OK then begin
    Cursor.Current := Cursors.WaitCursor;
    Exclude(ListNames.ItemCheck,ListNames_ItemCheck);
    Exclude(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
    ListNames.BeginUpdate;
    ListNamespaces.BeginUpdate;
    try
      AssemblyFiles := Directory.GetFileSystemEntries(DialogFolder.SelectedPath,'*.dll');
      for J := Low(AssemblyFiles) to High(AssemblyFiles) do begin
        try
          AAssembly := Assembly.LoadFrom(AssemblyFiles[J]);
        except
          on BadImageFormatException do
            Continue;
          on System.IO.FileLoadException do
            Continue;
          else
            raise;
        end;
        for I := 0 to Pred(ListAssemblies.Items.Count) do
          if System.string.Compare((ListAssemblies.Items[I].Tag as Assembly).FullName,AAssembly.FullName,true) = 0 then
            Continue;
        with ListAssemblies.Items.Add(AAssembly.FullName) do begin
          Tag := AAssembly;
          SubItems.Add(AAssembly.Location);
        end;
        StatusBarAssemblies.Text := System.string.Format('{0} Assemblies, {1} Namespaces, {2} Types',
                                                         [ListAssemblies.Items.Count,ListNamespaces.Items.Count,ListNames.Items.Count]);
        Refresh;
        ReflectAssembly(AAssembly,false);
        StatusBarAssemblies.Text := System.string.Format('{0} Assemblies, {1} Namespaces, {2} Types',
                                                         [ListAssemblies.Items.Count,ListNamespaces.Items.Count,ListNames.Items.Count]);
        Refresh;
      end;
      ListNames.Sort;
      ListNamespaces.Sort;
      ItemMerge.Enabled := true;
      ItemClear.Enabled := true;
    finally
      ListNames.EndUpdate;
      ListNamespaces.EndUpdate;
      Include(ListNames.ItemCheck,ListNames_ItemCheck);
      Include(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
      Cursor.Current := Cursors.Default;
    end;
  end;
end;

procedure TFormMain.ItemExit_Click(sender: System.Object; e: System.EventArgs);
begin
  Close;
end;

procedure TFormMain.AllCheckedTo(Value: Boolean; List: ListView);
var
  I: Integer;
begin
  for I := 0 to Pred(List.Items.Count) do
    List.Items[I].Checked := Value and not Assigned(List.Items[I].Tag);
end;

function TFormMain.GetSubitem(Subitems: ListViewItem.ListViewSubItemCollection; Index: Integer): ListViewItem.ListViewSubItem;
begin
  while Subitems.Count <= Index do
    Subitems.Add('');
  Result := Subitems[Index];
end;

procedure TFormMain.ReflectAssembly(AAssembly: Assembly; Refresh: Boolean);
var
  I,P: integer;
  NameItem,NamespaceItem: ListViewItem;
  Types: array of &Type;
  FullName,Name,Namespace,ReplacementName,NamespacePrefix: string;
  KnownTypes,KnownNamespaces,NamespacePrefixes: HashTable;
  KnownType: TKnownType;
  KnownNamespace: TKnownNamespace; 
begin
  KnownTypes := Options.GetHashedKnownTypes;
  KnownNamespaces := Options.GetHashedKnownNamespaces;
  NamespacePrefixes := HashTable.Create;
  Types := AAssembly.GetTypes;
  for I := Low(Types) to High(Types) do begin
    FullName := Types[i].ToString;
    P := FullName.LastIndexOf('.');
    if not Types[I].IsInterface and
       not Types[I].IsPrimitive and
       (Types[i].IsPublic or Types[i].IsNestedPublic) and
       (P >=0) and
       (FullName.IndexOfAny(['+','-','&','@']) < 0) then begin {Remove funny named types}
      Name := FullName.Substring(P + 1);
      Namespace := FullName.Remove(P,Length(FullName) - P);
      NamespaceItem := nil;
      NameItem := nil;
      if Refresh then begin
        NameItem := Names.Item[FullName.ToUpper] as ListViewItem;
        if not Assigned(NamespacePrefixes.Item[Namespace.ToUpper]) then
          NamespaceItem := Namespaces.Item[Namespace.ToUpper] as ListViewItem;
      end;
      if (Refresh and Assigned(NameItem)) or not Names.ContainsKey(FullName.ToUpper) then begin
        NamespacePrefix := '';
        ReplacementName := '';
        if not Refresh and not Namespaces.ContainsKey(Namespace.ToUpper) then begin
          NamespaceItem := ListNamespaces.Items.Add(Namespace);
          Namespaces.Add(Namespace.ToUpper,NamespaceItem);
        end;
        if Assigned(NamespaceItem) then with NamespaceItem do begin
          Checked := true;
          ImageIndex := 0;
          KnownNamespace := TKnownNamespace(KnownNamespaces.Item[Namespace.ToUpper]);
          if Assigned(KnownNamespace) then begin
            Checked := not KnownNamespace.Exclude;
            if KnownNamespace.Prefix <> '' then begin
              NamespacePrefix := KnownNamespace.Prefix.Replace('.','');
              GetSubitem(SubItems,1).Text := NamespacePrefix;
              ImageIndex := 2;
            end;
          end
          else
            GetSubitem(SubItems,1).Text := '';
          NamespacePrefixes.Add(Namespace.ToUpper,NamespacePrefix);
          if not Checked then
            Tag := TObject(1);
        end
        else
          NamespacePrefix := string(NamespacePrefixes.Item[Namespace.ToUpper]);
        if not Refresh then begin
          NameItem := ListNames.Items.Add(FullName);
          Names.Add(FullName.ToUpper,NameItem);
        end;
        if Assigned(NameItem) then with NameItem do begin
          ImageIndex := 0;
          KnownType := TKnownType(KnownTypes[FullName.ToUpper]);
          if Assigned(KnownType) then begin
            Checked := not KnownType.Exclude;
            ReplacementName := KnownType.DelphiName;
            if ReplacementName <> '' then
              ImageIndex := 1
            else if NamespacePrefix <> '' then
              ImageIndex := 2;
          end
          else begin
            Checked := (Name.ToUpper <> 'UNIT'); {Uncheck Delphi phantom class}
            if NamespacePrefix <> '' then
              ImageIndex := 2;
          end;
          if not Checked then
            Tag := TObject(1);
          if ReplacementName <> '' then
            GetSubitem(SubItems,1).Text := ReplacementName
          else if Types[I].IsValueType then begin
            if Types[I].IsEnum then
              GetSubitem(SubItems,1).Text := Options.EnumeratedPrefix + NamespacePrefix + Name
            else
              GetSubitem(SubItems,1).Text := Options.RecordPrefix + NamespacePrefix + Name;
          end
          else if Types[I].IsSubclassOf(TypeOf(System.Exception)) then begin
            if Options.RemoveExceptionPostfix then begin
              P := Name.LastIndexOf('Exception');
              if P >= 0 then
                Name := Name.Remove(P,Length(Name) - P);
            end;
            GetSubitem(SubItems,1).Text := Options.ExceptionPrefix + NamespacePrefix + Name;
          end
          else if Options.RemoveClassPostfix and Types[I].IsCOMObject then begin
            P := Name.LastIndexOf('Class');
            if P >= 0 then
              Name := Name.Remove(P,Length(Name) - P);
            GetSubitem(SubItems,1).Text := Options.ClassPrefix + NamespacePrefix + Name;
          end
          else
            GetSubitem(SubItems,1).Text := Options.ClassPrefix + NamespacePrefix + Name;
        end;
      end;
    end;
  end;
end;

procedure TFormMain.Generate(StoreFolderPath: string);
var
  I: Integer;
  P: string;

  procedure UnitGenerate(UnitPath: string; UnitName: string; Namespace: string);
  var
    I,P: Integer;
    S,E: string;
    TextFileStream: FileStream;
    TextWriter: StreamWriter;
  begin
    TextFileStream := FileStream.Create(UnitPath,FileMode.Create,FileAccess.Write);
    try
      TextWriter := StreamWriter.Create(TextFileStream);
      try
        TextWriter.BaseStream.Seek(0,SeekOrigin.Begin);
        TextWriter.WriteLine(System.String.Format('unit {0};',[UnitName]));
        TextWriter.WriteLine('');
        TextWriter.WriteLine('interface');
        TextWriter.WriteLine('');
        TextWriter.WriteLine('{$region ''Info''} {');
        TextWriter.WriteLine(System.String.Format('This code has been generated by PrefixIt! V{0} - {1}',[Application.ProductVersion,DateTime.Now.ToString]));
        TextWriter.WriteLine('Assemblies:');
        for I := 0 to Pred(ListAssemblies.Items.Count) do
          TextWriter.WriteLine(System.String.Format(' {0}',[(ListAssemblies.Items[I].Tag as Assembly).FullName]));
        with Options do begin
          TextWriter.WriteLine('Options:');
          TextWriter.WriteLine(System.String.Format(' ClassPrefix={0}',[ClassPrefix]));
          TextWriter.WriteLine(System.String.Format(' RecordPrefix={0}',[RecordPrefix]));
          TextWriter.WriteLine(System.String.Format(' EnumeratedPrefix={0}',[EnumeratedPrefix]));
          TextWriter.WriteLine(System.String.Format(' ExceptionPrefix={0}',[ExceptionPrefix]));
          TextWriter.WriteLine(System.String.Format(' RemoveExceptionPostfix={0}',[RemoveExceptionPostfix]));
          TextWriter.WriteLine(System.String.Format(' RemoveClassPostfix={0}',[RemoveClassPostfix]));
          TextWriter.WriteLine(' Known Namespaces');
          for I := 0 to Pred(KnownNamespaces.Count) do with KnownNamespaces[I] as TKnownNamespace do begin
            E := 'x';
            if Exclude then
              E := ' ';
            TextWriter.WriteLine(System.String.Format(' {1}[{0}]={2} {3}',[I,E,Name,Prefix.Replace('.','')]));
          end;
          TextWriter.WriteLine(' Known Types');
          for I := 0 to Pred(KnownTypes.Count) do with KnownTypes[I] as TKnownType do begin
            E := 'x';
            if Exclude then
              E := ' ';
            TextWriter.WriteLine(System.String.Format(' {1}[{0}]={2} {3}',[I,E,NETName,DelphiName]));
          end;
        end;
        TextWriter.WriteLine('}{$endregion}');
        TextWriter.WriteLine('');
        if Namespace.ToUpper <> 'SYSTEM' then begin
          TextWriter.WriteLine('uses');
          TextWriter.WriteLine(System.String.Format('  {0};',[Namespace]));
          TextWriter.WriteLine('');
        end;
        TextWriter.WriteLine('type');
        for I := 0 to Pred(ListNames.Items.Count) do begin
          if ListNames.Items[I].Checked then begin
            S := ListNames.Items[I].Text;
            P := S.LastIndexOf('.');
            S := S.Remove(P,Length(S) - P);
            if System.String.Compare(S,Namespace,true) = 0 then begin
              S := System.String.Format('  {0} = {1};',[ListNames.Items[I].SubItems[1].Text,ListNames.Items[I].Text]);
              TextWriter.WriteLine(S);
            end;
          end;
        end;
        TextWriter.WriteLine('');
        TextWriter.WriteLine('implementation');
        TextWriter.WriteLine('');
        TextWriter.WriteLine('end.');
      finally
        TextWriter.Close;
      end;
    finally
      TextFileStream.Close;
    end;
  end;

begin
  if Options.ClassPrefix = '' then
    P := 'P'
  else
    P := Options.ClassPrefix;
  for I := 0 to Pred(ListNamespaces.Items.Count) do begin
    if ListNamespaces.Items[I].Checked then begin
      UnitGenerate(StoreFolderPath + Path.AltDirectorySeparatorChar + ListNamespaces.Items[I].Text + '.' + P + '.pas',
                   ListNamespaces.Items[I].Text + '.' + P,
                   ListNamespaces.Items[I].Text);
      Refresh;
    end;
  end;
end;



end.



