unit Option;

interface

uses
  Commons.Settings,
  System.Collections,
  System.ComponentModel,
  System.Drawing,
  System.Windows.Forms,
  System.Xml.Serialization,
  Visibles.BorderExtender,
  Visibles.ButtonEx;

type
  [Serializable]
  KnownType = class (TObject)
    NETName: string;
    DelphiName: string;
  end;
  [XmlInclude(typeof(KnownType))]
  TOptions = class(TSettingsObject)
  public
    ClassPrefix: string;
    RecordPrefix: string;
    EnumeratedPrefix: string;
    ExceptionPrefix: string;
    RemoveExceptionPostfix: Boolean;
    RemoveClassPostfix: Boolean;
    KnownTypes: ArrayList;
    function GetHashedKnownTypes: HashTable;
    constructor Create; virtual;
  end;
  TFormOption = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: System.ComponentModel.IContainer;
    Panel: System.Windows.Forms.Panel;
    BorderExtender: Visibles.BorderExtender.TBorderExtender;
    BtnOk: Visibles.ButtonEx.TButtonEx;
    BtnCancel: Visibles.ButtonEx.TButtonEx;
    TextClassPrefix: System.Windows.Forms.TextBox;
    TextExceptionPrefix: System.Windows.Forms.TextBox;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    CheckException: System.Windows.Forms.CheckBox;
    CheckClass: System.Windows.Forms.CheckBox;
    Label3: System.Windows.Forms.Label;
    TextRecordPrefix: System.Windows.Forms.TextBox;
    BtnReload: Visibles.ButtonEx.TButtonEx;
    Label4: System.Windows.Forms.Label;
    TextEnumeratedPrefix: System.Windows.Forms.TextBox;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Prefix_TextChanged(sender: System.Object; e: System.EventArgs);
    procedure BtnOk_Click(sender: System.Object; e: System.EventArgs);
    procedure BtnReload_Click(sender: System.Object; e: System.EventArgs);
    procedure TFormOption_Activated(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    FOptions: TOptions;
    procedure Dispose(Disposing: Boolean); override;
  strict private
    procedure OptionsToControls(Options: TOptions);
    procedure ControlsToOptions(Options: TOptions);
  public
    function get_Options: TOptions;
    procedure set_Options(const Value: TOptions);
  public
    property Options: TOptions read get_Options write set_Options;
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFormOption))]

implementation

uses
  System.IO;

constructor TOptions.Create;
begin
  inherited Create;
  KnownTypes := ArrayList.Create;
  ClassPrefix := 'T';
  RecordPrefix := 'R';
  EnumeratedPrefix := 'T';
  ExceptionPrefix := 'E';
  RemoveExceptionPostfix := true;
  RemoveClassPostfix := true;
end;

function TOptions.GetHashedKnownTypes: HashTable;
var
  I: Integer;

begin
  Result := HashTable.Create;
  for I := 0 to Pred(KnownTypes.Count) do with KnownTypes[I] as KnownType do
    if DelphiName <> '' then
      Result.Add(NETName.ToUpper,DelphiName)
    else
      Result.Add(NETName.ToUpper,'');
end;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFormOption.InitializeComponent;
begin
  Self.components := System.ComponentModel.Container.Create;
  Self.Panel := System.Windows.Forms.Panel.Create;
  Self.Label4 := System.Windows.Forms.Label.Create;
  Self.TextEnumeratedPrefix := System.Windows.Forms.TextBox.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.TextRecordPrefix := System.Windows.Forms.TextBox.Create;
  Self.CheckClass := System.Windows.Forms.CheckBox.Create;
  Self.CheckException := System.Windows.Forms.CheckBox.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.TextExceptionPrefix := System.Windows.Forms.TextBox.Create;
  Self.TextClassPrefix := System.Windows.Forms.TextBox.Create;
  Self.BorderExtender := Visibles.BorderExtender.TBorderExtender.Create;
  Self.BtnOk := Visibles.ButtonEx.TButtonEx.Create(Self.components);
  Self.BtnCancel := Visibles.ButtonEx.TButtonEx.Create(Self.components);
  Self.BtnReload := Visibles.ButtonEx.TButtonEx.Create(Self.components);
  Self.Panel.SuspendLayout;
  Self.SuspendLayout;
  // 
  // Panel
  // 
  Self.Panel.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left)));
  Self.BorderExtender.SetBorder3DStyle(Self.Panel, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.Panel.Controls.Add(Self.Label4);
  Self.Panel.Controls.Add(Self.TextEnumeratedPrefix);
  Self.Panel.Controls.Add(Self.Label3);
  Self.Panel.Controls.Add(Self.TextRecordPrefix);
  Self.Panel.Controls.Add(Self.CheckClass);
  Self.Panel.Controls.Add(Self.CheckException);
  Self.Panel.Controls.Add(Self.Label2);
  Self.Panel.Controls.Add(Self.Label1);
  Self.Panel.Controls.Add(Self.TextExceptionPrefix);
  Self.Panel.Controls.Add(Self.TextClassPrefix);
  Self.Panel.DockPadding.All := 1;
  Self.Panel.Location := System.Drawing.Point.Create(0, 0);
  Self.Panel.Name := 'Panel';
  Self.Panel.Size := System.Drawing.Size.Create(254, 153);
  Self.Panel.TabIndex := 0;
  // 
  // Label4
  // 
  Self.Label4.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Label4, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label4.Location := System.Drawing.Point.Create(68, 62);
  Self.Label4.Name := 'Label4';
  Self.Label4.Size := System.Drawing.Size.Create(104, 16);
  Self.Label4.TabIndex := 8;
  Self.Label4.Text := 'Enumerated Prefix';
  Self.Label4.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // TextEnumeratedPrefix
  // 
  Self.TextEnumeratedPrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextEnumeratedPrefix.AutoSize := False;
  Self.TextEnumeratedPrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextEnumeratedPrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextEnumeratedPrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextEnumeratedPrefix.Location := System.Drawing.Point.Create(176, 60);
  Self.TextEnumeratedPrefix.Name := 'TextEnumeratedPrefix';
  Self.TextEnumeratedPrefix.Size := System.Drawing.Size.Create(64, 18);
  Self.TextEnumeratedPrefix.TabIndex := 7;
  Self.TextEnumeratedPrefix.Text := 'T';
  Self.TextEnumeratedPrefix.WordWrap := False;
  // 
  // Label3
  // 
  Self.Label3.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Label3, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label3.Location := System.Drawing.Point.Create(84, 38);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(88, 16);
  Self.Label3.TabIndex := 6;
  Self.Label3.Text := 'Record Prefix';
  Self.Label3.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // TextRecordPrefix
  // 
  Self.TextRecordPrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextRecordPrefix.AutoSize := False;
  Self.TextRecordPrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextRecordPrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextRecordPrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextRecordPrefix.Location := System.Drawing.Point.Create(176, 36);
  Self.TextRecordPrefix.Name := 'TextRecordPrefix';
  Self.TextRecordPrefix.Size := System.Drawing.Size.Create(64, 18);
  Self.TextRecordPrefix.TabIndex := 5;
  Self.TextRecordPrefix.Text := 'R';
  Self.TextRecordPrefix.WordWrap := False;
  // 
  // CheckClass
  // 
  Self.CheckClass.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.CheckClass.BackColor := System.Drawing.SystemColors.Control;
  Self.BorderExtender.SetBorder3DStyle(Self.CheckClass, System.Windows.Forms.Border3DStyle.Adjust);
  Self.CheckClass.CheckAlign := System.Drawing.ContentAlignment.MiddleRight;
  Self.CheckClass.FlatStyle := System.Windows.Forms.FlatStyle.Flat;
  Self.CheckClass.Location := System.Drawing.Point.Create(48, 128);
  Self.CheckClass.Name := 'CheckClass';
  Self.CheckClass.Size := System.Drawing.Size.Create(139, 16);
  Self.CheckClass.TabIndex := 4;
  Self.CheckClass.Text := 'No COM Class Postfix';
  Self.CheckClass.TextAlign := System.Drawing.ContentAlignment.MiddleRight;
  // 
  // CheckException
  // 
  Self.CheckException.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.CheckException, System.Windows.Forms.Border3DStyle.Adjust);
  Self.CheckException.CheckAlign := System.Drawing.ContentAlignment.MiddleRight;
  Self.CheckException.FlatStyle := System.Windows.Forms.FlatStyle.Flat;
  Self.CheckException.Location := System.Drawing.Point.Create(48, 108);
  Self.CheckException.Name := 'CheckException';
  Self.CheckException.Size := System.Drawing.Size.Create(139, 16);
  Self.CheckException.TabIndex := 2;
  Self.CheckException.Text := 'No Exception Postfix';
  Self.CheckException.TextAlign := System.Drawing.ContentAlignment.MiddleRight;
  // 
  // Label2
  // 
  Self.Label2.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Label2, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label2.Location := System.Drawing.Point.Create(82, 85);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(88, 16);
  Self.Label2.TabIndex := 3;
  Self.Label2.Text := 'Exception Prefix';
  Self.Label2.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // Label1
  // 
  Self.Label1.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Label1, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label1.Location := System.Drawing.Point.Create(82, 14);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(88, 16);
  Self.Label1.TabIndex := 2;
  Self.Label1.Text := 'Class Prefix';
  Self.Label1.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // TextExceptionPrefix
  // 
  Self.TextExceptionPrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextExceptionPrefix.AutoSize := False;
  Self.TextExceptionPrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextExceptionPrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextExceptionPrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextExceptionPrefix.Location := System.Drawing.Point.Create(176, 84);
  Self.TextExceptionPrefix.Name := 'TextExceptionPrefix';
  Self.TextExceptionPrefix.Size := System.Drawing.Size.Create(64, 18);
  Self.TextExceptionPrefix.TabIndex := 1;
  Self.TextExceptionPrefix.Text := 'E';
  Self.TextExceptionPrefix.WordWrap := False;
  Include(Self.TextExceptionPrefix.TextChanged, Self.Prefix_TextChanged);
  // 
  // TextClassPrefix
  // 
  Self.TextClassPrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextClassPrefix.AutoSize := False;
  Self.TextClassPrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextClassPrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextClassPrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextClassPrefix.Location := System.Drawing.Point.Create(176, 12);
  Self.TextClassPrefix.Name := 'TextClassPrefix';
  Self.TextClassPrefix.Size := System.Drawing.Size.Create(64, 18);
  Self.TextClassPrefix.TabIndex := 0;
  Self.TextClassPrefix.Text := 'T';
  Self.TextClassPrefix.WordWrap := False;
  Include(Self.TextClassPrefix.TextChanged, Self.Prefix_TextChanged);
  // 
  // BtnOk
  // 
  Self.BtnOk.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BtnOk.BackColor := System.Drawing.Color.LightSteelBlue;
  Self.BorderExtender.SetBorder3DStyle(Self.BtnOk, System.Windows.Forms.Border3DStyle.Adjust);
  Self.BtnOk.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.BtnOk.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.BtnOk.Location := System.Drawing.Point.Create(94, 160);
  Self.BtnOk.Name := 'BtnOk';
  Self.BtnOk.TabIndex := 1;
  Self.BtnOk.Text := '&Ok';
  Include(Self.BtnOk.Click, Self.BtnOk_Click);
  // 
  // BtnCancel
  // 
  Self.BtnCancel.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BtnCancel.BackColor := System.Drawing.Color.LightSteelBlue;
  Self.BorderExtender.SetBorder3DStyle(Self.BtnCancel, System.Windows.Forms.Border3DStyle.Adjust);
  Self.BtnCancel.DialogResult := System.Windows.Forms.DialogResult.Cancel;
  Self.BtnCancel.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.BtnCancel.Location := System.Drawing.Point.Create(174, 160);
  Self.BtnCancel.Name := 'BtnCancel';
  Self.BtnCancel.TabIndex := 2;
  Self.BtnCancel.Text := '&Cancel';
  // 
  // BtnReload
  // 
  Self.BtnReload.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BtnReload.BackColor := System.Drawing.Color.LightSteelBlue;
  Self.BorderExtender.SetBorder3DStyle(Self.BtnReload, System.Windows.Forms.Border3DStyle.Adjust);
  Self.BtnReload.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.BtnReload.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.BtnReload.Location := System.Drawing.Point.Create(5, 160);
  Self.BtnReload.Name := 'BtnReload';
  Self.BtnReload.TabIndex := 3;
  Self.BtnReload.Text := '&Reload';
  Include(Self.BtnReload.Click, Self.BtnReload_Click);
  // 
  // TFormOption
  // 
  Self.AcceptButton := Self.BtnOk;
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.CancelButton := Self.BtnCancel;
  Self.ClientSize := System.Drawing.Size.Create(254, 189);
  Self.Controls.Add(Self.BtnReload);
  Self.Controls.Add(Self.BtnCancel);
  Self.Controls.Add(Self.BtnOk);
  Self.Controls.Add(Self.Panel);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedDialog;
  Self.MaximizeBox := False;
  Self.MinimizeBox := False;
  Self.Name := 'TFormOption';
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterParent;
  Include(Self.Activated, Self.TFormOption_Activated);
  Self.Panel.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFormOption.Dispose(Disposing: Boolean);
begin
  if Disposing then begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TFormOption.Create;
begin
  inherited Create;
  InitializeComponent;
  Text := System.String.Format('{0} {1}',[Application.ProductName,'Options']);
  try
    FOptions := TOptions.LoadFrom(Path.ChangeExtension(Application.ExecutablePath,'.xml')) as TOptions;
  except
    FOptions := TOptions.Create;
  end;
end;

procedure TFormOption.TFormOption_Activated(sender: System.Object; e: System.EventArgs);
begin
  OptionsToControls(FOptions);
end;

procedure TFormOption.BtnReload_Click(sender: System.Object; e: System.EventArgs);
begin
  try
    FOptions := TOptions.LoadFrom(Path.ChangeExtension(Application.ExecutablePath,'.xml')) as TOptions;
  except
    ;
  end;
end;

procedure TFormOption.BtnOk_Click(sender: System.Object; e: System.EventArgs);
begin
  ControlsToOptions(FOptions);
  FOptions.StoreTo(Path.ChangeExtension(Application.ExecutablePath,'.xml'));
end;

procedure TFormOption.Prefix_TextChanged(sender: System.Object; e: System.EventArgs);
begin
  BtnOk.Enabled := (TextExceptionPrefix.Text <> '') and (TextClassPrefix.Text <> '');
end;

procedure TFormOption.ControlsToOptions(Options: TOptions);
begin
  with Options do begin
    ClassPrefix := TextClassPrefix.Text;
    RecordPrefix := TextRecordPrefix.Text;
    EnumeratedPrefix := TextEnumeratedPrefix.Text;
    ExceptionPrefix := TextExceptionPrefix.Text;
    RemoveExceptionPostfix := CheckException.Checked;
    RemoveClassPostfix := CheckClass.Checked;
  end;
end;

procedure TFormOption.OptionsToControls(Options: TOptions);
begin
  with Options do begin
    TextClassPrefix.Text := ClassPrefix;
    TextRecordPrefix.Text := RecordPrefix;
    TextEnumeratedPrefix.Text := EnumeratedPrefix;
    TextExceptionPrefix.Text := ExceptionPrefix;
    CheckException.Checked := RemoveExceptionPostfix;
    CheckClass.Checked := RemoveClassPostfix;
  end;
end;

function TFormOption.get_Options: TOptions;
begin
  Result := FOptions.Clone as TOptions;
end;

procedure TFormOption.set_Options(const Value: TOptions);
begin
  FOptions := Value.Clone as TOptions;
end;


end.
