unit Main;

interface

uses
  Option,
  System.Collections,
  System.ComponentModel,
  System.Drawing,
  System.Reflection,
  System.Resources,
  System.Windows.Forms,
  Visibles.BorderExtender, Invisibles.ExceptionHandler;

type
  TFormMain = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: System.ComponentModel.IContainer;
    DialogLoad: System.Windows.Forms.OpenFileDialog;
    StatusBar: System.Windows.Forms.StatusBar;
    BorderExtender: Visibles.BorderExtender.TBorderExtender;
    StatusBarAssembly: System.Windows.Forms.StatusBarPanel;
    ListNames: System.Windows.Forms.ListView;
    ColumnFCLName: System.Windows.Forms.ColumnHeader;
    ColumnTName: System.Windows.Forms.ColumnHeader;
    ListNamespaces: System.Windows.Forms.ListView;
    ColumnNamespaceName: System.Windows.Forms.ColumnHeader;
    MainMenu: System.Windows.Forms.MainMenu;
    ItemAssembly: System.Windows.Forms.MenuItem;
    ItemLoad: System.Windows.Forms.MenuItem;
    ItemPrefixUnit: System.Windows.Forms.MenuItem;
    ItemGenerate: System.Windows.Forms.MenuItem;
    Panel1: System.Windows.Forms.Panel;
    Splitter: System.Windows.Forms.Splitter;
    Panel2: System.Windows.Forms.Panel;
    ItemOptions: System.Windows.Forms.MenuItem;
    ItemExit: System.Windows.Forms.MenuItem;
    StatusBarLocation: System.Windows.Forms.StatusBarPanel;
    ExceptionHandler: Invisibles.ExceptionHandler.TExceptionHandler;
    ItemAbout: System.Windows.Forms.MenuItem;
    ContextMenuNamespaces: System.Windows.Forms.ContextMenu;
    ItemNamespacesUncheckAll: System.Windows.Forms.MenuItem;
    ItemNamespacesCheckAll: System.Windows.Forms.MenuItem;
    ContextMenuNames: System.Windows.Forms.ContextMenu;
    ItemNamesUncheckAll: System.Windows.Forms.MenuItem;
    ItemNamesCheckAll: System.Windows.Forms.MenuItem;
    ImageList: System.Windows.Forms.ImageList;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure ItemLoad_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemGenerate_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemOptions_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemExit_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemAbout_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamespacesUncheckAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamespacesCheckAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamesCheckAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamesUncheckAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ContextMenuNames_Popup(sender: System.Object; e: System.EventArgs);
    procedure ContextMenuNamespaces_Popup(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    procedure Dispose(Disposing: Boolean); override;
  strict private
    DialogFolder: FolderBrowserDialog;
    FormOption: TFormOption;
    Options: TOptions;
    LoadedAssembly: Assembly;
    function TweakColor(Color: System.Drawing.Color; ChannelDelta: Integer): System.Drawing.Color;
    procedure AllCheckedTo(Value: Boolean; List: ListView);
    procedure ReflectAssembly(aAssembly: Assembly);
    procedure Generate(StoreFolderPath: string);
    procedure UnitGenerate(UnitPath: string; UnitName: string; NameSpace: string);
  public
    constructor Create;
  end;

implementation

uses
  About,
  System.IO,
  System.Runtime.InteropServices;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFormMain.InitializeComponent;
type
  TArrayOfSystem_Windows_Forms_StatusBarPanel = array of System.Windows.Forms.StatusBarPanel;
  TArrayOfSystem_Windows_Forms_ColumnHeader = array of System.Windows.Forms.ColumnHeader;
  TArrayOfSystem_Windows_Forms_MenuItem = array of System.Windows.Forms.MenuItem;
var
  resources: System.Resources.ResourceManager;
begin
  Self.components := System.ComponentModel.Container.Create;
  resources := System.Resources.ResourceManager.Create(TypeOf(TFormMain));
  Self.DialogLoad := System.Windows.Forms.OpenFileDialog.Create;
  Self.StatusBar := System.Windows.Forms.StatusBar.Create;
  Self.StatusBarAssembly := System.Windows.Forms.StatusBarPanel.Create;
  Self.StatusBarLocation := System.Windows.Forms.StatusBarPanel.Create;
  Self.BorderExtender := Visibles.BorderExtender.TBorderExtender.Create;
  Self.ListNames := System.Windows.Forms.ListView.Create;
  Self.ColumnFCLName := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnTName := System.Windows.Forms.ColumnHeader.Create;
  Self.ContextMenuNames := System.Windows.Forms.ContextMenu.Create;
  Self.ItemNamesUncheckAll := System.Windows.Forms.MenuItem.Create;
  Self.ItemNamesCheckAll := System.Windows.Forms.MenuItem.Create;
  Self.ImageList := System.Windows.Forms.ImageList.Create(Self.components);
  Self.ListNamespaces := System.Windows.Forms.ListView.Create;
  Self.ColumnNamespaceName := System.Windows.Forms.ColumnHeader.Create;
  Self.ContextMenuNamespaces := System.Windows.Forms.ContextMenu.Create;
  Self.ItemNamespacesUncheckAll := System.Windows.Forms.MenuItem.Create;
  Self.ItemNamespacesCheckAll := System.Windows.Forms.MenuItem.Create;
  Self.Panel1 := System.Windows.Forms.Panel.Create;
  Self.Splitter := System.Windows.Forms.Splitter.Create;
  Self.Panel2 := System.Windows.Forms.Panel.Create;
  Self.MainMenu := System.Windows.Forms.MainMenu.Create;
  Self.ItemAssembly := System.Windows.Forms.MenuItem.Create;
  Self.ItemLoad := System.Windows.Forms.MenuItem.Create;
  Self.ItemExit := System.Windows.Forms.MenuItem.Create;
  Self.ItemPrefixUnit := System.Windows.Forms.MenuItem.Create;
  Self.ItemGenerate := System.Windows.Forms.MenuItem.Create;
  Self.ItemOptions := System.Windows.Forms.MenuItem.Create;
  Self.ItemAbout := System.Windows.Forms.MenuItem.Create;
  Self.ExceptionHandler := Invisibles.ExceptionHandler.TExceptionHandler.Create;
  (System.ComponentModel.ISupportInitialize(Self.StatusBarAssembly)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.StatusBarLocation)).BeginInit;
  Self.Panel1.SuspendLayout;
  Self.Panel2.SuspendLayout;
  Self.SuspendLayout;
  // 
  // DialogLoad
  // 
  Self.DialogLoad.DefaultExt := '*.dll';
  Self.DialogLoad.Filter := 'Libraries (*.dll)|*.dll|Apps (*.exe)|*.exe';
  Self.DialogLoad.InitialDirectory := '.';
  Self.DialogLoad.Title := 'Load Assembly';
  // 
  // StatusBar
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.StatusBar, System.Windows.Forms.Border3DStyle.Adjust);
  Self.StatusBar.Location := System.Drawing.Point.Create(1, 435);
  Self.StatusBar.Name := 'StatusBar';
  Self.StatusBar.Panels.AddRange(TArrayOfSystem_Windows_Forms_StatusBarPanel.Create(Self.StatusBarAssembly, 
          Self.StatusBarLocation));
  Self.StatusBar.ShowPanels := True;
  Self.StatusBar.Size := System.Drawing.Size.Create(534, 22);
  Self.StatusBar.TabIndex := 2;
  // 
  // StatusBarAssembly
  // 
  Self.StatusBarAssembly.AutoSize := System.Windows.Forms.StatusBarPanelAutoSize.Contents;
  Self.StatusBarAssembly.MinWidth := 15;
  Self.StatusBarAssembly.Width := 15;
  // 
  // StatusBarLocation
  // 
  Self.StatusBarLocation.AutoSize := System.Windows.Forms.StatusBarPanelAutoSize.Contents;
  Self.StatusBarLocation.MinWidth := 15;
  Self.StatusBarLocation.Width := 15;
  // 
  // ListNames
  // 
  Self.ListNames.AutoArrange := False;
  Self.ListNames.BackColor := System.Drawing.SystemColors.Control;
  Self.BorderExtender.SetBorder3DStyle(Self.ListNames, System.Windows.Forms.Border3DStyle.Adjust);
  Self.ListNames.BorderStyle := System.Windows.Forms.BorderStyle.None;
  Self.ListNames.CheckBoxes := True;
  Self.ListNames.Columns.AddRange(TArrayOfSystem_Windows_Forms_ColumnHeader.Create(Self.ColumnFCLName, 
          Self.ColumnTName));
  Self.ListNames.ContextMenu := Self.ContextMenuNames;
  Self.ListNames.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListNames.FullRowSelect := True;
  Self.ListNames.HeaderStyle := System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
  Self.ListNames.HideSelection := False;
  Self.ListNames.Location := System.Drawing.Point.Create(1, 1);
  Self.ListNames.Name := 'ListNames';
  Self.ListNames.Size := System.Drawing.Size.Create(532, 309);
  Self.ListNames.SmallImageList := Self.ImageList;
  Self.ListNames.Sorting := System.Windows.Forms.SortOrder.Ascending;
  Self.ListNames.TabIndex := 3;
  Self.ListNames.View := System.Windows.Forms.View.Details;
  // 
  // ColumnFCLName
  // 
  Self.ColumnFCLName.Text := '.NET Names';
  Self.ColumnFCLName.Width := 299;
  // 
  // ColumnTName
  // 
  Self.ColumnTName.Text := 'Delphi Names';
  Self.ColumnTName.Width := 233;
  // 
  // ContextMenuNames
  // 
  Self.ContextMenuNames.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.ItemNamesUncheckAll, 
          Self.ItemNamesCheckAll));
  Include(Self.ContextMenuNames.Popup, Self.ContextMenuNames_Popup);
  // 
  // ItemNamesUncheckAll
  // 
  Self.ItemNamesUncheckAll.Index := 0;
  Self.ItemNamesUncheckAll.Text := '&Uncheck All';
  Include(Self.ItemNamesUncheckAll.Click, Self.ItemNamesUncheckAll_Click);
  // 
  // ItemNamesCheckAll
  // 
  Self.ItemNamesCheckAll.Index := 1;
  Self.ItemNamesCheckAll.Text := '&Check All';
  Include(Self.ItemNamesCheckAll.Click, Self.ItemNamesCheckAll_Click);
  // 
  // ImageList
  // 
  Self.ImageList.ImageSize := System.Drawing.Size.Create(16, 16);
  Self.ImageList.ImageStream := (System.Windows.Forms.ImageListStreamer(resources.GetObject('ImageList.ImageStream')));
  Self.ImageList.TransparentColor := System.Drawing.Color.Transparent;
  // 
  // ListNamespaces
  // 
  Self.ListNamespaces.AutoArrange := False;
  Self.ListNamespaces.BackColor := System.Drawing.SystemColors.Control;
  Self.BorderExtender.SetBorder3DStyle(Self.ListNamespaces, System.Windows.Forms.Border3DStyle.Adjust);
  Self.ListNamespaces.BorderStyle := System.Windows.Forms.BorderStyle.None;
  Self.ListNamespaces.CheckBoxes := True;
  Self.ListNamespaces.Columns.AddRange(TArrayOfSystem_Windows_Forms_ColumnHeader.Create(Self.ColumnNamespaceName));
  Self.ListNamespaces.ContextMenu := Self.ContextMenuNamespaces;
  Self.ListNamespaces.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListNamespaces.FullRowSelect := True;
  Self.ListNamespaces.HeaderStyle := System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
  Self.ListNamespaces.HideSelection := False;
  Self.ListNamespaces.Location := System.Drawing.Point.Create(1, 1);
  Self.ListNamespaces.Name := 'ListNamespaces';
  Self.ListNamespaces.Size := System.Drawing.Size.Create(532, 118);
  Self.ListNamespaces.SmallImageList := Self.ImageList;
  Self.ListNamespaces.Sorting := System.Windows.Forms.SortOrder.Ascending;
  Self.ListNamespaces.TabIndex := 5;
  Self.ListNamespaces.View := System.Windows.Forms.View.Details;
  // 
  // ColumnNamespaceName
  // 
  Self.ColumnNamespaceName.Text := 'Namespaces';
  Self.ColumnNamespaceName.Width := 532;
  // 
  // ContextMenuNamespaces
  // 
  Self.ContextMenuNamespaces.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.ItemNamespacesUncheckAll, 
          Self.ItemNamespacesCheckAll));
  Include(Self.ContextMenuNamespaces.Popup, Self.ContextMenuNamespaces_Popup);
  // 
  // ItemNamespacesUncheckAll
  // 
  Self.ItemNamespacesUncheckAll.Index := 0;
  Self.ItemNamespacesUncheckAll.Text := '&Uncheck All';
  Include(Self.ItemNamespacesUncheckAll.Click, Self.ItemNamespacesUncheckAll_Click);
  // 
  // ItemNamespacesCheckAll
  // 
  Self.ItemNamespacesCheckAll.Index := 1;
  Self.ItemNamespacesCheckAll.Text := '&Check All';
  Include(Self.ItemNamespacesCheckAll.Click, Self.ItemNamespacesCheckAll_Click);
  // 
  // Panel1
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.Panel1, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.Panel1.Controls.Add(Self.ListNamespaces);
  Self.Panel1.Dock := System.Windows.Forms.DockStyle.Top;
  Self.Panel1.DockPadding.All := 1;
  Self.Panel1.Location := System.Drawing.Point.Create(1, 1);
  Self.Panel1.Name := 'Panel1';
  Self.Panel1.Size := System.Drawing.Size.Create(534, 120);
  Self.Panel1.TabIndex := 6;
  // 
  // Splitter
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.Splitter, System.Windows.Forms.Border3DStyle.RaisedInner);
  Self.Splitter.Dock := System.Windows.Forms.DockStyle.Top;
  Self.Splitter.Location := System.Drawing.Point.Create(1, 121);
  Self.Splitter.Name := 'Splitter';
  Self.Splitter.Size := System.Drawing.Size.Create(534, 3);
  Self.Splitter.TabIndex := 7;
  Self.Splitter.TabStop := False;
  // 
  // Panel2
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.Panel2, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.Panel2.Controls.Add(Self.ListNames);
  Self.Panel2.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.Panel2.DockPadding.All := 1;
  Self.Panel2.Location := System.Drawing.Point.Create(1, 124);
  Self.Panel2.Name := 'Panel2';
  Self.Panel2.Size := System.Drawing.Size.Create(534, 311);
  Self.Panel2.TabIndex := 8;
  // 
  // MainMenu
  // 
  Self.MainMenu.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.ItemAssembly, 
          Self.ItemPrefixUnit, Self.ItemOptions, Self.ItemAbout));
  // 
  // ItemAssembly
  // 
  Self.ItemAssembly.Index := 0;
  Self.ItemAssembly.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.ItemLoad, 
          Self.ItemExit));
  Self.ItemAssembly.Text := '&Assembly';
  // 
  // ItemLoad
  // 
  Self.ItemLoad.Index := 0;
  Self.ItemLoad.Text := 'Load...';
  Include(Self.ItemLoad.Click, Self.ItemLoad_Click);
  // 
  // ItemExit
  // 
  Self.ItemExit.Index := 1;
  Self.ItemExit.Text := '&Exit';
  Include(Self.ItemExit.Click, Self.ItemExit_Click);
  // 
  // ItemPrefixUnit
  // 
  Self.ItemPrefixUnit.Index := 1;
  Self.ItemPrefixUnit.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.ItemGenerate));
  Self.ItemPrefixUnit.Text := '&Prefix Units';
  // 
  // ItemGenerate
  // 
  Self.ItemGenerate.Index := 0;
  Self.ItemGenerate.Text := '&Generate...';
  Include(Self.ItemGenerate.Click, Self.ItemGenerate_Click);
  // 
  // ItemOptions
  // 
  Self.ItemOptions.Index := 2;
  Self.ItemOptions.Text := '&Options...';
  Include(Self.ItemOptions.Click, Self.ItemOptions_Click);
  // 
  // ItemAbout
  // 
  Self.ItemAbout.Index := 3;
  Self.ItemAbout.Text := 'About...';
  Include(Self.ItemAbout.Click, Self.ItemAbout_Click);
  // 
  // ExceptionHandler
  // 
  Self.ExceptionHandler.ExitOnError := False;
  Self.ExceptionHandler.SimpleMessageBox := False;
  // 
  // TFormMain
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(536, 458);
  Self.Controls.Add(Self.Panel2);
  Self.Controls.Add(Self.Splitter);
  Self.Controls.Add(Self.Panel1);
  Self.Controls.Add(Self.StatusBar);
  Self.DockPadding.All := 1;
  Self.Icon := (System.Drawing.Icon(resources.GetObject('$this.Icon')));
  Self.Menu := Self.MainMenu;
  Self.Name := 'TFormMain';
  (System.ComponentModel.ISupportInitialize(Self.StatusBarAssembly)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.StatusBarLocation)).EndInit;
  Self.Panel1.ResumeLayout(False);
  Self.Panel2.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFormMain.Dispose(Disposing: Boolean);
begin
  if Disposing then begin
    FormOption.Free;
    DialogFolder.Free;
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TFormMain.Create;
begin
  inherited Create;
  InitializeComponent;
  Text := Application.ProductName;
  ListNamespaces.BackColor := TweakColor(ListNamespaces.BackColor,12);
  ListNames.BackColor := TweakColor(ListNames.BackColor,12);
  DockPadding.All := 0;
  FormOption := TFormOption.Create;
  Options := FormOption.Options;
  DialogFolder := FolderBrowserDialog.Create;
  DialogFolder.Description := 'Prefix Units Store Folder';
  StatusBarAssembly.Text := System.string.Format('Assembly: {0}',['']);
  StatusBarLocation.Text := System.string.Format('Location: {0}',['']);
end;

procedure TFormMain.ContextMenuNamespaces_Popup(sender: System.Object; e: System.EventArgs);
begin
  ItemNamespacesCheckAll.Enabled := (ListNamespaces.Items.Count > 0);
  ItemNamespacesUncheckAll.Enabled := ItemNamespacesCheckAll.Enabled;
end;

procedure TFormMain.ContextMenuNames_Popup(sender: System.Object; e: System.EventArgs);
begin
  ItemNamesCheckAll.Enabled := (ListNames.Items.Count > 0);
  ItemNamesUncheckAll.Enabled := ItemNamesCheckAll.Enabled;
end;

procedure TFormMain.AllCheckedTo(Value: Boolean; List: ListView);
var
  I: Integer;
begin
  for I := 0 to Pred(List.Items.Count) do
    List.Items[I].Checked := Value and not Assigned(List.Items[I].Tag);
end;

procedure TFormMain.ItemNamesUncheckAll_Click(sender: System.Object; e: System.EventArgs);
begin
  AllCheckedTo(false,ListNames);
end;

procedure TFormMain.ItemNamesCheckAll_Click(sender: System.Object; e: System.EventArgs);
begin
  AllCheckedTo(true,ListNames);
end;

procedure TFormMain.ItemNamespacesUncheckAll_Click(sender: System.Object; e: System.EventArgs);
begin
  AllCheckedTo(false,ListNamespaces);
end;

procedure TFormMain.ItemNamespacesCheckAll_Click(sender: System.Object; e: System.EventArgs);
begin
  AllCheckedTo(true,ListNamespaces);
end;

procedure TFormMain.ItemAbout_Click(sender: System.Object; e: System.EventArgs);
begin
  with TFormAbout.Create do begin
    ShowDialog;
    Free;
  end;
end;

procedure TFormMain.ItemExit_Click(sender: System.Object; e: System.EventArgs);
begin
  Close;
end;

procedure TFormMain.ItemOptions_Click(sender: System.Object; e: System.EventArgs);
begin
  if FormOption.ShowDialog = System.Windows.Forms.DialogResult.OK then begin
    Options := FormOption.Options;
    if Assigned(LoadedAssembly) then begin
      ListNames.Items.Clear;
      ListNameSpaces.Items.Clear;
      Application.DoEvents;
      Cursor.Current := Cursors.WaitCursor;
      try
        ReflectAssembly(LoadedAssembly);
      finally
        Cursor.Current := Cursors.Default;
      end;
    end;
  end;
end;

procedure TFormMain.ItemGenerate_Click(sender: System.Object; e: System.EventArgs);
begin
  if DialogFolder.ShowDialog = System.Windows.Forms.DialogResult.OK then begin
    Cursor.Current := Cursors.WaitCursor;
    try
      Generate(DialogFolder.SelectedPath);
    finally
      Cursor.Current := Cursors.Default;
    end;
  end;
end;

procedure TFormMain.ItemLoad_Click(sender: System.Object; e: System.EventArgs);
begin
  LoadedAssembly := nil;
  ListNames.Items.Clear;
  ListNameSpaces.Items.Clear;
  StatusBarAssembly.Text := System.string.Format('Assembly: {0}',['']);
  StatusBarLocation.Text := System.string.Format('Location: {0}',['']);
  Application.DoEvents;
  if (DialogLoad.ShowDialog = System.Windows.Forms.DialogResult.OK) then begin
    Cursor.Current := Cursors.WaitCursor;
    try
      LoadedAssembly := Assembly.LoadFrom(DialogLoad.FileName);
      StatusBarAssembly.Text := System.string.Format('Assembly: {0}',[LoadedAssembly.FullName]);
      StatusBarLocation.Text := System.string.Format('Location: {0}',[LoadedAssembly.Location]);
      ReflectAssembly(LoadedAssembly);
    finally
      Cursor.Current := Cursors.Default;
    end;
  end;
end;

function TFormMain.TweakColor(Color: System.Drawing.Color; ChannelDelta: Integer): System.Drawing.Color;
var
  CTweak: Integer;
begin
  CTweak := ChannelDelta + (ChannelDelta shl 8) + (ChannelDelta shl 16);
  Result := System.Drawing.Color.FromArgb(Color.ToArgb + CTweak);
end;

procedure TFormMain.ReflectAssembly(AAssembly: Assembly);
var
  I,P: integer;
  Types: array of &Type;
  FullName,Name,NameSpace,ReplacementName: string;
  NameSpaces,KnownNames: HashTable;
  E: IEnumerator;
begin
  KnownNames := Options.GetHashedKnownTypes;
  NameSpaces := HashTable.Create;
  ListNames.BeginUpdate;
  ListNameSpaces.BeginUpdate;
  try
    Types := AAssembly.GetTypes;
    for I := Low(Types) to High(Types) do begin
      if not Types[i].IsInterface and
         not Types[i].IsPrimitive and
         (Types[i].IsPublic or Types[i].IsNestedPublic) then begin
        FullName := Types[i].ToString;
        P := FullName.LastIndexOf('.');
        if (P >=0) and (FullName.IndexOfAny(['+','-','&','@']) < 0) then begin {Remove funny named types}
          NameSpace := FullName.Remove(P,Length(FullName) - P);
          Name := FullName.Substring(P + 1);
          if not NameSpaces.ContainsKey(NameSpace) then
            NameSpaces.Add(NameSpace,NameSpace);
          with ListNames.Items.Add(FullName) do begin
            ReplacementName := string(KnownNames[FullName.ToUpper]);
            if Assigned(ReplacementName) then begin
              Checked := (ReplacementName <> '');
              if Checked then
                ImageIndex := 1
              else
                ImageIndex := 0;
            end
            else begin
              Checked := (Name.ToUpper <> 'UNIT'); {Uncheck Delphi phantom class}
              ImageIndex := 0;
            end;
            if not Checked then
              Tag := TObject(1);
            if ReplacementName <> '' then
              SubItems.Add(ReplacementName)
            else if Types[I].IsValueType then begin
              if Types[I].IsEnum then
                SubItems.Add(Options.EnumeratedPrefix + Name)
              else
                SubItems.Add(Options.RecordPrefix + Name);
            end
            else if Types[I].IsSubclassOf(TypeOf(System.Exception)) then begin
              if Options.RemoveExceptionPostfix then begin
                P := Name.LastIndexOf('Exception');
                if P >= 0 then
                  Name := Name.Remove(P,Length(Name) - P);
              end;
              SubItems.Add(Options.ExceptionPrefix + Name);
            end
            else if Options.RemoveClassPostfix and Types[I].IsCOMObject then begin
              P := Name.LastIndexOf('Class');
              if P >= 0 then
                Name := Name.Remove(P,Length(Name) - P);
              SubItems.Add(Options.ClassPrefix + Name);
            end
            else
              SubItems.Add(Options.ClassPrefix + Name);
          end;
        end;
      end;
    end;
    E := NameSpaces.Values.GetEnumerator;
    while E.MoveNext do with ListNameSpaces.Items.Add(E.Current.ToString) do begin
      Checked := true;
      ImageIndex := 0;
    end;
  finally
    ListNames.Sort;
    ListNameSpaces.Sort;
    ListNames.EndUpdate;
    ListNameSpaces.EndUpdate;
    NameSpaces.Free;
  end;
end;

procedure TFormMain.Generate(StoreFolderPath: string);
var
  I: Integer;
begin
  for I := 0 to Pred(ListNamespaces.Items.Count) do begin
    if ListNamespaces.Items[I].Checked then begin
      UnitGenerate(StoreFolderPath + '\' + ListNamespaces.Items[I].Text + '.' + Options.ClassPrefix + '.pas',
                   ListNamespaces.Items[I].Text + '.' + Options.ClassPrefix,
                   ListNamespaces.Items[I].Text);
    end;
  end;
end;

procedure TFormMain.UnitGenerate(UnitPath: string; UnitName: string; NameSpace: string);
var
  I,P: Integer;
  S: string;
  TextFileStream: FileStream;
  TextWriter: StreamWriter;

  procedure WriteOptions;
  var
    I: Integer;
  begin
    with Options do begin
      TextWriter.WriteLine(System.String.Format(' ClassPrefix={0}',[ClassPrefix]));
      TextWriter.WriteLine(System.String.Format(' RecordPrefix={0}',[RecordPrefix]));
      TextWriter.WriteLine(System.String.Format(' EnumeratedPrefix={0}',[EnumeratedPrefix]));
      TextWriter.WriteLine(System.String.Format(' ExceptionPrefix={0}',[ExceptionPrefix]));
      TextWriter.WriteLine(System.String.Format(' RemoveExceptionPostfix={0}',[RemoveExceptionPostfix]));
      TextWriter.WriteLine(System.String.Format(' RemoveClassPostfix={0}',[RemoveClassPostfix]));
      TextWriter.WriteLine(' KnownTypes');
      for I := 0 to Pred(KnownTypes.Count) do with KnownTypes[I] as KnownType do
        if DelphiName <> '' then
          TextWriter.WriteLine(System.String.Format('  [{0}]={1} {2}',[I,NETName,DelphiName]))
        else
          TextWriter.WriteLine(System.String.Format('  [{0}]={1}',[I,NETName]));
    end;
  end;

begin
  TextFileStream := FileStream.Create(UnitPath,FileMode.Create,FileAccess.Write);
  try
    TextWriter := StreamWriter.Create(TextFileStream);
    try
      TextWriter.BaseStream.Seek(0,SeekOrigin.Begin);
      TextWriter.WriteLine(System.String.Format('unit {0};',[UnitName]));
      TextWriter.WriteLine('');
      TextWriter.WriteLine('interface');
      TextWriter.WriteLine('');
      TextWriter.WriteLine('{$region ''Info''} {');
      TextWriter.WriteLine('This code has been generated by PrefixIt! V1.0 - ' + DateTime.Now.ToString);
      TextWriter.WriteLine(StatusBarAssembly.Text);
      WriteOptions;
      TextWriter.WriteLine('}{$endregion}');
      TextWriter.WriteLine('');
      if NameSpace.ToUpper <> 'SYSTEM' then begin
        TextWriter.WriteLine('uses');
        TextWriter.WriteLine(System.String.Format('  {0};',[NameSpace]));
        TextWriter.WriteLine('');
      end;
      TextWriter.WriteLine('type');
      for I := 0 to Pred(ListNames.Items.Count) do begin
        if ListNames.Items[I].Checked then begin
          S := ListNames.Items[I].Text;
          P := S.LastIndexOf('.');
          S := S.Remove(P,Length(S) - P);
          if S = NameSpace then begin
            S := System.String.Format('  {0} = {1};',[ListNames.Items[I].SubItems[1].Text,ListNames.Items[I].Text]);
            TextWriter.WriteLine(S);
          end;
        end;
      end;
      TextWriter.WriteLine('');
      TextWriter.WriteLine('implementation');
      TextWriter.WriteLine('');
      TextWriter.WriteLine('end.');
    finally
      TextWriter.Close;
    end;
  finally
    TextFileStream.Close;
  end;
end;


end.



