unit Options;

interface

uses
  Commons.Settings,
  System.Drawing,
  System.Drawing.T,
  System.IO,
  System.IO.T,
  System.T,
  System.Windows.Forms,
  System.Windows.Forms.T,
  System.Xml.Serialization,
  System.Xml.Serialization.T;

type
  TOptions = class(TSettingsObject)
  public
    [XmlIgnore]
    KnownDirectoryArray: array of string;
    [XmlIgnore]
    FilterArray: array of string;
    procedure set_Filters(const Value: string);
  public
    [XmlElement('Filters')]
    FFilters: string;
    KnownDirectories: string;
    AppDataClear: Boolean;
  public
    [XmlIgnore]
    property Filters: string read FFilters write set_Filters;
    function TrimFilters(List: string): string;
    function IsKnowDirectory(Path: string): Boolean;
    class function Load: TOptions;
    procedure Store;
    constructor Create;
  end;
  TApplicationSts = class(TSettingsObject)
  public
    MainFormSize: RSize;
  public
    class function Load: TApplicationSts;
    procedure Store;
    constructor Create;
  end;

implementation

{ TOptions }

constructor TOptions.Create;
begin
  inherited Create;
  Filters := '*.~*|*.dsk';
  KnownDirectories := '__history|Model|ModelSupport';
  AppDataClear := false;
end;

class function TOptions.Load: TOptions;
begin
  try
    Result := TOptions.LoadFrom(TPath.ChangeExtension(TApplication.ExecutablePath,'.xml')) as TOptions;
  except
    Result := TOptions.Create;
  end;
  Result.KnownDirectories := Result.TrimFilters(Result.KnownDirectories);
  Result.Filters := Result.TrimFilters(Result.Filters);
  Result.KnownDirectoryArray := Result.KnownDirectories.Split(['|']);
  Result.FilterArray := Result.Filters.Split(['|']);
end;

procedure TOptions.Store;
begin
  StoreTo(TPath.ChangeExtension(TApplication.ExecutablePath,'.xml'));
end;

function TOptions.IsKnowDirectory(Path: string): Boolean;
var
  Directory: string;
begin
  Result := false;
  for Directory in KnownDirectoryArray do
    if Path.ToLower.EndsWith(Directory.ToLower) then begin
      Result := true;
      Break;
    end;
end;

function TOptions.TrimFilters(List: string): string;
var
  Elements: array of string;
  Element: string;
begin
  Elements := List.Split(['|']);
  Result := '';
  for Element in Elements do
    Result := Result + Element + '|';
  Result := Result.Substring(0,Result.Length - 1);
end;

procedure TOptions.set_Filters(const Value: string);
begin
  FFilters := TrimFilters(Value);
  FilterArray := Filters.Split(['|']);
end;

{ TApplicationSts }

constructor TApplicationSts.Create;
begin
  inherited Create;
  MainFormSize.Width := 460;
  MainFormSize.Height := 360;
end;

class function TApplicationSts.Load: TApplicationSts;
begin
  try
    Result := TApplicationSts.LoadFrom(TApplication.LocalUserAppDataPath + TPath.DirectorySeparatorChar +
                                       TApplication.ProductName + '.xml') as TApplicationSts;
  except
    Result := TApplicationSts.Create;
  end;
end;

procedure TApplicationSts.Store;
begin
  StoreTo(TApplication.LocalUserAppDataPath + TPath.DirectorySeparatorChar + TApplication.ProductName + '.xml');
end;

end.
