unit BorlandProjectSettings;

interface

uses
  Commons.Settings,
  System.T,
  System.Xml.Serialization,
  System.Xml.Serialization.T;

type
  TFileInfo = record
  public
    [System.Xml.Serialization.XmlAttribute]
    FileName: string;
    [System.Xml.Serialization.XmlAttribute]
    ContainerId: string;
    [System.Xml.Serialization.XmlAttribute]
    ModuleName: string;
    [System.Xml.Serialization.XmlAttribute]
    AssemblyName: string;
    [System.Xml.Serialization.XmlAttribute]
    Version: string;
    [System.Xml.Serialization.XmlAttribute]
    LinkUnits: string;
    [System.Xml.Serialization.XmlAttribute]
    Parent: string;
  end;

  TDelphiDotNet = record
    [XmlArrayItem('File')]
    FileList: array of TFileInfo;
  end;

  [XmlRoot(ElementName = 'BorlandProject',IsNullable = true)]
  TBorlandProject = class (TSettingsObject)
  public
    [System.Xml.Serialization.XmlAnyElement]
    More: TObject;
    [System.Xml.Serialization.XmlElement('DelphiDotNet.Personality')]
    DelphiDotNet: TDelphiDotNet;
  end;

implementation

end.
