unit rtool;

{
  rtool
  =======
  Date: Sep 2002
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  rtool is set of variety functions

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, CheckLst, Registry;


function FillStrL(s: string; By: Char; Len: integer): string;
function FillStrR(s: string; By: Char; Len: integer): string;
  //fill str from left or right
function AnsiPosEx(Substr, s: string; From: integer;
                   CaseSensitive: boolean): integer;
  //find substring from start position
function FindStrPart(s: string; Separator: string; Sequence: byte;
                     CaseSensitive: boolean): string;
  //find index-th part of input string separated by separator
function FindStrFromTo(SubstrStart, SubstrStop, s: string;
                       CaseSensitive: boolean): string;

function ClearStr(Substr, s: string; CaseSensitive: boolean): string;
  //clear all substr from str
function ReplaceStr(OldSubstr, NewSubstr, s: string;
                    All, CaseSensitive: boolean): string;
  //replace oldSubStr by newSubStr in s
function ReplaceStrFromTo(OldSubstrStart, OldSubstrStop, NewSubstr, s: string;
                          ReplaceSubstrStop, All, CaseSensitive: boolean): string;

//conversion variable to string (for saving in BLOB)
function VarToString(PointToVar: Pointer; LengthVar: integer): string;
//conversion string to variable
function StringToVar(PointToVar: Pointer; LengthVar: integer; s: string): boolean;

function GetLine(StrList: string; Index: integer): string;
function SetLine(StrList, Line: string; Index: integer): string;

//conversion int to str with 0 on left side
function IntToStr0(Int: integer; Len: integer): string;

function GetDay(Date: TDateTime): word;
function GetMonth(Date: TDateTime): word;
function GetYear(Date: TDateTime): word;
function DaysPerMonth(Year,Month: word): word;
function DaysPerMonthD(Date: TDateTime): word;

// end Path with backslash
function SetEndOfPath(Path: string): string;
//return path of exe program
function GetAppPath: string;

//form actions
function CreateF(const FormClass: TFormClass; var Ref): boolean;
function FreeF(var Ref): boolean;
function CreateShowFM(const FormClass: TFormClass; var Ref): integer;
procedure CreateShowF(const FormClass: TFormClass; var Ref);
procedure FocusNextControl(Form: TForm);
function ShowWinHelp(Form: TForm; Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;
function ShowExtHelp(Form: TForm; Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;

procedure RaiseErr(ErrDesc: string);

//cursor actions
function ChCursor(const TypCursor: TCursor): TCursor;
function WCursor: TCursor;
function NCursor: TCursor;
function SQLCursor: TCursor;

//neg actions
function NegBool(var b: boolean): boolean;
function NegMenuItem(Item: TMenuItem): boolean;
function NegCheckBox(Box: TCheckBox): boolean;

//open document or run filr
function RunFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
//open and print document
function PrintFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;

//listbox actions
function MoveListBox(L: TListBox; old, new: integer): boolean;
function MoveCheckListBox(L: TCheckListBox; old, new: integer): boolean;

function ProcMouseWheel(var WheelDelta: integer; var Key: word): boolean;

// printer
procedure GetPrinterNames(List: TStrings);
function GetDefaultPrinterName: string;
function SetDefaultPrinter(const PrinterName: String; SendInfoMsg: boolean): boolean;


var
  ExtHelpDir: string;


implementation

uses rdlg, rstring, ShellApi;

function FillStrL(s: string; By: Char; Len: integer): string;
var a: integer;
begin
  Result:=s;
  for a:=1 to Len-Length(Result) do
    Result:=By+Result;
end;

function FillStrR(s: string; By: Char; Len: integer): string;
var a: integer;
begin
  Result:=s;
  for a:=1 to Len-Length(Result) do
    Result:=Result+By;
end;

function AnsiPosEx(Substr, s: string; From: integer;
                   CaseSensitive: boolean): integer;
begin
  if From<1 then From:=1;
  if not CaseSensitive then
  begin
    Substr:=AnsiUpperCase(Substr);
    s:=AnsiUpperCase(s);
  end;
  Result:=AnsiPos(Substr,copy(s,From,Length(s)));
  if Result>0 then Result:=Result+From-1;
end;

function FindStrPart(s: string; Separator: string; Sequence: byte;
                     CaseSensitive: boolean): string;
var a,p: integer;
begin
  Result:='';
  if Trim(s)='' then Exit;
  p:=1;
  for a:=2 to Sequence do
  begin
    p:=AnsiPosEx(Separator,s,1,CaseSensitive);
    if p>0 then s:=copy(s,p+Length(Separator),Length(s));
  end;
  if p=0 then Exit;
  p:=AnsiPosEx(Separator,s,1,CaseSensitive);
  if p>0 then s:=copy(s,1,p-1);
  Result:=s;
end;

function FindStrFromTo(SubstrStart, SubstrStop, s: string;
                       CaseSensitive: boolean): string;
var p1,p2: integer;
begin
  p1:=AnsiPosEx(SubstrStart,s,1,CaseSensitive);
  p2:=AnsiPosEx(SubstrStop,s,p1+Length(SubstrStart),CaseSensitive);
  if (p1=0) or (p2=0) then Result:=''
  else Result:=copy(s,p1,p2-p1);
end;

function ClearStr(Substr, s: string; CaseSensitive: boolean): string;
var p: integer;
begin
  repeat
    p:=AnsiPosEx(Substr,s,1,CaseSensitive);
    if p=0 then Break;
    Delete(s,p,Length(Substr));
  until false;
  Result:=s;
end;

function ReplaceStr(OldSubstr, NewSubstr, s: string;
                    All, CaseSensitive: boolean): string;
var p: integer;
begin
  p:=AnsiPosEx(OldSubstr,s,1,CaseSensitive);
  while p>0 do
  begin
    Delete(s,p,Length(OldSubStr));
    Insert(NewSubstr,s,p);
    p:=AnsiPosEx(OldSubstr,s,p+Length(NewSubstr),CaseSensitive);
    if not All then Break;
  end;
  Result:=s;
end;

function ReplaceStrFromTo(OldSubstrStart, OldSubstrStop, NewSubstr, s: string;
                          ReplaceSubstrStop, All, CaseSensitive: boolean): string;
var p1,p2: integer;
begin
  p1:=AnsiPosEx(OldSubstrStart,s,1,CaseSensitive);
  while p1>0 do
  begin
    p2:=AnsiPosEx(OldSubstrStop,s,p1+Length(OldSubstrStart),CaseSensitive);
    if p2=0 then Break;
    if ReplaceSubstrStop then Inc(p2,Length(OldSubstrStop));
    Delete(s,p1,p2-p1);
    Insert(NewSubstr,s,p1);
    p1:=AnsiPosEx(OldSubstrStart,s,p1+Length(NewSubstr),CaseSensitive);
    if not All then Break;
  end;
  Result:=s;
end;

function VarToString(PointToVar: Pointer; LengthVar: integer): string;
var p: ^Byte;
    a: integer;
begin
  p:=PointToVar;
  Result:='';
  for a:=1 to LengthVar do
  begin
    Result:=Result+chr(p^);
    Inc(p);
  end;
end;

function StringToVar(PointToVar: Pointer; LengthVar: integer; s: string): boolean;
var p: ^byte;
    a: integer;
begin
  Result:=false;
  if Length(s)<>LengthVar then Exit;
  p:=PointToVar;
  for a:=1 to LengthVar do
  begin
    p^:=ord(s[a]);
    Inc(p);
  end;
  Result:=true;
end;

function GetLine(StrList: string; Index: integer): string;
var L: TStringList;
begin
  Result:='';
  L:=TStringList.Create;
  try
    L.Text:=StrList;
    if L.Count>Index then Result:=L.Strings[Index];
  finally
    L.Free;
  end;
end;

function SetLine(StrList, Line: string; Index: integer): string;
var L: TStringList;
begin
  Result:='';
  L:=TStringList.Create;
  try
    L.Text:=StrList;
    while L.Count<=Index do L.Add('');
    L.Strings[Index]:=Line;
    Result:=L.Text;
  finally
    L.Free;
  end;
end;

function GetDay(Date: TDateTime): word;
var y,m: word;
begin
  DecodeDate(Date,y,m,Result);
end;

function GetMonth(Date: TDateTime): word;
var y,d: word;
begin
  DecodeDate(Date,y,Result,d);
end;

function GetYear(Date: TDateTime): word;
var m,d: word;
begin
  DecodeDate(Date,Result,m,d);
end;

function DaysPerMonth(Year,Month: word): word;
const nd:array [1..12] of integer=(31,28,31,30,31,30,31,31,30,31,30,31);
begin
  Result:=nd[Month];
  if (Month=2) and IsLeapYear(Year) then Inc(Result);
end;

function DaysPerMonthD(Date: TDateTime): word;
begin
  Result:=DaysPerMonth(GetYear(Date),GetMonth(Date));
end;

function IntToStr0(Int: integer; Len: integer): string;
begin
  Result:=FillStrL(IntToStr(Int),'0',Len);
end;

function SetEndOfPath(Path: string): string;
begin
  Result:=Path;
  if Path='' then Exit;
  if Path[Length(Path)]<>'\' then Result:=Path+'\';
end;

function GetAppPath: string;
begin
  Result:=SetEndOfPath(ExtractFilePath(AnsiLowerCase(Application.ExeName)));
end;

//Form functions
function CreateF(const FormClass: TFormClass; var Ref): boolean;
begin
  Result:=false;
  if TForm(Ref)<>nil then Exit;
  Application.CreateForm(FormClass, Ref);
  Result:=true;
end;

function FreeF(var Ref): boolean;
begin
  Result:=false;
  if TForm(Ref)=nil then Exit;
  TForm(Ref).Free;
  TForm(Ref):=nil;
  Result:=true;
end;

function CreateShowFM(const FormClass: TFormClass; var Ref): integer;
var temp: boolean;
begin
  temp:=CreateF(FormClass, Ref);
  if TForm(Ref).WindowState=wsMinimized then TForm(Ref).WindowState:=wsNormal;
  if TForm(Ref).Visible then TForm(Ref).Hide;
  Result:=TForm(Ref).ShowModal;
  if temp then FreeF(Ref);
end;

procedure CreateShowF(const FormClass: TFormClass; var Ref);
begin
  CreateF(FormClass, Ref);
  if TForm(Ref).WindowState=wsMinimized then TForm(Ref).WindowState:=wsNormal;
  TForm(Ref).Show;
end;

procedure RaiseErr(ErrDesc: string);
var s: string;
begin
  s:=sRaiseErr;
  if ErrDesc<>'' then s:=s+#13+sErrorDescription+#13+ErrDesc;
  raise Exception.Create(s);
end;

procedure FocusNextControl(Form: TForm);
begin
  SendMessage(Form.Handle,WM_NEXTDLGCTL,0,0);
end;

function ShowWinHelp(Form: TForm; Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;
begin
  Result:=false;
  if Form.HelpFile='' then Exit;
  if (Command=HELP_CONTEXTPOPUP) and (Data<100) then
    Result:=WinHelp(Form.Handle, PChar(Form.HelpFile), HELP_CONTEXT, Data)
  else
    Result:=WinHelp(Form.Handle, PChar(Form.HelpFile), Command, Data);
  CallHelp:=false;
end;

function ShowExtHelp(Form: TForm; Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;
begin
  CallHelp:=false;
  if (Command=HELP_CONTEXTPOPUP) then
    Result:=(RunFile(ExtHelpDir+Form.HelpFile,'','',SW_SHOW)>=32)
  else Result:=true;
end;

// Cursor functions
function ChCursor(const TypCursor: TCursor): TCursor;
begin
  Result:=Screen.Cursor;
  Screen.Cursor:=TypCursor;
end;

function WCursor: TCursor;
begin
  Result:=ChCursor(crHourGlass);
end;

function NCursor: TCursor;
begin
  Result:=ChCursor(crDefault);
end;

function SQLCursor: TCursor;
begin
  Result:=ChCursor(crSQLWait);
end;

//Bool function
function NegBool(var b: boolean): boolean;
begin
  b:=not b;
  Result:=b;
end;

function NegMenuItem(Item: TMenuItem): boolean;
begin
  Item.Checked:=not Item.Checked;
  Result:=Item.Checked;
end;

function NegCheckBox(Box: TCheckBox): boolean;
begin
  Box.Checked:=not Box.Checked;
  Result:=Box.Checked;
end;

// Shell functions
function RunFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
begin
 Result := ShellExecute(Application.MainForm.Handle, nil,
   PChar(FileName), PChar(Params), PChar(DefaultDir), ShowCmd);
 if Result<=32 then DlgE(Format(sFileOpenErr,[FileName]));
end;

function PrintFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
begin
 Result := ShellExecute(Application.MainForm.Handle, 'print',
   PChar(FileName), PChar(Params), PChar(DefaultDir), ShowCmd);
 if Result<=32 then
   if ShowDlg(dtE,btAN,['^C'+sError,'^B'+Format(sFilePrintErr,[FileName]),Format(sFileOpenQ,[FileName])])=mrYes then
     RunFile(FileName, Params, DefaultDir, ShowCmd);
end;

//listbox actions
function MoveListBox(L: TListBox; old, new: integer): boolean;
begin
  Result:=false;
  if (new=old) or (new<0) or (old<0) or (new>L.Items.Count-1) then Exit;
  L.Items.Move(old,new);
  if (new<=L.TopIndex) and (L.TopIndex>0) then L.TopIndex:=L.TopIndex-1;
  if new>=L.TopIndex+(L.Height div L.ItemHeight)-1 then
    L.TopIndex:=L.TopIndex+1;
  if L.MultiSelect then L.Selected[new]:=true
                   else L.ItemIndex:=new;
  Result:=true;
end;

function MoveCheckListBox(L: TCheckListBox; old, new: integer): boolean;
var oldState: TCheckBoxState;
begin
  Result:=false;
  if (new=old) or (new<0) or (old<0) or (new>L.Items.Count-1) then Exit;
  oldState:=L.State[old];
  L.Items.Move(old,new);
  L.State[new]:=oldState;
  if (new<=L.TopIndex) and (L.TopIndex>0) then L.TopIndex:=L.TopIndex-1;
  if new>=L.TopIndex+(L.Height div L.ItemHeight)-1 then
    L.TopIndex:=L.TopIndex+1;
  L.ItemIndex:=new;
  Result:=true;
end;

function ProcMouseWheel(var WheelDelta: integer; var Key: word): boolean;
begin
  Result:=WheelDelta<>0;
  if WheelDelta>0 then
  begin
    Key:=VK_UP;
    Dec(WheelDelta,WHEEL_DELTA);
    if WheelDelta<0 then WheelDelta:=0;
  end;
  if WheelDelta<0 then
  begin
    Key:=VK_DOWN;
    Inc(WheelDelta,WHEEL_DELTA);
    if WheelDelta>0 then WheelDelta:=0;
  end;
end;


// printer functions
procedure GetPrinterNames(List: TStrings);
const
  MaxBuf=8000;
var
  Buf: array [0..MaxBuf] of char;
  i: integer;
  s: string;
begin
  List.Clear;
  s:='';
  if GetProfileString('PrinterPorts',nil,'',Buf,MaxBuf)>0 then
    for i:=0 to MaxBuf do
      if Buf[i]<>#0 then s:=s+Buf[i]
      else if s='' then Break
           else
           begin
             List.Add(s);
             s:='';
           end;
end;

function GetDefaultPrinterName: string;
var
  Res: array[0..255] of Char;
begin
  GetProfileString('Windows','device','',Res,255);
  Result:=copy(Res,1,Pos(',',Res)-1);
end;

function SetDefaultPrinter(const PrinterName: String; SendInfoMsg: boolean): boolean;
const
  MaxBuf=256;
  cs1='Windows'; cs2='Device'; cs3='Devices'; cs4=#0;
var
  Buf: array [0..MaxBuf] of char;
  PrinterInfo: string;
  Res: integer;
begin
  Result:=false;
  Res:=GetProfileString(cs3,PChar(PrinterName),#0,Buf,MaxBuf);
  if (Res>0) and (Trim(Buf)<>'') then
  begin
    PrinterInfo:=PrinterName+','+Buf;
    while GetProfileString(cs1,cs2,cs4,Buf,MaxBuf)>0 do
      WriteProfileString(cs1,cs2,#0);
    WriteProfileString(cs1,cs2,PChar(PrinterInfo));
    if SendInfoMsg then
      case Win32Platform of
        VER_PLATFORM_WIN32_NT:
          SendMessage(HWND_BROADCAST,WM_WININICHANGE,0,LongInt(PChar(cs1)));
        VER_PLATFORM_WIN32_WINDOWS:
          SendMessage(HWND_BROADCAST,WM_SETTINGCHANGE,0,LongInt(PChar(cs1)));
      end;
    Result:=true;
  end;
end;


initialization
  ExtHelpDir:=GetAppPath+'help\';
//  ForceCurrentDirectory:=true;

end.
