unit rdbtool_CDS;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Db, DBClient, Variants, Forms, DBGrids;

function SetTableIndexCDS(T: TClientDataSet; FieldName: string): boolean;
procedure ChangeSortCDS(CDS: TClientDataSet; KeyField: TField;
  SortFieldName: String; SortDesc: Boolean; var Accept: Boolean);
function RequeryExCDS(CDS: TClientDataSet; F: TField): boolean;
function RequeryGridCDS(DBGrid: TDBGrid): boolean;

implementation

uses rtool, rdbtool;

function SetTableIndexCDS(T: TClientDataSet; FieldName: string): boolean;
begin
  Result:=false;
  try
    T.IndexFieldNames:=FieldName;
    Result:=true;
  except
  end;
end;

procedure ChangeSortCDS(CDS: TClientDataSet; KeyField: TField;
  SortFieldName: String; SortDesc: Boolean; var Accept: Boolean);
var F: TField;
    oldCursor: TCursor;
    oldId: variant;
begin
  oldCursor:=SQLCursor;
  oldId:=0;
  try
    F:=CDS.FindField(SortFieldName);
    Accept:=(not SortDesc) and CDS.Active and (not IsEditing(CDS)) and
      ((SortFieldName='') or IsSimpleField(F));
    if not Accept then Abort;
    if Assigned(F) and (F.FieldKind=fkLookup) then
      SortFieldName:=F.LookupKeyFields;
    if Assigned(KeyField) then oldId:=KeyField.AsVariant;
    if Pos(' ',SortFieldName)>0 then SortFieldName:='['+SortFieldName+']';
    CDS.IndexFieldNames:=SortFieldName;
    if Assigned(KeyField) then CDS.Locate(KeyField.FieldName,oldId,[]);
  except
    Accept:=false;
  end;
  ChCursor(oldCursor);
end;

function RequeryExCDS(CDS: TClientDataSet; F: TField): boolean;
var B: TBookmark;
    oldCursor: TCursor;
    oldId: variant;
    oldSort: string;
    ToLast: boolean;
begin
  oldCursor:=SQLCursor;
  Result:=false;
  try
    if not CDS.Active then CDS.Open
    else
    begin
      // Find record after requery by old field value
      if Assigned(F) then
      begin
        oldId:=F.AsVariant;
        CDS.Close;
        CDS.Open;
        Result:=CDS.Locate(F.FieldName,oldId,[]);
        if not Result then CDS.First;
      end
      else
      begin
        // Find record after requery by Bookmark
        B:=CDS.GetBookmark;
        ToLast:=false;
        try
          CDS.Close;
          CDS.Open;
          try
            CDS.GotoBookmark(B);
            Result:=true;
          except
            ToLast:=true;
          end;
        finally
          CDS.FreeBookmark(B);
        end;
        if ToLast then
        begin
          oldSort:=CDS.IndexFieldNames;
          CDS.IndexFieldNames:='';
          CDS.Last;
          B:=CDS.GetBookmark;
          try
            CDS.IndexFieldNames:=oldSort;
            CDS.GotoBookmark(B);
          finally
            CDS.FreeBookmark(B);
          end;
        end;
      end;
    end;
  finally
    ChCursor(oldCursor);
  end;
end;

function RequeryGridCDS(DBGrid: TDBGrid): boolean;
begin
  Result:=false;
  if DBGrid.DataSource.DataSet is TClientDataSet then
    Result:=RequeryExCDS(DBGrid.DataSource.DataSet as TClientDataSet,nil);
end;

end.
