unit rdbtool_ADO;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Db, ADODb, Variants, Forms, DBGrids, ComObj;


function SetTableIndexADO(T: TADOTable; FieldName: string): boolean;
procedure ChangeSortADO(ADO: TCustomADODataSet;
  SortFieldName: String; SortDesc: Boolean; var Accept: Boolean);
function RequeryExADO(ADO: TCustomADODataSet; F: TField): boolean;
function RequeryGridADO(DBGrid: TDBGrid): boolean;

//function CompactMDBToFile(SourceFileName, DestFileName, Psw: string): boolean;
//function CompactMDB(FileName, Psw: string): boolean;

implementation

uses rstring, rtool, rdbtool, rdlg;

function SetTableIndexADO(T: TADOTable; FieldName: string): boolean;
begin
  Result:=false;
  try
    T.IndexFieldNames:=FieldName;
    Result:=true;
  except
  end;
end;

procedure ChangeSortADO(ADO: TCustomADODataSet;
  SortFieldName: String; SortDesc: Boolean; var Accept: Boolean);
const
  FieldSep=',';
var B: TBookmark;
    F: TField;
    oldCursor: TCursor;
    i: integer;
    aFN, sFN: string;
begin
  oldCursor:=SQLCursor;
  try
    Accept:=ADO.Active and (not IsEditing(ADO));
    if not Accept then Abort;
    sFN:='';
    if SortFieldName<>'' then
    begin
      i:=0;
      repeat
        Inc(i);
        aFN:=FindStrPart(SortFieldName,FieldSep,i,false);
        if aFN='' then Break;
        F:=ADO.FindField(aFN);
        Accept:=Assigned(F) and IsSimpleField(F);
        if not Accept then Abort;
        if (F.FieldKind=fkLookup) then aFN:=F.KeyFields;
        if Pos(' ',aFN)>0 then aFN:='['+aFN+']';
        if SortDesc then aFN:=aFN+' DESC';
        if sFN<>'' then sFN:=sFN+FieldSep;
        sFN:=sFN+aFN;
      until false;
    end;
    B:=ADO.GetBookmark;
    try
      ADO.Sort:=sFN;
      ADO.GotoBookmark(B);
    finally
      ADO.FreeBookmark(B);
    end;
  except
    Accept:=false;
  end;
  ChCursor(oldCursor);
end;

function RequeryExADO(ADO: TCustomADODataSet; F: TField): boolean;
var B: TBookmark;
    oldCursor: TCursor;
    oldId: variant;
    oldSort: string;
    ToLast: boolean;
begin
  oldCursor:=SQLCursor;
  Result:=false;
  try
    if not ADO.Active then ADO.Open
    else
    begin
      // Find record after requery by old field value
      if Assigned(F) then
      begin
        oldId:=F.AsVariant;
        ADO.Requery();
        Result:=ADO.Locate(F.FieldName,oldId,[]);
        if not Result then ADO.First;
      end
      else
      begin
        // Find record after requery by Bookmark
        B:=ADO.GetBookmark;
        ToLast:=false;
        try
          ADO.Requery();
          try
            ADO.GotoBookmark(B);
            Result:=true;
          except
            ToLast:=true;
          end;
        finally
          ADO.FreeBookmark(B);
        end;
        if ToLast then
        begin
          oldSort:=ADO.Sort;
          ADO.Sort:='';
          ADO.Last;
          B:=ADO.GetBookmark;
          try
            ADO.Sort:=oldSort;
            ADO.GotoBookmark(B);
          finally
            ADO.FreeBookmark(B);
          end;
        end;
      end;
    end;
  finally
    ChCursor(oldCursor);
  end;
end;

function RequeryGridADO(DBGrid: TDBGrid): boolean;
begin
  Result:=false;
  if DBGrid.DataSource.DataSet is TCustomADODataSet then
    Result:=RequeryExADO(DBGrid.DataSource.DataSet as TCustomADODataSet,nil);
end;

{
function GetDAOObject: OLEVariant;
const
  max=3;
  OLENames: array [1..max] of string=
    ('DAO.DBEngine','DAO.DBEngine.35','DAO.DBEngine.36');
var
  i: integer;
begin
  for i:=1 to max do
  begin
    try
      Result := GetActiveOLEObject(OLENames[i]);
    except
      try
        Result:=CreateOLEObject(OLENames[i]);
      except
      end;
    end;
    if not VarIsEmpty(Result) then Break;
  end;
end;

function CompactMDBToFile(SourceFileName, DestFileName, Psw: string): boolean;
var db: OLEVariant;
begin
  Result:=false;
  SQLCursor;
  try
    db:=GetDAOObject;
    if VarIsEmpty(db) then raise Exception.Create('OLE object "BDEngine" not found.');
    if Psw='' then db.CompactDataBase(SourceFileName, DestFileName)
              else db.CompactDataBase(SourceFileName, DestFileName,,,';pwd='+Psw);
    Result := true;
  except
    on E: Exception do ShowErr(sCompressDataErr,E,false);
  end;
  db:=Unassigned;
  NCursor;
end;

function CompactMDB(FileName, Psw: string): boolean;
var Dest,Old: string;
  procedure DelFile(f: string);
  begin
    if FileExists(f) then
      if not DeleteFile(f) then
        raise Exception.Create('Cannot delete file: '+f);
  end;
begin
  Result:=false;
  SQLCursor;
  try
    Dest:=ExtractFilePath(FileName)+'compact.mdb';
    Old:=ExtractFilePath(FileName)+'old.mdb';
    DelFile(Dest);
    DelFile(Old);
    if CompactMDBToFile(FileName,Dest,Psw) then
    begin
      if not RenameFile(FileName,Old) then
        raise Exception.Create('Cannot rename file: '+FileName);
      if not RenameFile(Dest,FileName) then
        raise Exception.Create('Cannot rename file: '+Dest);
      DelFile(Dest);
      DelFile(Old);
      Result := true;
    end;
  except
    on E: Exception do ShowErr(sCompressDataErr,E,false);
  end;
  NCursor;
end;
}

end.
