unit rdbtool;

{
  rdbtool
  =======
  Date: Sep 2002
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  rdbtool is set of database functions

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Db, Grids, DbGrids, Menus, Forms;

const
  sfSimpleFld: Set of TFieldType=
    ([ftString, ftWideString, ftSmallint, ftInteger, ftWord, ftBoolean, ftFloat, ftCurrency,
      ftBCD, ftDate, ftTime, ftDateTime, ftAutoInc, ftLargeint]);
  sfApostrFld: Set of TFieldType=
    ([ftString, ftWideString, ftDate, ftTime, ftDateTime]);

  sBooleanString: array [boolean] of string = ('false','true');

function GetDataSet(GridOrDSet: TObject): TDataSet;
function GetDSStateStr(GridOrDSet: TObject): string;

function IsEditing(GridOrDSet: TObject): boolean;
function IsSimpleField(Fld: TField): boolean;
function IsApostrField(Fld: TField): boolean;
function IsMemoField(Fld: TField): boolean;
function IsGraphicField(Fld: TField): boolean;

function GetFldList(GridOrDSet: TObject; List: TStrings;
                   GetLabels, OnlyVisible, OnlySimple: boolean): integer;

function ShowRecordCount(GridOrDSet: TObject): boolean;
function LocateRecord(F: TField; Value: Variant): boolean;

procedure AddRecordEx(G: TDBGrid);
procedure DuplicRecord(GridOrDSet: TObject; TagToDuplic: integer);

function GetSQLLine(SQL: TStrings; KeyWord: string): string;
function SetSQLLine(SQL: TStrings; KeyWord, NewLine: string): boolean;
function SetSQLOrder(SQL: TStrings; FieldName: string; Desc: boolean): boolean;
function SetSQLWhere(SQL: TStrings; Condition: string): boolean;

procedure GenerateSQLUpdateCmd(L: TStrings; DS: TDataSet;
                               TableName, IdField: string; AllRecords: boolean);

type
  TProcOnHelp=procedure(Form: TForm; HelpContext: integer) of object;

var
  ProcOnHelp: TProcOnHelp;

implementation

uses rstring, rdlg;

function GetDataSet(GridOrDSet: TObject): TDataSet;
begin
  Result:=nil;
  try
    if GridOrDSet is TDBGrid then
      Result:=(GridOrDSet as TDBGrid).DataSource.DataSet;
    if GridOrDSet is TDataSource then Result:=(GridOrDSet as TDataSource).DataSet;
    if GridOrDSet is TDataSet then Result:=GridOrDSet as TDataSet;
  except
    Result:=nil;
  end;
end;

function GetDSStateStr(GridOrDSet: TObject): string;
begin
  try
    case GetDataSet(GridOrDSet).State of
      dsInsert: Result:=sInserting;
      dsEdit: Result:=sEditing;
      dsBrowse: Result:=sBrowsing;
      dsInActive: Result:=sInactive;
      else Result:='';
    end;
  except
    Result:='';
  end;
end;

function IsEditing(GridOrDSet: TObject): boolean;
begin
  try
    Result:=(GetDataSet(GridOrDSet).State in [dsEdit,dsInsert]);
  except
    Result:=false;
  end;
end;

function IsSimpleField(Fld: TField): boolean;
begin
  if Fld=nil then Result:=false
  else Result:=Fld.DataType in sfSimpleFld;
end;

function IsApostrField(Fld: TField): boolean;
begin
  if Fld=nil then Result:=false
  else Result:=Fld.DataType in sfApostrFld;
end;

function IsMemoField(Fld: TField): boolean;
begin
  Result:=Fld is TMemoField;
  if Fld is TBlobField then
    if ((Fld as TBlobField).BlobType=ftMemo) or
       ((Fld as TBlobField).BlobType=ftFmtMemo) then Result:=true;
end;

function IsGraphicField(Fld: TField): boolean;
begin
  Result:=Fld is TGraphicField;
  if Fld is TBlobField then
    if ((Fld as TBlobField).BlobType=ftTypedBinary) or
       ((Fld as TBlobField).BlobType=ftGraphic) then Result:=true;
end;

function GetFldList(GridOrDSet: TObject; List: TStrings;
                   GetLabels, OnlyVisible, OnlySimple: boolean): integer;
var a: integer;
begin
  List.Clear;
  if GridOrDSet is TDBGrid then
    with GridOrDSet as TDBGrid do
      for a:=0 to Columns.Count-1 do
        if ((not OnlyVisible) or (Columns[a].Visible))
           and
           ((not OnlySimple) or (IsSimpleField(Columns[a].Field))) then
          if GetLabels then List.Add(Columns[a].Title.Caption)
                       else List.Add(Columns[a].FieldName);
  if GridOrDSet is TDataSet then
    with GridOrDSet as TDataSet do
      for a:=0 to FieldCount-1 do
        if ((not OnlyVisible) or (Fields[a].Visible))
           and
           ((not OnlySimple) or (IsSimpleField(Fields[a]))) then
          if GetLabels then List.Add(Fields[a].DisplayLabel)
                       else List.Add(Fields[a].FieldName);
  Result:=List.Count;
end;

function ShowRecordCount(GridOrDSet: TObject): boolean;
begin
  try
    DlgI(Format(sSelRecords,[GetDataSet(GridOrDSet).RecordCount]));
    Result:=true;
  except
    Result:=false
  end;
end;

function LocateRecord(F: TField; Value: Variant): boolean;
begin
  F.DataSet.Locate(F.FieldName,Value,[]);
  Result:=F.AsVariant=Value;
end;

procedure AddRecordEx(G: TDBGrid);
begin
  if G=nil then Exit;
  G.SelectedIndex:=0;
  while (not G.Columns[G.SelectedIndex].Visible) and
    (G.SelectedIndex<G.Columns.Count-1) do G.SelectedIndex:=G.SelectedIndex+1;
  G.DataSource.DataSet.Append;
end;

procedure DuplicRecord(GridOrDSet: TObject; TagToDuplic: integer);
var i,max: integer;
    arr: array of variant;
    D: TDataSet;
begin
  D:=GetDataSet(GridOrDSet);
  if (D=nil) or (not D.Active) then Exit;
  max:=D.FieldCount;
  SetLength(arr,max);
  for i:=0 to max-1 do arr[i]:=D.Fields[i].AsVariant;
  if GridOrDSet is TDBGrid then AddRecordEx(GridOrDSet as TDBGrid)
                           else D.Append;
  for i:=0 to max-1 do
  try
    if (D.Fields[i].Tag and TagToDuplic)<>0 then
      D.Fields[i].AsVariant:=arr[i];
  except
  end;
end;

function GetSQLLine(SQL: TStrings; KeyWord: string): string;
var a: integer;
    s: string;
begin
  Result:='';
  for a:=0 to SQL.Count-1 do
  begin
    s:=AnsiUpperCase(Trim(SQL.Strings[a]));
    if Pos(AnsiUpperCase(KeyWord),s)=1 then
    begin
      Result:=SQL.Strings[a];
    end;
  end;
end;

function SetSQLLine(SQL: TStrings; KeyWord, NewLine: string): boolean;
var a: integer;
    s: string;
begin
  Result:=false;
  for a:=0 to SQL.Count-1 do
  begin
    s:=AnsiUpperCase(Trim(SQL.Strings[a]));
    if Pos(AnsiUpperCase(KeyWord),s)=1 then
    begin
      SQL.Strings[a]:=NewLine;
      Result:=true;
    end;
  end;
end;

function SetSQLOrder(SQL: TStrings; FieldName: string; Desc: boolean): boolean;
const o='ORDER BY ';
begin
  if Desc then FieldName:=FieldName+' DESC';
  Result:=SetSQLLine(SQL, o, o+FieldName);
end;

function SetSQLWhere(SQL: TStrings; Condition: string): boolean;
const w='WHERE ';
begin
  Result:=SetSQLLine(SQL, w, w+'('+Condition+')');
end;

procedure GenerateSQLUpdateCmd(L: TStrings; DS: TDataSet;
                               TableName, IdField: string; AllRecords: boolean);
var F: TField;
    s,w: string;
    first: boolean;

  function FrmFieldValue(F: TField): string;
  var FrmStr,Val: string;
  begin
    if IsApostrField(F) then FrmStr:='%s="%s"'
                        else FrmStr:='%s=%s';
    if F.IsNull then Val:='null'
                else Val:=F.AsString;
    Result:=Format(FrmStr,[F.FieldName,Val]);
  end;

  procedure Add1Rec;
  var i: integer;
  begin
    first:=true;
    s:=Format('UPDATE %s SET ',[TableName]);
    for i:=0 to DS.FieldCount-1 do
    begin
      F:=ds.Fields[i];
      if AnsiCompareText(F.FieldName,IdField)=0 then w:=FrmFieldValue(F)
      else
      if IsSimpleField(F) then
      begin
        if not first then s:=s+', ';
        first:=false;
        s:=s+FrmFieldValue(F);
      end;
    end;
    L.Add(s);
    L.Add('WHERE '+w);
    L.Add('GO');
  end;

begin
  if AllRecords then
  begin
    DS.First;
    while not DS.Eof do
    begin
      Add1Rec;
      DS.Next;
    end;
  end
  else Add1Rec;
end;

initialization
  ProcOnHelp:=nil;

end.
