unit rTip;

{
  rTip
  ====
  Date: Sep 2002
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  rTip provides "Tip of the day" dialog with "Dont show next time"
  function.

  Note:
  Full functional demo   
{}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, FormatLabel, ExtCtrls, PropSaveMain;

procedure ShowTip(FormatedInfo: string; Id: string; PropSaveFile: TPropSaveFile);
procedure EnableAllTips(PropSaveFile: TPropSaveFile);

type
  TrTipForm = class(TForm)
    Image1: TImage;
    lTip: TFormatLabel;
    PS: TPropSaveMain;
    pBottom: TPanel;
    cbSuppresNextTime: TCheckBox;
    Panel2: TPanel;
    btOk: TBitBtn;
    Bevel1: TBevel;
    procedure PSReadProperties(PSFile: TPropSaveFile; Key: String);
    procedure PSSaveProperties(PSFile: TPropSaveFile; Key: String);
  private
    { Private declarations }
    FId: string;
  public
    { Public declarations }
  end;

var
  rTipForm: TrTipForm;

implementation

uses rtool;

{$R *.dfm}

procedure EnableAllTips(PropSaveFile: TPropSaveFile);
begin
  if Assigned(PropSaveFile) then PropSaveFile.EraseSection('rTipForm');
end;

procedure ShowTip(FormatedInfo: string; Id: string; PropSaveFile: TPropSaveFile);
begin
  CreateF(TrTipForm,rTipForm);
  with rTipForm do
  begin
    FId:=Id;
    PS.PropSaveFile:=PropSaveFile;
    cbSuppresNextTime.Enabled:=Assigned(PropSaveFile);
    PS.ReadProperties;
    if not cbSuppresNextTime.Checked then
    begin
      lTip.Width:=ClientWidth-lTip.Left-20;
      lTip.Caption:=FormatedInfo;
      // Set window size according Label size
      if lTip.Left+lTip.Width>ClientWidth then
        ClientWidth:=lTip.Left+lTip.Width+20;
      if lTip.Top+lTip.Height>ClientHeight-pBottom.Height then
        ClientHeight:=lTip.Top+lTip.Height+pBottom.Height+20;
      ShowModal;
      PS.SaveProperties;
    end;
  end;
  FreeF(rTipForm);
end;

procedure TrTipForm.PSReadProperties(PSFile: TPropSaveFile; Key: String);
begin
  cbSuppresNextTime.Checked:=PSFile.ReadBool(Key,FId,false);
end;

procedure TrTipForm.PSSaveProperties(PSFile: TPropSaveFile; Key: String);
begin
  PSFile.WriteBool(Key,FId,cbSuppresNextTime.Checked);
end;

end.
