unit rDBGridsPropSave;

{
  rDBGridsPropSave
  ================
  Date: Sep 2002
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  rDBGridsPropSave is descendant of TDBGridsPropSave component and
  provides re/storing of rDBGrid properties.

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Classes, PropSaveMain,
  DBGridsPropSave, DB, DBGrids, RDBGrid;

type
  TrDBGridsPropSave = class(TDBGridsPropSave)
  private
    procedure SaveRDBGrid(PSFile: TPropSaveFile; Key: string; SG: TRDBGrid);
    procedure ReadRDBGrid(PSFile: TPropSaveFile; Key: string; SG: TRDBGrid);
  protected
    procedure ReadSaveProps(A: TPropSaveAction; PSFile: TPropSaveFile;
                            Key: string; Comp: TComponent); override;
  public
    function CanSave(Comp: TComponent): boolean; override;
  published
  end;

procedure Register;

implementation

{$R *.res}

const
  sRowLines='RowLines';
  sSortField='SortField';
  sSortDesc='SortDesc';
  sColumnWidth='ColumnWidth';
  sTitleLines='TitleLines';
  sDrawColored='DrawColored';
  sColorOddRow='ColorOddRow';


procedure Register;
begin
  RegisterComponents('Rosi', [TrDBGridsPropSave]);
end;

function TrDBGridsPropSave.CanSave(Comp: TComponent): boolean;
begin
  Result:=inherited CanSave(Comp) or (Comp is TrDBGrid);
end;

procedure TrDBGridsPropSave.ReadSaveProps(A: TPropSaveAction; PSFile: TPropSaveFile;
                                          Key: string; Comp: TComponent);
begin
  inherited ReadSaveProps(A,PSFile,Key,Comp);
  if (Comp is TRDBGrid) then
  begin
    if A=psaRead then ReadRDBGrid(PSFile,Key,Comp as TRDBGrid)
                 else SaveRDBGrid(PSFile,Key,Comp as TRDBGrid);
  end;
end;

procedure TrDBGridsPropSave.SaveRDBGrid(PSFile: TPropSaveFile; Key: string; SG: TRDBGrid);
begin
  PSFile.WriteBool(Key,sRowLines,dgRowLines in SG.Options);
  PSFile.WriteString(Key,sSortField,SG.SortFieldName);
  PSFile.WriteBool(Key,sSortDesc,SG.SortDesc);
  PSFile.WriteInteger(Key,sColumnWidth,ord(SG.ColumnWidth));
  PSFile.WriteInteger(Key,sTitleLines,SG.TitleLines);
  PSFile.WriteBool(Key,sDrawColored,dgDrawColoredRow in SG.OptionsEx);
  PSFile.WriteInteger(Key,sColorOddRow,SG.ColorOddRow);
end;

procedure TrDBGridsPropSave.ReadRDBGrid(PSFile: TPropSaveFile; Key: string; SG: TRDBGrid);
var b: boolean;
begin
  b:=PSFile.ReadBool(Key,sRowLines,dgRowLines in SG.Options);
  if b then SG.Options:=SG.Options+[dgRowLines]
       else SG.Options:=SG.Options-[dgRowLines];
  SG.SortFieldName:=PSFile.ReadString(Key,sSortField,SG.SortFieldName);
  SG.SortDesc:=PSFile.ReadBool(Key,sSortDesc,SG.SortDesc);
  SG.ColumnWidth:=TColumnWidth(PSFile.ReadInteger(Key,sColumnWidth,ord(SG.ColumnWidth)));
  SG.TitleLines:=PSFile.ReadInteger(Key,sTitleLines,SG.TitleLines);
  b:=PSFile.ReadBool(Key,sDrawColored,dgDrawColoredRow in SG.OptionsEx);
  if b then SG.OptionsEx:=SG.OptionsEx+[dgDrawColoredRow]
       else SG.OptionsEx:=SG.OptionsEx-[dgDrawColoredRow];
  SG.ColorOddRow:=PSFile.ReadInteger(Key,sColorOddRow,SG.ColorOddRow);
end;

end.
