unit rDBGrid_MemoForm;

{
  rDBGrid Memo Form
  ====================
  Date: Sep 2002
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  rDBGrid_MemoForm is a dialog for displaying of memo or long string fields.

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Menus, Dialogs, StdCtrls, PropSaveMain, Buttons, ExtCtrls;

type
  TrDBGridMemoForm = class(TForm)
    PS: TPropSaveMain;
    MainMenu: TMainMenu;
    mnOptions: TMenuItem;
    mnFont: TMenuItem;
    mnEnter: TMenuItem;
    mnTab: TMenuItem;
    mnWrap: TMenuItem;
    FontDlg: TFontDialog;
    mnWindows: TMenuItem;
    Memo: TMemo;
    pBottom: TPanel;
    pRight: TPanel;
    btOk: TBitBtn;
    btCancel: TBitBtn;
    procedure mnFontClick(Sender: TObject);
    procedure mnEnterClick(Sender: TObject);
    procedure PSReadProperties(PSFile: TPropSaveFile; Key: String);
    procedure PSSaveProperties(PSFile: TPropSaveFile; Key: String);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    procedure SetAll;
  public
    { Public declarations }
    IsEdit: boolean;
  end;

var
  rDBGridMemoForm: TrDBGridMemoForm;

implementation

{$R *.dfm}

procedure TrDBGridMemoForm.SetAll;
begin
  btOk.Enabled:=IsEdit;
  Memo.ReadOnly:=not IsEdit;
  Memo.WantReturns:=mnEnter.Checked;
  Memo.WantTabs:=mnTab.Checked;
  Memo.WordWrap:=mnWrap.Checked;
  if Memo.WordWrap then Memo.ScrollBars:=ssVertical
                   else Memo.ScrollBars:=ssBoth;
end;

procedure TrDBGridMemoForm.FormShow(Sender: TObject);
begin
  SetAll;
  Memo.SelStart:=Length(Memo.Text);
  Memo.SelLength:=1;
end;

procedure TrDBGridMemoForm.mnFontClick(Sender: TObject);
begin
  FontDlg.Font:=Memo.Font;
  if FontDlg.Execute then Memo.Font:=FontDlg.Font;
end;

procedure TrDBGridMemoForm.mnEnterClick(Sender: TObject);
begin
  SetAll;
end;

procedure TrDBGridMemoForm.PSReadProperties(PSFile: TPropSaveFile; Key: String);
begin
  PSFile.ReadFont(Key+'.Memo',Memo.Font);
end;

procedure TrDBGridMemoForm.PSSaveProperties(PSFile: TPropSaveFile; Key: String);
begin
  PSFile.WriteFont(Key+'.Memo',Memo.Font);
end;

procedure TrDBGridMemoForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#27 then Close;
end;

end.
