unit rDBGrid_GraphicForm;

{
  rDBGrid Graphic Form
  ====================
  Date: Sep 2002
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  rDBGrid_GraphicForm is a dialog for displaying of graphic fields.

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, DBCtrls, ComCtrls, ToolWin, StdCtrls, PropSaveMain,
  ImgList, ExtCtrls, Buttons;

type
  TrDBGridGraphicForm = class(TForm)
    SBox: TScrollBox;
    ToolBar1: TToolBar;
    tbLoad: TToolButton;
    tbSave: TToolButton;
    tbCopy: TToolButton;
    tbPaste: TToolButton;
    ToolButton5: TToolButton;
    tbClear: TToolButton;
    ToolButton3: TToolButton;
    lInfo: TLabel;
    ImageList1: TImageList;
    ToolButton1: TToolButton;
    OpenDlg: TOpenDialog;
    SaveDlg: TSaveDialog;
    PS: TPropSaveMain;
    Image: TImage;
    pBottom: TPanel;
    pRight: TPanel;
    btOk: TBitBtn;
    btCancel: TBitBtn;
    procedure tbCopyClick(Sender: TObject);
    procedure tbPasteClick(Sender: TObject);
    procedure tbClearClick(Sender: TObject);
    procedure tbLoadClick(Sender: TObject);
    procedure tbSaveClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    procedure SetAll;
  public
    { Public declarations }
    IsEdit: boolean;
  end;

var
  rDBGridGraphicForm: TrDBGridGraphicForm;

implementation

{$R *.dfm}

uses rstring, clipbrd;

procedure TrDBGridGraphicForm.SetAll;
begin
  lInfo.Visible:=(Image.Picture.Bitmap=nil) or (Image.Picture.Bitmap.Empty);
  Image.Visible:=not lInfo.Visible;
  btOk.Enabled:=IsEdit;
  tbLoad.Enabled:=IsEdit;
  tbPaste.Enabled:=IsEdit;
  tbClear.Enabled:=IsEdit;
end;

procedure TrDBGridGraphicForm.FormShow(Sender: TObject);
begin
  OpenDlg.Filter:=sFileTypeBMP+'|'+sFileTypeAll;
  SaveDlg.Filter:=OpenDlg.Filter;
  SetAll;
end;

procedure TrDBGridGraphicForm.tbCopyClick(Sender: TObject);
begin
  if Image.Picture.Bitmap<>nil then
    Clipboard.Assign(Image.Picture.Bitmap);
end;

procedure TrDBGridGraphicForm.tbPasteClick(Sender: TObject);
begin
  try
    if Clipboard.HasFormat(CF_BITMAP) and IsEdit then
      Image.Picture.Bitmap.Assign(Clipboard);
  except
    on E: Exception do ShowMessage(E.Message);
  end;
  SetAll;
end;

procedure TrDBGridGraphicForm.tbClearClick(Sender: TObject);
begin
  if Image.Picture.Bitmap<> nil then
  begin
    Clipboard.Assign(Image.Picture.Bitmap);
    Image.Picture.Bitmap:=nil;
  end;
  SetAll;
end;

procedure TrDBGridGraphicForm.tbLoadClick(Sender: TObject);
begin
  try
    if OpenDlg.Execute then
      Image.Picture.Bitmap.LoadFromFile(OpenDlg.FileName);
  except
    on E: Exception do ShowMessage(E.Message);
  end;
  SetAll;
end;

procedure TrDBGridGraphicForm.tbSaveClick(Sender: TObject);
begin
  if SaveDlg.Execute then
    Image.Picture.Bitmap.SaveToFile(SaveDlg.FileName);
end;

procedure TrDBGridGraphicForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#27 then Close;
end;

end.
