unit rDBGrid_DTEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, DBGrids, rDBGrid, db, CheckLst, ComCtrls;

type
  TrDBGrid_DTEditForm = class(TForm)
    pc: TPageControl;
    tsCol: TTabSheet;
    tsTag: TTabSheet;
    gbActions: TGroupBox;
    gbEdit: TGroupBox;
    chAdd: TCheckBox;
    chEdit: TCheckBox;
    chDuplic: TCheckBox;
    chDelete: TCheckBox;
    chSaveAdd: TCheckBox;
    chAutoEdit: TCheckBox;
    chEditGroup: TCheckBox;
    gbTools: TGroupBox;
    chSort: TCheckBox;
    chFilter: TCheckBox;
    chColumn: TCheckBox;
    chClose: TCheckBox;
    chEnaAll: TCheckBox;
    lbFields: TListBox;
    lbCol: TCheckListBox;
    btUp: TBitBtn;
    btDown: TBitBtn;
    btMove: TBitBtn;
    btMoveAll: TBitBtn;
    btDel: TBitBtn;
    btDelAll: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    btClose: TBitBtn;
    eTitle: TEdit;
    Label4: TLabel;
    btNext: TBitBtn;
    eSep: TEdit;
    Label3: TLabel;
    lblFName: TLabel;
    Label5: TLabel;
    tsLink: TTabSheet;
    lbLink: TCheckListBox;
    Label6: TLabel;
    procedure chEditGroupClick(Sender: TObject);
    procedure chEnaAllClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure lbColDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure btUpClick(Sender: TObject);
    procedure btDownClick(Sender: TObject);
    procedure lbColClickCheck(Sender: TObject);
    procedure lbColDblClick(Sender: TObject);
    procedure lbColKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btDelClick(Sender: TObject);
    procedure btDelAllClick(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btMoveClick(Sender: TObject);
    procedure btMoveAllClick(Sender: TObject);
    procedure lbColClick(Sender: TObject);
    procedure eTitleChange(Sender: TObject);
    procedure eTitleEnter(Sender: TObject);
    procedure eTitleExit(Sender: TObject);
    procedure btNextClick(Sender: TObject);
    procedure lbLinkDblClick(Sender: TObject);
  private
    { Private declarations }
    Tag: integer;
    Cs: TDBGridColumns;
    Flds: TFields;
    FAsLink: TStrings;
    procedure LoadProps;
    procedure SetProps;
    procedure LoadCol;
    procedure AddCol(Fld: TField);
    procedure MoveI(List: TCheckListBox; old, new: integer);
    procedure CheckI(act: integer);
  public
    { Public declarations }
  end;

function ShowrDBGridEditor(Component: TComponent): boolean;

implementation

{$R *.dfm}

uses TypInfo, rtool, rdlg;

const cTag='Tag';

function ShowrDBGridEditor(Component: TComponent): boolean;
var F: TrDBGrid_DTEditForm;
    DS: TDataSource;
begin
  Result:=true;
  F:=TrDBGrid_DTEditForm.Create(Application);
  try
    F.Caption:=Component.Name;
    F.Tag:=GetOrdProp(Component,cTag);
    F.Cs:=GetObjectProp(Component,'Columns') as TDBGridColumns;
    F.FAsLink:=GetObjectProp(Component,'FieldsAsLink') as TStrings;
    try
      DS:=GetObjectProp(Component,'DataSource') as TDataSource;
      F.Flds:=DS.Dataset.Fields;
    except
      F.Flds:=nil;
    end;
    F.ShowModal;
    SetOrdProp(Component,cTag,F.Tag);
  finally
    F.Free;
  end;
end;

procedure TrDBGrid_DTEditForm.FormShow(Sender: TObject);
begin
  pc.ActivePageIndex:=0;
  LoadProps;
end;

procedure TrDBGrid_DTEditForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  SetProps;
end;

procedure TrDBGrid_DTEditForm.btCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TrDBGrid_DTEditForm.LoadProps;
var i,p: integer;
begin
  // set actions controls
  chEnaAll.Checked:=Tag<>-1;
  if chEnaAll.Checked then
  begin
    chEditGroup.Checked:=Tag and 1=0;
    chSort.Checked:=Tag and 2=0;
    chFilter.Checked:=Tag and 4=0;
    chColumn.Checked:=Tag and 8=0;
    chClose.Checked:=Tag and 128=0;

    chAdd.Checked:=Tag and 1024=0;
    chDuplic.Checked:=Tag and 256=0;
    chEdit.Checked:=Tag and 2048=0;
    chDelete.Checked:=Tag and 4096=0;
    chSaveAdd.Checked:=Tag and 512=0;
    chAutoEdit.Checked:=Tag and 8192=0;
  end;
  chEnaAllClick(nil);
  chEditGroupClick(nil);
  // load fields
  lbFields.Clear;
  if Flds<>nil then
    for i:=0 to Flds.Count-1 do lbFields.Items.Add(Flds[i].FieldName);
  LoadCol;
  // load FieldsAsLink
  lbLink.Items.Assign(lbFields.Items);
  for i:=0 to FAsLink.Count-1 do
  begin
    p:=lbLink.Items.IndexOf(FAsLink.Strings[i]);
    if p>=0 then lbLink.Checked[p]:=true;
  end;
end;

procedure TrDBGrid_DTEditForm.SetProps;
var i: integer;
begin
  // set action control
  if not chEnaAll.Checked then Tag:=-1
  else
  begin
    Tag:=0;
    if not chEditGroup.Checked then Tag:=Tag or 1;
    if not chSort.Checked then Tag:=Tag or 2;
    if not chFilter.Checked then Tag:=Tag or 4;
    if not chColumn.Checked then Tag:=Tag or 8;
    if not chClose.Checked then Tag:=Tag or 128;

    if not chAdd.Checked then Tag:=Tag or 1024;
    if not chDuplic.Checked then Tag:=Tag or 256;
    if not chEdit.Checked then Tag:=Tag or 2048;
    if not chDelete.Checked then Tag:=Tag or 4096;
    if not chSaveAdd.Checked then Tag:=Tag or 512;
    if not chAutoEdit.Checked then Tag:=Tag or 8192;
  end;
  // set FieldsAsLink
  FAsLink.Clear;
  for i:=0 to lbLink.Items.Count-1 do
    if lbLink.Checked[i] then FAsLink.Add(lbLink.Items[i]);
end;

procedure TrDBGrid_DTEditForm.LoadCol;
var i: integer;
begin
  // load columns
  lbCol.Clear;
  for i:=0 to Cs.Count-1 do
    lbCol.Items.Add(Cs[i].Title.Caption);
  for i:=0 to Cs.Count-1 do
    lbCol.Checked[i]:=Cs[i].Visible;
end;

procedure TrDBGrid_DTEditForm.AddCol(Fld: TField);
var C: TColumn;
    oldItemIndex: integer;
begin
  oldItemIndex:=lbCol.ItemIndex;
  C:=Cs.Add;
  C.FieldName:=Fld.FieldName;
  C.Title.Caption:=ReplaceStr(eSep.Text,' ',Fld.DisplayLabel,true,false);
  C.Title.Alignment:=C.Alignment;
  C.ReadOnly:=Fld.ReadOnly;
  C.Visible:=Fld.Visible;
  try
    C.Width:=Fld.DisplayWidth*4;
    if C.Width<20 then C.Width:=20;
    if C.Width>200 then C.Width:=200;
  except
  end;
  if oldItemIndex<>-1 then C.Index:=oldItemIndex+1;
  LoadCol;
  lbCol.ItemIndex:=oldItemIndex+1;
end;

procedure TrDBGrid_DTEditForm.MoveI(List: TCheckListBox; old, new: integer);
begin
  if not MoveCheckListBox(List, old, new) then Exit;
  Cs[old].Index:=new;
end;

procedure TrDBGrid_DTEditForm.CheckI(act: integer);
begin
  Cs[act].Visible:=lbCol.Checked[act];
end;

procedure TrDBGrid_DTEditForm.lbColDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept:=true;
  MoveI(lbCol,lbCol.ItemIndex,Y div lbCol.ItemHeight+lbCol.TopIndex);
end;

procedure TrDBGrid_DTEditForm.btUpClick(Sender: TObject);
begin
  MoveI(lbCol,lbCol.ItemIndex,lbCol.ItemIndex-1);
end;

procedure TrDBGrid_DTEditForm.btDownClick(Sender: TObject);
begin
  MoveI(lbCol,lbCol.ItemIndex,lbCol.ItemIndex+1);
end;

procedure TrDBGrid_DTEditForm.lbColClickCheck(Sender: TObject);
begin
  CheckI(lbCol.ItemIndex);
end;

procedure TrDBGrid_DTEditForm.lbColDblClick(Sender: TObject);
begin
  lbCol.Checked[lbCol.ItemIndex]:=not lbCol.Checked[lbCol.ItemIndex];
  CheckI(lbCol.ItemIndex);
end;

procedure TrDBGrid_DTEditForm.lbColKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key=VK_UP) and (ssCtrl in Shift) then
  begin
    MoveI(lbCol,lbCol.ItemIndex,lbCol.ItemIndex-1);
    Key:=0;
  end;
  if (Key=VK_DOWN) and (ssCtrl in Shift) then
  begin
    MoveI(lbCol,lbCol.ItemIndex,lbCol.ItemIndex+1);
    Key:=0;
  end;
  if (Key=VK_DELETE) then
  begin
    btDel.Click;
    Key:=0;
  end;
end;

procedure TrDBGrid_DTEditForm.btDelClick(Sender: TObject);
var i: integer;
begin
  i:=lbCol.ItemIndex;
  if i=-1 then Exit;
  Cs.Delete(i);
  lbCol.Items.Delete(i);
  if i>lbCol.Items.Count-1 then i:=lbCol.Items.Count-1;
  lbCol.ItemIndex:=i;
end;

procedure TrDBGrid_DTEditForm.btDelAllClick(Sender: TObject);
begin
  if DlgQ('Delete all columns?')<>mrYes then Exit;
  Cs.Clear;
  lbCol.Clear;
end;

procedure TrDBGrid_DTEditForm.chEditGroupClick(Sender: TObject);
begin
  gbEdit.Visible:=chEditGroup.Checked;
end;

procedure TrDBGrid_DTEditForm.chEnaAllClick(Sender: TObject);
begin
  gbActions.Visible:=chEnaAll.Checked;
end;

procedure TrDBGrid_DTEditForm.btMoveClick(Sender: TObject);
var i: integer;
begin
  for i:=0 to lbFields.Items.Count-1 do
    if lbFields.Selected[i] then AddCol(Flds[i]);
//  LoadProps;
end;

procedure TrDBGrid_DTEditForm.btMoveAllClick(Sender: TObject);
var i: integer;
begin
  if DlgQ('Add all columns?')<>mrYes then Exit;
  for i:=0 to lbFields.Items.Count-1 do
    lbFields.Selected[i]:=true;
  btMove.Click;
end;

procedure TrDBGrid_DTEditForm.lbColClick(Sender: TObject);
begin
  lblFName.Caption:=Cs[lbCol.ItemIndex].FieldName;
  eTitle.Text:=lbCol.Items[lbCol.ItemIndex];
  eTitle.Enabled:=true;
end;

procedure TrDBGrid_DTEditForm.eTitleChange(Sender: TObject);
begin
  lbCol.Items[lbCol.ItemIndex]:=eTitle.Text;
  Cs[lbCol.ItemIndex].Title.Caption:=eTitle.Text;
end;

procedure TrDBGrid_DTEditForm.eTitleEnter(Sender: TObject);
begin
  btNext.Default:=true;
end;

procedure TrDBGrid_DTEditForm.eTitleExit(Sender: TObject);
begin
  btNext.Default:=false;
end;

procedure TrDBGrid_DTEditForm.btNextClick(Sender: TObject);
begin
  if lbCol.ItemIndex<lbCol.Items.Count-1 then
    lbCol.ItemIndex:=lbCol.ItemIndex+1;
  lbColClick(nil);
end;

procedure TrDBGrid_DTEditForm.lbLinkDblClick(Sender: TObject);
begin
  lbLink.Checked[lbLink.ItemIndex]:=not lbLink.Checked[lbLink.ItemIndex];
end;

end.
