unit rDBGridProps;

{
  DBGrid Props
  ============
  Date: Feb 2003
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  DBGrid Props provides dialog for editing of some rDBGrid properties.

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, EditNum, ExtCtrls, DBGrids, rDBGrid;

procedure DBGridProperties(rDBGrid: TrDBGrid; SetColumns: boolean);

type
  TrDBGridPropsForm = class(TForm)
    GroupBox1: TGroupBox;
    chRowLines: TCheckBox;
    chColored: TCheckBox;
    cbColor: TColorBox;
    Label1: TLabel;
    eTitleLines: TEditNum;
    lColor: TLabel;
    gbColumns: TGroupBox;
    btColumn: TBitBtn;
    btWidthDef: TBitBtn;
    Label2: TLabel;
    btWidthData: TBitBtn;
    cbAutoWidth: TCheckBox;
    cbSameWidth: TCheckBox;
    btClose: TBitBtn;
    btDefault: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure chColoredClick(Sender: TObject);
    procedure btColumnClick(Sender: TObject);
    procedure btWidthDefClick(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
    procedure chRowLinesClick(Sender: TObject);
    procedure eTitleLinesChange(Sender: TObject);
    procedure cbAutoWidthClick(Sender: TObject);
    procedure btWidthDataClick(Sender: TObject);
    procedure cbSameWidthClick(Sender: TObject);
    function FormHelp(Command: Word; Data: Integer;
      var CallHelp: Boolean): Boolean;
  private
    { Private declarations }
    gr: TrDBGrid;
    procedure SetAll;
  public
    { Public declarations }
  end;

var
  rDBGridPropsForm: TrDBGridPropsForm;

implementation

{$R *.dfm}

uses rtool, rdbtool, rDBFields;

var
  isLoading: boolean;

procedure DBGridProperties(rDBGrid: TrDBGrid; SetColumns: boolean);
begin
  isLoading:=true;
  CreateF(TrDBGridPropsForm,rDBGridPropsForm);
  rDBGridPropsForm.gr:=rDBGrid;
  if Assigned(ProcOnHelp) then
  begin
    rDBGridPropsForm.BorderIcons:=rDBGridPropsForm.BorderIcons+[biHelp];
    rDBGridPropsForm.HelpContext:=1;
  end;
  rDBGridPropsForm.gbColumns.Visible:=SetColumns;
  rDBGridPropsForm.ShowModal;
  FreeF(rDBGridPropsForm);
end;

procedure TrDBGridPropsForm.FormShow(Sender: TObject);
begin
  chRowLines.Checked:=(dgRowLines in gr.Options);
  chColored.Checked:=(dgDrawColoredRow in gr.OptionsEx);
  cbColor.Selected:=gr.ColorOddRow;
  eTitleLines.AsInteger:=gr.TitleLines;
  SetAll;
  isLoading:=false;
end;

procedure TrDBGridPropsForm.SetAll;
begin
  isLoading:=true;
  lColor.Enabled:=chColored.Checked;
  cbColor.Enabled:=lColor.Enabled;
  cbAutoWidth.Checked:=gr.ColumnWidth=cwAutoWidth;
  cbSameWidth.Checked:=gr.ColumnWidth=cwSameWidth;
  isLoading:=false;
end;

procedure TrDBGridPropsForm.chRowLinesClick(Sender: TObject);
begin
  if isLoading then Exit;
  if chRowLines.Checked then gr.Options:=gr.Options+[dgRowLines]
                        else gr.Options:=gr.Options-[dgRowLines];
end;

procedure TrDBGridPropsForm.chColoredClick(Sender: TObject);
begin
  if isLoading then Exit;
  SetAll;
  if chColored.Checked then gr.OptionsEx:=gr.OptionsEx+[dgDrawColoredRow]
                       else gr.OptionsEx:=gr.OptionsEx-[dgDrawColoredRow];
  gr.ColorOddRow:=cbColor.Selected;
end;

procedure TrDBGridPropsForm.eTitleLinesChange(Sender: TObject);
begin
  if isLoading then Exit;
  gr.TitleLines:=eTitleLines.AsInteger;
end;

procedure TrDBGridPropsForm.cbAutoWidthClick(Sender: TObject);
begin
  if isLoading then Exit;
  if cbAutoWidth.Checked then gr.ColumnWidth:=cwAutoWidth
                         else gr.ColumnWidth:=cwNone;
  SetAll;
end;

procedure TrDBGridPropsForm.cbSameWidthClick(Sender: TObject);
begin
  if isLoading then Exit;
  if cbSameWidth.Checked then gr.ColumnWidth:=cwSameWidth
                         else gr.ColumnWidth:=cwNone;
  SetAll;
end;

procedure TrDBGridPropsForm.btWidthDataClick(Sender: TObject);
begin
  gr.ColumnWidth:=cwDataWidth;
  gr.ColumnWidth:=cwNone;
  SetAll;
end;

procedure TrDBGridPropsForm.btWidthDefClick(Sender: TObject);
begin
  gr.ColumnWidth:=cwDefaultWidth;
  gr.ColumnWidth:=cwNone;
  SetAll;
end;

procedure TrDBGridPropsForm.btColumnClick(Sender: TObject);
begin
  ChooseFields(gr);
end;

procedure TrDBGridPropsForm.btCloseClick(Sender: TObject);
begin
  Close;
end;

function TrDBGridPropsForm.FormHelp(Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;
begin
  CallHelp:=false;
  Result:=true;
  if (Command=HELP_CONTEXTPOPUP) then
    if Assigned(ProcOnHelp) then ProcOnHelp(Self,Data);
end;

end.
