unit rDBFilterSaver;

{
  DB Filter Saver
  =======
  Date: Feb 2003
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  DB Filter Saver provides dialog for saving and loading of filter strings.

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, rDBGrid, PropSaveMain, GridsPropSave, ExtCtrls, StdCtrls,
  Buttons;

procedure SaveFilter(rDBGrid: TrDBGrid);
function LoadFilter(rDBGrid: TrDBGrid): boolean;

type
  TrDBFilterSaverForm = class(TForm)
    sgFilter: TStringGrid;
    GridsPropSave: TGridsPropSave;
    PropSaveMain: TPropSaveMain;
    pBottom: TPanel;
    btDel: TBitBtn;
    btUse: TBitBtn;
    Panel1: TPanel;
    btClose: TBitBtn;
    procedure sgFilterDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect;
      State: TGridDrawState);
    procedure FormCreate(Sender: TObject);
    procedure GridsPropSaveGetKeyString(Comp: TComponent; var Key: String);
    procedure FormActivate(Sender: TObject);
    procedure btDelClick(Sender: TObject);
    procedure btUseClick(Sender: TObject);
    function FormHelp(Command: Word; Data: Integer;
      var CallHelp: Boolean): Boolean;
  private
    { Private declarations }
    G: TrDBGrid;
    Load: boolean;
    NewFilterName: string;
  public
    { Public declarations }
  end;

var
  rDBFilterSaverForm: TrDBFilterSaverForm;

implementation

{$R *.dfm}

uses rstring, rtool, rdbtool, rdlg, rDBFilter;

function ShowFilterSaver(G: TrDBGrid; Load: boolean): boolean;
var s: string;
begin
  Result:=false;
  s:='';
  if not Load then
    if not InputStr(sInput,sFilterName+':',s) then Exit;
  CreateF(TrDBFilterSaverForm,rDBFilterSaverForm);
  rDBFilterSaverForm.G:=G;
  rDBFilterSaverForm.Load:=Load;
  rDBFilterSaverForm.NewFilterName:=s;
  rDBFilterSaverForm.PropSaveMain.PropSaveFile:=G.PropSaveFile;
  if Assigned(ProcOnHelp) then
  begin
    rDBFilterSaverForm.BorderIcons:=rDBFilterSaverForm.BorderIcons+[biHelp];
    rDBFilterSaverForm.HelpContext:=1;
  end;
  Result:=rDBFilterSaverForm.ShowModal=mrOk;
  FreeF(rDBFilterSaverForm);
end;

procedure SaveFilter(rDBGrid: TrDBGrid);
begin
  ShowFilterSaver(rDBGrid,false);
end;

function LoadFilter(rDBGrid: TrDBGrid): boolean;
begin
  Result:=ShowFilterSaver(rDBGrid,true);
end;

procedure TrDBFilterSaverForm.FormCreate(Sender: TObject);
begin
;
end;

procedure TrDBFilterSaverForm.FormActivate(Sender: TObject);
var r: integer;
begin
  sgFilter.Cells[1,0]:=sFilterName;
  sgFilter.Cells[2,0]:=sFilterString;
  if not Load then
  begin
    // Add new filter
    if (sgFilter.RowCount>2) or (Trim(sgFilter.Cells[1,1])<>'') or
      (Trim(sgFilter.Cells[2,1])<>'') then
         sgFilter.RowCount:=sgFilter.RowCount+1;
    r:=sgFilter.RowCount-1;
    sgFilter.Cells[1,r]:=NewFilterName;
    sgFilter.Cells[2,r]:=G.DataSource.DataSet.Filter;
    sgFilter.Col:=1;
    sgFilter.Row:=r;
  end;
end;

procedure TrDBFilterSaverForm.GridsPropSaveGetKeyString(Comp: TComponent;
  var Key: String);
begin
  // Sets key in INI file according DBGrid name
  // (dialog shows only filters of one DBGrid, so application should use unique DBGrid names)
  if Comp=sgFilter then Key:=Key+'.'+G.Name;
end;

procedure TrDBFilterSaverForm.sgFilterDrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
var s: string;
begin
  s:=sgFilter.Cells[ACol,ARow];
  if (ACol=0) and (sgFilter.Cells[2,ARow]=G.DataSource.DataSet.Filter) then s:='+';
  if (gdFixed in State) then sgFilter.Canvas.Brush.Color:=sgFilter.FixedColor
                        else sgFilter.Canvas.Brush.Color:=sgFilter.Color;
  sgFilter.Canvas.FillRect(Rect);
  if (gdSelected in State) then sgFilter.Canvas.DrawFocusRect(Rect);
  InflateRect(Rect,-2,-1);
  DrawText(sgFilter.Canvas.Handle,PChar(s),Length(s),
           Rect,DT_LEFT+DT_WORDBREAK);
end;

procedure TrDBFilterSaverForm.btUseClick(Sender: TObject);
var s: string;
begin
  s:=sgFilter.Cells[2,sgFilter.Row];
  SetFilterString(G.DataSource.DataSet,s,true);
  sgFilter.Invalidate;
  if Sender=btUse then Close;
end;

procedure TrDBFilterSaverForm.btDelClick(Sender: TObject);
var r: integer;
    s: TStringList;
begin
  if DlgQ(sDelRecordQ)<>mrYes then Exit;
  s:=TStringList.Create;
  try
    r:=sgFilter.Row;
    s.Assign(sgFilter.Cols[1]);
    s.Delete(r);
    s.Add('');
    sgFilter.Cols[1].Assign(s);
    s.Assign(sgFilter.Cols[2]);
    s.Delete(r);
    s.Add('');
    sgFilter.Cols[2].Assign(s);
    if sgFilter.RowCount>2 then sgFilter.RowCount:=sgFilter.RowCount-1;
    if r>=sgFilter.RowCount then Dec(r);
    sgFilter.Row:=r;
  finally
    s.Free;
  end;
end;

function TrDBFilterSaverForm.FormHelp(Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;
begin
  CallHelp:=false;
  Result:=true;
  if (Command=HELP_CONTEXTPOPUP) then
    if Assigned(ProcOnHelp) then ProcOnHelp(Self,Data);
end;

end.
