unit rComp_DTReg;

interface

uses
  DesignIntf, DesignEditors, Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, rDBGrid, PropSaveMain;

type
  TrDBGrid_Editor=class(TComponentEditor)
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

  TPropSave_Editor=class(TComponentEditor)
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

procedure Register;

implementation

uses rDBGrid_DTEdit, PropSave_DTEdit;

function TrDBGrid_Editor.GetVerbCount: Integer;
begin
  Result:=inherited GetVerbCount+1;
end;

function TrDBGrid_Editor.GetVerb(Index: Integer): string;
var
  I: Integer;
begin
  I:=inherited GetVerbCount;
  if Index < I then Result:=inherited GetVerb(Index)
  else
    case Index-I of
      0: Result:='rDBGrid Editor';
    end;
end;

procedure TrDBGrid_Editor.ExecuteVerb(Index: Integer);
var
  I: Integer;
begin
  I:=inherited GetVerbCount;
  if Index<I then inherited else
  begin
    case Index-I of
      0: if ShowrDBGridEditor(Component) then Designer.Modified;
    end;
  end;
end;

function TPropSave_Editor.GetVerbCount: Integer;
begin
  Result:=inherited GetVerbCount+1;
end;

function TPropSave_Editor.GetVerb(Index: Integer): string;
var
  I: Integer;
begin
  I:=inherited GetVerbCount;
  if Index < I then Result:=inherited GetVerb(Index)
  else
    case Index-I of
      0: Result:='PropertySaver Editor';
    end;
end;

procedure TPropSave_Editor.ExecuteVerb(Index: Integer);
var
  I: Integer;
begin
  I:=inherited GetVerbCount;
  if Index<I then inherited else
  begin
    case Index-I of
      0: if ShowPropertySaverEditor(Component) then Designer.Modified;
    end;
  end;
end;

procedure Register;
begin
  RegisterComponentEditor(TrDBGrid, TrDBGrid_Editor);
  RegisterComponentEditor(TCustomPropSave, TPropSave_Editor);
  RegisterComponentEditor(TPropSaveMain, TPropSave_Editor);
end;

end.
