unit ToolBarPropSave;

{
  ToolBarPropSave
  ===============
  Date: Sep 2004
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  ToolBarPropSave is descendant of TCustomPropSave component and
  provides re/storing of ToolBar properties.

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PropSaveMain, ComCtrls;

type
  TToolBarPropSave = class(TCustomPropSave)
  private
    procedure SaveTB(PSFile: TPropSaveFile; Key: string; TB: TToolBar);
    procedure ReadTB(PSFile: TPropSaveFile; Key: string; TB: TToolBar);
  protected
    procedure ReadSaveProps(A: TPropSaveAction; PSFile: TPropSaveFile;
                            Key: string; Comp: TComponent); override;
  public
    constructor Create(AOwner: TComponent); override;
    function CanSave(Comp: TComponent): boolean; override;
  published
  end;

procedure Register;


implementation

{$R *.res}

const
  sButCount='ButtonsCount';
  sButton='Button%d';
  sShowCaptions='ShowCaptions';
  sShowList='ShowList';
  sAutoSize='AutoSize';
  //sVisible='Visible';

procedure Register;
begin
  RegisterComponents('Rosi', [TToolBarPropSave]);
end;

constructor TToolBarPropSave.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

function TToolBarPropSave.CanSave(Comp: TComponent): boolean;
begin
  Result:=(Comp is TToolBar);
end;

procedure TToolBarPropSave.ReadSaveProps(A: TPropSaveAction; PSFile: TPropSaveFile;
                            Key: string; Comp: TComponent);
begin
  if (Comp is TToolBar) then
    if A=psaRead then ReadTB(PSFile,Key,Comp as TToolBar)
                 else SaveTB(PSFile,Key,Comp as TToolBar);
end;

procedure TToolBarPropSave.SaveTB(PSFile: TPropSaveFile; Key: string; TB: TToolBar);
var a: integer;
begin
  PSFile.WriteInteger(Key,sButCount,TB.ButtonCount);
  PSFile.WriteBool(Key,sShowCaptions,TB.ShowCaptions);
  PSFile.WriteBool(Key,sShowList,TB.List);
  if TB.ButtonCount>0 then
    PSFile.WriteBool(Key,sAutoSize,TB.Buttons[0].AutoSize);
  for a:=0 to TB.ButtonCount-1 do
    PSFile.WriteBool(Key,Format(sButton,[a]),TB.Buttons[a].Visible);
end;

procedure TToolBarPropSave.ReadTB(PSFile: TPropSaveFile; Key: string; TB: TToolBar);
var a: integer;
begin
  TB.ShowCaptions:=PSFile.ReadBool(Key,sShowCaptions,TB.ShowCaptions);
  TB.List:=PSFile.ReadBool(Key,sShowList,TB.List);
  for a:=0 to TB.ButtonCount-1 do
  begin
    TB.Buttons[a].Visible:=PSFile.ReadBool(Key,Format(sButton,[a]),TB.Buttons[a].Visible);
    TB.Buttons[a].AutoSize:=PSFile.ReadBool(Key,sAutoSize,TB.Buttons[a].AutoSize);
  end;
end;



end.
