unit RTFRep_Dialog2;

{
  RTFRep Dialog
  =========
  Date: Jan 2005
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  RTFRep_Dialog provides universal dialog before execution of report.
  User can choose report, files and some properties.

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, FormatLabel, ComCtrls, Buttons, ExtCtrls, DB,
  EditNum, RTFReport2;

type
  TDataSetList= array of TDataSet;
     // List of datasets for one report
  TRTFRepInfo=record
    // Information record for each report (each tab)
                Caption: string;
                ReportFile: string;
                OutputFile: string;
                DataSets: TDataSetList;
                DefaultCharset: integer;
                FieldNotFoundValue: string;
                Variables: array of string;
                ShowDetail: boolean;
                ReportVersion: integer;
              end;

   TRTFRepDlgInfo=record
                    OnBeforeEdit: TNotifyEvent;
                    OnReadInfo: TNotifyEvent;
                    OnAfterRun: TNotifyEvent;
                    ShowMailBtn: boolean;
                    UseMapi: boolean;
                    MailTo: string;
                    MailApp: string;
                  end;

function CreateDataSetList(const DataSets: array of TDataSet): TDataSetList;
procedure ShowRTFRepDialog(const RTFRepInfo: array of TRTFRepInfo;
                           RTFRepDlgInfo: TRTFRepDlgInfo);
procedure AddRTFRepVariable(var RTFRepInfo: TRTFRepInfo; Variable: string);
procedure ClearRTFRepVariable(var RTFRepInfo: TRTFRepInfo);

type
  TRTFRepDialog2 = class(TForm)
    RTFRep2: TRTFReport2;
    pc: TTabControl;
    gbRep: TGroupBox;
    fRep: TFormatLabel;
    btOpen: TBitBtn;
    gbOut: TGroupBox;
    fOut: TFormatLabel;
    btSave: TBitBtn;
    NB: TNotebook;
    btShow: TBitBtn;
    btPrint: TBitBtn;
    btEdit: TBitBtn;
    btClose: TBitBtn;
    Label2: TLabel;
    Label1: TLabel;
    lNum: TLabel;
    btAbort: TBitBtn;
    OpenDlg: TOpenDialog;
    SaveDlg: TSaveDialog;
    gbDetail: TGroupBox;
    Label3: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    eCharset: TEditNum;
    eNotFound: TEdit;
    eVar: TMemo;
    btMail: TBitBtn;
    eVer: TEditNum;
    Label4: TLabel;
    procedure FormShow(Sender: TObject);
    procedure pcChanging(Sender: TObject; var AllowChange: Boolean);
    procedure pcChange(Sender: TObject);
    procedure btShowClick(Sender: TObject);
    procedure btAbortClick(Sender: TObject);
    procedure RTFRep1ReportProcess(Sender: TObject; RecNbr: Integer;
      var Abort: Boolean);
    procedure btEditClick(Sender: TObject);
    procedure btOpenClick(Sender: TObject);
    procedure btSaveClick(Sender: TObject);
    function FormHelp(Command: Word; Data: Integer;
      var CallHelp: Boolean): Boolean;
  private
    { Private declarations }
    RepInfo: array of TRTFRepInfo;
    RepDlgInfo: TRTFRepDlgInfo;
    Aborted: boolean;
    VerChanged: boolean;
    function RunRTF(DS: array of TDataSet; RepVer: integer): boolean;
    procedure SendMail;
    procedure OnReadInfo(Sender: TObject);
  public
    { Public declarations }
  end;

var
  RTFRepDialog2: TRTFRepDialog2;

implementation

uses rstring, rtool, rdlg, rdbtool, SendMail_const;

{$R *.dfm}

function CreateDataSetList(const DataSets: array of TDataSet): TDataSetList;
var i: integer;
begin
  SetLength(Result,High(DataSets)+1);
  for i:=0 to High(DataSets) do Result[i]:=DataSets[i];
end;

procedure ShowRTFRepDialog(const RTFRepInfo: array of TRTFRepInfo;
                           RTFRepDlgInfo: TRTFRepDlgInfo);
var i: integer;
begin
  CreateF(TRTFRepDialog2,RTFRepDialog2);
  SetLength(RTFRepDialog2.RepInfo,High(RTFRepInfo)+1);
  for i:=0 to High(RTFRepInfo) do RTFRepDialog2.RepInfo[i]:=RTFRepInfo[i];
  RTFRepDialog2.RepDlgInfo:=RTFRepDlgInfo;
  RTFRepDialog2.btMail.Visible:=RTFRepDlgInfo.ShowMailBtn;
  if Assigned(ProcOnHelp) then
  begin
    RTFRepDialog2.BorderIcons:=RTFRepDialog2.BorderIcons+[biHelp];
    RTFRepDialog2.HelpContext:=1;
  end;
  RTFRepDialog2.ShowModal;
  FreeF(RTFRepDialog2);
end;

procedure AddRTFRepVariable(var RTFRepInfo: TRTFRepInfo; Variable: string);
var h: integer;
begin
  h:=High(RTFRepInfo.Variables);
  SetLength(RTFRepInfo.Variables,h+2);
  RTFRepInfo.Variables[h+1]:=Variable;
end;

procedure ClearRTFRepVariable(var RTFRepInfo: TRTFRepInfo);
begin
  SetLength(RTFRepInfo.Variables,0);
end;

procedure TRTFRepDialog2.FormShow(Sender: TObject);
var i: integer;
begin
  for i:=0 to High(RepInfo) do pc.Tabs.Add(RepInfo[i].Caption);
  pcChange(pc);
  OpenDlg.Filter:=sFileTypeRTF+'|'+sFileTypeAll;
  SaveDlg.Filter:=OpenDlg.Filter;
end;

procedure TRTFRepDialog2.pcChanging(Sender: TObject;
  var AllowChange: Boolean);
var i: integer;
begin
  with RepInfo[pc.TabIndex] do
  begin
    ReportFile:=fRep.Caption;
    OutputFile:=fOut.Caption;
    DefaultCharset:=eCharset.AsInteger;
    FieldNotFoundValue:=eNotFound.Text;
    SetLength(Variables,eVar.Lines.Count);
    for i:=0 to eVar.Lines.Count-1 do Variables[i]:=eVar.Lines[i];
    ReportVersion:=eVer.AsInteger;
  end;
end;

procedure TRTFRepDialog2.pcChange(Sender: TObject);
var i: integer;
begin
  with RepInfo[pc.TabIndex] do
  begin
    gbDetail.Visible:=ShowDetail;
    fRep.Caption:=ReportFile;
    fOut.Caption:=OutputFile;
    eCharset.AsInteger:=DefaultCharset;
    eNotFound.Text:=FieldNotFoundValue;
    eVar.Lines.Clear;
    for i:=0 to High(Variables) do eVar.Lines.Add(Variables[i]);
    eVer.Value:=ReportVersion;
  end;
end;

function TRTFRepDialog2.RunRTF(DS: array of TDataSet; RepVer: integer): boolean;
begin
  Aborted:=false;
  Result:=false;
  NB.PageIndex:=1;
  lNum.Caption:='';
  try
    RTFRep2.Execute(DS);
    Result:=true;
  except
    on E: Exception do
      if not VerChanged then ShowErr('',E,false);
  end;
  NB.PageIndex:=0;
end;

procedure TRTFRepDialog2.SendMail;
var L: TStringList;
begin
  if RepDlgInfo.UseMapi then
  begin
    L:=TStringList.Create;
    try
      L.Add(smSendTo+'='+RepDlgInfo.MailTo);
      L.Add(smSubject+'='+sReport+': '+ExtractFileName(fRep.Caption));
      L.Add(smAttachedFile+'='+fOut.Caption);
      L.SaveToFile(GetAppPath+smIniFile);
    except
      on E: Exception do DlgE(E.Message);
    end;
    L.Free;
    RunFile(GetAppPath+smRunFile,'','',SW_SHOW);
  end
  else RunFile(RepDlgInfo.MailApp,'"'+fOut.Caption+'"','',SW_SHOW);
end;

procedure TRTFRepDialog2.btShowClick(Sender: TObject);
begin
  VerChanged:=false;
  RTFRep2.ReportFile:=fRep.Caption;
  RTFRep2.OutputFile:=fOut.Caption;
  RTFRep2.DefaultCharset:=eCharset.AsInteger;
  RTFRep2.FieldNotFoundValue:=eNotFound.Text;
  RTFRep2.Variables.Assign(eVar.Lines);
  RTFRep2.OnReadInfo:=OnReadInfo;
  if Sender=btShow then RTFRep2.ActionAfter:=aaShow
  else if Sender=btPrint then RTFRep2.ActionAfter:=aaPrint
       else RTFRep2.ActionAfter:=aaNone;
  if RunRTF(RepInfo[pc.TabIndex].DataSets,eVer.AsInteger) then
  begin
    if (Sender=btMail) then SendMail;
  end;
  if VerChanged then btShowClick(Sender)
  else if Assigned(RepDlgInfo.OnAfterRun) then RepDlgInfo.OnAfterRun(nil);
end;

procedure TRTFRepDialog2.OnReadInfo(Sender: TObject);
var L: TStrings;
    ver: integer;
    s: string;
begin
  L:=RTFRep2.ExtendedInfo;
  if Assigned(L) then
  begin
    //check Version
    try
      ver:=StrToInt(L.Values['ver']);
      if ver in [1,2] then
        if ver<>eVer.AsInteger then
        begin
          eVer.AsInteger:=ver;
          Aborted:=true;
          VerChanged:=true;
        end;
    except
    end;
    // check Printer
    s:=L.Values['PrinterName'];
    if (s<>'') then RTFRep2.PrinterName:=s;
  end;
  if not VerChanged then
    if Assigned(RepDlgInfo.OnReadInfo) then RepDlgInfo.OnReadInfo(L);
end;

procedure TRTFRepDialog2.RTFRep1ReportProcess(Sender: TObject;
  RecNbr: Integer; var Abort: Boolean);
begin
  lNum.Caption:=IntToStr(RecNbr);
  lNum.Update;
  Abort:=Aborted;
end;

procedure TRTFRepDialog2.btEditClick(Sender: TObject);
begin
  if Assigned(RepDlgInfo.OnBeforeEdit) then RepDlgInfo.OnBeforeEdit(nil);
  RunFile(fRep.Caption,'','',SW_SHOW);
end;

procedure TRTFRepDialog2.btAbortClick(Sender: TObject);
begin
  Aborted:=true;
end;

procedure TRTFRepDialog2.btOpenClick(Sender: TObject);
begin
  OpenDlg.FileName:=fRep.Caption;
  if OpenDlg.Execute then fRep.Caption:=OpenDlg.FileName;
end;

procedure TRTFRepDialog2.btSaveClick(Sender: TObject);
begin
  SaveDlg.FileName:=fOut.Caption;
  if SaveDlg.Execute then fOut.Caption:=SaveDlg.FileName;
end;

function TRTFRepDialog2.FormHelp(Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;
begin
  CallHelp:=false;
  Result:=true;
  if (Command=HELP_CONTEXTPOPUP) then
    if Assigned(ProcOnHelp) then ProcOnHelp(Self,Data);
end;

end.

