unit PropSave_DTEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, PropSaveMain;

type
  TPropSave_DTEditForm = class(TForm)
    tc: TTabControl;
    btClose: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    lbSave: TListBox;
    lbComps: TListBox;
    btMove1: TButton;
    btMoveAll: TButton;
    btDel1: TButton;
    btDelAll: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btCloseClick(Sender: TObject);
    procedure tcChange(Sender: TObject);
    procedure tcChanging(Sender: TObject; var AllowChange: Boolean);
    procedure btMove1Click(Sender: TObject);
    procedure btMoveAllClick(Sender: TObject);
    procedure btDel1Click(Sender: TObject);
    procedure btDelAllClick(Sender: TObject);
  private
    { Private declarations }
    Form: TForm;
    List: array [0..1] of TStrings;
    CPS: array [0..1] of TCustomPropSave;
    procedure LoadProps;
    procedure SetProps;
    procedure ShowControls;
  public
    { Public declarations }
  end;

function ShowPropertySaverEditor(Component: TComponent): boolean;

implementation

{$R *.dfm}

uses TypInfo, rtool, rdlg;

const cTag='Tag';

function ShowPropertySaverEditor(Component: TComponent): boolean;
var F: TPropSave_DTEditForm;
begin
  Result:=true;
  F:=TPropSave_DTEditForm.Create(Application);
  try
    F.Caption:=Component.Name;
    F.Form:=Component.Owner as TForm;
    F.tc.Tabs.Clear;
    if Component is TPropSaveMain then
    begin
      F.tc.Tabs.Add('StdCtrl');
      F.CPS[0]:=GetObjectProp(Component,'StdCtrl') as TCustomPropSave;
      F.List[0]:=F.CPS[0].Components as TStrings;
      F.tc.Tabs.Add('CtrlPosition');
      F.CPS[1]:=GetObjectProp(Component,'CtrlPosition') as TCustomPropSave;
      F.List[1]:=F.Cps[1].Components as TStrings;
    end
    else
    if Component is TCustomPropSave then
    begin
      F.tc.Tabs.Add('Components');
      F.CPS[0]:=Component as TCustomPropSave;
      F.List[0]:=GetObjectProp(Component,'Components') as TStrings;
    end
    else raise Exception.Create('Unknown component type.');
    F.ShowModal;
  finally
    F.Free;
  end;
end;

procedure TPropSave_DTEditForm.FormShow(Sender: TObject);
begin
  tc.TabIndex:=0;
  lbSave.Items.Assign(List[0]);
  LoadProps;
end;

procedure TPropSave_DTEditForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  SetProps;
end;

procedure TPropSave_DTEditForm.LoadProps;
begin
  ShowControls;
end;

procedure TPropSave_DTEditForm.SetProps;
begin
  List[tc.TabIndex].Assign(lbSave.Items);
end;

procedure TPropSave_DTEditForm.btCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TPropSave_DTEditForm.ShowControls;
  procedure AddComp(C: TComponent; Prefix: string);
  var x: integer;
  begin
    for x:=0 to C.ComponentCount-1 do
    begin
      if CPS[tc.TabIndex].CanSave(C.Components[x]) then
        if C.Components[x].Name<>'' then
          lbComps.Items.Add(Prefix+C.Components[x].Name);
      AddComp(C.Components[x],Prefix+C.Components[x].Name+'.');
    end;
  end;

begin
  lbComps.Items.Clear;
  AddComp(Form,'');
  lbComps.Sorted:=true;
end;

procedure TPropSave_DTEditForm.tcChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  SetProps;
end;

procedure TPropSave_DTEditForm.tcChange(Sender: TObject);
begin
  lbSave.Items.Assign(List[tc.TabIndex]);
  ShowControls;
end;

procedure TPropSave_DTEditForm.btMove1Click(Sender: TObject);
var s: string;
begin
  s:=lbComps.Items[lbComps.ItemIndex];
  if lbSave.Items.IndexOf(s)=-1 then lbSave.Items.Add(s);
end;

procedure TPropSave_DTEditForm.btMoveAllClick(Sender: TObject);
begin
  lbSave.Items.Assign(lbComps.Items);
end;

procedure TPropSave_DTEditForm.btDel1Click(Sender: TObject);
begin
  lbSave.DeleteSelected;
end;

procedure TPropSave_DTEditForm.btDelAllClick(Sender: TObject);
begin
  lbSave.Items.Clear;
end;

end.
