unit f_main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, PropSaveMain, Grids, ExtCtrls, GridsPropSave, ComCtrls, ToolWin,
  ImgList, ToolBarPropSave, Menus;

type
  TMainForm = class(TForm)
    PS: TPropSaveMain;
    Panel1: TPanel;
    Label1: TLabel;
    cbDropDownList: TComboBox;
    Label2: TLabel;
    cbDropDown: TComboBox;
    Label3: TLabel;
    Edit: TEdit;
    CheckBox: TCheckBox;
    RadioGroup: TRadioGroup;
    Panel3: TPanel;
    Label4: TLabel;
    ListBox: TListBox;
    StatusBar1: TStatusBar;
    Splitter1: TSplitter;
    Panel4: TPanel;
    Memo: TMemo;
    Label5: TLabel;
    FontDlg: TFontDialog;
    PSFile: TPropSaveFile;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ImageList1: TImageList;
    ToolButton5: TToolButton;
    procedure PSReadProperties(PSFile: TPropSaveFile;
      Key: String);
    procedure PSSaveProperties(PSFile: TPropSaveFile;
      Key: String);
    procedure ToolButton1Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton5Click(Sender: TObject);
  private
    { Private declarations }

  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses rtool, f_child;

procedure TMainForm.PSReadProperties(PSFile: TPropSaveFile;
  Key: String);
begin
  PSFile.ReadFont(Key+'.Memo',Memo.Font);
end;

procedure TMainForm.PSSaveProperties(PSFile: TPropSaveFile;
  Key: String);
begin
  PSFile.WriteFont(Key+'.Memo',Memo.Font);
end;

procedure TMainForm.ToolButton1Click(Sender: TObject);
begin
  ChildForm.ShowModal;
end;

procedure TMainForm.ToolButton2Click(Sender: TObject);
begin
  FontDlg.Font:=Memo.Font;
  if FontDlg.Execute then Memo.Font:=FontDlg.Font;
end;

procedure TMainForm.ToolButton3Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.ToolButton5Click(Sender: TObject);
begin
  PS.PropSaveFile.Clear;
  PS.PropSaveFile.SaveFile('');
  PS.PropSaveFile.DisableAll:=true;
  ShowMessage('Close the application and run again with default values.');
end;

end.
