unit GridsPropSave;

{
  GridsPropSave
  =============
  Date: Jan 2005
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  GridsPropSave is descendant of TCustomPropSave component and
  provides re/storing of  Grid properties.

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PropSaveMain, Grids;

type
  TGridsPropSave = class(TCustomPropSave)
  private
    FStoreMetrix: boolean;
    FStoreStrings: boolean;
    procedure SaveStrGrid(PSFile: TPropSaveFile; Key: string; SG: TStringGrid);
    procedure ReadStrGrid(PSFile: TPropSaveFile; Key: string; SG: TStringGrid);
  protected
    procedure ReadSaveProps(A: TPropSaveAction; PSFile: TPropSaveFile;
                            Key: string; Comp: TComponent); override;
  public
    constructor Create(AOwner: TComponent); override;
    function CanSave(Comp: TComponent): boolean; override;
  published
    property StoreMetrix: boolean read FStoreMetrix write FStoreMetrix;
    property StoreStrings: boolean read FStoreStrings write FStoreStrings;
  end;

procedure Register;

implementation

{$R *.res}

const
  sColCount='ColCount';
  sRowCount='RowCount';
  sRowHeight='RowHeight%d';
  sColumn='Column%d';
  sWidth='Width';

procedure Register;
begin
  RegisterComponents('Rosi', [TGridsPropSave]);
end;

constructor TGridsPropSave.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FStoreMetrix:=true;
  FStoreStrings:=true;
end;

function TGridsPropSave.CanSave(Comp: TComponent): boolean;
begin
  Result:=(Comp is TStringGrid);
end;

procedure TGridsPropSave.ReadSaveProps(A: TPropSaveAction; PSFile: TPropSaveFile;
                            Key: string; Comp: TComponent);
begin
  if (Comp is TStringGrid) then
    if A=psaRead then ReadStrGrid(PSFile,Key,Comp as TStringGrid)
                 else SaveStrGrid(PSFile,Key,Comp as TStringGrid);
end;

procedure TGridsPropSave.SaveStrGrid(PSFile: TPropSaveFile; Key: string; SG: TStringGrid);
var a: integer;
    k: string;
begin
  PSFile.WriteInteger(Key,sColCount,SG.ColCount);
  PSFile.WriteInteger(Key,sRowCount,SG.RowCount);
  if FStoreMetrix then
    for a:=0 to SG.RowCount-1 do
      PSFile.WriteInteger(Key,Format(sRowHeight,[a]),SG.RowHeights[a]);
  for a:=0 to SG.ColCount-1 do
  begin
    k:=Key+'.'+Format(sColumn,[a]);
    if FStoreMetrix then PSFile.WriteInteger(k,sWidth,SG.ColWidths[a]);
    if FStoreStrings then PSFile.WriteStrings(k,SG.Cols[a]);
  end;
end;

procedure TGridsPropSave.ReadStrGrid(PSFile: TPropSaveFile; Key: string; SG: TStringGrid);
var a: integer;
    k: string;
begin
  SG.ColCount:=PSFile.ReadInteger(Key,sColCount,SG.ColCount);
  SG.RowCount:=PSFile.ReadInteger(Key,sRowCount,SG.RowCount);
  if FStoreMetrix then
    for a:=0 to SG.RowCount-1 do
      SG.RowHeights[a]:=PSFile.ReadInteger(Key,Format(sRowHeight,[a]),SG.RowHeights[a]);
  for a:=0 to SG.ColCount-1 do
  begin
    k:=Key+'.'+Format(sColumn,[a]);
    if FStoreMetrix then SG.ColWidths[a]:=PSFile.ReadInteger(k,sWidth,SG.ColWidths[a]);
    if FStoreStrings then PSFile.ReadStrings(k,SG.Cols[a]);
  end;
end;

end.
