unit f_main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, FormatLabel, ExtCtrls, URLLabel, ComCtrls, Buttons;

type
  TMain = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet3: TTabSheet;
    GroupBox1: TGroupBox;
    lRes: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    rgIcon: TRadioGroup;
    rgBut: TRadioGroup;
    btShowDlg: TButton;
    btDlgQ: TButton;
    btDlgQ2: TButton;
    cb1: TComboBox;
    cb2: TComboBox;
    GroupBox2: TGroupBox;
    lIn: TLabel;
    Label7: TLabel;
    eInputStr: TEdit;
    Button4: TButton;
    Button5: TButton;
    Button32: TButton;
    Button33: TButton;
    GroupBox3: TGroupBox;
    Button6: TButton;
    Button7: TButton;
    Button11: TButton;
    Label8: TLabel;
    GroupBox8: TGroupBox;
    lblTest: TFormatLabel;
    Memo: TMemo;
    Panel2: TPanel;
    Label13: TLabel;
    eP1: TEdit;
    TabSheet2: TTabSheet;
    GroupBox7: TGroupBox;
    lbURL1: TURLLabel;
    lbURL2: TURLLabel;
    FormatLabel6: TFormatLabel;
    FormatLabel7: TFormatLabel;
    lbURL3: TURLLabel;
    FormatLabel8: TFormatLabel;
    lbURL4: TURLLabel;
    FormatLabel9: TFormatLabel;
    TabSheet4: TTabSheet;
    Panel1: TPanel;
    FormatLabel1: TFormatLabel;
    FormatLabel2: TFormatLabel;
    FormatLabel4: TFormatLabel;
    FormatLabel3: TFormatLabel;
    lblFont: TFormatLabel;
    FormatLabel5: TFormatLabel;
    eNum: TEdit;
    procedure btDlgQClick(Sender: TObject);
    procedure btDlgQ2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button32Click(Sender: TObject);
    procedure Button33Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lbURL4Click(Sender: TObject);
    procedure lblTestAnchorClick(Sender: TObject; LinkName: String);
    procedure lblTestGetParameter(Sender: TObject;
      var ParamStr: String);
    procedure eP1Change(Sender: TObject);
    procedure MemoChange(Sender: TObject);
    procedure btShowDlgClick(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

uses rdlg, rtool, rstring;

procedure TMain.FormCreate(Sender: TObject);
begin
  lbURL3.SetURLCommand('file:'+GetAppPath+'test.txt');
end;

procedure TMain.btShowDlgClick(Sender: TObject);
begin
  lRes.Caption:=IntToStr(
                ShowDlg(TDialogType(rgIcon.ItemIndex),
                        TButtonsType(rgBut.ItemIndex),
                        [cb1.Text,cb2.Text]));
end;

procedure TMain.btDlgQClick(Sender: TObject);
begin
  lRes.Caption:=IntToStr(DlgQ(cb1.Text));
end;

procedure TMain.btDlgQ2Click(Sender: TObject);
begin
  lRes.Caption:=IntToStr(DlgQ2(cb1.Text,cb2.Text));
end;

procedure TMain.Button4Click(Sender: TObject);
var s:string;
begin
  s:=eInputStr.Text;
  if InputStr('Caption',cb1.Text,s) then eInputStr.Text:=s;
end;

procedure TMain.Button32Click(Sender: TObject);
var s:string;
begin
  s:='';
  if InputPassword('Caption',s) then eInputStr.Text:=s;
end;

procedure TMain.Button5Click(Sender: TObject);
var i: integer;
begin
  try
    i:=StrToInt(eNum.Text);
  except
    i:=0;
  end;
  if InputInt('',cb1.Text,i) then eNum.Text:=IntToStr(i);
end;

procedure TMain.Button33Click(Sender: TObject);
var s:string;
begin
  s:=eInputStr.Text;
  if ShowInput('Caption',cb1.Text,s,500,#0) then eInputStr.Text:=s;
end;

procedure TMain.Button11Click(Sender: TObject);
begin
  ShowInfo('Loading...',Main);
  sleep(1000);
  ShowInfo('Final...',nil);
  sleep(1000);
  ShowInfo('',nil);
end;

procedure TMain.Button7Click(Sender: TObject);
begin
  try
    DlgI(IntToStr(1 div Random(1)));;
  except
    on E:Exception do ShowErr('',E,false);
  end;
end;

procedure TMain.Button6Click(Sender: TObject);
begin
  try
    DlgI(IntTostr(1 div Random(1)));;
  except
    on E:Exception do
      ShowErr('Error during calculation.',E,false);
  end;
end;

procedure TMain.lbURL4Click(Sender: TObject);
begin
  DlgI('Clicked');
end;

procedure TMain.lblTestAnchorClick(Sender: TObject;
  LinkName: String);
begin
  DlgI('Click on link named: '+LinkName);
end;

procedure TMain.lblTestGetParameter(Sender: TObject;
  var ParamStr: String);
begin
  if paramstr='p1' then ParamStr:=eP1.Text;
end;

procedure TMain.eP1Change(Sender: TObject);
begin
  lblTest.Invalidate;
end;

procedure TMain.MemoChange(Sender: TObject);
begin
  lblTest.CaptionStrings.Assign(Memo.Lines);
  lblTest.Invalidate;
end;

end.
