unit DateInterval_Form;

{
  Date Interval Form
  ==================
  Date: Sep 2002
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  DateInterval_Form is dialog for DateInterval component.

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, EditNum, EditDate, ExtCtrls, Buttons;

type
  TDIForm = class(TForm)
    btOk: TBitBtn;
    btCancel: TBitBtn;
    nbExt: TNotebook;
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    rb5: TRadioButton;
    rb4: TRadioButton;
    rb3: TRadioButton;
    rb2: TRadioButton;
    rb1: TRadioButton;
    cb1: TComboBox;
    cb2: TComboBox;
    cb3: TComboBox;
    rb0: TRadioButton;
    gb1: TGroupBox;
    btExt: TBitBtn;
    gb2: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    btAdd: TBitBtn;
    btClear: TBitBtn;
    lb2: TListBox;
    lExt: TLabel;
    eDay: TEditDate;
    eStart: TEditDate;
    eStop: TEditDate;
    eYear: TEditNum;
    eStart3: TEditDate;
    eStop3: TEditDate;
    procedure eYearExit(Sender: TObject);
    procedure rb1Click(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure btExtClick(Sender: TObject);
    procedure btAddClick(Sender: TObject);
    procedure btClearClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    procedure SetBtn;
  public
    { Public declarations }
  end;


implementation

{$R *.DFM}

uses rdlg, rtool, rstring;

//*******************************************************************
//Form action
procedure TDIForm.FormShow(Sender: TObject);
begin
  btOk.SetFocus;
  eStart3.Text:='';
  eStop3.Text:='';
end;

//*******************************************************************
//Internal functions
procedure TDIForm.SetBtn;
begin
  try
    if nbExt.PageIndex=0 then
    begin
      btExt.Caption:='>>';
      eDay.Enabled:=rb0.Checked;
      cb1.Enabled:=rb1.Checked;
      cb2.Enabled:=rb2.Checked;
      cb3.Enabled:=rb3.Checked;
      eYear.Enabled:=not (rb5.Checked or rb0.Checked);
      eStart.Enabled:=rb5.Checked;
      eStop.Enabled:=rb5.Checked;
      btOk.Enabled:=not ((rb0.Checked and (eDay.Text='')) or
                         (rb5.Checked and ((eStart.Text='') or (eStop.Text=''))));
    end
    else
    begin
      btExt.Caption:='<<';
      btAdd.Enabled:=not ((eStart3.Text='') or (eStop3.Text=''));
      btClear.Enabled:=lb2.ItemIndex>=0;
      btOk.Enabled:=lb2.Items.Count>0;
    end;
  except
  end;
end;

procedure TDIForm.rb1Click(Sender: TObject);
begin
  SetBtn;
end;

procedure TDIForm.eYearExit(Sender: TObject);
begin
end;


//*******************************************************************
//Button functions
procedure TDIForm.btOkClick(Sender: TObject);
begin
  if nbExt.PageIndex=0 then
  begin
    if rb0.Checked then
      if eDay.Text='' then Exit;
    if rb5.Checked then
    begin
      if eStart.Text='' then Exit;
      if eStop.Text='' then Exit;
      if eStart.DateValue>eStop.DateValue then
      begin
        DlgE2(sInputErr,sDateIntervalErr);
        Exit;
      end;
    end;
  end;
  ModalResult:=mrOK;
end;

procedure TDIForm.btExtClick(Sender: TObject);
begin
  if nbExt.PageIndex=0 then nbExt.PageIndex:=1
                       else nbExt.PageIndex:=0;
  SetBtn;
end;

procedure TDIForm.btAddClick(Sender: TObject);
begin
  if eStart3.Text='' then Exit;
  if eStop3.Text='' then Exit;
  if eStart3.DateValue>eStop3.DateValue then
  begin
    DlgE2(sInputErr,sDateIntervalErr);
    Exit;
  end;
  lb2.Items.Add(eStart3.Text+' - '+eStop3.Text);
  eStart3.Text:='';
  eStop3.Text:='';
  eStart3.SetFocus;
  SetBtn;
end;

procedure TDIForm.btClearClick(Sender: TObject);
var i: integer;
begin
  if lb2.ItemIndex<0 then Exit;
  i:=lb2.ItemIndex;
  lb2.Items.Delete(i);
  if i>=lb2.Items.Count then Dec(i);
  lb2.ItemIndex:=i;
  SetBtn;
end;

end.
