unit DBGridsPropSave;

{
  DBGridsPropSave
  ===============
  Date: Jan 2005
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  DBGridsPropSave is descendant of TCustomPropSave component and
  provides re/storing of DBGrid properties.

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, PropSaveMain, DB, dbgrids, dbctrls;

type
  TDBGridsPropSave = class(TCustomPropSave)
  private
    FStoreColumnsProp: boolean;
    procedure SaveDBGrid(PSFile: TPropSaveFile; Key: string; SG: TDBGrid);
    procedure ReadDBGrid(PSFile: TPropSaveFile; Key: string; SG: TDBGrid);
    procedure SaveDataSet(PSFile: TPropSaveFile; Key: string; DS: TDataSet);
    procedure ReadDataSet(PSFile: TPropSaveFile; Key: string; DS: TDataSet);
  protected
    procedure ReadSaveProps(A: TPropSaveAction; PSFile: TPropSaveFile;
                            Key: string; Comp: TComponent); override;
  public
    function CanSave(Comp: TComponent): boolean; override;
  published
    property StoreColumnsProp: boolean
      read FStoreColumnsProp write FStoreColumnsProp;
  end;

procedure Register;

implementation

{$R *.res}

const
  sColCount='ColCount';
  sColumn='Column%d';
  sFieldName='FieldName';
  sColWidth='ColWidth';
  sColVisible='ColVisible';

  sColColor='ColColor';
  sColFont='ColFont';
  sColAlign='ColAlign';
  sColTitle='ColTitle';

  sFieldCount='FieldCount';
  sField='Field%d';
  sFieldWidth='FieldWidth';
  sFieldFormat='FieldFormat';
  sFieldVisible='FieldVisible';

  sText='Text';

  sItemsCount='ItemsCount';
  sItemIndex='ItemIndex';
  sItemSel='Selected%d';
  sItem='Item%d';

procedure Register;
begin
  RegisterComponents('Rosi', [TDBGridsPropSave]);
end;

function TDBGridsPropSave.CanSave(Comp: TComponent): boolean;
begin
  Result:=(Comp is TDBComboBox)
       or (Comp is TDBGrid)
       or (Comp is TDataSet);
end;

procedure TDBGridsPropSave.ReadSaveProps(A: TPropSaveAction; PSFile: TPropSaveFile;
                            Key: string; Comp: TComponent);

  procedure RSDBComboBox(CB: TDBComboBox);
  begin
    if A=psaSave then
    begin
      PSFile.WriteStrings(Key,CB.Items);
    end
    else
    begin
      PSFile.ReadStrings(Key,CB.Items);
    end;
  end;

begin
  if (Comp is TDBComboBox) then RSDBComboBox(Comp as TDBComboBox)
  else
  if (Comp is TDBGrid) then
  begin
    if A=psaRead then ReadDBGrid(PSFile,Key,Comp as TDBGrid)
                 else SaveDBGrid(PSFile,Key,Comp as TDBGrid);
  end
  else
  if (Comp is TDataSet) then
  begin
    if A=psaRead then ReadDataSet(PSFile,Key,Comp as TDataSet)
                 else SaveDataSet(PSFile,Key,Comp as TDataSet);
  end
end;

procedure TDBGridsPropSave.SaveDBGrid(PSFile: TPropSaveFile; Key: string; SG: TDBGrid);
var a: integer;
    k: string;
    c: TColumn;
begin
  PSFile.WriteInteger(Key,sColCount,SG.Columns.Count);
  for a:=0 to SG.Columns.Count-1 do
  begin
    c:=SG.Columns[a];
    k:=Key+'.'+Format(sColumn,[a]);
    // Save column position
    PSFile.WriteString(k,sFieldName,c.FieldName);
    if c.Visible then PSFile.WriteInteger(k,sColWidth,c.Width);
    PSFile.WriteBool(k,sColVisible,c.Visible);

    // Save column props
    if FStoreColumnsProp then
    begin
      PSFile.WriteInteger(k,sColColor,c.Color);
      PSFile.WriteFont(k,c.Font);
      PSFile.WriteInteger(k,sColAlign,Ord(c.Alignment));
      PSFile.WriteString(k,sColTitle,c.Title.Caption);

      if c.Field<>nil then
      begin
        PSFile.WriteInteger(k,sFieldWidth,c.Field.DisplayWidth);
        if (c.Field is TNumericField) then
          PSFile.WriteString(k,sFieldFormat,(c.Field as TNumericField).DisplayFormat);
        if (c.Field is TDateTimeField) then
          PSFile.WriteString(k,sFieldFormat,(c.Field as TDateTimeField).DisplayFormat);
      end;
    end;
  end;
end;

procedure TDBGridsPropSave.ReadDBGrid(PSFile: TPropSaveFile; Key: string; SG: TDBGrid);
var a, b, p: integer;
    k, fn: string;
    c: TColumn;
begin
  p:=PSFile.ReadInteger(Key,sColCount,-1);
  if p<>SG.Columns.Count then
  for a:=0 to 1000 do
  begin
    k:=Key+'.'+Format(sColumn,[a]);
    if PSFile.SectionExists(k) then PSFile.EraseSection(k)
                               else Break;
  end
  else
  for a:=0 to p-1 do
  begin
    k:=Key+'.'+Format(sColumn,[a]);
    // Read column position
    fn:=PSFile.ReadString(k,sFieldName,'');
    for b:=0 to p-1 do
      if SG.Columns[b].FieldName=fn then SG.Columns[b].Index:=a;

    c:=SG.Columns[a];
    c.Width:=PSFile.ReadInteger(k,sColWidth,c.Width);
    c.Visible:=PSFile.ReadBool(k,sColVisible,c.Visible);

    // Read column props
    if FStoreColumnsProp then
    begin
      c.Color:=PSFile.ReadInteger(k,sColColor,c.Color);

      PSFile.ReadFont(k,c.Font);
      c.Title.Font.Assign(c.Font);

      c.Alignment:=TAlignment(PSFile.ReadInteger(k,sColAlign,ord(c.Alignment)));
      c.Title.Alignment:=c.Alignment;

      c.Title.Caption:=PSFile.ReadString(k,sColTitle,c.Title.Caption);

      if c.Field<>nil then
      begin
        c.Field.Alignment:=c.Alignment;
        c.Field.DisplayLabel:=c.Title.Caption;
        c.Field.DisplayWidth:=PSFile.ReadInteger(k,sFieldWidth,c.Field.DisplayWidth);
        if (c.Field is TNumericField) then
          (c.Field as TNumericField).DisplayFormat:=
            PSFile.ReadString(k,sFieldFormat,(c.Field as TNumericField).DisplayFormat);
        if (c.Field is TDateTimeField) then
          (c.Field as TDateTimeField).DisplayFormat:=
            PSFile.ReadString(k,sFieldFormat,(c.Field as TDateTimeField).DisplayFormat);
      end;
    end;
  end;
end;

procedure TDBGridsPropSave.SaveDataSet(PSFile: TPropSaveFile; Key: string; DS: TDataSet);
var a: integer;
    k: string;
    F: TField;
begin
  PSFile.WriteInteger(Key,sFieldCount,DS.Fields.Count);
  for a:=0 to DS.Fields.Count-1 do
  begin
    F:=DS.Fields[a];
    k:=Key+'.'+Format(sField,[a]);
    // Save column position
    PSFile.WriteString(k,sFieldName,F.FieldName);
    PSFile.WriteInteger(k,sFieldWidth,F.DisplayWidth);
    PSFile.WriteBool(k,sFieldVisible,F.Visible);
    // Save column props
    if FStoreColumnsProp then
    begin
      PSFile.WriteInteger(k,sColAlign,Ord(F.Alignment));
      PSFile.WriteString(k,sColTitle,F.DisplayLabel);
      if (F is TNumericField) then
        PSFile.WriteString(k,sFieldFormat,(F as TNumericField).DisplayFormat);
      if (F is TDateTimeField) then
        PSFile.WriteString(k,sFieldFormat,(F as TDateTimeField).DisplayFormat);
    end;
  end;
end;

procedure TDBGridsPropSave.ReadDataSet(PSFile: TPropSaveFile; Key: string; DS: TDataSet);
var a, b, p: integer;
    k, fn: string;
    F: TField;
begin
  p:=PSFile.ReadInteger(Key,sFieldCount,-1);
  if p<>DS.Fields.Count then
  for a:=0 to 1000 do
  begin
    k:=Key+'.'+Format(sField,[a]);
    if PSFile.SectionExists(k) then PSFile.EraseSection(k)
                               else Break;
  end
  else
  for a:=0 to p-1 do
  begin
    k:=Key+'.'+Format(sField,[a]);
    // Read column position
    fn:=PSFile.ReadString(k,sFieldName,'');
    for b:=0 to p-1 do
      if DS.Fields[b].FieldName=fn then DS.Fields[b].Index:=a;
    F:=DS.Fields[a];
    F.DisplayWidth:=PSFile.ReadInteger(k,sFieldWidth,F.DisplayWidth);
    F.Visible:=PSFile.ReadBool(k,sFieldVisible,F.Visible);

    // Read column props
    if FStoreColumnsProp then
    begin
      F.Alignment:=TAlignment(PSFile.ReadInteger(k,sColAlign,ord(F.Alignment)));
      F.DisplayLabel:=PSFile.ReadString(k,sColTitle,F.DisplayLabel);
      if (F is TNumericField) then
        (F as TNumericField).DisplayFormat:=
          PSFile.ReadString(k,sFieldFormat,(F as TNumericField).DisplayFormat);
      if (F is TDateTimeField) then
        (F as TDateTimeField).DisplayFormat:=
          PSFile.ReadString(k,sFieldFormat,(F as TDateTimeField).DisplayFormat);
    end;
  end;
end;

end.
