unit f_univedit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, ADODB, DBCtrls, rDBComponents, StdCtrls, Mask,
  ComCtrls, Buttons, ToolWin, Grids, DBGrids, rDBGrid,
  fr_dbeditbar, fr_dbtoolbar_short, FormatLabel, ExtCtrls, PropSaveMain,
  rImpComps, Menus, DBGridsPropSave, rDBGridsPropSave;

type
  TUnivEdit = class(TForm)
    ds: TDataSource;
    pc: TPageControl;
    ts1: TTabSheet;
    pEdit: TPanel;
    pComp: TPanel;
    tbEdit2: TrToolBar;
    ToolButton1: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    pGrid: TPanel;
    fl1: TFormatLabel;
    gr: TrDBGrid;
    tbEdit1: TrToolBar;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    rDBToolBarShort1: TrDBToolBarShort;
    FormatLabel1: TFormatLabel;
    sbEdit: TScrollBox;
    PropSaveMain1: TPropSaveMain;
    Panel1: TPanel;
    Panel2: TPanel;
    btClose: TBitBtn;
    Splitter1: TSplitter;
    pmRef: TPopupMenu;
    mnRef: TMenuItem;
    rDBGridsPropSave1: TrDBGridsPropSave;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure grEnter(Sender: TObject);
    procedure grChangeSort(Sender: TObject; DataSet: TDataSet;
  SortFieldName: String; SortDesc: Boolean; var Accept: Boolean);
    procedure grRefreshData(Sender: TObject);
    procedure dsStateChange(Sender: TObject);
    procedure pcChanging(Sender: TObject; var AllowChange: Boolean);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btCloseClick(Sender: TObject);
    procedure Splitter1Moved(Sender: TObject);
    procedure grTitleExClick(Sender: TObject);
    procedure mnRefClick(Sender: TObject);
  private
    { Private declarations }
    MRes: integer;
  public
    { Public declarations }
  end;

var
  UnivEdit: TUnivEdit;

implementation

uses rstring, rdlg, rtool, rdbtool, rdbtool_ADO,
  dm_rdbaction;

{$R *.dfm}

procedure TUnivEdit.FormCreate(Sender: TObject);
begin
  RequeryExADO(gr.Datasource.DataSet as TCustomADODataSet,nil);
  CreateDBControls(gr.DataSource,sbEdit,false,true);
end;

procedure TUnivEdit.FormShow(Sender: TObject);
begin
  MRes:=mrCancel;
  pc.ActivePageIndex:=0;
end;

procedure TUnivEdit.FormActivate(Sender: TObject);
begin
  rDBAction.SetActiveGrid(gr);
  gr.ReSort;
  NCursor;
end;

procedure TUnivEdit.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  try
    gr.DataSource.DataSet.Cancel;
  except
  end;
  ModalResult:=MRes;
end;

procedure TUnivEdit.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose:=rDBAction.CheckEditState(true);
end;

procedure TUnivEdit.FormDestroy(Sender: TObject);
begin
  try
    gr.DataSource.DataSet.Close;
  except
  end;
end;

procedure TUnivEdit.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  rDBAction.CheckShortcut(Key,Shift);
end;

procedure TUnivEdit.btCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TUnivEdit.Splitter1Moved(Sender: TObject);
begin
//  tbEdit1.RefButtPos;
//  tbEdit2.RefButtPos;
end;

procedure TUnivEdit.pcChanging(Sender: TObject; var AllowChange: Boolean);
begin
  AllowChange:=rDBAction.CheckEditState(true);
end;

procedure TUnivEdit.grEnter(Sender: TObject);
begin
  rDBAction.SetActiveGrid(Sender as TrDBGrid);
end;

procedure TUnivEdit.grChangeSort(Sender: TObject; DataSet: TDataSet;
  SortFieldName: String; SortDesc: Boolean; var Accept: Boolean);
begin
  ChangeSortADO(DataSet as TCustomADODataSet,SortFieldName,SortDesc,Accept);
end;

procedure TUnivEdit.grRefreshData(Sender: TObject);
begin
  RequeryGridADO(Sender as TDBGrid);
end;

procedure TUnivEdit.grTitleExClick(Sender: TObject);
begin
  ShowRecordCount(Sender as TDBGrid);
end;

procedure TUnivEdit.dsStateChange(Sender: TObject);
begin
  if IsEditing(gr) then
  try
    pComp.SetFocus;
    FocusNextControl(Self);
  except
  end;
  gr.Enabled:=not IsEditing(gr);
  if not IsEditing(gr) then
  try
    gr.SetFocus;
  except
  end;
end;

procedure TUnivEdit.mnRefClick(Sender: TObject);
begin
  CreateDBControls(gr.DataSource,sbEdit,false,true);
end;

end.
