unit dm_rdbaction;

{
 rDBActions
 ==========
 Date: Jan 2005
 Author: Rosinsky (http://sweb.cz/rosisoft)

 rDBAction is set of database actions, menus and toolbars,
 which can be easilly used in application in various situation.
 rDBAction with other rDB-units helps you to create user friendly
 database application very quickly and simply.

 All actions automatically change their state (enability and visibility)
 according dataset state and tag value of Grid, ev. according user rights.
 All actions can be used by any components in your application,
 as buttons, toolbars etc.

 Common using:
 1/ rDBAction with DBGrid and TolBars
    - provide all important database functions as searching, sorting,
      filtering, exporting etc.
 2/ rDBAction with DBComponents and Buttond
    - provide all function for editing, posting

 for more information see DEMO on sweb.cz/rosisoft

 // ************************************************************************ //

 Enabling and showing of Actions depends on TAG value of Active Grid,
 on UserRights value and on TAG value of each action

 TAG value of Actions:
 =====================
 tag value of each action defines when the action is visibled or enabled

  format: XYZZ
    X - user rights for non edit actions
    Y - user rights for edit actions
    ZZ - bitmask for disable according Dataset state

  typical vaules of Y - user rights for edit values
    1: TOOL actions
    2: TOOL and ADD record actions
    3: enable TOOL, ADD and EDIT record actions
    4: enable TOOL, ADD, EDIT and DELETE Actions

  Bitmask for disable each action according Dataset state:
    1: Inactive
    2: ReadOnly
    4: IsEmpty
    8: Browse
    16: Edit
    32: Insert

  Typical values of ZZ for disabling according dataset state:
    ADD record: 0251 (Insert+Edit+ReadOnly+Inactive)
    EDIT record: 0355 (Insert+Edit+ReadOnly+IsEmpty+Inactive)
    DELETE record: 0455 (Insert+Edit+ReadOnly+IsEmpty+Inactive)
    TOOL Button: 1049  (Insert+Edit+Inactive)
    SAVE or CANCEL record: 0315  (Browse+IsEmpty+ReadOnly+Inactive)
    EXIT Button: 0048  (Insert+Edit)


 TAG value of Grid:
 ==================
 tag value of grid defines which action is visible and accessible
 with this grid
 bitmask for hiding Actions according TAG value of Grid
    -1: disable all Actions
     1: hide whole Edit menu
     2: hide whole Sort menu
     4: hide whole Filter menu
     8: hide whole Columns menu
    16: dummy
    32: dummy
    64: dummy
   128: hide action acoClose
   256: hide action aceDuplic
   512: hide action aceSaveAdd
  1024: hide action aceAdd
  2048: hide action aceEdit
  4096: hide action aceDelete
  8192: hide action aceAutoEdit

 typical values of TAG value of Grid:
    all actions: 0
    not editing: 1 or 3841
      only Edit: 3840


 UserRights value (00 - 99):
 ===========================
 user rights value defines action is visible and accessible
 format: XY
   X - user rights for non edit actions
   Y - user rights for edit actions

 rDBAction disable actions if
     UserRights part (X or Y) < part of Tag value of Action (X or Y)

}


interface

uses
  Windows, SysUtils, Classes, Menus, Forms, Controls, StdCtrls, Buttons,
  ActnList, ActnMan, ImgList, DB, DBGrids, rDBGrid, ComCtrls;

type
  TrDBAction = class(TDataModule)
    Images: TImageList;
    ActionMng: TActionManager;
    aceAdd: TAction;
    aceDuplic: TAction;
    aceEdit: TAction;
    aceDelete: TAction;
    aceSave: TAction;
    aceSaveAdd: TAction;
    aceCancel: TAction;
    acoFind: TAction;
    acfFilterSel: TAction;
    acfFilterSelAnd: TAction;
    acfFilterSelOr: TAction;
    acfFilterForm: TAction;
    acfFilter: TAction;
    accColumns: TAction;
    acsSort1: TAction;
    acsSort2: TAction;
    acoExport: TAction;
    acoPrint: TAction;
    acoProperties: TAction;
    acoRefresh: TAction;
    accWidthAuto: TAction;
    accWidthSame: TAction;
    accWidthDefault: TAction;
    acsSortNone: TAction;
    acfFilterSave: TAction;
    acfFilterLoad: TAction;
    aceAutoEdit: TAction;
    acoClose: TAction;
    aceAdd2: TAction;
    pmDBAction: TPopupMenu;
    mnEdit1: TMenuItem;
    aceAdd1: TMenuItem;
    aceDuplic1: TMenuItem;
    aceEdit1: TMenuItem;
    aceDelete1: TMenuItem;
    mnN11: TMenuItem;
    aceSave1: TMenuItem;
    aceSaveAdd1: TMenuItem;
    aceCancel1: TMenuItem;
    mnN12: TMenuItem;
    mnAutoEdit: TMenuItem;
    aceAdd21: TMenuItem;
    mnN1: TMenuItem;
    mnFind1: TMenuItem;
    mnSort1: TMenuItem;
    mnSort12: TMenuItem;
    mnSort22: TMenuItem;
    mnN21: TMenuItem;
    mnSortNone2: TMenuItem;
    mnFilter1: TMenuItem;
    mnFilterSel1: TMenuItem;
    mnFilterAnd1: TMenuItem;
    mnFilterOr1: TMenuItem;
    mnFilterForm1: TMenuItem;
    mnN31: TMenuItem;
    mnFilter21: TMenuItem;
    mnN32: TMenuItem;
    mnFilterSave1: TMenuItem;
    mnFilterLoad1: TMenuItem;
    mnN2: TMenuItem;
    mnColumns1: TMenuItem;
    mnColumns2: TMenuItem;
    mnN41: TMenuItem;
    mnWidthAuto1: TMenuItem;
    mnWidthSame1: TMenuItem;
    mnWidthDefault1: TMenuItem;
    mnProperties1: TMenuItem;
    mnN3: TMenuItem;
    mnExport1: TMenuItem;
    mnRefresh1: TMenuItem;
    pmFilterSel: TPopupMenu;
    mnFilterSelAnd: TMenuItem;
    mnFilterSelOr: TMenuItem;
    mnFilterNot: TMenuItem;
    pmFilterSave: TPopupMenu;
    mnFilterSave: TMenuItem;
    mnFilterLoad: TMenuItem;
    pmColumnWidth: TPopupMenu;
    mnWidthAuto: TMenuItem;
    mnWidthSame: TMenuItem;
    mnWidthDefault: TMenuItem;
    acsSort3: TAction;
    accWidthData: TAction;
    mnWidthData: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    mnWidthData1: TMenuItem;
    mnSort32: TMenuItem;
    aceSave2: TAction;
    aceSave21: TMenuItem;
    acdIfBrowse: TAction;
    acdIfBrowseNotBOF: TAction;
    acdIfBrowseNotEOF: TAction;
    pmEditToolBar: TPopupMenu;
    acetbCaptions: TAction;
    acetbList: TAction;
    acetbAutoSize: TAction;
    mnCaptions: TMenuItem;
    mnList: TMenuItem;
    mnAutoSize: TMenuItem;
    N3: TMenuItem;
    procedure DataModuleCreate(Sender: TObject);
    procedure ActionMngUpdate(Action: TBasicAction; var Handled: Boolean);
    procedure aceAddExecute(Sender: TObject);
    procedure accColumnsExecute(Sender: TObject);
    procedure accWidthAutoExecute(Sender: TObject);
    procedure accWidthSameExecute(Sender: TObject);
    procedure accWidthDefaultExecute(Sender: TObject);
    procedure acfFilterSelExecute(Sender: TObject);
    procedure acsSort1Execute(Sender: TObject);
    procedure acsSortNoneExecute(Sender: TObject);
    procedure acoFindExecute(Sender: TObject);
    procedure acoExportExecute(Sender: TObject);
    procedure acoPropertiesExecute(Sender: TObject);
    procedure acoRefreshExecute(Sender: TObject);
    procedure acoCloseExecute(Sender: TObject);
    procedure accWidthDataExecute(Sender: TObject);
    procedure acdIfBrowseExecute(Sender: TObject);
    procedure pmDBActionPopup(Sender: TObject);
    procedure pmEditToolBarPopup(Sender: TObject);
    procedure acetbCaptionsExecute(Sender: TObject);
  private
    { Private declarations }
    G: TrDBGrid;
    URights: integer;
    URightsEdit: integer;
    acShortCuts: array of integer;
    acEditSC: integer;
    function IsUserRightsOk(A: TAction): boolean;
    procedure pmEditToolBarClick(Sender: TObject);
  public
    { Public declarations }
    procedure SetActiveGrid(Grid: TrDBGrid);
    procedure SetUserRights(actRights: integer);
    procedure AddDBToolMenu(M: TMenuItem);
    function CheckEditState(ShowDialog: boolean): boolean;
    procedure CheckShortcut(var Key: Word; Shift: TShiftState);
    procedure RefreshAction;
  end;

var
  rDBAction: TrDBAction;

implementation

{$R *.dfm}

uses rstring, rdlg, rdbtool, rDBFind, rDBFilter, rDBFields, rDBExport,
  rDBGridProps, rDBFilterSaver;

const
  acCatMax=3;
  acCatStr: array [0..acCatMax] of string = ('Edit','Sort','Filter','Column');
  acCatMask: array [0..acCatMax] of integer = (1,2,4,8);

  acSpecMax=6;
  acSpecStr: array [0..acSpecMax] of string =
    ('acoClose','aceDuplic','aceSaveAdd','aceAdd','aceEdit','aceDelete','aceAutoEdit');
  acSpecMask: array [0..acSpecMax] of integer = (128,256,512,1024,2048,4096,8192);

procedure TrDBAction.DataModuleCreate(Sender: TObject);
var i: integer;
begin
  G:=nil;
  // save old shortcuts
  SetLength(acShortCuts,ActionMng.ActionCount);
  for i:=0 to ActionMng.ActionCount-1 do
    acShortCuts[i]:=(ActionMng.Actions[i] as TAction).ShortCut;
  acEditSC:=aceEdit.ShortCut;
  SetUserRights(99);
//  RefreshAction;
end;

procedure TrDBAction.ActionMngUpdate(Action: TBasicAction;
  var Handled: Boolean);
begin
  RefreshAction;
  Handled:=true;
end;

procedure TrDBAction.SetActiveGrid(Grid: TrDBGrid);
begin
  G:=Grid;
  RefreshAction;
end;

procedure TrDBAction.SetUserRights(actRights: integer);
begin
  if actRights in [00..99] then
  begin
    URights:=actRights div 10;
    URightsEdit:=actRights mod 10;
    RefreshAction;
  end
  else Exception.Create('Invalid user rights value.');
end;

function TrDBAction.IsUserRightsOk(A: TAction): boolean;
begin
  if A.Category='Edit' then Result:=((A.Tag div 100) mod 10)<=URightsEdit
                       else Result:=((A.Tag div 1000) mod 10)<=URights;
end;

procedure TrDBAction.AddDBToolMenu(M: TMenuItem);
var a: integer;
    procedure CopyItems(miFrom, miTo: TMenuItem);
    var i: integer;
        newm: TMenuItem;
    begin
      newm:=TMenuItem.Create(miTo.Owner);
      newm.Caption:=miFrom.Caption;
      newm.Action:=miFrom.Action;
      for i:=0 to miFrom.Count-1 do
        CopyItems(miFrom.Items[i],newm);
      miTo.Add(newm);
    end;
begin
  // Add Toolmenu to M
  for a:=2 to pmDBAction.Items.Count-1 do
    CopyItems(pmDBAction.Items[a],M);
end;

function TrDBAction.CheckEditState(ShowDialog: boolean): boolean;
begin
  if IsEditing(G) and ShowDialog then
  try
    case ShowDlg(dtQ,btANS,[sSaveChangesQ]) of
      mrYes: aceSave.Execute;
      mrNo: aceCancel.Execute;
    end;
  except
    on E: Exception do
      if not(E is EAbort) then ShowErr(sSaveRecordErr,E,false);
  end;
  Result:=not IsEditing(G);
end;

procedure TrDBAction.CheckShortcut(var Key: Word; Shift: TShiftState);
var i: integer;
    A: TAction;
begin
  if Key=0 then Exit;
  for i:=0 to ActionMng.ActionCount-1 do
  begin
    A:=(ActionMng.Actions[i] as TAction);
    if A.ShortCut=ShortCut(Key,Shift) then
    begin
      Key:=0;
      A.Execute;
      Break;
    end;
  end;
  if (Key in [VK_ESCAPE]) then
  begin
    aceCancel.Execute;
    Key:=0;
  end;
end;

procedure TrDBAction.RefreshAction;
var i,j,tg,grmsk: integer;
    tgEna, mskEna, Vis: boolean;
    A: TAction;
begin
  try
    tg:=G.Tag;
  except
    tg:=-1
  end;
  // set mask according grid and dataset state
  if tg=-1 then grmsk:=255
  else
  try
    case G.DataSource.DataSet.State of
      dsInsert: grmsk:=32;
      dsEdit: grmsk:=16;
      dsBrowse: grmsk:=8;
      else grmsk:=1;
    end;
    if G.DataSource.DataSet.IsEmpty then grmsk:=grmsk or 4;
    //if not (dgEditing in G.Options) then grmsk:=grmsk or 2;
  except
    grmsk:=1;
  end;

  for i:=0 to ActionMng.ActionCount-1 do
  begin
    A:=(ActionMng.Actions[i] as TAction);
    // Set Action Enable according Grid Tag
    tgEna:=true;
    for j:=0 to acCatMax do
      if A.Category=acCatStr[j] then tgEna:=tg and acCatMask[j]=0;
    // Set Action Enable according Dataset State and UserRights
    mskEna:=((A.Tag mod 100) and grmsk=0) and IsUserRightsOk(A);
    // Set Refresh action according OnRefreshData procedure
    if A=acoRefresh then mskEna:=mskEna and Assigned(G.OnRefreshData);
    // Set Action Enable
    A.Enabled:=tgEna and mskEna;
    // Set special actions visible
    Vis:=true;
    if tg<>-1 then
      for j:=0 to acSpecMax do
        if A.Name=acSpecStr[j] then Vis:=tg and acSpecMask[j]=0;
    A.Visible:=Vis and (A<>aceAdd2) and (A<>aceSave2);
    // Set shortcut
    if tgEna and Vis then A.ShortCut:=acShortCuts[i]
                     else A.ShortCut:=0;
  end;
  // Set shortcut for Edit
  // F2 is used to start to edit record and later
  // in Grid to start to edit selected field,
  // so shortcut should be deleted if aceEdit is disable
  if aceEdit.Enabled then aceEdit.ShortCut:=acEditSC
                     else aceEdit.ShortCut:=0;

  // Set Popup Menu visible
  mnEdit1.Visible:=tg and 1=0;
  mnN1.Visible:=mnEdit1.Visible;
  mnSort1.Visible:=tg and 2=0;
  mnFilter1.Visible:=tg and 4=0;
  mnColumns1.Visible:=tg and 8=0;

  // Set particular Actions
  // Disable AutoEdit if Edit is not allowed
  if not IsUserRightsOk(aceEdit) then
  try
    G.DataSource.AutoEdit:=false;
  except
  end;
  // Cancel ADDed record if Add is not allowed
//  if not IsUserRightsOk(aceAdd)then
  if not aceAdd.Visible then
    try
      if G.DataSource.DataSet.State=dsInsert then G.DataSource.DataSet.Cancel;
    except
    end;
  // Set other spec Actions
  try
    accWidthAuto.Checked:=G.ColumnWidth=cwAutoWidth;
    accWidthSame.Checked:=G.ColumnWidth=cwSameWidth;
    aceAutoEdit.Checked:=G.DataSource.AutoEdit;
    acfFilter.Checked:=G.DataSource.DataSet.Filtered;
    acfFilterSave.Enabled:=acfFilter.Checked;
    acdIfBrowseNotBOF.Enabled:=not G.DataSource.DataSet.Bof;
    acdIfBrowseNotEOF.Enabled:=not G.DataSource.DataSet.Eof;
  except
  end;
end;

procedure TrDBAction.aceAddExecute(Sender: TObject);
begin
  if (Sender=aceAdd) or (Sender=aceAdd2) then AddRecordEx(G);
  if Sender=aceDuplic then DuplicRecord(G,1);
  if Sender=aceEdit then G.DataSource.DataSet.Edit;
  if Sender=aceDelete then G.DataSource.DataSet.Delete;
  if (Sender=aceSave) or (Sender=aceSave2) then G.DataSource.DataSet.Post;
  if Sender=aceSaveAdd then
  begin
    G.DataSource.DataSet.Post;
    AddRecordEx(G);
  end;
  if Sender=aceCancel then G.DataSource.DataSet.Cancel;
  if Sender=aceAutoEdit then G.DataSource.AutoEdit:=not G.DataSource.AutoEdit;
end;

procedure TrDBAction.accColumnsExecute(Sender: TObject);
begin
  ChooseFields(G);
end;

procedure TrDBAction.accWidthAutoExecute(Sender: TObject);
begin
  if G.ColumnWidth=cwAutoWidth then G.ColumnWidth:=cwNone
                               else G.ColumnWidth:=cwAutoWidth;
end;

procedure TrDBAction.accWidthSameExecute(Sender: TObject);
begin
  if G.ColumnWidth=cwSameWidth then G.ColumnWidth:=cwNone
                               else G.ColumnWidth:=cwSameWidth;
end;

procedure TrDBAction.accWidthDataExecute(Sender: TObject);
begin
  G.ColumnWidth:=cwDataWidth;
  G.ColumnWidth:=cwNone;
end;

procedure TrDBAction.accWidthDefaultExecute(Sender: TObject);
begin
  G.ColumnWidth:=cwDefaultWidth;
  G.ColumnWidth:=cwNone;
end;

procedure TrDBAction.acfFilterSelExecute(Sender: TObject);
begin
  if Sender=acfFilterSel then FilterBySel(G,fjNone);
  if Sender=acfFilterSelAnd then FilterBySel(G,fjAnd);
  if Sender=acfFilterSelOr then FilterBySel(G,fjOr);
  if Sender=acfFilterForm then FilterRec(G);
  if Sender=acfFilter then
  try
    if G.DataSource.DataSet.Filtered then
    begin
      G.DataSource.DataSet.Filtered:=false;
    end
    else SetFilterString(G.DataSource.DataSet,G.DataSource.DataSet.Filter,true);
  except
  end;
  if Sender=acfFilterSave then SaveFilter(G);
  if Sender=acfFilterLoad then LoadFilter(G);
end;

procedure TrDBAction.acsSort1Execute(Sender: TObject);
var fn: string;
begin
  try
    fn:=G.SelectedField.FieldName;
    if Sender=acsSort3 then
    begin
      if G.PosInSortField(fn)=0 then
        G.ChangeSort(G.SortFieldName+','+fn,G.SortDesc)
    end
    else
      G.ChangeSort(G.SelectedField.FieldName,Sender=acsSort2);
  except
  end;
end;

procedure TrDBAction.acsSortNoneExecute(Sender: TObject);
begin
  G.SortFieldName:='';
  G.ChangeSort('',false);
end;

procedure TrDBAction.acoFindExecute(Sender: TObject);
begin
  FindRec(G);
end;

procedure TrDBAction.acoExportExecute(Sender: TObject);
begin
  DBExport(G,acfFilter.Enabled,accColumns.Enabled);
end;

procedure TrDBAction.acoPropertiesExecute(Sender: TObject);
begin
  DBGridProperties(G,accColumns.Enabled);
end;

procedure TrDBAction.acoRefreshExecute(Sender: TObject);
begin
  try
    G.OnRefreshData(G);
  except
  end;
end;

procedure TrDBAction.acoCloseExecute(Sender: TObject);
begin
  if CheckEditState(true) then Screen.ActiveForm.Close;
end;

procedure TrDBAction.acdIfBrowseExecute(Sender: TObject);
begin
  if Sender is TButton then
    (Sender as TButton).OnClick(Self);
  if Sender is TSpeedButton then
    (Sender as TSpeedButton).OnClick(Self);
  if Sender is TMenuItem then
    (Sender as TMenuItem).OnClick(Self);
end;

procedure TrDBAction.pmDBActionPopup(Sender: TObject);
begin
//  BUG - ShortCut doesnot set PopupComponents
//  if pmDBAction.PopupComponent is TrDBGrid then
//    SetActiveGrid(pmDBAction.PopupComponent as TrDBGrid);
end;

// PopupMenu EditToolBar
procedure TrDBAction.pmEditToolBarClick(Sender: TObject);
var tb: TToolBar;
    i: integer;
begin
  try
    tb:=pmEditToolBar.PopupComponent as TToolBar;
    i:=(Sender as TMenuItem).Tag;
    tb.Buttons[i].Visible:=(Sender as TMenuItem).Checked;
  except
    Abort;
  end;
end;

procedure TrDBAction.pmEditToolBarPopup(Sender: TObject);
var tb: TToolBar;
    i: integer;
    m: TMenuItem;
begin
  for i:=pmEditToolBar.Items.Count-1 downto 4 do pmEditToolBar.Items[i].Free;
  try
    tb:=pmEditToolBar.PopupComponent as TToolBar;
    acetbCaptions.Checked:=tb.ShowCaptions;
    acetbList.Checked:=tb.List;
    for i:=0 to tb.ButtonCount-1 do
    begin
      acetbAutoSize.Checked:=tb.Buttons[i].AutoSize;
      m:=TMenuItem.Create(pmEditToolBar.Owner);
      if tb.Buttons[i].Style in [tbsDivider,tbsSeparator] then m.Caption:='- '
      else m.Caption:=tb.Buttons[i].Caption;
      m.OnClick:=pmEditToolBarClick;
      m.Tag:=i;
      m.AutoCheck:=true;
      m.Checked:=tb.Buttons[i].Visible;
      pmEditToolBar.Items.Add(m);
    end;
  except
    Abort;
  end;
end;

procedure TrDBAction.acetbCaptionsExecute(Sender: TObject);
var tb: TToolBar;
    i: integer;
begin
  try
    tb:=pmEditToolBar.PopupComponent as TToolBar;
    if Sender=acetbCaptions then
    begin
      tb.ShowCaptions:=not tb.ShowCaptions;
      if not tb.ShowCaptions then
        for i:=0 to tb.ButtonCount-1 do tb.Buttons[i].AutoSize:=true;
    end;
    if Sender=acetbList then tb.List:=not tb.List;
    if Sender=acetbAutoSize then
      for i:=0 to tb.ButtonCount-1 do
        tb.Buttons[i].AutoSize:=not tb.Buttons[i].AutoSize;
    tb.Width:=tb.Width+1;
  except
    Abort;
  end;
end;

end.

