unit f_main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, ADODB, TXTExport, SLKExport, PropSaveMain,
  DBGridsPropSave, rDBGridsPropSave, fr_dbeditbar, fr_dbtoolbar, ComCtrls,
  StdCtrls, rDBRecView, Grids, DBGrids, rDBGrid, Buttons, ExtCtrls,
  EditNum, DBCtrls, Mask, rDBComponents, FormatLabel, RTFReport2,
  Menus, ToolBarPropSave, rdbtool, URLLabel;

const
  Ver='2.0';
  sDBFile='DB file: ';

type
  TMain = class(TForm)
    PropSaveMain1: TPropSaveMain;
    pTop: TPanel;
    btSelectDB: TBitBtn;
    RDBGridsPropSave1: TRDBGridsPropSave;
    btCloseDB: TBitBtn;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    grEmployee: TrDBGrid;
    grCustomer: TRDBGrid;
    Label2: TFormatLabel;
    Label3: TFormatLabel;
    TabSheet4: TTabSheet;
    GroupBox3: TGroupBox;
    Label5: TLabel;
    eRTFHeader: TEdit;
    lRepInfo: TLabel;
    SLKExport1: TSLKExport;
    GroupBox4: TGroupBox;
    btSLKExport: TBitBtn;
    eSLKHeader: TEdit;
    Label6: TLabel;
    GroupBox5: TGroupBox;
    btTXTExport: TBitBtn;
    TXTExport1: TTXTExport;
    btRTFDlg: TButton;
    SBar: TStatusBar;
    rDBToolBar1: TrDBToolBar;
    TabSheet5: TTabSheet;
    rDBRecView: TrDBRecView;
    Panel2: TPanel;
    cbOV: TCheckBox;
    cbOS: TCheckBox;
    Label1: TFormatLabel;
    TabSheet3: TTabSheet;
    mLog: TMemo;
    Panel1: TPanel;
    btAbout: TButton;
    PSFile: TPropSaveFile;
    TabSheet6: TTabSheet;
    grEmp2: TrDBGrid;
    TabSheet7: TTabSheet;
    grCust2: TrDBGrid;
    RTFRep2: TRTFReport2;
    btRep1: TBitBtn;
    btRep2: TBitBtn;
    mInfo: TMemo;
    ToolBarPropSave1: TToolBarPropSave;
    Label8: TFormatLabel;
    rDBEditBar1: TrDBEditBar;
    Panel3: TPanel;
    gbOpt: TGroupBox;
    Label4: TLabel;
    Label7: TLabel;
    ch11: TCheckBox;
    ch12: TCheckBox;
    ch13: TCheckBox;
    ch21: TCheckBox;
    ch23: TCheckBox;
    ch22: TCheckBox;
    chEdit: TCheckBox;
    chAS: TCheckBox;
    chAutoEdit: TCheckBox;
    ch31: TCheckBox;
    eGTag: TEditNum;
    eUR: TEditNum;
    rDBEditBar2: TrDBEditBar;
    Label9: TFormatLabel;
    GroupBox7: TGroupBox;
    FormatLabel12: TFormatLabel;
    rDBMoveButton5: TrDBMoveButton;
    rDBMoveButton6: TrDBMoveButton;
    rDBMoveButton7: TrDBMoveButton;
    rDBMoveButton8: TrDBMoveButton;
    Label10: TFormatLabel;
    btExportDlg: TBitBtn;
    FormatLabel13: TFormatLabel;
    FormatLabel14: TFormatLabel;
    FormatLabel15: TFormatLabel;
    Panel6: TPanel;
    GroupBox2: TGroupBox;
    FormatLabel4: TFormatLabel;
    rDBMoveButton1: TrDBMoveButton;
    rDBMoveButton2: TrDBMoveButton;
    rDBMoveButton4: TrDBMoveButton;
    rDBMoveButton3: TrDBMoveButton;
    GroupBox1: TGroupBox;
    FormatLabel1: TFormatLabel;
    FormatLabel9: TFormatLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    Panel4: TPanel;
    FormatLabel2: TFormatLabel;
    FormatLabel3: TFormatLabel;
    rDBEdit1: TrDBEdit;
    rDBEdit2: TrDBEdit;
    rDBEdit3: TrDBEdit;
    rDBDateTimePicker1: TrDBDateTimePicker;
    rDBDateTimePicker2: TrDBDateTimePicker;
    rDBCheckBox1: TrDBCheckBox;
    rDBMemo1: TrDBMemo;
    Panel7: TPanel;
    GroupBox6: TGroupBox;
    FormatLabel10: TFormatLabel;
    FormatLabel11: TFormatLabel;
    BitBtn6: TBitBtn;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    BitBtn9: TBitBtn;
    BitBtn10: TBitBtn;
    Panel5: TPanel;
    FormatLabel5: TFormatLabel;
    FormatLabel6: TFormatLabel;
    FormatLabel8: TFormatLabel;
    FormatLabel7: TFormatLabel;
    rDBLookupComboBox1: TrDBLookupComboBox;
    rDBComboBox1: TrDBComboBox;
    rDBLookupComboBox2: TrDBLookupComboBox;
    rDBListBox1: TrDBListBox;
    btDef: TURLLabel;
    chHelp: TCheckBox;
    procedure chEditClick(Sender: TObject);
    procedure btSelectDBClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure grEmployeeChangeSort(Sender: TObject; DataSet: TDataSet;
      SortFieldName: String; SortDesc: Boolean; var Accept: Boolean);
    procedure grEmployeeTitleExClick(Sender: TObject);
    procedure grEmployeeFixColClick(Sender: TObject);
    procedure btCloseDBClick(Sender: TObject);
    procedure RTFRep1ReportProcess(Sender: TObject; RecNbr: Integer;
      var Abort: Boolean);
    procedure btSLKExportClick(Sender: TObject);
    procedure SLKExport1BeforeExport(Sender: TObject; MaxX, MaxY: Integer);
    procedure btTXTExportClick(Sender: TObject);
    procedure btRTFDlgClick(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure cbOVClick(Sender: TObject);
    procedure cbOSClick(Sender: TObject);
    procedure grEmployeeRefreshData(Sender: TObject);
    procedure btAboutClick(Sender: TObject);
    procedure eGTagChange(Sender: TObject);
    procedure eURChange(Sender: TObject);
    procedure btBeforeEditClick(Sender: TObject);
    procedure btOnInfoClick(Sender: TObject);
    procedure PageControl1Changing(Sender: TObject;
      var AllowChange: Boolean);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btRep1Click(Sender: TObject);
    procedure btRep2Click(Sender: TObject);
    procedure RTFRep2ReadInfo(Sender: TObject);
    procedure grEmployeeLinkClick(Sender: TObject; DataSet: TDataSet;
      Column: TColumn; Field: TField; Value: Variant);
    procedure btDefClick(Sender: TObject);
    procedure chHelpClick(Sender: TObject);
  private
    { Private declarations }
//    DefaultPrinterName: string;
    procedure OnHlp(Form: TForm; HelpContext: integer);
    procedure SetControls(JustOpened: boolean);
  public
    { Public declarations }
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

uses rdlg, rtool, rdbtool_ADO, rstring,
  dm_data, f_startup, RTFRep_Dialog2, dm_rdbaction;

const
  DefaultDB='data\data2000.mdb';

procedure TMain.FormCreate(Sender: TObject);
begin
  ShowStartUpInfo(sConnecting);
  mLog.Lines.Clear;
  Data.ADOConWiz.Disconnect;
  Data.ADOConWiz.DefaultDBFile:=GetAppPath+DefaultDB;
  Data.ADOConWiz.UDLFilePath:=GetAppPath+'udl';
  Data.ADOCon.ConnectionString:='';
  if not Data.ADOConWiz.OpenAll_LastFile then Application.Terminate;
end;

procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Data.ADOConWiz.Disconnect;
  mLog.Lines.Clear;
end;

procedure TMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose:=rDBAction.CheckEditState(true);
end;

procedure TMain.FormActivate(Sender: TObject);
begin
  PageControl1.ActivePageIndex:=0;
  PageControl1Change(Self);
  SetControls(true);
  ShowStartUpInfo('');
end;

procedure TMain.PageControl1Changing(Sender: TObject;
  var AllowChange: Boolean);
begin
  AllowChange:=rDBAction.CheckEditState(true);
end;

procedure TMain.PageControl1Change(Sender: TObject);
var G: TrDBGrid;
begin
  case PageControl1.ActivePageIndex of
  0,4,5: G:=grEmployee;
  1: G:=grCustomer;
  2: G:=grEmp2;
  3: G:=grCust2;
  else
    G:=nil;
  end;
  rDBAction.SetActiveGrid(G);
end;

procedure TMain.SetControls(JustOpened: boolean);
begin
  if JustOpened then
  begin
    SBar.SimpleText:=sDBFile+Data.ADOConWiz.ConnectedFile;
    grEmployee.ReSort;
    grEmployee.DataSource.DataSet.First;
    grCustomer.ReSort;
    grCustomer.DataSource.DataSet.First;
  end;
  with grEmployee do
  begin
    if ch11.Checked then OptionsEx:=OptionsEx+[dgTitleExBtn]
                    else OptionsEx:=OptionsEx-[dgTitleExBtn];
    if ch12.Checked then OptionsEx:=OptionsEx+[dgTitleBtn]
                    else OptionsEx:=OptionsEx-[dgTitleBtn];
    if ch13.Checked then OptionsEx:=OptionsEx+[dgFixColBtn]
                    else OptionsEx:=OptionsEx-[dgFixColBtn];
    if ch21.Checked then OptionsEx:=OptionsEx+[dgBool]
                    else OptionsEx:=OptionsEx-[dgBool];
    if ch22.Checked then OptionsEx:=OptionsEx+[dgMemo]
                    else OptionsEx:=OptionsEx-[dgMemo];
    if ch23.Checked then OptionsEx:=OptionsEx+[dgGraphic]
                    else OptionsEx:=OptionsEx-[dgGraphic];
    if ch31.Checked then OptionsEx:=OptionsEx+[dgDrawRowFocus]
                    else OptionsEx:=OptionsEx-[dgDrawRowFocus];
    if chEdit.Checked then Options:=Options+[dgEditing]
                      else Options:=Options-[dgEditing];
    if chAS.Checked then Options:=Options+[dgAlwaysShowSelection]
                    else Options:=Options-[dgAlwaysShowSelection];
    DataSource.AutoEdit:=chAutoEdit.Checked;
  end;
end;

procedure TMain.btSelectDBClick(Sender: TObject);
begin
  if Data.ADOConWiz.OpenAll_SelectFile then SetControls(true)
  else Application.Terminate;
end;

procedure TMain.btCloseDBClick(Sender: TObject);
begin
  Data.ADOConWiz.Disconnect;
end;

procedure TMain.chEditClick(Sender: TObject);
begin
  SetControls(false);
end;

procedure TMain.grEmployeeChangeSort(Sender: TObject; DataSet: TDataSet;
  SortFieldName: String; SortDesc: Boolean; var Accept: Boolean);
begin
  ChangeSortADO(DataSet as TCustomADODataSet,SortFieldName,SortDesc,Accept);
end;

procedure TMain.grEmployeeRefreshData(Sender: TObject);
begin
  RequeryGridADO(Sender as TDBGrid);
end;

procedure TMain.grEmployeeTitleExClick(Sender: TObject);
begin
  DlgI('TitleEx Btn Click on '+(Sender as TControl).Name);
end;

procedure TMain.grEmployeeFixColClick(Sender: TObject);
begin
  DlgI('FixedCol Btn Click on '+(Sender as TControl).Name);
end;

procedure TMain.cbOVClick(Sender: TObject);
begin
  rDBRecView.OnlyVisibleField:=cbOv.Checked;
end;

procedure TMain.cbOSClick(Sender: TObject);
begin
  rDBRecView.OnlySimpleField:=cbOS.Checked;
end;

procedure TMain.btAboutClick(Sender: TObject);
begin
  ShowAbout;
end;

procedure TMain.eGTagChange(Sender: TObject);
begin
  grEmployee.Tag:=eGTag.AsInteger;
end;

procedure TMain.eURChange(Sender: TObject);
begin
  rDBAction.SetUserRights(eUR.AsInteger);
end;

procedure TMain.btTXTExportClick(Sender: TObject);
begin
  TXTExport1.ExportFile:=GetAppPath+'Export.txt';
  TXTExport1.Execute(grCustomer);
end;

procedure TMain.btSLKExportClick(Sender: TObject);
begin
  SLKExport1.ExportFile:=GetAppPath+'Export.slk';
  SLKExport1.Execute(grEmployee);
end;

procedure TMain.SLKExport1BeforeExport(Sender: TObject; MaxX,
  MaxY: Integer);
begin
  SLKExport1.ExportText(eSLKHeader.Text,1,1);
  SLKExport1.SetCellFormat(cfBold,1,1);
end;

procedure TMain.RTFRep1ReportProcess(Sender: TObject; RecNbr: Integer;
  var Abort: Boolean);
begin
  lRepInfo.Caption:=Format('Report is creating... record %d',[RecNbr]);
end;

procedure TMain.btRep1Click(Sender: TObject);
begin
  Data.tCustDetail.Open;
  try
    RTFRep2.ReportFile:=GetAppPath+'Reports\Master_detail2.rtf';
    RTFRep2.OutputFile:=GetAppPath+'Report.rtf';
    RTFRep2.Variables.Clear;
    RTFRep2.Variables.Add('Header='+eRTFHeader.Text);
    RTFRep2.Execute([Data.qFirms,Data.tCustDetail]);
  finally
    Data.tCustDetail.Close;
  end;
  mInfo.Lines.Assign(RTFRep2.ExtendedInfo);
end;

procedure TMain.btRep2Click(Sender: TObject);
begin
  RTFRep2.ReportFile:=GetAppPath+'Reports\Employee_list2.rtf';
  RTFRep2.OutputFile:=GetAppPath+'Reports\Report.rtf';
  RTFRep2.Variables.Clear;
  RTFRep2.Variables.Add('Header='+eRTFHeader.Text);
  RTFRep2.Variables.Add('P1='+GetAppPath+'Reports\logo_small.bmp');
  RTFRep2.Execute([Data.tEmployee]);
end;

procedure TMain.RTFRep2ReadInfo(Sender: TObject);
begin
  mInfo.Lines.Assign(RTFRep2.ExtendedInfo);
end;

procedure TMain.btRTFDlgClick(Sender: TObject);
var r1,r2: TRTFRepInfo;
    d: TRTFRepDlgInfo;
begin
  r1.Caption:='Employee report';
  r1.ReportFile:=GetAppPath+'Reports\Employee_list2.rtf';
  r1.OutputFile:=GetAppPath+'Report.rtf';
  r1.ShowDetail:=false;
  r1.DefaultCharset:=238;
  r1.ShowDetail:=true;
  r1.ReportVersion:=2;
  r1.DataSets:=CreateDataSetList([Data.tEmployee]);
  ClearRTFRepVariable(r1);
  AddRTFRepVariable(r1,'Header='+eRTFHeader.Text);
  AddRTFRepVariable(r1,'P1='+GetAppPath+'Reports\logo_small.bmp');

  r2.Caption:='Master detail report';
  r2.ReportFile:=GetAppPath+'Reports\Master_detail2.rtf';
  r2.OutputFile:=GetAppPath+'Report.rtf';
  r2.ShowDetail:=false;
  r2.DefaultCharset:=238;
  r2.ShowDetail:=true;
  r2.ReportVersion:=2;
  r2.DataSets:=CreateDataSetList([Data.qFirms,Data.tCustDetail]);
  ClearRTFRepVariable(r2);
  AddRTFRepVariable(r2,'Header='+eRTFHeader.Text);

  d.ShowMailBtn:=true;
  d.UseMapi:=true;
  d.MailTo:='test@rosinsky.cz';
  d.OnBeforeEdit:=btBeforeEditClick;
  d.OnReadInfo:=btOnInfoClick;

  Data.tCustDetail.Open;
  try
    ShowRTFRepDialog([r1,r2],d);
  finally
    Data.tCustDetail.Close;
  end;
end;

procedure TMain.btBeforeEditClick(Sender: TObject);
begin
  DlgI('any action before edit');
end;

procedure TMain.btOnInfoClick(Sender: TObject);
begin
//  mInfo.Lines.Clear;
  mInfo.Lines.Assign(Sender as TStrings);
end;


procedure TMain.grEmployeeLinkClick(Sender: TObject; DataSet: TDataSet;
  Column: TColumn; Field: TField; Value: Variant);
begin
  DlgI2(Column.FieldName, String(Value));
end;

procedure TMain.btDefClick(Sender: TObject);
begin
  PSFile.Clear;
  PSFile.SaveFile('');
  PSFile.DisableAll:=true;
  ShowMessage('Close the application and run again with default values.');
end;

procedure TMain.OnHlp(Form: TForm; HelpContext: integer);
begin
  DlgI('Show help for form: '+Form.Name+', HelpContext: '+IntToStr(HelpContext));
end;


procedure TMain.chHelpClick(Sender: TObject);
begin
  if chHelp.Checked then rdbtool.ProcOnHelp:=OnHlp
                    else rdbtool.ProcOnHelp:=nil;
end;

end.
