unit dm_data;

interface

uses
  SysUtils, Classes, Dialogs, Controls, DB, ADODB, ADOConWizard, PropSaveMain;

type
  TData = class(TDataModule)
    ADOConWiz: TADOConWizard;
    ADOCon: TADOConnection;
    tCustomer: TADOTable;
    tEmployee: TADOTable;
    tCustomerCustNo: TFloatField;
    tCustomerAddr1: TStringField;
    tCustomerPhone: TStringField;
    tCustomerFAX: TStringField;
    tCustomerTaxRate: TFloatField;
    tCustomerContact: TStringField;
    tCustomerLastInvoiceDate: TDateTimeField;
    tEmployeeEmpNo: TIntegerField;
    tEmployeeLastName: TStringField;
    tEmployeeFirstName: TStringField;
    tEmployeePhoneExt: TStringField;
    tEmployeeHireDate: TDateTimeField;
    tEmployeeSalary: TFloatField;
    tEmployeeMemo: TMemoField;
    tEmployeePhoto: TBlobField;
    tEmployeeRetired: TBooleanField;
    dsEmployee: TDataSource;
    dsCustomer: TDataSource;
    tCustomerFirmNo: TIntegerField;
    dsFirms: TDataSource;
    tCustomerFirmName: TStringField;
    qFirms: TADOQuery;
    qFirmsFirmNo: TAutoIncField;
    qFirmsFirmName: TWideStringField;
    tCustDetail: TADOTable;
    tCustDetailCustNo: TFloatField;
    tCustDetailFirmNo: TIntegerField;
    tCustDetailAddr1: TWideStringField;
    tCustDetailPhone: TWideStringField;
    tCustDetailFAX: TWideStringField;
    tCustDetailTaxRate: TFloatField;
    tCustDetailContact: TWideStringField;
    tCustDetailLastInvoiceDate: TDateTimeField;
    procedure ADOConWizOpenTables(Sender: TObject; var Opened: Boolean);
    procedure ADOConWizInfo(Sender: TObject; Info: String);
    procedure tEmployeeBeforeDelete(DataSet: TDataSet);
    procedure tEmployeePostError(DataSet: TDataSet; E: EDatabaseError;
      var Action: TDataAction);
    procedure ADOConWizGetDBFilePassword(Sender: TObject; var UserID,
      Password: String);
    procedure dsEmployeeStateChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function OpenTables: boolean;
  end;

var
  Data: TData;

implementation

{$R *.dfm}

uses rstring, rdlg, rtool, rdbtool, f_main;

function TData.OpenTables: boolean;
begin
  Result:=false;
  try
    tEmployee.Close;
    tCustomer.Close;
    qFirms.Close;

    tEmployee.Open;
    tCustomer.Open;
    qFirms.Open;

    Result:=true;
  except
    on E: Exception do ShowErr('',E,false);
  end;
end;

procedure TData.ADOConWizOpenTables(Sender: TObject; var Opened: Boolean);
begin
  Opened:=OpenTables;
end;

procedure TData.ADOConWizInfo(Sender: TObject; Info: String);
begin
  Main.mLog.Lines.Add(Info);
end;

procedure TData.tEmployeeBeforeDelete(DataSet: TDataSet);
begin
  if DlgQ(sDelRecordQ)<>mrYes then Abort;
end;

procedure TData.tEmployeePostError(DataSet: TDataSet; E: EDatabaseError;
  var Action: TDataAction);
begin
  ShowErr(sSaveRecordErr,E,false);
  Action:=daAbort;
end;

procedure TData.ADOConWizGetDBFilePassword(Sender: TObject; var UserID,
  Password: String);
begin
  Password:='test';
end;

procedure TData.dsEmployeeStateChange(Sender: TObject);
begin
  Main.grEmp2.Enabled:=not IsEditing(tEmployee);
end;

end.
