unit ADOConWizard_Form;

{
  ADO Connection Wizard Form
  ==========================
  Date: Sep 2004
  Author: Rosi (http://www.rosinsky.cz/delphi.html)

  Description:
  ADOConWizard_Form is error dialog for ADOConWizard component.

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ADOConWizard, FormatLabel;

type
  TADOConForm = class(TForm)
    lInfo: TLabel;
    btYes: TBitBtn;
    btNo: TBitBtn;
    btDetail: TBitBtn;
    pUDL: TPanel;
    pDetail: TPanel;
    Memo: TMemo;
    btSaveLog: TBitBtn;
    Label3: TLabel;
    Image1: TImage;
    FormatLabel1: TFormatLabel;
    procedure btSaveLogClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btDetailClick(Sender: TObject);
    procedure FormatLabel1AnchorClick(Sender: TObject; LinkName: String);
  private
    { Private declarations }
    ConWiz: TADOConWizard;
  public
    { Public declarations }
  end;

var
  ADOConForm: TADOConForm;

function ShowADOConDlg(ADOConWizard: TADOConWizard;
                       Caption: string; UDLPanel: boolean): boolean;

implementation

{$R *.dfm}

uses rtool, rdlg, rstring;

function ShowADOConDlg(ADOConWizard: TADOConWizard;
                       Caption: string; UDLPanel: boolean): boolean;
begin
  CreateF(TADOConForm, ADOConForm);
  ADOConForm.ConWiz:=ADOConWizard;
  ADOConForm.lInfo.Caption:=Caption;
  ADOConForm.pUDL.Visible:=UDLPanel;
  Result:=ADOConForm.ShowModal=mrYes;
  FreeF(ADOConForm);
end;

procedure TADOConForm.FormShow(Sender: TObject);
begin
  ADOConForm.Memo.Lines.Assign(ConWiz.LogText);
  Height:=btYes.Top+70;
  if pUDL.Visible then Height:=Height+pUDL.Height;
end;

procedure TADOConForm.btDetailClick(Sender: TObject);
begin
  Height:=Height+pDetail.Height;
  pDetail.Visible:=true;
  btDetail.Enabled:=false;
  Memo.SelStart:=Length(Memo.Text)-1;
  Memo.SelLength:=1;
end;

procedure TADOConForm.btSaveLogClick(Sender: TObject);
var s: string;
begin
  s:='';
  if ConWiz.SaveLog(s) then DlgI(Format(sFileSaved,[s]));
end;

procedure TADOConForm.FormatLabel1AnchorClick(Sender: TObject;
  LinkName: String);
var b: boolean;
begin
  if LinkName='newudl' then ConWiz.CreateUDLFile;
  if LinkName='helpudl' then ShowExtHelp(Self,HELP_CONTEXTPOPUP,1,b);
end;

end.
