{ ********************( Demo2 - TGTrend )*************************************
 Made by : Gran Pettersson, GPsoft.
 Version : 1.1
 -----------------------------------------------------------------------------
The main purpose with this program is to show how to use the component TGTrend.
In this demo You can see how to get signals into the graph "online". The demo
also shows how to manipulate signals and info in and out from the component.
 -----------------------------------------------------------------------------
  !!!! NOTE !!!! NOTE !!!! NOTE !!!! NOTE !!!! NOTE !!!! NOTE !!!! NOTE !!!!
 To compile this demo You need the following components from the following
 places:
* TMyRadioGroup, TRSGen  -
  These components are avable from our homepage
                              http://home.ueab.net/gpsoft/freeware.html

*  TPBSuperSpin, TPBNumEdit -
  These components are from the PBEditPack from BakSoft. They, and other
  components are avable at BakSoft's homepage,
           http://home11.inet.tele.dk/BakSoft/PBEditPack.htm
  ****************************************************************************}
unit TGTrend_Demo2_Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls,
  GTrend, MyRadioGroup, RSGen,
  PBNumEdit, PBSuperSpin, Menus, ComCtrls;

type
  TForm_Demo2 = class(TForm)
    RSGen1: TRSGen;
    Timer1: TTimer;
    timOnline: TTimer;
    ChanSel: TMyRadioGroup;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    GTrend1: TGTrend;
    pbsChannels: TPBSuperSpin;
    Label1: TLabel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    View1: TMenuItem;
    Exit1: TMenuItem;
    SetupChannels1: TMenuItem;
    SetupRSgen1: TMenuItem;
    About: TMenuItem;
    gbRsgSetup: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    cbRSG_Type: TComboBox;
    cbRsgEnabled: TCheckBox;
    psbTimeBase: TPBSuperSpin;
    psbMax: TPBSuperSpin;
    psbMin: TPBSuperSpin;
    gbChanConf: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    edName: TEdit;
    edDescr: TEdit;
    edUnit: TEdit;
    pbsScaleMax: TPBSuperSpin;
    pbsScaleMin: TPBSuperSpin;
    pbsLimMax: TPBSuperSpin;
    pbsLimMin: TPBSuperSpin;
    cbColor: TColorBox;
    cbLineStyle: TComboBox;
    cbEnabled: TCheckBox;
    cbLimEn: TCheckBox;
    btnOptimizeScale: TButton;
    pbnScMax: TPBNumEdit;
    pbnScMin: TPBNumEdit;
    edTime: TEdit;
    edValue: TEdit;
    cbAdaptPlot: TCheckBox;
    sbDuration: TScrollBar;
    sbEndTime: TScrollBar;
    cbOnLine: TCheckBox;
    pbOnLineTime: TPBSuperSpin;
    Label18: TLabel;
    StatusBar1: TStatusBar;
    Label16: TLabel;
    Label17: TLabel;
    Label19: TLabel;
    Label20: TLabel;

    procedure Timer1Timer(Sender: TObject);
    procedure timOnlineTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);

    procedure UpdateChanSel;
    procedure ChanSelClick(Sender: TObject);
    procedure ChanSelDblClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure SetupChannels1Click(Sender: TObject);
    procedure SetupRSgen1Click(Sender: TObject);
    procedure AboutClick(Sender: TObject);

    procedure GTrend1ChangedChanScale(Sender: TObject; Chan: Integer);
    procedure GTrend1ChangedMarker(Sender: TObject; dt: TDateTime;
      Values: array of Single);
    procedure GTrend1ChangedTimeScale(Sender: TObject);

    procedure pbOnLineTimeChange(Sender: TObject);
    procedure sbEndTimeChange(Sender: TObject);
    procedure sbDurationChange(Sender: TObject);


    // Channel Setup ...
    procedure pbsChannelsChange(Sender: TObject);
    procedure cbEnabledClick(Sender: TObject);
    procedure pbsScaleMaxChange(Sender: TObject);
    procedure pbsScaleMinChange(Sender: TObject);
    procedure pbsLimMaxChange(Sender: TObject);
    procedure pbsLimMinChange(Sender: TObject);
    procedure cbColorChange(Sender: TObject);
    procedure cbLimEnClick(Sender: TObject);
    procedure edUnitChange(Sender: TObject);
    procedure edDescrChange(Sender: TObject);
    procedure edNameChange(Sender: TObject);
    procedure cbLineStyleChange(Sender: TObject);

    procedure btnOptimizeScaleClick(Sender: TObject);
    procedure rgChanSelClick;

    // RSGEN Setup...
    procedure UpdateRSGsettings;
    procedure cbRSG_TypeChange(Sender: TObject);
    procedure psbTimeBaseChange(Sender: TObject);
    procedure psbMaxChange(Sender: TObject);
    procedure psbMinChange(Sender: TObject);
    procedure cbRsgEnabledClick(Sender: TObject);
    procedure cbOnLineClick(Sender: TObject);

  private
    { Private declarations }
    myUpdateActive : Boolean;
  public
    { Public declarations }
    IsRunning : Boolean;
  end;

var
  Form_Demo2: TForm_Demo2;

implementation

uses TGTrend_Demo_About_Unit;

{$R *.dfm}

procedure TForm_Demo2.FormCreate(Sender: TObject);
var
  c : Integer;
begin
  myUpdateActive := False;

  pbsChannels.AsInteger := GTrend1.NoOfChan +1;

  // RSGen is the Signal Generator in this demo. Therefor we set it
  // to the same number of as channels in the TGTrend.
  RSGen1.RSNoOfChan     := GTrend1.NoOfChan ;
  RSGen1.RSGenEnabled   := True;

  // We are setting every channel to Enabled, default is False.
  for c:= 0 to GTrend1.NoOfChan do begin
    GTrend1.SetChanEnabled(c, True)
  end;
  // Here we are setting the display time of the grid. In this case 5min.
  GTrend1.DurationTime := StrToDateTime('00:05:00');

  // Rember sizes, etc. Just for the Demo ...
  gbChanConf.Tag := gbChanConf.Width ;
  gbRsgSetup.Tag := gbRsgSetup.Width ;
  SetupChannels1.Checked := True ;
  SetupRSgen1.Checked    := True ;

  cbOnLine.Checked := timOnline.Enabled;
  pbOnLineTime.AsFloat := timOnline.Interval / 1000;

  // Calculate the position for the Scrollbar ..
  sbDuration.Position := Trunc(sbDuration.Max * GTrend1.DurationTime );
end;

{ ****************************************************************************
  Main routine in this demo program. Here is the values from the signals,
   (in this case from the RSGen), added into the TGTrend component.
  To ensure that the same time is stored into all channels,
   the actual time is stored into a local variable, before using.
  ****************************************************************************}
procedure TForm_Demo2.Timer1Timer(Sender: TObject);
var
  c : Integer;
  myNow : TDateTime;
  Val : Single;
begin
  myNow := Now;
  for c:= 0 to GTrend1.NoOfChan do begin
    Val := RSGen1.GetOut0(c);
    GTrend1.AddValue(c, myNow, Val );
  end;
end;

{ ****************************************************************************
  This routine just update the time in the Graph. When the time is updated,
  the graph is automaticly updated.
  ****************************************************************************}
procedure TForm_Demo2.timOnlineTimer(Sender: TObject);
begin
    GTrend1.EndTime := Gtrend1.GetNewestDataTime ;
    with sbEndTime do
      sbEndTime.Position := sbEndTime.Max;
end;

{ ****************************************************************************
  This routine handles the update of the panel with channel info's.
  When a channel is selected, the corresponding info is transfered,
  ****************************************************************************}
procedure TForm_Demo2.UpdateChanSel;
var
 c, i : Integer;
 myStr : String;
begin
  if not myUpdateActive then begin
    myUpdateActive := True;
    ChanSel.Items.Clear ;
    c := GTrend1.NoOfChan ;
    for i:= 0 to c do begin
      myStr := IntToStr(i) + ' - ' + GTrend1.GetChanName (i);
       ChanSel.Items.Add( myStr );
       ChanSel.Buttons[i].Font.Color := GTrend1.GetChanColor(i);
       ChanSel.Buttons[i].OnDblClick := ChanSelDblClick; // Add DoubleClickEventHandling ...
       // Check if the channel is enabled or not ...
        if GTrend1.GetChanEnabled(i) then begin
            ChanSel.Buttons[i].Font.Style := [fsBold]; // Shows that the channels is enabled
          end
        else begin
          ChanSel.Buttons[i].Font.Style := [];
        end;
    end;
    myStr :=  IntToStr( ChanSel.Items.Count);
    ChanSel.ItemIndex := GTrend1.ActiveChan ;
    myUpdateActive := False;
  end;
end;

procedure TForm_Demo2.ChanSelClick(Sender: TObject);
begin
  GTrend1.ActiveChan := ChanSel.ItemIndex;
    rgChanSelClick    ;
    UpdateRSGsettings ;
end;


procedure TForm_Demo2.ChanSelDblClick(Sender: TObject);
begin
  cbEnabled.Checked := not cbEnabled.Checked ;
  cbEnabledClick(Self);
end;

procedure TForm_Demo2.FormShow(Sender: TObject);
begin
  UpdateChanSel;
end;

procedure TForm_Demo2.pbsChannelsChange(Sender: TObject);
begin
  GTrend1.NoOfChan := pbsChannels.AsInteger -1 ;
  RSGen1.RSNoOfChan := GTrend1.NoOfChan;
  UpdateChanSel;
end;

procedure TForm_Demo2.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm_Demo2.SetupChannels1Click(Sender: TObject);
begin
  SetupChannels1.Checked := not SetupChannels1.Checked;

  if SetupChannels1.Checked then begin
      gbChanConf.Width := gbChanConf.tag;
      gbChanConf.Enabled := True;
    end
  else begin
      gbChanConf.Enabled := False;
      gbChanConf.Width := 0;
  end;
end;

procedure TForm_Demo2.SetupRSgen1Click(Sender: TObject);
begin
  with SetupRSgen1 do begin
    Checked := not Checked;
    if Checked then
      gbRsgSetup.Width := gbRsgSetup.Tag
    else
      gbRsgSetup.Width := 0;
  end;
end;

procedure TForm_Demo2.AboutClick(Sender: TObject);
begin
  Form_About.ShowModal;
end;

// Channel Setup ...

procedure TForm_Demo2.pbsScaleMaxChange(Sender: TObject);
begin
  GTrend1.SetChanScaleMax(ChanSel.ItemIndex, pbsScaleMax.AsFloat );
end;

procedure TForm_Demo2.pbsScaleMinChange(Sender: TObject);
begin
  GTrend1.SetChanScaleMin(ChanSel.ItemIndex, pbsScaleMin.AsFloat );
end;

procedure TForm_Demo2.pbsLimMaxChange(Sender: TObject);
begin
  GTrend1.SetChanLimMax(ChanSel.ItemIndex, pbsLimMax.AsFloat );
end;

procedure TForm_Demo2.pbsLimMinChange(Sender: TObject);
begin
  GTrend1.SetChanLimMin(ChanSel.ItemIndex, pbsLimMin.AsFloat );
end;

procedure TForm_Demo2.cbColorChange(Sender: TObject);
begin
  GTrend1.SetChanColor(ChanSel.ItemIndex,  cbColor.Selected );

  ChanSel.Buttons[ChanSel.ItemIndex].Font.Color := cbColor.Selected;
end;

procedure TForm_Demo2.cbEnabledClick(Sender: TObject);
begin
  GTrend1.SetChanEnabled( ChanSel.ItemIndex, cbEnabled.Checked );

  if cbEnabled.Checked then
    ChanSel.Buttons[ChanSel.ItemIndex].Font.Style := [fsBold]
  else
    ChanSel.Buttons[ChanSel.ItemIndex].Font.Style := [];
end;

procedure TForm_Demo2.cbLimEnClick(Sender: TObject);
begin
  GTrend1.SetChanLimEnabled(ChanSel.ItemIndex, cbLimEn.Checked );
end;

procedure TForm_Demo2.edUnitChange(Sender: TObject);
begin
  GTrend1.SetChanUnits(ChanSel.ItemIndex,  edUnit.Text );
end;

procedure TForm_Demo2.edDescrChange(Sender: TObject);
begin
  GTrend1.SetChanDescr(ChanSel.ItemIndex,  edDescr.Text );
end;

procedure TForm_Demo2.edNameChange(Sender: TObject);
var
  Chan : Integer;
begin
    // Get the selected channel ...
  Chan := ChanSel.ItemIndex ;
    // Put in the the changed text into the channel ...
  GTrend1.SetChanName( Chan, edname.Text );
    // Add the same text into the channel selection group ...
  ChanSel.Items[ Chan ] := IntToStr(Chan) + ' - ' + edname.Text ;
end;

procedure TForm_Demo2.cbLineStyleChange(Sender: TObject);
begin
  GTrend1.SetChanLimPStyle(ChanSel.ItemIndex, TPenStyle(cbLineStyle.ItemIndex));
end;

procedure TForm_Demo2.btnOptimizeScaleClick(Sender: TObject);
begin
  pbnScMax.AsFloat      := GTrend1.GetHighestData(ChanSel.ItemIndex );
  pbnScMin.AsFloat      := GTrend1.GetLowestData(ChanSel.ItemIndex );
  
  if (pbnScMax.AsFloat <> 0) OR (pbnScMin.AsFloat <>0 ) then begin
    pbsScaleMax.AsFloat :=  pbnScMax.AsFloat * 1.1 ;
    pbsScaleMin.AsFloat :=  pbnScMin.AsFloat * 0.9 ;
  end;
end;

procedure TForm_Demo2.rgChanSelClick;
var
  Chan : Integer;
begin
  with GTrend1 do begin
    Chan                  := ChanSel.ItemIndex;
    gbChanConf.Caption    := ' Channel ' + IntToStr(Chan) + '  ';

    edName.Text           := GetChanName (Chan);
    edDescr.Text          := GetChanDescr(Chan);
    edUnit.Text           := GetChanUnits(Chan);
    pbsScaleMax.AsFloat   := GetChanScaleMax(Chan);
    pbsScaleMin.AsFloat   := GetChanScaleMin(Chan);
    pbsLimMax.AsFloat     := GetChanLimMax(Chan);
    pbsLimMin.AsFloat     := GetChanLimMin(Chan);
    cbColor.Selected      := GetChanColor(Chan);
    cbLineStyle.ItemIndex := Integer(GetChanLimPStyle(Chan));
    cbEnabled.Checked     := GetChanEnabled(Chan);
    cbLimEn.Checked       := GetChanLimEnabled(Chan);
    edUnit.Text           := GetChanUnits(Chan);
    pbnScMax.AsFloat      := GTrend1.GetHighestData(Chan);
    pbnScMin.AsFloat      := GTrend1.GetLowestData(Chan);
    cbAdaptPlot.Checked   := GTrend1.GetChanAdaptive(Chan);
  end;
end;


// RSGen Setup ..

procedure TForm_Demo2.UpdateRSGsettings;
var
  RSGchan : Integer;
begin
  RSGchan :=  ChanSel.ItemIndex;
  gbRsgSetup.Caption := ' RSG Setup, chan #' + IntToStr(RSGchan) + '  ';;
    cbRSG_Type.ItemIndex := Integer(RSGen1.GetType(RSGchan));
    psbTimeBase.AsFloat  := RSGen1.GetTimeBase(RSGchan);
    psbMax.AsFloat       := RSGen1.GetMax(RSGchan);
    psbMin.asfloat       := RSGen1.GetMin(RSGchan);
    cbRsgEnabled.Checked    := RSGen1.GetEnable(RSGchan);
end;

procedure TForm_Demo2.cbRSG_TypeChange(Sender: TObject);
begin
  RSGen1.SetType(ChanSel.ItemIndex, TRSG_Type(cbRSG_Type.ItemIndex) );
end;

procedure TForm_Demo2.psbTimeBaseChange(Sender: TObject);
begin
  RSGen1.SetTimeBase(ChanSel.ItemIndex, psbTimeBase.AsFloat);
end;

procedure TForm_Demo2.psbMaxChange(Sender: TObject);
begin
  RSGen1.SetMax(ChanSel.ItemIndex, psbMax.AsFloat);
end;

procedure TForm_Demo2.psbMinChange(Sender: TObject);
begin
  RSGen1.SetMin(ChanSel.ItemIndex, psbMin.AsFloat);
end;

procedure TForm_Demo2.cbRsgEnabledClick(Sender: TObject);
begin
  RSGen1.SetEnable(ChanSel.ItemIndex, cbRsgEnabled.Checked );
end;

procedure TForm_Demo2.cbOnLineClick(Sender: TObject);
begin
  timOnline.Enabled    := cbOnLine.Checked ;
  pbOnLineTime.Enabled := cbOnLine.Checked ;
  Label18.Enabled      := cbOnLine.Checked ;
end;

procedure TForm_Demo2.GTrend1ChangedChanScale(Sender: TObject; Chan: Integer);
begin
  rgChanSelClick    ;
end;

procedure TForm_Demo2.GTrend1ChangedMarker(Sender: TObject; dt: TDateTime; Values: array of Single);
begin
  edTime.Text  := DateTimeToStr(dt);
  edValue.Text := FloatToStr(Values[ChanSel.ItemIndex]);
end;

procedure TForm_Demo2.GTrend1ChangedTimeScale(Sender: TObject);
begin
  sbDuration.Position := Trunc(sbDuration.Max * GTrend1.DurationTime );
end;

// Common functions in the demo ..
procedure TForm_Demo2.pbOnLineTimeChange(Sender: TObject);
begin
  timOnline.Interval := Trunc(pbOnLineTime.AsFloat * 1000)
end;

procedure TForm_Demo2.sbEndTimeChange(Sender: TObject);
var
  OldestTime, NewestTime, dt : TDateTime;
  myDurationTimeExt: Extended;
begin
  myDurationTimeExt := sbDuration.Position /(24*60*60);
  OldestTime := Gtrend1.GetOldestDataTime;
  NewestTime := Gtrend1.GetNewestDataTime;
  if (OldestTime + myDurationTimeExt) < NewestTime then begin
    with GTrend1 do begin
      dt := NewestTime - (OldestTime + myDurationTimeExt);
      with sbEndTime do
        EndTime := NewestTime -(dt * ((Max - Position) /Max));
    end;
  end;
end;

procedure TForm_Demo2.sbDurationChange(Sender: TObject);
begin
  Gtrend1.DurationTime := sbDuration.Position / sbDuration.Max ;
end;

end.
