{ ********************( TGTrend_Demo1 )*************************************
 Made by : Gran Pettersson, GPsoft.
 Version : 1.1
 -----------------------------------------------------------------------------
The main purpose with this program is to show how to use the component TGTrend.
In this demo You can see how to get information, stroed in a text fiel into the
graph. The demo also shows how to manipulate signals and other information
in and out from the component.
 -----------------------------------------------------------------------------
  !!!! NOTE !!!! NOTE !!!! NOTE !!!! NOTE !!!! NOTE !!!! NOTE !!!! NOTE !!!!
 To compile this demo You need the following components from the following
 places:
* TMyRadioGroup  -
  These components are avable from our homepage
                              http://home.ueab.net/gpsoft/freeware.html

*  TPBSuperSpin, TPBNumEdit -
  These components are from the PBEditPack from BakSoft. They, and other
  components are avable at BakSoft's homepage,
           http://home11.inet.tele.dk/BakSoft/PBEditPack.htm
  ****************************************************************************}
unit TGTrend_Demo1_Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Menus,   StrUtils, PBNumEdit, PBSuperSpin,
  MyRadioGroup, GTrend, ComCtrls ;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    ChanSel: TMyRadioGroup;
    MainMenu1: TMainMenu;
    Arkiv1: TMenuItem;
    Exit: TMenuItem;
    Visa1: TMenuItem;
    ChannelSetup: TMenuItem;
    gbChanConf: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    edName: TEdit;
    edDescr: TEdit;
    edUnit: TEdit;
    pbsScaleMax: TPBSuperSpin;
    pbsScaleMin: TPBSuperSpin;
    pbsLimMax: TPBSuperSpin;
    pbsLimMin: TPBSuperSpin;
    cbColor: TColorBox;
    cbLineStyle: TComboBox;
    cbEnabled: TCheckBox;
    cbLimEn: TCheckBox;
    btnOptimizeScale: TButton;
    pbnScMax: TPBNumEdit;
    pbnScMin: TPBNumEdit;
    StatusBar1: TStatusBar;
    OpenFile: TMenuItem;
    Label9: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Panel3: TPanel;
    GTrend1: TGTrend;
    cbAdaptPlot: TCheckBox;
    Label10: TLabel;
    N1: TMenuItem;
    About1: TMenuItem;
    scbRewind: TScrollBar;
    scbDuration: TScrollBar;
    FileScan: TProgressBar;
    Label16: TLabel;
    Label17: TLabel;
    Label19: TLabel;
    Label20: TLabel;

    procedure FormCreate(Sender: TObject);
    procedure UpdateThe_ChanSel;
    procedure OpenFileClick(Sender: TObject);
    procedure ExitClick(Sender: TObject);
    function  CountNoOfFields( s : String): Integer;
    procedure ChanSel_Click(Sender: TObject);
    procedure ChannelSetupClick(Sender: TObject);

    procedure pbsScaleMaxChange(Sender: TObject);
    procedure pbsScaleMinChange(Sender: TObject);
    procedure pbsLimMaxChange(Sender: TObject);
    procedure pbsLimMinChange(Sender: TObject);
    procedure cbColorChange(Sender: TObject);
    procedure cbEnabledClick(Sender: TObject);
    procedure cbLimEnClick(Sender: TObject);
    procedure edUnitChange(Sender: TObject);
    procedure edDescrChange(Sender: TObject);
    procedure edNameChange(Sender: TObject);
    procedure cbLineStyleChange(Sender: TObject);
    procedure UpdateChanSel_Datas;
    procedure FormShow(Sender: TObject);
    procedure scbDurationChange(Sender: TObject);
    function  myDurationTime(): String;
    procedure scbRewindChange(Sender: TObject);
    procedure CleanUpAtEndOfInput;
    procedure GTrend1ChangedChanScale(Sender: TObject; Chan: Integer);
    procedure GTrend1ChangedMarker(Sender: TObject; dt: TDateTime;
      Values: array of Single);
    procedure GTrend1ChangedTimeScale(Sender: TObject);
    procedure ChanSelDblClick(Sender: TObject);
    procedure cbAdaptPlotClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure btnOptimizeScaleClick(Sender: TObject);
  private
    { Private declarations }

  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses TGTrend_Demo_About_Unit;

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  GTrend1.NoOfChan := 0;
  UpdateThe_ChanSel;
  // Rember sizes, etc. Just for the Demo ...
  gbChanConf.Tag := gbChanConf.Width ;

end;

{ ****************************************************************************
 This procedure transfer channel names into the radiogroup,
 used to select channel.
  ****************************************************************************}
procedure TForm1.UpdateThe_ChanSel;
var
 chan : Integer;
begin
  ChanSel.Items.Clear ;
  for chan:= 0 to GTrend1.NoOfChan do begin
      // Create the RadioButton Item from the channel numer and the channel name ...
     ChanSel.Items.Add( IntToStr(chan) + ' - ' + GTrend1.GetChanName (chan) );
      // Set the font color to the same as selected for the channel ...
     ChanSel.Buttons[chan].Font.Color := GTrend1.GetChanColor(chan);
      // Assign the double clock procedure for the item ...
     ChanSel.Buttons[chan].OnDblClick := ChanSelDblClick;
     // Check if the channel is enabled or not ...
      if GTrend1.GetChanEnabled(chan) then
          ChanSel.Buttons[chan].Font.Style := [fsBold]
      else
        ChanSel.Buttons[chan].Font.Style := [];
  end;
   // Finaly, set the ItemIndex to the selected channel ...
  ChanSel.ItemIndex := GTrend1.ActiveChan ;
end;

{ ****************************************************************************
 This demo's main procedure. Here we are reading the stored values in a
 comma separated text file.
  First row in the text file contains the field name's. The very first field
 contains the TDateTime value, there after is the values for each channel ..
  ****************************************************************************}
Const
  FIELDSEP = ';';
  DECSEP   = ',';
procedure TForm1.OpenFileClick(Sender: TObject);
var
  OpenDialog    : TOpenDialog;
  F             : TextFile;
  S             : string;
  chan,
  iLeftPos,
  iRightPos,
  NoOfCh        : Integer;
  r, rTot, rec  : Longint;
  eTimeStamp    : Extended;
  bChangeDecSep : Boolean;
begin
  // ------------------------------------------------------------------------
  // Check the system settings for the decimal separator.
  // The "demo_data.txt" file is created on a system where
  //  decimal separator is ','. To avoid error on systems with other setting
  //  for the decsep we need to replace the ',' with actual system settings ...
  // ------------------------------------------------------------------------
  bChangeDecSep := (DecimalSeparator <> DECSEP);
  
  rTot := 0;
  OpenDialog := TOpenDialog.Create(Self);
  OpenDialog.InitialDir := ExtractFilePath(Application.ExeName);
  OpenDialog.Filter := 'Text Files|*.txt|Log Files|*.log';
  if OpenDialog.Execute then begin
    // ------------------------------------------------------------------------
    // Reset the channels and update ..
    // ------------------------------------------------------------------------
    Gtrend1.NoOfChan :=0;
    UpdateThe_ChanSel;
      Form1.Caption := 'TGTrend Demo 1 - ' + OpenDialog.FileName;
      Statusbar1.Panels[1].Text := 'Open file ...' ;
    AssignFile(F, OpenDialog.FileName); { File selected in dialog }
    Reset(F);
      Statusbar1.Panels[1].Text := 'Readning file ...' ;
      FileScan.Visible := True;
      FileScan.Max := FileSize(f) div 10;
      FileScan.Position := 0;
    // ------------------------------------------------------------------------
    // Check how many rows to read in  ..
    // ------------------------------------------------------------------------
    while not EOF(F) do begin
      Readln(F, S);  //  Read line from file ...
      inc(rTot);
      FileScan.Position := FilePos(f) div 10;
      if (rTot mod 100)= 0 then //begin
        StatusBar1.Panels[3].Text := 'Have scanned ' + IntToStr( rTot ) + ' rows ...';
      Application.ProcessMessages;
    end;
    // ------------------------------------------------------------------------
    // Set the DataDeep to the number of records in the file ..
    // ------------------------------------------------------------------------
    GTRend1.DataDeep := rTot;
    Reset(F);       // "rewind" the filepointer ..
    // ------------------------------------------------------------------------------
    // Read the first row and determ how many fields(=channels) the file contains  ..
    // ------------------------------------------------------------------------------
    Readln(F, S);
    NoOfCh := CountNoOfFields( s ) -1;
    GTrend1.NoOfChan := NoOfCh;
    Statusbar1.Panels[2].Text := 'No of fields :' + IntToStr(GTrend1.NoOfChan) ;
    iLeftPos := Pos( FIELDSEP, s);
    // ------------------------------------------------------------------------
    // Get the channel name's from the file ..
    // ------------------------------------------------------------------------
    for chan:= 0 to NoOfCh do begin
      if chan < NoOfCh then
        iRightPos := PosEx( FIELDSEP, s, iLeftPos+1)
      else
        iRightPos := Length(s) + 1;
      GTrend1.SetChanName(chan, Copy(s, iLeftPos+1, iRightPos-iLeftPos-1) );
      iLeftPos := iRightPos;
      // as default, all channels are turned off (= not shown) ..
      GTrend1.SetChanEnabled(chan, False) ;
    end;

    // ------------------------------------------------------------------------
    // Here start the "real job" to decode the values, stroed in the file.
    //  The decode job can be written in a more "beatutiful" way, it's done
    // to make it easier to understand, and because it's faster ...
    // ------------------------------------------------------------------------
    r   := 0;
    rec := 1;
    // ------------------------------------------------------------------------
    // Repeat as long we not have reached the End Of File ..
    // ------------------------------------------------------------------------
    while not EOF(F) do begin
      Readln(F, S);  //  Read line from file ...
      // --------------------------------------------------------------------------
      // If needed, replace the decimal separator in the file to system settings ..
      // --------------------------------------------------------------------------
      if bChangeDecSep then
        S := StringReplace( S,DECSEP, DecimalSeparator, [rfReplaceAll]);

      inc(r);
      FileScan.Position := FilePos(f) div 10;
      Application.ProcessMessages;
      if (r mod 100)= 0 then begin
        StatusBar1.Panels[3].Text := ' Have read ' + IntToStr( r ) + ' rows of '  + IntToStr( rTot );
      end;
      // Decode the time for this record ...
      inc(rec);
      iRightPos := PosEx(FIELDSEP, s, 1);
      eTimeStamp := StrToFloat(Copy(s, 1, iRightPos-1));           // Avkoda tiden ...
      iLeftPos := iRightPos;
      for chan := 0 to NoOfCh do begin    // Hmta resp. vrde och verfr till rtt kanal ...
        if chan < NoOfCh then
          iRightPos := PosEx( FIELDSEP, s, iLeftPos+1)
        else
          iRightPos := Length(s) + 1;

        GTrend1.AddValue(chan, eTimeStamp, StrToFloat(Copy(s, iLeftPos+1, iRightPos-iLeftPos-1)));
        iLeftPos := iRightPos;
      end;
    end; {while not EOF(F) do begin}

    // ------------------------------------------------------------------------
    // Close the file, and clean up ..
    // ------------------------------------------------------------------------
    CloseFile(F);
      FileScan.Visible := False;
      StatusBar1.Panels[3].Text := ' Have read in ' + IntToStr( rec ) +
                                   ' records of ' +IntToStr( rTot )+ ' rows ...';
      Statusbar1.Panels[1].Text := 'File Closed ...' ;

    // ------------------------------------------------------------------------
    // Calculate an "optimal" scaling for each channel ...
    // ------------------------------------------------------------------------
    for chan:= 0 to NoOfCh do begin
      GTrend1.SetChanScaleMax(chan, GTrend1.GetHighestData(chan) * 1.01 );
      GTrend1.SetChanScaleMin(chan, GTrend1.GetLowestData(chan)  * 0.99 );
    end;

    CleanUpAtEndOfInput;
  end;
end;

procedure TForm1.CleanUpAtEndOfInput;
var
  dur, start, endTime : Extended;
  days  : integer;
  myTime : TdateTime;
begin
  Start := GTrend1.GetOldestDataTime;
  EndTime := GTrend1.GetNewestDataTime ;
  if EndTime > Start then begin
    Dur := EndTime - Start ;
    days := Trunc(Dur);
    if days >0 then
      myTime := Dur - days
    else
      myTime := Dur;
    StatusBar1.Panels[5].Text := ' Scanned time ' + IntToStr( days ) + ' day(s), ' + TimeToStr(myTime) ;

    scbDuration.Max := Trunc(86399 * Dur);
    scbDuration.Position := scbDuration.Max;

    Gtrend1.DurationTime :=  Dur;
    Gtrend1.EndTime := EndTime;

    UpdateThe_ChanSel;
  end;
end;

function TForm1.CountNoOfFields( s : String): Integer;
var
 i, v : Integer;
begin
 v := 0;
 for i:= 1 to Length(s) do
   if s[i] = FIELDSEP then
     inc(v);
 result := v ;
end;

procedure TForm1.ExitClick(Sender: TObject);
begin
  close;
end;

{ ****************************************************************************
  When clicking on a radiobutton, the
  ****************************************************************************}
procedure TForm1.ChanSel_Click(Sender: TObject);
var
  chan : Integer;
begin
  for chan:= 0 to pred(ChanSel.Items.Count) do
    if chan = ChanSel.ItemIndex then
      ChanSel.Buttons[ChanSel.ItemIndex].color := clSkyBlue
    else
      ChanSel.Buttons[chan].color := clBtnFace;

  GTrend1.ActiveChan := ChanSel.ItemIndex;
  UpdateChanSel_Datas;
end;

{ ****************************************************************************
  "Extra feature". When double clicking on the item, the channel is toggling
   between enabled and not enabled.
  ****************************************************************************}
procedure TForm1.ChanSelDblClick(Sender: TObject);
begin
  cbEnabled.Checked := not cbEnabled.Checked ;
  cbEnabledClick(Self);
end;

{ ****************************************************************************
  This procedure fetch information from the TGTrend and put it to
  corresponding place ..
  ****************************************************************************}
procedure TForm1.UpdateChanSel_Datas;
var
  Chan : Integer;
begin
  with form1.GTrend1 do begin
    Chan                := ChanSel.ItemIndex;
    gbChanConf.Caption  := ' Channel ' + IntToStr(Chan) + '  ';;
    edName.Text         := GetChanName (Chan);
    edDescr.Text        := GetChanDescr(Chan);
    //
    edUnit.Text         := GetChanUnits(Chan);
    pbsScaleMax.AsFloat := GetChanScaleMax(Chan);
    pbsScaleMin.AsFloat := GetChanScaleMin(Chan);
    pbsLimMax.AsFloat   := GetChanLimMax(Chan);
    pbsLimMin.AsFloat   := GetChanLimMin(Chan);
    cbColor.Selected    := GetChanColor(Chan);
    cbLineStyle.ItemIndex := Integer(GetChanLimPStyle(Chan));
    cbEnabled.Checked   := GetChanEnabled(Chan);
    cbLimEn.Checked     := GetChanLimEnabled(Chan);
    edUnit.Text         := GetChanUnits(Chan);
    pbnScMax.AsFloat    := GTrend1.GetHighestData(Chan);
    pbnScMin.AsFloat    := GTrend1.GetLowestData(Chan);
    cbAdaptPlot.Checked := GTrend1.GetChanAdaptive(Chan);
  end;
end;


{ ****************************************************************************
  This procedure is used to hide or show the Channel Setup panel ...
  ****************************************************************************}
procedure TForm1.ChannelSetupClick(Sender: TObject);
begin
  with ChannelSetup do begin
    Checked := not Checked;
    if Checked then
      gbChanConf.Width := gbChanConf.tag
     else
      gbChanConf.Width := 0 ;
  end;
end;

// **************************************************************************************/

procedure TForm1.FormShow(Sender: TObject);
begin
  if gbChanConf.Width > 0 then
    ChannelSetup.Checked := True;
end;

{ ****************************************************************************
  Procedures below are used to put back edited info into the TGTrend module ...
  ****************************************************************************}
procedure TForm1.pbsScaleMaxChange(Sender: TObject);
begin
  GTrend1.SetChanScaleMax(ChanSel.ItemIndex, pbsScaleMax.AsFloat );
end;

procedure TForm1.pbsScaleMinChange(Sender: TObject);
begin
  GTrend1.SetChanScaleMin(ChanSel.ItemIndex, pbsScaleMin.AsFloat );
end;

procedure TForm1.pbsLimMaxChange(Sender: TObject);
begin
  GTrend1.SetChanLimMax(ChanSel.ItemIndex, pbsLimMax.AsFloat );
end;

procedure TForm1.pbsLimMinChange(Sender: TObject);
begin
  GTrend1.SetChanLimMin(ChanSel.ItemIndex, pbsLimMin.AsFloat );
end;

procedure TForm1.cbColorChange(Sender: TObject);
begin
  GTrend1.SetChanColor(ChanSel.ItemIndex,  cbColor.Selected );
  ChanSel.Buttons[ChanSel.ItemIndex].Font.Color := cbColor.Selected;
end;

procedure TForm1.cbEnabledClick(Sender: TObject);
begin
  GTrend1.SetChanEnabled( ChanSel.ItemIndex, cbEnabled.Checked );

  if cbEnabled.Checked then
    ChanSel.Buttons[ChanSel.ItemIndex].Font.Style := [fsBold, fsItalic]
  else
    ChanSel.Buttons[ChanSel.ItemIndex].Font.Style := [];
end;

procedure TForm1.cbLimEnClick(Sender: TObject);
begin
  GTrend1.SetChanLimEnabled(ChanSel.ItemIndex, cbLimEn.Checked );
end;

procedure TForm1.edUnitChange(Sender: TObject);
begin
  GTrend1.SetChanUnits(ChanSel.ItemIndex,  edUnit.Text );
end;

procedure TForm1.edDescrChange(Sender: TObject);
begin
  GTrend1.SetChanDescr(ChanSel.ItemIndex,  edDescr.Text );
end;

procedure TForm1.edNameChange(Sender: TObject);
var
  Chan : Integer;
begin
    // Get the selected channel ...
  Chan := ChanSel.ItemIndex ;
    // Put in the the changed text into the channel ...
  GTrend1.SetChanName( Chan, edname.Text );
    // Add the same text into the channel selection group ...
  ChanSel.Items[ Chan ] := IntToStr(Chan) + ' - ' + edname.Text ;
end;

procedure TForm1.cbLineStyleChange(Sender: TObject);
begin
  GTrend1.SetChanLimPStyle(ChanSel.ItemIndex, TPenStyle(cbLineStyle.ItemIndex));
end;

{ ****************************************************************************
  These procedures below are activated from events in the TGTrend module ...
  ****************************************************************************}
procedure TForm1.GTrend1ChangedChanScale(Sender: TObject; Chan: Integer);
begin
  UpdateChanSel_Datas;
end;

procedure TForm1.GTrend1ChangedMarker(Sender: TObject; dt: TDateTime; Values: array of Single);
begin
  Edit1.Text := DateTimeToStr(dt);
  Edit2.Text := FormatFloat('##0.00',Values[GTrend1.ActiveChan]);
end;

procedure TForm1.GTrend1ChangedTimeScale(Sender: TObject);
begin
  scbDuration.Position := Trunc((24*60*60) * Gtrend1.DurationTime );
end;

{ ****************************************************************************
  These procedures belongs to the changing the time setup from the scrollbars ...
  ****************************************************************************}
procedure TForm1.scbDurationChange(Sender: TObject);
begin
  Statusbar1.Panels [4].Text := 'Duration : ' + myDurationTime;
  Gtrend1.DurationTime := scbDuration.Position /(24*60*60);
end;

function TForm1.myDurationTime(): String;
var
  h, m, s : Integer;
begin
  h := scbDuration.Position div (60*60);
  m := (scbDuration.Position -(h*60*60)) div 60;
  s := scbDuration.Position mod 60;
  if h > 23 then
    Result := Format('%d dag, %2.2d:%2.2d:%2.2d',[h div 24, h mod 24,m,s])
  else
    Result := Format('%2.2d:%2.2d:%2.2d',[h,m,s]);
end;

procedure TForm1.scbRewindChange(Sender: TObject);
var
  OldestTime, NewestTime, Duration : TDateTime;
  myDurationTimeExt : Extended;
begin
  with GTrend1 do begin
    OldestTime := GetOldestDataTime;
    NewestTime := GetNewestDataTime;
    myDurationTimeExt := scbDuration.Position /(24*60*60);
    if (OldestTime + myDurationTimeExt) < NewestTime then begin
        Duration := NewestTime - (OldestTime + myDurationTimeExt);
        with scbRewind do
          EndTime := NewestTime -(Duration * ((Max - Position) /Max));
    end;
  end;
end;

procedure TForm1.cbAdaptPlotClick(Sender: TObject);
begin
    GTrend1.SetChanAdaptive( ChanSel.ItemIndex, cbAdaptPlot.Checked );
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  Form_About.ShowModal;
end;

// --------------------( End of Program )-------------------------------------------------------
procedure TForm1.btnOptimizeScaleClick(Sender: TObject);
begin
  if (pbnScMax.AsFloat <> 0) OR (pbnScMin.AsFloat <>0 ) then begin
    pbsScaleMax.AsFloat :=  pbnScMax.AsFloat * 1.1 ;
    pbsScaleMin.AsFloat :=  pbnScMin.AsFloat * 0.9 ;
  end;
end;

end.
