{$I dbpOptions.Inc}
unit DbpBdeSet;

interface

uses
  {SysUtils,} Classes, Db, dbtables, DbpSet;

type
  TDPBdeFindIndex=class(TDPFindIndex)
  private
    function TableFindKey(const KeyValues:Variant; const ExactFind:Boolean):Boolean;
  protected
  {$IFNDEF V4_MORE}
    function GetIndexDefs:TIndexDefs; override;
  {$ENDIF}
    function FindKey(const KeyValues:Variant):Boolean; override;
    procedure FindNearest(const KeyValues:Variant); override;
  end;

  TDPBdeFindPanel=class(TDBFindPanel)
  protected
    function CreateFindIndex:TDPFindIndex; override;
  end;


  TDPBdeFindDialog=class(TDBFindDialog)
  protected
    function CreatePanelFieldsSet:TPanelFieldsSet; override;
  end;

implementation
{$IFDEF V6_MORE}
uses Variants;
{$ENDIF}


type
  TBDEFindComponent=class(TDBFindComponent)
  protected
    function CreateFindIndex:TDPFindIndex; override;
  end;

{ TDPBdeFindIndex }

{$IFNDEF V4_MORE}
function TDPBdeFindIndex.GetIndexDefs:TIndexDefs;
begin
  if (DataSet is TTable) then result:=TTable(DataSet).IndexDefs
  else result:= inherited GetIndexDefs;
end;
{$ENDIF}

function TDPBdeFindIndex.FindKey(const KeyValues:Variant):Boolean;
begin
  if DataSet is TTable then result:=TableFindKey(KeyValues,true)
  else result:=inherited FindKey(KeyValues);
end;

procedure TDPBdeFindIndex.FindNearest(const KeyValues:Variant);
begin
  if DataSet is TTable then TableFindKey(KeyValues,false)
  else inherited FindNearest(KeyValues);
end;

function TDPBdeFindIndex.TableFindKey(const KeyValues:Variant; const ExactFind:Boolean):Boolean;
var
  i,HighBound:Integer;
begin
  HighBound:=VarArrayHighBound(KeyValues,1);
  TTable(DataSet).SetKey;
  for i:=0 to Count-1 do
  begin
    if i<=HighBound then Items[i].Field.Value:=KeyValues[i]
    else Items[i].Field.Value:=null;
  end;
  if ExactFind then result:=TTable(DataSet).GotoKey
  else
  begin
    TTable(DataSet).GotoNearest;
    result:=true;
  end;
end;

{ TDPBdeFindPanel }

function TDPBdeFindPanel.CreateFindIndex:TDPFindIndex;
begin
  result:=TDPBdeFindIndex.Create(Self);
end;

{ TBDEFindComponent }

function TBDEFindComponent.CreateFindIndex:TDPFindIndex;
begin
  result:=TDPBdeFindIndex.Create(Self);
end;

{ TDPBdeFindDialog }

function TDPBdeFindDialog.CreatePanelFieldsSet:TPanelFieldsSet;
begin
  result:=TBDEFindComponent.Create(Self);
end;

end.
