unit Main;

interface

uses
  Windows, SysUtils, Classes, Controls, Forms, Graphics, StdCtrls, ParamSync, Math;
  
type
  TFormMain = class;
  TBoing = class (TObject)
  private
    Pos: TPoint;
    Up: TPoint;
    Height,Width: Integer;
  public
    function Next: TPoint;
    constructor Create(Height,Width: Integer);
  end;
  TAParamThread = class(TParamThread)
  private
    Form: TFormMain;
    ID: Integer;
    Color: TColor;
    procedure DrawSync(ID: Byte; I: Integer; Color: TColor; S: string); pascal; {IMPORTANT: only pascal parameters convention supported}
    procedure DrawAsync(ID: Byte; I: Integer; Color: TColor); pascal;
    procedure DrawAsyncCarrier(ID: Byte; I: Integer; Color: TColor; S: string); pascal;
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean; ID: Integer; Form: TFormMain; Color: TColor);
  end;
  TAThread = class(TThread)
  private
    Form: TFormMain;
    ID: Integer;
    Color: TColor;
    ParamSynchronize: TParamSynchronize;
    ParamAsynchronize: TParamAsynchronize;
    procedure DrawSync(ID: Byte; I: Integer; Color: TColor; S: string); pascal; {IMPORTANT: only pascal parameters convention supported}
    procedure DrawAsync(ID: Byte; I: Integer; Color: TColor); pascal;
    procedure DrawAsyncCarrier(ID: Byte; I: Integer; Color: TColor; S: string); pascal;
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean; ID: Integer; Form: TFormMain; Color: TColor);
    destructor Destroy; override;
  end;
  TFormMain = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    Boings: array [0..7] of TBoing;
    ParamThreads: array [0..3] of TAParamThread;
    Threads: array [0..3] of TAThread;
    procedure Draw(ID: Byte; I: Integer; Color: TColor; S: string);
  end;

var
  FormMain: TFormMain;

implementation

{$R *.dfm}

constructor TBoing.Create(Height,Width: Integer);
begin
  inherited Create;
  Self.Height := Height;
  Self.Width := Width;
  Up.X := 1;
  Up.Y := 1;
  Pos.X := RandomRange(0,Self.Width);
  Pos.Y := RandomRange(0,Self.Height);
end;

function TBoing.Next: TPoint;
begin
  if (Pos.X <= 0) then
    Up.X := 1
  else if (Pos.X >= Self.Width) then
    Up.X := - 1;
  if (Pos.Y <= 0) then
    Up.Y := 1
  else if (Pos.Y >= Self.Height) then
    Up.Y := - 1;
  Pos.X := Pos.X + Up.X + RandomRange(-1,1);
  Pos.Y := Pos.Y + Up.Y + RandomRange(-1,1);
  Result := Pos;
end;

procedure TAParamThread.DrawSync(ID: Byte; I: Integer; Color: TColor; S: string);
begin
  if ParamSynchronize(@TAParamThread.DrawSync) then Exit;
  Form.Draw(ID,I,Color,S + ' S');
end;

procedure TAParamThread.DrawAsync(ID: Byte; I: Integer; Color: TColor);
begin
  if ParamAsynchronize(@TAParamThread.DrawAsync) then Exit;
  Form.Draw(ID,I,Color,'');
end;

procedure TAParamThread.DrawAsyncCarrier(ID: Byte; I: Integer; Color: TColor; S: string);
type
  TCarrier = record
    ID: Byte; I: Integer; Color: TColor; S: string[16] {Must be a sort string}
  end;
var
  Carrier: ^TCarrier;
begin
  if ParamAsynchronizeNewCarrier(Carrier,SizeOf(TCarrier),@TAParamThread.DrawAsyncCarrier) then begin
    Carrier^.ID := ID;
    Carrier^.I := I;
    Carrier^.Color := Color;
    Carrier^.S := S;
    ParamAsynchronizeSendCarrier(Carrier);
    Exit;
  end;
  Form.Draw(Carrier^.ID,Carrier^.I,Carrier^.Color,Carrier^.S + ' A');
end;

procedure TAParamThread.Execute;
var
  I,R: Integer;
  S: string;
begin
  I := 0;
  R := 100;
  while (I <= 1000) and not Terminated do begin
    if (I mod 100) = 0 then
      S := 'ID: ' + IntToStr(ID)
    else
      S := '';
    if ID = 0 then begin
      DrawSync(ID,I,Color,S);
      Sleep(1);
    end
    else begin
      if ID = 3 then
        DrawAsyncCarrier(ID,I,Color,S)
      else
        DrawAsync(ID,I,Color);
      if (I mod R) = 0 then begin
        Sleep(R);
        R := RandomRange(20,200);
      end;
    end;
    Inc(I);
  end;
end;

constructor TAParamThread.Create(CreateSuspended: Boolean; ID: Integer; Form: TFormMain; Color: TColor);
begin
  inherited Create(CreateSuspended);
  Self.ID := ID;
  Self.Form := Form;
  Self.Color := Color;
end;

procedure TAThread.DrawSync(ID: Byte; I: Integer; Color: TColor; S: string);
begin
  if ParamSynchronize.Execute(@TAThread.DrawSync) then Exit;
  Form.Draw(ID,I,Color,S + ' S');
end;

procedure TAThread.DrawAsync(ID: Byte; I: Integer; Color: TColor);
begin
  if ParamAsynchronize.Execute(@TAThread.DrawAsync) then Exit;
  Form.Draw(ID,I,Color,'');
end;

procedure TAThread.DrawAsyncCarrier(ID: Byte; I: Integer; Color: TColor; S: string);
type
  TCarrier = record
    ID: Byte; I: Integer; Color: TColor; S: string[16] {Must be a sort string}
  end;
var
  Carrier: ^TCarrier;
begin
  if ParamAsynchronize.NewCarrier(Carrier,SizeOf(TCarrier),@TAThread.DrawAsyncCarrier) then begin
    Carrier^.ID := ID;
    Carrier^.I := I;
    Carrier^.Color := Color;
    Carrier^.S := S;
    ParamAsynchronize.SendCarrier(Carrier);
    Exit;
  end;
  Form.Draw(Carrier^.ID,Carrier^.I,Carrier^.Color,Carrier^.S + ' A');
end;

procedure TAThread.Execute;
var
  I,R: Integer;
  S: string;
begin
  I := 0;
  R := 100;
  while (I <= 1000) and not Terminated do begin
    if (I mod 100) = 0 then
      S := 'ID: ' + IntToStr(ID)
    else
      S := '';
    if ID = 4 then begin
      DrawSync(ID,I,Color,S);
      Sleep(1);
    end
    else begin
      if ID = 7 then
        DrawAsyncCarrier(ID,I,Color,S)
      else
        DrawAsync(ID,I,Color);
      if (I mod R) = 0 then begin
        Sleep(R);
        R := RandomRange(20,200);
      end;
    end; 
    Inc(I);
  end;
end;

constructor TAThread.Create(CreateSuspended: Boolean; ID: Integer; Form: TFormMain; Color: TColor);
begin
  inherited Create(CreateSuspended);
  ParamSynchronize := TParamSynchronize.Create;
  ParamAsynchronize := TParamAsynchronize.Create;
  ParamAsynchronize.StartServerThread(2);
  Self.ID := ID;
  Self.Form := Form;
  Self.Color := Color;
end;

destructor TAThread.Destroy;
begin
  ParamAsynchronize.Free;
  ParamSynchronize.Free;
  inherited Destroy;
end;

procedure TFormMain.Draw(ID: Byte; I: Integer; Color: TColor; S: string);
var
  Rect: TRect;
begin
  Rect.TopLeft := Boings[ID].Next;
  Rect.BottomRight.X := Rect.TopLeft.X + 2;
  Rect.BottomRight.Y := Rect.TopLeft.Y + 2;
  Canvas.Pen.Color := Color;
  Canvas.Ellipse(Rect);
  if Length(S) > 2 then begin
    Canvas.Font.Color := Color;
    Canvas.TextOut(Rect.TopLeft.X,Rect.TopLeft.Y,S);
  end;
end;

procedure TFormMain.FormCreate(Sender: TObject);
var
  I: Integer;
begin
  Randomize;
  for I := Low(Boings) to High(Boings) do
    Boings[I] := TBoing.Create(ClientHeight,ClientWidth);
  ParamThreads[0] := TAParamThread.Create(true,0,Self,clRed);
  with ParamThreads[0] do begin
    StartServerThread(1);
    Resume;
  end;
  ParamThreads[1] := TAParamThread.Create(true,1,Self,clLime);
  with ParamThreads[1] do begin
    StartServerThread(1);
    Resume;
  end;
  ParamThreads[2] := TAParamThread.Create(true,2,Self,clAqua);
  with ParamThreads[2] do begin
    StartServerThread(1);
    Resume;
  end;
  ParamThreads[3] := TAParamThread.Create(true,3,Self,clYellow);
  with ParamThreads[3] do begin
    StartServerThread(1);
    Resume;
  end; 
  Threads[0] := TAThread.Create(true,4,Self,clRed);
  with Threads[0] do begin
    Resume;
  end;
  Threads[1] := TAThread.Create(true,5,Self,clLime);
  with Threads[1] do begin
    Resume;
  end;
  Threads[2] := TAThread.Create(true,6,Self,clAqua);
  with Threads[2] do begin
    Resume;
  end;
  Threads[3] := TAThread.Create(true,7,Self,clYellow);
  with Threads[3] do begin
    Resume;
  end;
end;

procedure TFormMain.FormDestroy(Sender: TObject);
var
  I: Integer;
begin
  for I := Low(ParamThreads) to High(ParamThreads) do
    ParamThreads[I].Terminate;
  for I := Low(Threads) to High(Threads) do
    Threads[I].Terminate;
  for I := Low(ParamThreads) to High(ParamThreads) do
    ParamThreads[I].Free;
  for I := Low(Threads) to High(Threads) do
    Threads[I].Free;
  for I := Low(Boings) to High(Boings) do
    Boings[I].Free;
end;


end.
