unit IPathSyncOptions;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, checklst, ExtCtrls,Registry, ImgList, Buttons;

type
  TIPathSyncOptionsForm = class(TForm)
    WinDir: TCheckBox;
    SysDir: TCheckBox;
    SubSysDir: TCheckBox;
    Ok: TBitBtn;
    Cancel: TBitBtn;
    Label1: TLabel;
    Dirs: TCheckListBox;
    procedure OKClick(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Root                  : String;
  end;

var
  IPathSyncOptionsForm: TIPathSyncOptionsForm;

implementation

{$R *.DFM}
Uses IPathEditorForm;


procedure TIPathSyncOptionsForm.OKClick(Sender: TObject);

Const
  TF                    : Array [Boolean] Of String = ('F','T');

Var
  Loop                  : Integer;
  RegFile               : TRegINIFile;
  Work                  : String;
  At                    : Integer;

begin
  ModalResult := mrOK;
  RegFile := TRegINIFile.Create(Delphi_Root);
  Try
    RegFile.WriteBool(Delphi_EXTRALIBRARYPATHSOps,'WinDir',WinDir.Checked);
    RegFile.WriteBool(Delphi_EXTRALIBRARYPATHSOps,'SysDir',SysDir.Checked);
    RegFile.WriteBool(Delphi_EXTRALIBRARYPATHSOps,'SubSysDir',SubSysDir.Checked);

    RegFile.EraseSection(Delphi_EXTRALIBRARYPATHS);
    For Loop := 0 To Dirs.Items.Count-1 Do
    Begin
      Work := Dirs.Items[Loop];
      At := Pos(Root,Work);
      If (At<>0) Then
      Begin
        Delete(Work,At,Length(Root));
        Insert(RootDirReplaceMarker,Work,At);
      End;
      RegFile.WriteBool(Delphi_EXTRALIBRARYPATHS,Work,Dirs.Checked[Loop]);
    End;
    // We only want to leave the checkec items to be added now.
    For Loop := Dirs.Items.Count-1 DownTo 0 Do
    Begin
      If Not Dirs.Checked[Loop] Then Dirs.Items.Delete(Loop);
    End;
  Finally
    RegFile.Free;
  End;
end;

procedure TIPathSyncOptionsForm.CancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TIPathSyncOptionsForm.FormCreate(Sender: TObject);

Var
  RegFile               : TRegINIFile;
  Strings               : TStringList;
  Loop                  : Integer;
  Work                  : String;
  Checked               : Boolean;
  At                    : Integer;

  Procedure AddChecked(What : String);

  Begin
    At := Dirs.Items.Add(What);
    Dirs.Checked[At] := True;
  End;

Var
  Dir: String;

Begin

  SetLength(Dir,Max_Path);
  GetWindowsDirectory(PChar(Dir),max_Path);
  SetLength(Dir,StrLen(PChar(Dir)));

  WinDir.Caption := Format(WinDir.Caption,[Dir]);

  SetLength(Dir,Max_Path);
  GetSystemDirectory(pChar(Dir),Max_Path);
  SetLength(Dir,StrLen(PChar(Dir)));

  SysDir.Caption := Format(SysDir.Caption,[Dir]);
  SubSysDir.Caption := Format(SubSysDir.Caption,[Dir]);

  RegFile := TRegINIFile.Create(Delphi_ROOT);
  Try
    RegFile.CloseKey;
    RegFile.RootKey := HKEY_LOCAL_MACHINE;
    RegFile.OpenKey(Delphi_ROOT_HKLM,False);
    Root := AddbackSlash(RegFile.ReadString(Delphi_SECTION,Delphi_ROOTDIR,''));
  Finally
    RegFile.Free;
  End;

  RegFile := TRegINIFile.Create(Delphi_ROOT);
  Try
    AddChecked(RootDirReplaceMarker+'\Lib\');
    AddChecked(RootDirReplaceMarker+'\Lib\Delphi2');
    AddChecked(RootDirReplaceMarker+'\Bin\');
    AddChecked(RootDirReplaceMarker+'\Imports');

    Strings := TStringList.Create;
    Try
      WinDir.Checked := RegFile.ReadBool(Delphi_EXTRALIBRARYPATHSOps,'WinDir',WinDir.Checked);
      SysDir.Checked := RegFile.ReadBool(Delphi_EXTRALIBRARYPATHSOps,'SysDir',SysDir.Checked);
      SubSysDir.Checked := RegFile.ReadBool(Delphi_EXTRALIBRARYPATHSOps,'SubSysDir',SubSysDir.Checked);

      RegFile.ReadSection(Delphi_EXTRALIBRARYPATHS,Strings);

      For Loop :=0 To Strings.Count-1 Do
      Begin
        Work := Strings[Loop];
        Checked := RegFile.ReadBool(Delphi_EXTRALIBRARYPATHS,Work,True);

        Work := Trim(Work);

        At := Dirs.Items.IndexOf(Work);
        If (At=-1) Then
        Begin
          At := Dirs.Items.Add(Work);
        End;
        Dirs.Checked[At] := Checked;
      End;

      Caption := Root;
    Finally
      Strings.Free;
    End;
  Finally
    RegFile.Free;
  End;
end;

end.
