unit IPathEditorForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CheckLst, ExtCtrls,Registry, Buttons, ComCtrls,ShellAPI,
  FileCtrl;

const
{$IFDEF VER170}
  Delphi_ROOT                = '\Software\Borland\bds\3.0';
    Delphi_SECTION                 = '3.0';
    Delphi_LIBRARY             = 'Library';
      LIB_SEARCHPATH               = 'Search Path';
      LIB_FULLPATH                 = 'FullPath';
      LIB_LASTTAB                  = 'LastTab';
    Delphi_KNOWNPACKAGES       = 'Known Packages';
    Delphi_EXTRALIBRARYPATHS   = 'Extra Library Paths';
    Delphi_EXTRALIBRARYPATHSOps= 'Extra Library Paths Options';
  Delphi_ROOT_HKLM           = '\Software\Borland\bds';
      Delphi_ROOTDIR             = 'RootDir';
{$Else}
  DELPHI_ROOT                = '\Software\Borland\Delphi\7.0';
    DELPHI_SECTION                 = '7.0';
    DELPHI_LIBRARY             = 'Library';
      LIB_SEARCHPATH               = 'SearchPath';
      LIB_FULLPATH                 = 'FullPath';
      LIB_LASTTAB                  = 'LastTab';
    DELPHI_KNOWNPACKAGES       = 'Known Packages';
    DELPHI_EXTRALIBRARYPATHS   = 'Extra Library Paths';
    DELPHI_EXTRALIBRARYPATHSOps= 'Extra Library Paths Options';
  DELPHI_ROOT_HKLM           = '\Software\Borland\Delphi';
      DELPHI_ROOTDIR             = 'RootDir';
{$ENDIF VER170}

Const
{$IFDEF VER170}
  RootDirReplaceMarker = '$(bds)';
{$Else}
  RootDirReplaceMarker = '$(Delphi)';
{$ENDIF VER170}

type
  TPathEditorAddon = class(TForm)
    SidePanel: TPanel;
    Dirs: TDirectoryListBox;
    Panel1: TPanel;
    btnSort: TBitBtn;
    btnSync: TBitBtn;
    Panel2: TPanel;
    DriveComboBox1: TDriveComboBox;
    procedure btnSyncClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DirsChange(Sender: TObject);
    procedure CreationListClick(Sender: TObject);
    procedure btnSortClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    AddButton           : TButton;
    Bevel1              : TBevel;
    CancelButton        : TButton;
    CLOnClick           : TNotifyEvent;
    CreationList        : TListBox;
    DeleteButton        : TButton;
    DeleteInvalidBtn    : TButton;
    DownButton          : TBitBtn;
    ElementEdit         : TEdit;
    HelpButton          : TButton;
    Label1              : TLabel;
    OKButton            : TButton;
    OrderedListEditDlg  : TCustomForm;
    ReplaceButton       : TButton;
    BrowseButton        : TButton;
    Root                : String;
    UpButton            : TBitBtn;
    InvalidPathLbl      : TLabel;
  end;

var
  PathEditorAddon: TPathEditorAddon;

Function AddBackSlash (InStr : String) : String;

implementation

{$R *.DFM}

Uses IPathSyncOptions;

Function AddBackSlash (InStr : String) : String;

Begin
  Result := Instr;
  If (Copy(Result,Length(Result),1)<>'\') Then
    Result := Result+'\';
End;

procedure TPathEditorAddon.btnSyncClick(Sender: TObject);
Var
  RegFile: TRegIniFile;
  Pkgs: TStringList;
  Loop : Integer;
  At : Integer;
  Work : String;
  IPathSyncOptionsForm : TIPathSyncOptionsForm;

  Procedure AddItem(Item : String; NoWinDir : Boolean; NoSysDir : Boolean; NoSubSysDir : Boolean);
  Var
    Dir : String;
  Begin
    While (Copy(Item,Length(Item)-1,2)='\\') Do
      Delete(Item,Length(Item),1);

    SetLength(Dir,Max_Path);
    GetWindowsDirectory(PChar(Dir),max_Path);
    SetLength(Dir,StrLen(PChar(Dir)));

    Dir := AddBackSlash(AnsiUpperCase(Dir));
    If NoWinDir And (AnsiCompareText(Dir,AddbackSlash(Item))=0) Then
    Begin
      Exit;
    End;

    SetLength(Dir,Max_Path);
    GetSystemDirectory(pChar(Dir),Max_Path);
    SetLength(Dir,StrLen(PChar(Dir)));
    Dir := AddBackSlash(AnsiUpperCase(Dir));

    If (AnsiCompareText(Dir,AddbackSlash(Item))=0) Then
    Begin
      If NoSysDir Then
      Begin
        Exit;
      End;
    End
    Else
    Begin
      If NoSubSysDir And (Pos(Dir,AnsiUpperCase(AddbackSlash(Item)))=1) Then
      Begin
        Exit;
      End;
    End;

    If (CreationList.Items.IndexOf(Item)=-1) Then
      CreationList.Items.Add(Item);
  End;

begin
  RegFile := TRegINIFile.Create(Delphi_ROOT);
  Pkgs := TStringList.Create;
  Try
    RegFile.ReadSection(Delphi_KNOWNPACKAGES,Pkgs);
    For Loop := 0 To Pkgs.Count-1 Do
    Begin
      Work := Pkgs[Loop];
      Work := AddBackSlash(ExtractFilePath(work));
      Pkgs[Loop] := Work;
    End;

    For Loop := Pkgs.Count-1 DownTo 0 Do
    Begin
      Work := Pkgs[Loop];
      At := Pkgs.IndexOf(Work);
      If (At<>Loop) Then
      Begin
        Pkgs.Delete(Loop);
      End;
    End;

    IPathSyncOptionsForm := TIPathSyncOptionsForm.Create(Self);
    Try
      If (IPathSyncOptionsForm.ShowModal=mrOk) Then
      Begin
        CreationList.Clear;
        With IPathSyncOptionsForm Do
        Begin
          For Loop := 0 To Dirs.Items.Count-1 Do
            AddItem(Dirs.Items[Loop],WinDir.Checked,SysDir.Checked,SubSysDir.Checked);
          For Loop := 0 To Pkgs.Count-1 Do
            AddItem(Pkgs[Loop],WinDir.Checked,SysDir.Checked,SubSysDir.Checked);
        End;
      End;
    Finally
      IPathSyncOptionsForm.Free;
    End;
  Finally
    Pkgs.Free;
    RegFile.Free;
  End;
end;

procedure TPathEditorAddon.FormCreate(Sender: TObject);

Var
  RegFile : TRegINIFile;
  Min : integer;
begin
  RegFile := TRegINIFile.Create(Delphi_ROOT);
  Try
    RegFile.CloseKey;
    RegFile.RootKey := HKEY_LOCAL_MACHINE;
    RegFile.OpenKey(Delphi_ROOT_HKLM,False);
    Root := AddbackSlash(RegFile.ReadString(Delphi_SECTION,Delphi_ROOTDIR,''));
    Delete(Root,Length(Root),1);
  Finally
    RegFile.Free;
  End;

  OrderedListEditDlg := Owner As TCustomForm;
  CreationList := OrderedListEditDlg.FindComponent('CreationList') as  TListBox;
  ElementEdit := OrderedListEditDlg.FindComponent('ElementEdit') as  TEdit;
  Min := 410;
  if OrderedListEditDlg.Width < (Min + SidePanel.Width) then
  OrderedListEditDlg.ClientWidth := OrderedListEditDlg.ClientWidth+SidePanel.Width;
  OrderedListEditDlg.Left := (Screen.Width-OrderedListEditDlg.Width) Div 2;
  OrderedListEditDlg.Constraints.MinWidth := Min + SidePanel.Width;
  Bevel1 := OrderedListEditDlg.FindComponent('Bevel1') as  TBevel;
  AddButton := OrderedListEditDlg.FindComponent('AddButton') as TButton;
  CancelButton := OrderedListEditDlg.FindComponent('CancelButton') as  TButton;
  DeleteButton := OrderedListEditDlg.FindComponent('DeleteButton') as  TButton;
  DownButton := OrderedListEditDlg.FindComponent('DownButton') as  TBitBtn;
  HelpButton := OrderedListEditDlg.FindComponent('HelpButton') as  TButton;
  Label1 := OrderedListEditDlg.FindComponent('Label1') as  TLabel;
  OKButton := OrderedListEditDlg.FindComponent('OkButton') as  TButton;
  ReplaceButton := OrderedListEditDlg.FindComponent('ReplaceButton') as  TButton;
  UpButton := OrderedListEditDlg.FindComponent('UpButton') as  TBitBtn;
  BrowseButton := OrderedListEditDlg.FindComponent('BrowseButton') as  TButton;
  DeleteInvalidBtn := OrderedListEditDlg.FindComponent('DeleteInvalidBtn') as  TButton;
  InvalidPathLbl := OrderedListEditDlg.FindComponent('InvalidPathLbl') as  TLabel;
  CancelButton.Left := CancelButton.Left-SidePanel.Width;
  OkButton.Left := OkButton.Left-SidePanel.Width;
  HelpButton.Left := HelpButton.Left-SidePanel.Width;
  DownButton.Left := DownButton.Left-SidePanel.Width;
  UpButton.Left := UpButton.Left-SidePanel.Width;
  Bevel1.Width := Bevel1.Width-SidePanel.Width;
  DeleteInvalidBtn.Left := DeleteInvalidBtn.Left-SidePanel.Width;
  CreationList.Width := CreationList.Width-SidePanel.Width;
  ElementEdit.Width := ElementEdit.Width-SidePanel.Width;
  BrowseButton.Left := BrowseButton.Left-SidePanel.Width;
  DeleteButton.Left := DeleteButton.Left-SidePanel.Width;
  AddButton.Left := AddButton.Left-SidePanel.Width;
  ReplaceButton.Left := ReplaceButton.Left-SidePanel.Width;
  SidePanel.Parent := OrderedListEditDlg;
  CLOnClick := CreationList.OnClick;
  CreationList.OnClick := CreationListClick;
  CreationListClick(Self);
end;

procedure TPathEditorAddon.DirsChange(Sender: TObject);

Var
  At : Integer;
  aDir : String;

begin
  aDir := Dirs.Directory;

  If (Pos(AnsiUpperCase(Root),AnsiUpperCase(ADir))=1) Then
  Begin
    Delete(ADir,1,Length(Root));
    ADir := RootDirReplaceMarker+ADir;
  End;

  ElementEdit.Text := ADir;
  At := CreationList.Items.IndexOf(ADir);

  If (CreationList.ItemIndex<>At) And (At<>-1) Then
    CreationList.ItemIndex := At;
end;

procedure TPathEditorAddon.CreationListClick(Sender: TObject);

Var
  ADir : String;

begin
  If (CreationList.ItemIndex=-1) Then
  Begin
    ADir := RootDirReplaceMarker;
  End
  Else
  Begin
    ADir := CreationList.Items[CreationList.ItemIndex];
  End;

  If (Pos(AnsiUpperCase(RootDirReplaceMarker),AnsiUpperCase(ADir))=1) Then
  Begin
    Delete(ADir,1,Length(RootDirReplaceMarker));
    ADir := Root+ADir;
  End;

  If AnsiCompareText(Dirs.Directory,aDir)<>0 Then
  Begin
    Dirs.OnChange := Nil;
    Try
      Dirs.Directory := aDir;
    Except
      Try
        Dirs.Directory := Root;
      Except
      End;
    End;
    Dirs.OnChange := DirsChange;
  End;

  If (Sender<>Self) And Assigned(CLOnClick) Then
  Begin
    CLOnClick(Sender);
  End;
end;

procedure TPathEditorAddon.btnSortClick(Sender: TObject);

Var
  Paths : TStringList;

Begin
  Paths := TStringList.Create;
  Try
    Paths.Assign(CreationList.Items);
    Paths.Sort;
    CreationList.Items.Assign(Paths);
  Finally
    Paths.Free;
  End;
End;

end.
