{ TShellLink 1.00 - 20-11-98

  Copyright by Karsten Bendsen (Koger) koger@iname.com

  Freeware for all NON-commerciel programs, otherwise contact me!
  Please send me a email about what you think of the component}

unit ShellLink;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ShlObj, ActiveX, ComObj;

type
  TShellLink = class(TComponent)
  private
    FArguments: String;
    FDescription: String;
    FIconFile: TFileName;
    FProgramFile: TFileName;
    FLinkFile: TFileName;
    FWorkingDirectory: String;
    FIconIndex: Cardinal;
    FHotKey: TShortCut;
    FWindowState: TWindowState;
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
  published
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Read;
    procedure Write;

    property Arguments: String read FArguments write FArguments;
    property Description: String read FDescription write FDescription;
    property IconFile: TFileName read FIconFile write FIconFile;
    property IconIndex: Cardinal read FIconIndex write FIconIndex;
    property HotKey: TShortCut read FHotKey write FHotKey; 
    property LinkFile: TFileName read FLinkFile write FLinkFile;
    property ProgramFile: TFileName read FProgramFile write FProgramFile;
    property WindowState: TWindowState read FWindowState write FWindowState;
    property WorkingDirectory: String read FWorkingDirectory write FWorkingDirectory;
    { Published declarations }
  end;

  procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TShellLink]);
end;

constructor TShellLink.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  WindowState := wsNormal;  
end;

destructor TShellLink.Destroy;
begin
  inherited Destroy;
end;

{ TShellLink }

procedure TShellLink.Read;
var
  AnObj: IUnknown;
  ShLink: IShellLink;
  PFile: IPersistFile;
  WFileName: WideString;  
  Data: TWin32FindData;
  pwHotKey: word;
  Int: Integer;
  Buffer: array [0..255] of char;
begin
  AnObj := CreateComObject(CLSID_ShellLink);
  ShLink := AnObj as IShellLink;
  PFile := AnObj as IPersistFile;
//Load
  WFileName := LinkFile;
  PFile.Load(PWChar(WFileName), STGM_READ);
//GetLink properties
//Parameters
  ShLink.GetArguments(Buffer,SizeOf(Buffer));
  Arguments := Buffer;
//Description
  ShLink.GetDescription(Buffer,SizeOf(Buffer));
  Description := Buffer;
//HotKey
  ShLink.GetHotKey(pwHotKey);
  HotKey := pwHotKey;
//Icon
  ShLink.GetIconLocation(Buffer, SizeOf(Buffer), Int);
  IconFile := Buffer;
  IconIndex := Int;
//Shelllink
  ShLink.GetPath(Buffer, Sizeof(Buffer), Data, SLGP_UNCPRIORITY);
  ProgramFile := Buffer;
//Windows state
  ShLink.GetShowCmd(Int);
  case Int of
    SW_SHOWNORMAL: WindowState := wsNormal;
    SW_MINIMIZE: WindowState := wsMinimized;
    SW_MAXIMIZE: WindowState := wsMaximized;
  end;
//Work Dir
  ShLink.GetWorkingDirectory(Buffer, Sizeof(Buffer));
  WorkingDirectory := Buffer;
end;

procedure TShellLink.Write;
var
  AnObj: IUnknown;
  ShLink: IShellLink;
  PFile: IPersistFile;
  WFileName: WideString;
begin
  AnObj := CreateComObject(CLSID_ShellLink);
  ShLink := AnObj as IShellLink;
  PFile := AnObj as IPersistFile;
//Set Link properties
//Parameters
  ShLink.SetArguments(PChar( Arguments ));
//Description
  ShLink.SetDescription(PChar( Description ));
//Hotkey
  ShLink.SetHotKey(HotKey);
//Icon
  if IconFile <> '' then
    ShLink.SetIconLocation(PChar( IconFile ), IconIndex);
//Shelllink target
  ShLink.SetPath(PChar( ProgramFile ));
//ShowCommand
  case WindowState of
    wsNormal   : ShLink.SetShowCmd(SW_SHOWNORMAL);
    wsMinimized: ShLink.SetShowCmd(SW_MINIMIZE);
    wsMaximized: ShLink.SetShowCmd(SW_MAXIMIZE);
  end;
//Working Dir
  if WorkingDirectory = '' then
    WorkingDirectory := ExtractFilePath( ProgramFile );
  ShLink.SetWorkingDirectory(PChar( WorkingDirectory ));
// Save
  WFileName := LinkFile;
  PFile.Save(PWChar(WFileName), False);
end;

end.
