unit demomain;
{
Updated by Angus Robertson, Magenta Systems Ltd, England, 3rd November 2005
delphi@magsys.co.uk, http://www.magsys.co.uk/delphi/
Copyright Magenta Systems Ltd

This is a test and demo application for the TMagHttp, TMagFtp and TMagFileCopy
Magenta Systems File Transfer Components.

Magenta Systems DUN Manager application (from http://www.magsys.co.uk/dunman/),
has more extensive demonstrations of these components, look under Scheduled Task
Properties, HTTP Download, FTP Upload, FTP Download and Sync Files.

Requires Internet Component Suite (ICS) from http://www.overbyte.be/, dated
1st November 2005 or later.

Compatible with Delphi 5/6/7/2005/2006
Tested with Windows 98, NT4, Windows 2000, XP and 2003

Requires Kevin Boylan's TVCLZip component for zipping from http://www.vclzip.net/,
if you don't purchase this component you will need to suppress DEFINE Zipping from
MAGZIP.INC so the zip code is not linked.

Note this demo program does not make use of all the component's functionality,
but there are comments indicating where alternative properties may be set.

22 Sep 2004 - 1.2 - added single file FTP download and upload (faster since no directory listing)
22 Aug 2005 - 1.3 - various bug fixes
6  Sep 2005 - 1.4 - magcopy and magftp supports files larger than 2 gigs
                    testing SSL and fix for small FTP file uploads
3 Nov 2005  - 1.5 - bug fixes



}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, MagCopy, MagFtp, MagHttp, MagSubs1, Wsocket, Ftpcli, FtpSrvT,
  ComCtrls ;

type
  TForm1 = class(TForm)
    LogText: TMemo;
    Label1: TLabel;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    doCopyCheck: TButton;
    doCopyList: TButton;
    Label2: TLabel;
    Label3: TLabel;
    CopySrcDir: TEdit;
    CopySrcFile: TEdit;
    doCopyFiles: TButton;
    CopyTarDir: TEdit;
    Label4: TLabel;
    doCopyAbort: TButton;
    LabelProgress: TLabel;
    LogDelim: TMemo;
    ShowDiags: TCheckBox;
    doExit: TButton;
    doDeleteCheck: TButton;
    doDeleteFiles: TButton;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    FtpLocDir: TEdit;
    HttpTarDir: TEdit;
    doHttpDownCheck: TButton;
    doFtpDownCheck: TButton;
    doHttpDownFiles: TButton;
    doHttpAbort: TButton;
    Label8: TLabel;
    FtpPath: TEdit;
    Label9: TLabel;
    FtpHost: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    FtpUsername: TEdit;
    FtpPassword: TEdit;
    Label12: TLabel;
    doFtpDownFiles: TButton;
    Label13: TLabel;
    FtpSrcFile: TEdit;
    doFtpAbort: TButton;
    doFtpList: TButton;
    doFtpUpCheck: TButton;
    doFtpUpFiles: TButton;
    Label14: TLabel;
    TabSheet4: TTabSheet;
    Ftp1Path: TEdit;
    Label15: TLabel;
    Label16: TLabel;
    Ftp1SrcName: TEdit;
    Label17: TLabel;
    Ftp1LocDir: TEdit;
    doFtpDown1: TButton;
    FtpReplace: TCheckBox;
    doFtpUp1: TButton;
    Label18: TLabel;
    Ftp1UpFile: TEdit;
    doTest: TButton;
    HttpSrcDir: TComboBox;
    HttpSrcFile: TComboBox;
    procedure doCopyListClick(Sender: TObject);
    procedure CopyFiles(Sender: TObject);
    procedure doAbortClick(Sender: TObject);
    procedure doExitClick(Sender: TObject);
    procedure DeleteFiles(Sender: TObject);
    procedure HttpDownload(Sender: TObject);
    procedure FtpDownload(Sender: TObject);
    procedure doFtpListClick(Sender: TObject);
    procedure FtpUpload(Sender: TObject);
    procedure doFtpDown1Click(Sender: TObject);
    procedure doFtpUp1Click(Sender: TObject);
    procedure doTestClick(Sender: TObject);
  private
    { Private declarations }
    procedure AddLogText (S: string) ;
    procedure AddLogDelim (S: string) ;
    procedure onCopyEvent (LogLevel: TLogLevel ; Info: string ;
                                                      var Cancel: boolean) ;
    procedure onHttpEvent (LogLevel: TLogLevel ; Info: string ;
                                                  var Cancel: boolean) ;
    function SetFTPGen: boolean ;
    procedure SetFtpButtons (value: boolean) ;
    procedure onFtpEvent (LogLevel: TLogLevel ; Info: string ;
                                                  var Cancel: boolean) ;
  public
    { Public declarations }
  end;

var
    Form1: TForm1;
    MagHTTPClient: TMagHTTP ;
    MagFTPClient: TMagFTP ;
    MagFileCopyClient: TMagFileCopy ;
    AbortFlag: boolean ;

implementation

{$R *.dfm}

procedure TForm1.AddLogText (S: string) ;
begin
    LogText.Lines.Add (S) ;   // general unformatted comments about xfers
end ;

procedure TForm1.AddLogDelim (S: string) ;
begin
    LogDelim.Lines.Add (S) ;   // delimited formatted xfer information
end ;

procedure TForm1.doAbortClick(Sender: TObject);
begin
    AbortFlag := true ;
end;

procedure TForm1.doExitClick(Sender: TObject);
begin
    AbortFlag := true ;
    Close ;
end;

procedure TForm1.onCopyEvent (LogLevel: TLogLevel ; Info: string ;
                                                  var Cancel: boolean) ;
begin
    if (LogLevel = LogLevelInfo) or (LogLevel = LogLevelFile) then
    begin
        AddLogText (Info) ;
        LabelProgress.Caption := Info ;
    end ;
    if (LogLevel = LogLevelProg) then
    begin
        if Info <> '' then LabelProgress.Caption := 'Progress: ' + Info ;
    end ;
    if (LogLevel = LogLevelDiag) and ShowDiags.Checked then AddLogText (Info) ;
    if (LogLevel = LogLevelDelimFile) then AddLogDelim (Info) ;
    if (LogLevel = LogLevelDelimTot) then AddLogDelim (Info) ;
    if AbortFlag then Cancel := true ;
end ;

procedure TForm1.doCopyListClick(Sender: TObject);
begin
    AbortFlag := false ;
    MagFileCopyClient := TMagFileCopy.Create (self) ;
    doCopyFiles.Enabled := false ;
    doCopyCheck.Enabled := false ;
    doCopyList.Enabled := false ;
    doCopyAbort.Enabled := true ;
    try
        MagFileCopyClient.CopyEvent := onCopyEvent ;
        AddLogText (MagFileCopyClient.DispLocFiles (CopySrcDir.Text,
                                    CopySrcFile.Text, FCTypeMaskDir, true, false)) ;
    finally
        FreeAndNil (MagFileCopyClient) ;
        LabelProgress.Caption := 'List Completed' ;
        doCopyFiles.Enabled := true ;
        doCopyCheck.Enabled := true ;
        doCopyList.Enabled := true ;
        doCopyAbort.Enabled := false ;
    end ;
end;

procedure TForm1.CopyFiles(Sender: TObject);
var
    taskres: TTaskResult ;
    checkflag: boolean ;
begin
    AbortFlag := false ;
    MagFileCopyClient := TMagFileCopy.Create (self) ;
    doCopyFiles.Enabled := false ;
    doCopyCheck.Enabled := false ;
    doCopyList.Enabled := false ;
    doCopyAbort.Enabled := true ;
    try
        checkflag := false ;
        if Sender = doCopyCheck then checkflag := true ;
        try
            with MagFileCopyClient do
            begin
                MultiDir := false ; // true copy multiple specific directorie
           //  multi directories are passed as srcdir+tab+tardir+recsep (repeat)
           //   MultiDirList :=
           // or as a pair of TStringLists
           //   SrcDirList :=  ;
           //   TarDirList :=  ;
           // not multidirs, pass source, file and target separately
                SrcDir := CopySrcDir.Text ;
                SrcFName := CopySrcFile.Text ;
                TarDir := CopyTarDir.Text ;
            // CopyType: FCTypeSingle, FCTypeMaskDir, FCTypeArchDir, FCTypeAllDir, FCTypeDates
                CopyType := FCTypeMaskDir ;
                SubDirs := true ;   // true copy all sub directories
                DelDone := false ;  // true delete source file after copy
                DelOldTar := false ; // true, delete target files not in source directories
                Mask := false ;     // true, allow date/time masked characters in SrcFName
                Prev := false ;     // true, use yesterday's date for Mask
            // Repl: FCReplNever, FCReplAlways, FCReplDiff, FCReplNewer
                Repl := FCReplNever ;
                ReplRO := true ;    // true, replace read only files
                Safe := false ;     // true, copy file with TMP extension, rename when done
                LocalHost := WSocket.LocalHostName ;
                CopyEvent := onCopyEvent ;
            { following properties only available if VCLZip available
                Zipped := false ;
                ZipDownDel := false ;
           // ZipExtFmt: ExtnAdd, ExtnReplace
           // ZipPath: PathNone, PathNew, PathOriginal, PathNewOrig, PathSpecific, PathSpecOrig
           // ZipType: TypeUnzip, TypeSrcAddX, TypeSrcReplX, TypeSrcDirs
                ZipType := TypeUnzip ;
                ZipPath := PathNone ;
                ZipDir := '' ;   }
                IgnoreFileExt := 'tmp' ;
                taskres := SelCopyFiles (checkflag) ;   // main file copy function
                AddLogText ('Task Result: ' + GetTaskResName (taskres)) ;
                AddLogText (ReqResponse) ;
            end ;
        except
            AddLogText ('Copying Error - ' + GetExceptMess (ExceptObject)) ;
        end ;
    finally
        FreeAndNil (MagFileCopyClient) ;
        LabelProgress.Caption := 'Copy Completed' ;
        doCopyFiles.Enabled := true ;
        doCopyCheck.Enabled := true ;
        doCopyList.Enabled := true ;
        doCopyAbort.Enabled := false ;
    end ;
end;

procedure TForm1.DeleteFiles(Sender: TObject);
var
    taskres: TTaskResult ;
    checkflag: boolean ;
begin
    AbortFlag := false ;
    MagFileCopyClient := TMagFileCopy.Create (self) ;
    doDeleteFiles.Enabled := false ;
    doDeleteCheck.Enabled := false ;
    doCopyAbort.Enabled := true ;
    try
        checkflag := false ;
        if Sender = doDeleteCheck then checkflag := true ;
        try
            with MagFileCopyClient do
            begin
                SrcDir := CopyTarDir.Text ;
                SrcFName := CopySrcFile.Text ;
                MultiDir := false ; // true copy multiple specific directorie
                SubDirs := true ;   // true copy all sub directories
                Mask := false ;     // true, allow date/time masked characters in SrcFName
                Prev := false ;     // true, use yesterday's date for Mask
                CopyLoDT := 0 ;     // lower date range
                CopyHiDT := Now ;   // higher date range
                CopyEvent := onCopyEvent ;
                taskres := DeleteFiles (checkflag) ;   // main file delete function
                AddLogText ('Task Result: ' + GetTaskResName (taskres)) ;
                AddLogText (ReqResponse) ;
            end ;
        except
            AddLogText ('Copying Error - ' + GetExceptMess (ExceptObject)) ;
        end ;
    finally
        FreeAndNil (MagFileCopyClient) ;
        LabelProgress.Caption := 'Delete Completed' ;
        doDeleteFiles.Enabled := true ;
        doDeleteCheck.Enabled := true ;
        doCopyAbort.Enabled := false ;
    end ;
end;

procedure TForm1.onHttpEvent (LogLevel: TLogLevel ; Info: string ;
                                                  var Cancel: boolean) ;
begin
    if (LogLevel = LogLevelInfo) or (LogLevel = LogLevelFile) then
    begin
        AddLogText (Info) ;
        LabelProgress.Caption := Info ;
    end ;
    if (LogLevel = LogLevelProg) then LabelProgress.Caption := 'Progress: ' + Info ;
    if (LogLevel = LogLevelDiag) and ShowDiags.Checked then AddLogText (Info) ;
    if (LogLevel = LogLevelDelimFile) then AddLogDelim (Info) ;
    if (LogLevel = LogLevelDelimTot) then AddLogDelim (Info) ;
    if AbortFlag then Cancel := true ;
end ;

procedure TForm1.HttpDownload(Sender: TObject);
var
    taskres: TTaskResult ;
    checkflag: boolean ;
const
    ReplaceList: array[0..2] of TFileCopyRepl = (FCReplNever, FCReplAlways, FCReplNewer) ;
begin
    AbortFlag := false ;
    doHttpDownCheck.Enabled := false ;
    doHttpDownFiles.Enabled := false ;
    doHttpAbort.Enabled := true ;
    MagHTTPClient := TMagHTTP.Create (self) ;
    try
        try
            checkflag := false ;
            if Sender = doHttpDownCheck then checkflag := true ;
            with MagHTTPClient do
            begin
                URLList := HttpSrcDir.Text ;  // one or more source URLs separated by CRLF
                SrcMask := HttpSrcFile.Text ; // optional source file mask to restrict downloads
                DownDir := HttpTarDir.Text ;  // directory for downloaded files
                KeepPath := false ;           // if true, use HTTP path for subdirs
                KeepHost := false ;           // if true, use HTTP host for subdir
                ParseHTML := true ;           // if true, parse HTML page for links to files
                Repl := ReplaceList [2] ;     // replace options
                ReplRO := true ;              // replace read only files
  //              Timeout := 60 ;               // command timeout
                LogFiles := true ;            // log each file downloaded
                LogProt := ShowDiags.Checked ;// log HTTP protocol
                LogLDir := false ;            // log destination directory
                LogRDir := true ;             // log created HTTP directory
                CopyEvent := onHttpEvent ;
           //   ProxyPort :=  ;
           //   Proxy :=  ;
             { following properties only available if VCLZip available
                Zipped := false ;
                ZipDownDel := false ;
           // ZipExtFmt: ExtnAdd, ExtnReplace
           // ZipPath: PathNone, PathNew, PathOriginal, PathNewOrig, PathSpecific, PathSpecOrig
           // ZipType: TypeUnzip, TypeSrcAddX, TypeSrcReplX, TypeSrcDirs
                ZipPath := PathNone ;
                ZipDir := '' ;   }
                taskres := Download (checkflag) ;  // main download function
                AddLogText ('Task Result: ' + GetTaskResName (taskres)) ;
                AddLogText (ReqResponse) ;
            end ;
        except
            AddLogText ('Download Error - ' + GetExceptMess (ExceptObject)) ;
        end ;
    finally
        FreeAndNil (MagHTTPClient) ;
        LabelProgress.Caption := 'HTTP Completed' ;
        doHttpDownCheck.Enabled := true ;
        doHttpDownFiles.Enabled := true ;
        doHttpAbort.Enabled := false ;
    end ;
end;

procedure TForm1.onFtpEvent (LogLevel: TLogLevel ; Info: string ;
                                                  var Cancel: boolean) ;
begin
    if (LogLevel = LogLevelInfo) or (LogLevel = LogLevelFile) then
    begin
        AddLogText (Info) ;
        LabelProgress.Caption := Info ;
    end ;
    if (LogLevel = LogLevelProg) then LabelProgress.Caption := 'Progress: ' + Info ;
    if (LogLevel = LogLevelDiag) and ShowDiags.Checked then AddLogText (Info) ;
    if (LogLevel = LogLevelDelimFile) then AddLogDelim (Info) ;
    if (LogLevel = LogLevelDelimTot) then AddLogDelim (Info) ;
    if AbortFlag then Cancel := true ;
end ;

function TForm1.SetFTPGen: boolean ;
begin
    AbortFlag := false ;
    result := false ;
    try
        with MagFTPClient do
        begin
            LocalHost := WSocket.LocalHostName ;
            HostName1 := FtpHost.Text ;
            HostName2 := '' ;
            UserName := FtpUsername.Text ;
            PassWord := FtpPassword.Text ;
            Port := '21' ;
            AttemptDelay := 5 ;
            MaxAttempts := 2 ;
            FailRepeat := 1 ;  // retries for failure
       // ConnectionType: ftpDirect, ftpProxy, ftpSocks4, ftpSocks4A, ftpSocks5
            ConnectionType := ftpDirect ;
            SocksPort := '' ;
            SocksServer := '' ;
            ProxyPort := '' ;
            ProxyServer := '' ;
            SocksUsercode := '' ;
            SocksPassword := '' ;
            if ConnectionType = ftpProxy then
            begin
                ProxyPort := '21' ;
                ProxyServer := '' ;
            end
            else if ConnectionType >= ftpSocks4 then
            begin
                SocksPort := '21' ;
                SocksServer := '' ;
                if ConnectionType = ftpSocks5 then
                begin
                    SocksUsercode := '' ;
                    SocksPassword := '' ;
                end ;
            end ;
            PassiveX := false ;  // must be after connection type
       // HostType: FTPTYPE_NONE, FTPTYPE_UNIX, FTPTYPE_DOS, FTPTYPE_MVS, FTPTYPE_AS400, FTPTYPE_MLSD
            HostType := FTPTYPE_NONE ;
       // TXferMode: XferModeBinary, XferModeAscii
            XferMode := XferModeBinary ;
       // TCaseFile: FileLowerCase, FileMixedCase
            CaseFile := FileLowerCase ;
            DiffStampMins := 62 ;
            Timeout := 60 ;
            DispLog := true ;
            DispFiles := true ;
            DispRDir:= true ;
            DispLDir:= false ;
            CopyEvent := onFtpEvent ;
            UpArchDir := '' ;
            UpArchive := false ;
            ResFailed := true ;
        { following properties only available if VCLZip available
            Zipped := false ;
            ZipDownDel := false ;
        // ZipExtFmt: ExtnAdd, ExtnReplace
        // ZipPath: PathNone, PathNew, PathOriginal, PathNewOrig, PathSpecific, PathSpecOrig
        // ZipType: TypeUnzip, TypeSrcAddX, TypeSrcReplX, TypeSrcDirs
            ZipExtFmt := ExtnAdd ;
            ZipPath := PathNone ;
            ZipDir := '' ;   }
            DispRemList := true ;
        end ;
    except
        AddLogText ('FTP Error - ' + GetExceptMess (ExceptObject)) ;
        result := true ;
    end ;
end;

procedure TForm1.SetFtpButtons (value: boolean) ;
begin
    doFtpDownCheck.Enabled := value ;
    doFtpDownFiles.Enabled := value ;
    doFtpUpCheck.Enabled := value ;
    doFtpUpFiles.Enabled := value ;
    doFtpList.Enabled := value ;
    doFtpDown1.Enabled := value ;
    doFtpAbort.Enabled := NOT value ;
end ;

procedure TForm1.doFtpListClick(Sender: TObject);
var
    dirlisting: string ;
    taskres: TTaskResult ;
begin
    AbortFlag := false ;
    SetFtpButtons (false) ;
    MagFTPClient := TMagFTP.Create (self) ;
    try
        if SetFTPGen then exit ;
        try
            with MagFTPClient do
            begin
                BulkMode := BulkModeDownload ;
                SrcDir := FtpPath.Text ;
                SubDirs := true ;
                taskres := DispFtpDir (dirlisting) ;  // main FTP function
                AddLogText ('Task Result: ' + GetTaskResName (taskres)) ;
                AddLogText (dirlisting) ;
            end ;
        except
            AddLogText ('FTP Error - ' + GetExceptMess (ExceptObject)) ;
        end ;
    finally
        FreeAndNil (MagFTPClient) ;
        LabelProgress.Caption := 'FTP Completed' ;
        SetFtpButtons (true) ;
    end ;
end;

procedure TForm1.FtpDownload(Sender: TObject);
var
    checkflag: boolean ;
    taskres: TTaskResult ;
begin
    AbortFlag := false ;
    SetFtpButtons (false) ;
    MagFTPClient := TMagFTP.Create (self) ;
    try
        if SetFTPGen then exit ;
        try
            checkflag := false ;
            if Sender = doFtpDownCheck then checkflag := true ;
            with MagFTPClient do
            begin
                BulkMode := BulkModeDownload ;
                SrcDir := FtpPath.Text ;
                SrcFName := FtpSrcFile.Text ;
                TarDir := FtpLocDir.Text ;
            // CopyType: FCTypeSingle, FCTypeMaskDir, FCTypeArchDir, FCTypeAllDir, FCTypeDates
                CopyType := FCTypeMaskDir ;
                DelDone := false ;
                DelOldTar := false ;
                SubDirs := true ;   // true copy all sub directories
                Mask := false ;     // true, allow date/time masked characters in SrcFName
                Prev := false ;     // true, use yesterday's date for Mask
            // Repl: FCReplNever, FCReplAlways, FCReplDiff, FCReplNewer
                Repl := FCReplNever ;
                if FtpReplace.Checked then Repl := FCReplAlways ;
                ReplRO := true ;    // true, replace read only files
                Safe := false ;     // true, copy file with TMP extension, rename when done
                IgnoreFileExt := 'tmp;ftp' ;
                taskres := FtpDownload (checkflag) ;   // main FTP function
                AddLogText ('Task Result: ' + GetTaskResName (taskres)) ;
                AddLogText (ReqResponse) ;
            end ;
        except
            AddLogText ('FTP Error - ' + GetExceptMess (ExceptObject)) ;
        end ;
    finally
        FreeAndNil (MagFTPClient) ;
        LabelProgress.Caption := 'FTP Completed' ;
        SetFtpButtons (true) ;
    end ;
end;


procedure TForm1.FtpUpload(Sender: TObject);
var
    checkflag: boolean ;
    taskres: TTaskResult ;
begin
    AbortFlag := false ;
    SetFtpButtons (false) ;
    MagFTPClient := TMagFTP.Create (self) ;
    try
        if SetFTPGen then exit ;
        try
            checkflag := false ;
            if Sender = doFtpUpCheck then checkflag := true ;
            with MagFTPClient do
            begin
                BulkMode := BulkModeUpload ;
                SrcDir := FtpLocDir.Text ;
                SrcFName := FtpSrcFile.Text ;
                TarDir := FtpPath.Text ;
            // CopyType: FCTypeSingle, FCTypeMaskDir, FCTypeArchDir, FCTypeAllDir, FCTypeDates
                CopyType := FCTypeMaskDir ;
                DelDone := false ;
                DelOldTar := false ;
                SubDirs := true ;   // true copy all sub directories
                Mask := false ;     // true, allow date/time masked characters in SrcFName
                Prev := false ;     // true, use yesterday's date for Mask
            // Repl: FCReplNever, FCReplAlways, FCReplDiff, FCReplNewer
                Repl := FCReplNewer ;
                if FtpReplace.Checked then Repl := FCReplAlways ;
                Safe := true ;     // ignored
                IgnoreFileExt := 'tmp' ;
                UpImmed := false ;   // immediate move/delete after upload
                TimeStamp := false ; // update local file time stamp to match remote
                taskres := FtpUpload (checkflag) ;   // main FTP function
                AddLogText ('Task Result: ' + GetTaskResName (taskres)) ;
                AddLogText (ReqResponse) ;
            end ;
        except
            AddLogText ('FTP Error - ' + GetExceptMess (ExceptObject)) ;
        end ;
    finally
        FreeAndNil (MagFTPClient) ;
        LabelProgress.Caption := 'FTP Completed' ;
        SetFtpButtons (true) ;
    end ;
end;

procedure TForm1.doFtpDown1Click(Sender: TObject);
var
    taskres: TTaskResult ;
begin
    AbortFlag := false ;
    SetFtpButtons (false) ;
    MagFTPClient := TMagFTP.Create (self) ;
    try
        if SetFTPGen then exit ;
        try
            with MagFTPClient do
            begin
                SrcDir := '/' ;
                BulkMode := BulkModeDownload ;
                taskres := FtpLogon ;
                if taskres = TaskResOKNew then
                begin
                    taskres := FtpDownOneFile (Ftp1Path.Text, Ftp1SrcName.Text,
                             Ftp1LocDir.Text + '\' + Ftp1SrcName.Text, FCReplNever) ;
                end ;
                AddLogText ('Task Result: ' + GetTaskResName (taskres)) ;
                AddLogText (ReqResponse) ;
            end ;
        except
            AddLogText ('FTP Error - ' + GetExceptMess (ExceptObject)) ;
        end ;
    finally
        MagFTPClient.FtpLogoff ;
        FreeAndNil (MagFTPClient) ;
        LabelProgress.Caption := 'FTP Completed' ;
        SetFtpButtons (true) ;
    end ;
end;

procedure TForm1.doFtpUp1Click(Sender: TObject);
var
    taskres: TTaskResult ;
begin
    AbortFlag := false ;
    SetFtpButtons (false) ;
    MagFTPClient := TMagFTP.Create (self) ;
    try
        if SetFTPGen then exit ;
        try
            with MagFTPClient do
            begin
                TarDir := '/' ;
                BulkMode := BulkModeUpload ;
                taskres := FtpLogon ;
                if taskres = TaskResOKNew then
                begin
                    taskres := FtpUpOneFile (Ftp1UpFile.Text, Ftp1Path.Text,
                                                     Ftp1SrcName.Text, FCReplNever) ;
                end ;
                AddLogText ('Task Result: ' + GetTaskResName (taskres)) ;
                AddLogText (ReqResponse) ;
            end ;
        except
            AddLogText ('FTP Error - ' + GetExceptMess (ExceptObject)) ;
        end ;
    finally
        MagFTPClient.FtpLogoff ;
        FreeAndNil (MagFTPClient) ;
        LabelProgress.Caption := 'FTP Completed' ;
        SetFtpButtons (true) ;
    end ;
end;

procedure TForm1.doTestClick(Sender: TObject);
{var
    taskres: TTaskResult ;
    fname: string ;
    actualDT, newDT: TDateTime ;
    FSize: Int64 ;}
begin
{    fname := 'd:\temp1\testfile.tst' ;
    newDT := Packed2Date ('20040102-003456') ;
    if NOT UpdateUFileAge (fname, newDT) then
    begin
        AddLogText ('Failed to update File Age: ' + fname) ;
        exit ;
    end ;
    GetUAgeSizeFile (fname, actualDT, FSize) ;
    if Abs (actualDT - newDT) <= (OneSecond * 2) then
        AddLogText ('Update File Age OK: ' + fname)
    else
        AddLogText ('File Age Incorrect for: ' + fname) ;
    AddLogText ('New Age: ' + DateTimetoStr (newDT) +
                                    ', Actual: ' + DateTimetoStr (actualDT)) ;

// test install download
    MagFTPClient := TMagFTP.Create (self) ;
    try
        with MagFTPClient do
        begin
            LocalHost := WSocket.LocalHostName ;
            HostName1 := '192.168.1.63' ;
            HostName2 := '' ;
            UserName := 'angus' ;
            PassWord := 'fgh' ;
            Port := '21' ;
            AttemptDelay := 5 ;
            MaxAttempts := 2 ;
            FailRepeat := 1 ;  // retries for failure
       // ConnectionType: ftpDirect, ftpProxy, ftpSocks4, ftpSocks4A, ftpSocks5
            ConnectionType := ftpDirect ;
            SocksPort := '' ;
            SocksServer := '' ;
            ProxyPort := '' ;
            ProxyServer := '' ;
            SocksUsercode := '' ;
            SocksPassword := '' ;
            PassiveX := false ;  // must be after connection type
       // HostType: FTPTYPE_NONE, FTPTYPE_UNIX, FTPTYPE_DOS, FTPTYPE_MVS, FTPTYPE_AS400, FTPTYPE_MLSD
            HostType := FTPTYPE_NONE ;
       // TXferMode: XferModeBinary, XferModeAscii
            XferMode := XferModeBinary ;
       // TCaseFile: FileLowerCase, FileMixedCase
            CaseFile := FileLowerCase ;
            DiffStampMins := 2 ;
            Timeout := 60 ;
            DispLog := true ;
            DispFiles := true ;
            DispRDir:= true ;
            DispLDir:= true ;
            CopyEvent := onFtpEvent ;
            UpArchDir := '' ;
            UpArchive := false ;
            ResFailed := true ;
            DispRemList := true ;
            BulkMode := BulkModeDownload ;
            SrcDir := '/download/alldepots/install' ;
            SrcFName := '*.zip' ;
            TarDir := 'e:\temp1\install' ;
            CopyType := FCTypeAllDir ;
            DelDone := false ;
            DelOldTar := false ;
            SubDirs := true ;   // true copy all sub directories
            Mask := false ;     // true, allow date/time masked characters in SrcFName
            Prev := false ;     // true, use yesterday's date for Mask
        // Repl: FCReplNever, FCReplAlways, FCReplDiff, FCReplNewer
            Repl := FCReplDiff ;
            ReplRO := true ;    // true, replace read only files
            Safe := false ;     // true, copy file with TMP extension, rename when done
            IgnoreFileExt := 'tmp;ftp' ;
            taskres := FtpDownload (false) ;   // main FTP function
            AddLogText ('Task Result: ' + GetTaskResName (taskres)) ;
            AddLogText (ReqResponse) ;
        end ;
    except
        AddLogText ('FTP Error - ' + GetExceptMess (ExceptObject)) ;
    end ;
    FreeAndNil (MagFTPClient) ; }
end;

end.
