{
    websniffer - ConItem.pas (TCP connection analysis)
    Copyright (C) 2005 Josef Schtzenberger

    websniffer is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    websniffer is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with websniffer; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
unit ConItem;

interface

uses
  Classes,PcapNet,http,buffer;
type
  PPacketList = ^APacket;
  APacket = record
    seq: Cardinal;
    len: Cardinal;
    buf: PChar;
  end;
  TPacket=class(Tbuf)
    seq: Cardinal;
  end;
  TPacketList=class(TList)
    Packet: TPacket;
  public
    function AddPacket(seq:cardinal;buf:PChar;Len:cardinal): Boolean;
    function GetPacket(seq:cardinal;var buf:PChar;var Len:Cardinal): boolean;
    function DeletePacket(seq:cardinal): boolean;
    procedure Free;
  end;
  TOnSaveFile = procedure(var Filename:String;Host:String;Len:Integer) of object;
  TOnPacketMessage = procedure(const msg:String;const Info:Integer) of object;
  TOnError = procedure(const msg:String) of object;
  TConList = class(TList)
  private
   FOnSaveFile:TOnSaveFile;
   FOnPacketMessage:TOnPacketMessage;
   FOnError:TOnError;
  protected
  public
    function  ExchangeBuffer(const Host,Filename:String;Range:Cardinal;var Buffer:Tbuf):boolean;
    procedure OnFileSave(var Filename:String;Host:String;Len:Integer);
    procedure OnPaMessage(const msg:String;const Info:Integer);
    procedure OnErrorMsg(const msg:String);
    procedure Free;
  published
    property OnSaveFile: TOnSaveFile read FOnSaveFile write FOnSaveFile;
    property OnPacketMessage: TOnPacketMessage read FOnPacketMessage write FOnPacketMessage;
    property OnError: TOnError read FOnError write FOnError;
  end;
 TConItem =class(TObject)
 private
   PacketList:TPacketList;
 public
   lastTime:Integer;
   DestIp: integer;
   SrcIp: integer;
   DestPort: word;
   SrcPort: word;
   ConitemNr:integer;
   reqbuf,replybuf:Tbuf;
   HTTPContext:THTTPContext;
   ReqSeqPosition:cardinal;
   ReplySeqPosition:cardinal;
   FOwner:TConList;
   constructor create(ASrcIp,ADestIp:integer;ASrcPort,ADestPort: word;Owner:TConList);
   function onPacket(dir:Integer;IPheader:PIP_header;TCPheader:PTCP_header;TCPPayload:PChar;PayloadLen:cardinal):boolean;
   destructor free;
 end;

implementation
uses StrUtils,sysutils;

function TPacketList.AddPacket(seq:cardinal;buf:PChar;Len:cardinal): boolean;
var AItem:TPacket;
    i:integer;
begin
  result:=false;
  for i:=0 to count-1 do
  begin
    if TPacket(Items[i]).seq=seq then
    begin
     assert(false,'Add Packet:Packet exists');
     exit;
    end;
  end;
  AItem:=TPacket.Create(Len);
  AItem.seq:=seq;
  AItem.Add(buf,Len);
  inherited Add(AItem);
  result:=true;
end;
function TPacketList.GetPacket(seq:cardinal;var Buf:PChar;var Len:cardinal): boolean;
var    i:integer;
begin
  Result:=false;
  for i:=0 to count-1 do
  begin
    if TPacket(Items[i]).seq=seq then
    begin
      Buf:=TPacket(Items[i]).Buffer;
      Len:=TPacket(Items[i]).DataLen;
      Result:=true;
      break;
    end;
  end;
end;
function TPacketList.DeletePacket(seq:cardinal): boolean;
var i:integer;
begin
  Result:=false;
  for i:=0 to count-1 do
  begin
    if TPacket(Items[i]).seq=seq then
    begin
      TPacket(Items[i]).Free;
      Delete(i);
      Result:=true;
      break;
    end;
  end;
end;
procedure TPacketList.free;
begin
 while count>0 do
 begin
    TPacket(Items[0]).free;
    Delete(0);
 end;
 inherited free;
end;
constructor TConItem.Create(ASrcIp,ADestIp:integer;ASrcPort,ADestPort: word;Owner:TConList);
begin
 inherited create;
 replybuf:=Tbuf.create(40000);
 reqbuf:=Tbuf.create(2000);
 DestIp:=ADestIp;
 SrcIp:=ASrcIp;
 SrcPort:=ASrcPort;
 DestPort:=ADestPort;
 ReqSeqPosition:=0;
 ReplySeqPosition:=0;
 lastTime:=DateTimeToFileDate(Now());
 ConitemNr:=ConitemNrCount;
 inc(ConitemNrCount);
 FOwner:=Owner;
 HTTPContext:=THTTPContext.create(Owner);
end;

destructor TConItem.free;
begin
  if PacketList<>nil then PacketList.Free;
  if replybuf.DataLen>0 then
  begin
    TConlist(FOwner).OnPaMessage('Lost Bytes: '+HTTPContext.FHost+HTTPContext.FFileName+' Len: '+
    inttostr(replybuf.DataLen)+' Itemnr '+inttostr(ConitemNr),1);
  end;
  replybuf.free;
  reqbuf.free;
  HTTPContext.free;
end;

function TConItem.onPacket(dir:Integer;IPheader:PIP_header;TCPheader:PTCP_header;TCPPayload:PChar;PayloadLen:cardinal):boolean;
var seq,Len:Cardinal; P,SavedPacketBuf:PChar;
begin
  result:=false;
  if (TCPheader.flags and TH_FIN)>0 then result:=true;
  lastTime:=DateTimeToFileDate(Now());
  seq:=SwapDoubleWord(@TCPheader.sequence);
  if PayloadLen>0 then
  if dir > 0 then
  begin
    if ReqSeqPosition=0 then ReqSeqPosition:=seq;
    if not HTTPContext.FHasFoundGet then
      P:=HTTPContext.onRequestStream(TCPPayload,PayloadLen,replybuf) else P:=nil;
    if ReqSeqPosition=seq then
    begin
      if P<>nil then  reqbuf.Add(P,integer(PayloadLen)-(P-TCPPayload))
                else reqbuf.Add(TCPPayload,PayloadLen);
      ReqSeqPosition:=ReqSeqPosition + PayloadLen;
    end;
  end else
  begin
    if ReplySeqPosition=0 then ReplySeqPosition:=seq;
    if ReplySeqPosition=seq then
    begin
      P:=HTTPContext.onReplyData(TCPPayload,PayloadLen,replybuf);
      if P<>nil then replybuf.Add(P,integer(PayloadLen)-(P-TCPPayload));
      ReplySeqPosition:=ReplySeqPosition + PayloadLen;
      if (PacketList<>nil) then
      begin
        PacketList.DeletePacket(seq);
        while PacketList.GetPacket(ReplySeqPosition,SavedPacketBuf,Len) do  //get all saved packetes
        begin
          P:=HTTPContext.onReplyData(SavedPacketBuf,Len,replybuf);
          if p<>nil then replybuf.Add(P,integer(Len)-(P-SavedPacketBuf));
          PacketList.DeletePacket(ReplySeqPosition);
          ReplySeqPosition:=ReplySeqPosition + Len;
        end;
      end;
    end else
    begin
      if seq > ReplySeqPosition then
      begin
        if PacketList=nil then PacketList:=TPacketList.Create;
        PacketList.AddPacket(seq,TCPPayload,PayloadLen);
      end;
      if seq < ReplySeqPosition then
      begin
        if PacketList<>nil then PacketList.DeletePacket(seq);
      end;
    end;
    if  (PacketList<>nil) and (PacketList.count>0) then result:=false;//dont stop wait for late packets
  end;
  if  HTTPContext.FDone then
  begin
      HTTPContext.WriteFile(replybuf);
      if PacketList<>nil then
        if PacketList.count > 0 then
          PacketList.clear;
  end;
end;
function  TConlist.ExchangeBuffer(const Host,Filename:String;Range:Cardinal;var Buffer:Tbuf):boolean;
var i:integer; Buf:Tbuf;
begin
  for i := 0 to (Count - 1) do
  begin
    if TConItem(Items[i]).HTTPContext.FFileName=Filename then
    if TConItem(Items[i]).HTTPContext.FHost=Host then
    if TConItem(Items[i]).replybuf<>Buffer then
    if TConItem(Items[i]).replybuf.DataLen>=Range then
    break;
  end;
  if i<Count then
  begin
    Buf:=TConItem(Items[i]).replybuf;
    TConItem(Items[i]).replybuf:=Buffer;
    Buffer:=buf;
    Result:=true;
  end else Result:=false;
end;
procedure TConlist.Free;
begin
  while Count>0 do
  begin
    TConItem(Items[0]).Free;
    Delete(0);
  end;
  inherited;
end;
procedure TConlist.OnPaMessage(const msg:String;const Info:Integer);
begin
  if Assigned(OnPacketMessage) then OnPacketMessage(msg,Info);
end;
procedure TConlist.OnFileSave(var Filename:String;Host:String;Len:Integer);
begin
   if Assigned(FOnSaveFile) then FOnSaveFile(Filename, Host, Len);
end;
procedure TConlist.OnErrorMsg(const msg:String);
begin
   if Assigned(FOnError) then FOnError(msg);
end;
end.

