;****************************************************************************
; INT13 Extensions VxD
; Version: 1.0
; Copyright (C) 2001 Alexander Grau,  All Rights Reserved
;****************************************************************************
        .386p

;******************************************************************************
;                             I N C L U D E S
;******************************************************************************

  DEBUG equ 1

        .XLIST
        INCLUDE VMM.Inc
        INCLUDE Debug.Inc
        INCLUDE v86mmgr.inc
	include vwin32.inc
	include shell.inc
        .LIST


;******************************************************************************
;              V I R T U A L   D E V I C E   D E C L A R A T I O N
;******************************************************************************

Declare_Virtual_Device INT13EXT, \
        INT13EXT_MAJOR_VERSION,  \
        INT13EXT_MINOR_VERSION,  \
        INT13EXT_Control, ,      \
	UNDEFINED_INIT_ORDER


;******************************************************************************
;                                E Q U A T E S
;******************************************************************************

  INT13EXT_MAJOR_VERSION EQU 1
  INT13EXT_MINOR_VERSION EQU 0


  DIOC_CHECKEXTENSIONS   EQU 1
  DIOC_EXTENDEDREAD      EQU 2
  DIOC_EXTENDEDWRITE     EQU 3
  DIOC_GETDRIVEPARAMS    EQU 4


  INT13EXT_ERROR_SUCCESS       EQU 0
  INT13EXT_ERROR_NOSUCHSERVICE EQU 1
  INT13EXT_ERROR_FAILED        EQU 2
  INT13EXT_ERROR_OUTOFMEMORY   EQU 3


  CARRY_FLAG EQU 1


;******************************************************************************
;                             S T R U C T U R E S
;******************************************************************************

  extstruc struc
    ext_Drv           db ?
    ext_LBA           dd ?
    ext_Blocks        db ?
    ext_Buf           dd ?
    ext_verify        db ?
  extstruc ends


  diskaddrpacket struc
    DAP_Packetsize    db ?
    DAP_Res           db ?
    DAP_Numblocks     db ?
    DAP_Res2          db ?
    DAP_Transferbuf   dd ?
    DAP_BlocknumberLO dd ?
    DAP_BlocknumberHI dd ?
  diskaddrpacket ends



;******************************************************************************
;                                D A T A
;******************************************************************************

VxD_IDATA_SEG
;       Initialization data here - discarded after Init_Complete
VxD_IDATA_ENDS


VxD_DATA_SEG
;       Normal Data here
VxD_DATA_ENDS


VxD_LOCKED_DATA_SEG
;       Pagelocked data here - try to keep this to a minimum.

  ioctlerror     dd 0
  DAP          diskaddrpacket <?>

  PtrDAP         dd ?
  PtrBuf         dd ?
  AllocLenDAP    dd ?
  AllocLenBuf    dd ?

VxD_LOCKED_DATA_ENDS



;******************************************************************************
;                  I N I T I A L I Z A T I O N   C O D E
;------------------------------------------------------------------------------
;    Code in the initialization segment is discarded after Init_Complete
;******************************************************************************

VxD_ICODE_SEG

;******************************************************************************
;
;   INT13EXT_Device_Init
;
;   DESCRIPTION:
;       This is a shell for a routine that is called at system BOOT.
;       Typically, a VxD would do its initialization in this routine.
;
;   ENTRY:
;       EBX = System VM handle
;
;   EXIT:
;       Carry clear to indicate load success
;       Carry set to abort loading this VxD
;
;   USES:
;       flags
;
;==============================================================================
VxdCaption	db	"VxD Extensions",0
VxdMessage	db	"         Loading...",0

BeginProc INT13EXT_Device_Init

        Trace_Out "INT13EXT_Device_Init"
  ifdef debugmsg
	; Put up message box indicating we're loading
	VMMcall	Get_Cur_VM_Handle
	mov	eax, MB_OK
	mov	ecx, OFFSET32 VxdMessage
	mov	edi, OFFSET32 VxdCaption
	VxDcall	SHELL_SYSMODAL_Message
  endif

        clc                             ;no error - load VxD
        ret

EndProc INT13EXT_Device_Init

VxD_ICODE_ENDS



;******************************************************************************
;                               C O D E
;------------------------------------------------------------------------------
; The 'body' of the VxD would typically be in the standard code segment.
;******************************************************************************

VxD_CODE_SEG



VxD_CODE_ENDS



;******************************************************************************
;                      P A G E   L O C K E D   C O D E
;------------------------------------------------------------------------------
;       Memory is a scarce resource. Use this only where necessary.
;******************************************************************************
VxD_LOCKED_CODE_SEG



;******************************************************************************
;
;   INT13EXT_Control
;
;   DESCRIPTION:
;       This is a call-back routine to handle the messages that are sent
;
;   ENTRY:
;       EAX = Message number
;       EBX = VM Handle
;
;==============================================================================

public INT13EXT_control
BeginProc INT13EXT_Control
        Control_Dispatch SYS_DYNAMIC_DEVICE_INIT,      INT13EXT_Device_Init
        Control_Dispatch SYS_DYNAMIC_DEVICE_EXIT,      INT13EXT_Device_Exit
	Control_Dispatch W32_DEVICEIOCONTROL,          INT13EXT_ioctl
        clc
        ret
EndProc INT13EXT_Control



;******************************************************************************
;
; INT13EXT_ioctl - Respond to DeviceIOcontrol messages sent by Win32 program.
;
; Entry: esi -> DIOC block
; DIOCParams	STRUC
;               Internal1	DD	?
;               VMHandle	DD	?
;               Internal2	DD	?
;               dwIoControlCode	DD	?    ; 0=CheckExtensions
;               lpvInBuffer	DD	?
;               cbInBuffer	DD	?
;               lpvOutBuffer	DD	?    
;               cbOutBuffer	DD	?
;               lpcbBytesReturned	DD
;               lpoOverlapped	DD	?
;               hDevice	DD	?
;               tagProcess	DD	?
; DIOCParams	ENDS
;
; Exit:
;
;******************************************************************************


BeginProc INT13EXT_ioctl

        Trace_Out "INT13EXT_ioctl..."
        mov     ioctlerror, INT13EXT_ERROR_NOSUCHSERVICE
	mov	ecx,[esi].dwIoControlCode	; get ioctl code
        cmp     ecx, DIOC_OPEN                  ; DIOC_OPEN is sent when VxD is loaded w/ CreateFile
        je      ioctl_open
        cmp     ecx, DIOC_CLOSEHANDLE           ; DIOC_CLOSEHANDLE is sent when VxD is unloaded w/ CloseHandle
        je      ioctl_close
        cmp     ecx, DIOC_CHECKEXTENSIONS
        je      ioctl_chkext
        cmp     ecx, DIOC_EXTENDEDREAD
        je      ioctl_extread
        cmp     ecx, DIOC_EXTENDEDWRITE
        je      ioctl_extwrite
        cmp     ecx, DIOC_GETDRIVEPARAMS
        je      ioctrl_getparams
        jmp     ioctl_done                      ; Returning a positive value will cause the WIN32 DeviceIOControl call
                                                ; to return FALSE, the error code can then be retrieved via the WIN32 GetLastError


        ;** DIOC_OPEN ********************************************************
ioctl_open:
        Trace_Out "INT13EXT_ioctl: DIOC_OPEN"
        ; Must return 0 to tell WIN32 that this VxD supports DEVIOCTL
        mov     ioctlerror, INT13EXT_ERROR_SUCCESS
        jmp     ioctl_done

        ;** DIOC_CLOSE *******************************************************
ioctl_close:
        Trace_Out "INT13EXT_ioctl: DIOC_CLOSE"
        mov     ioctlerror, INT13EXT_ERROR_SUCCESS
        jmp     ioctl_done

ioctl_chkext:
        ;*** DIOC_CHECKEXTENSIONS *********************************************
        Trace_Out "INT13EXT_ioctl: DIOC_CHECKEXTENSIONS"
        mov     edi,dword ptr [esi].lpvInBuffer
        mov     al,[edi]

        Push_Client_State                      ; save all registers
        VMMcall Begin_Nest_V86_Exec            ; Enter nested execution in V86-mode (force VM to V86)
        mov     [ebp.Client_AH], 41h
        mov     [ebp.Client_BX], 55AAh
        mov     [ebp.Client_DL], al
        mov     eax, 13h
        VMMCall Exec_Int                       ; current VM to call BIOS
        test    [ebp.Client_Flags], CARRY_FLAG
        jnz     ioctl_no_ext
        cmp     [ebp.Client_BX], 0AA55h
        jne     ioctl_no_ext
        mov     al, 1
	mov	ah, [ebp.Client_AH]
	mov	cx, [ebp.Client_CX]
        jmp     ioctl_chk_fin
ioctl_no_ext:
        mov     al, 0
ioctl_chk_fin:
        VMMcall End_Nest_Exec                  ; end of nested exec calls
        Pop_Client_State                       ; restore all registers when done
        mov     edi, [esi].lpvOutBuffer
        mov     byte ptr [edi], al
	mov	byte ptr [edi]+1, ah
	mov	word ptr [edi]+2, cx
        mov     [esi].cbOutBuffer, 4
        mov     ioctlerror, INT13EXT_ERROR_SUCCESS
	jmp	ioctl_done		       ; exit successfully


        ;*********** DIOC_EXTENDEDREAD *****************************************
ioctl_extread:
        Trace_Out "INT13EXT_ioctl: DIOC_EXTENDEDREAD"

        mov     ioctlerror, INT13EXT_ERROR_OUTOFMEMORY
        mov     edi,dword ptr [esi].lpvInBuffer
        mov     al, byte ptr [edi].ext_drv

        mov     ebx, [edi].ext_LBA
        mov     DAP.DAP_blocknumberLO, ebx
        mov     bl, [edi].ext_Blocks
        mov     DAP.DAP_numblocks, bl
        mov     DAP.DAP_blocknumberHI, 0
        mov     DAP.DAP_res, 0
        mov     DAP.DAP_res2, 0
        mov     DAP.DAP_packetsize, size diskaddrpacket

        ; allocate sector buffer...
        VMMcall	Get_Sys_VM_Handle              ; ebx = handle of system VM (address of VM control block)
        mov     ebp, [ebx].CB_Client_Pointer   ; ebp = Address of a Client_Reg_Struc structure
        push    eax                            ; save eax
        xor     ax, ax
        mov     al, [edi].ext_Blocks
        mov     cx, 512
        mul     cx
        xor     ecx, ecx
        mov     cx, ax                         ; ecx = NumBytes
        pop     eax                            ; restore eax
        ; mov     ecx, 512                       ; ecx = NumBytes
        clc                                    ; carry clear => allocate only
        VxDcall V86MMGR_Allocate_Buffer        ; Result: edi = FarPtrBuffer
        jc      ioctl_done
        mov     PtrBuf, edi
        mov     AllocLenBuf, ecx
        mov     DAP.DAP_transferbuf, edi

        ; allocate DAP buffer...
        mov     ecx, size diskaddrpacket
        push    esi                            ; save ESI
        mov     esi, OFFSET32 DAP              ; extended memory to copy if carry set
        push    ds
        pop     fs
        stc                                    ; set carry flag to copy
        VxDcall V86MMGR_Allocate_Buffer        ; edi = FarPtrBuffer
        pop     esi                            ; restore ESI
        jc      ioctl_done
        mov     AllocLenDAP, ecx
        mov     PtrDAP, edi

        ; execute INT13...
        mov     ioctlerror, INT13EXT_ERROR_FAILED
        Push_Client_State                      ; save all registers
        VMMcall Begin_Nest_V86_Exec	       ; Enter nested execution in V86-mode
        mov     edx, PtrDAP
        mov     [ebp.Client_SI], dx
        shr     edx, 16
        mov     [ebp.Client_DS], dx            ; client ds:si=PtrDAP
        mov     [ebp.Client_AH], 42h
        mov     [ebp.Client_DL], al
        mov     eax, 13h
        VMMCall Exec_Int                       ; current VM to call BIOS
        clc
        test    [ebp.Client_Flags], CARRY_FLAG
        jnz     ioctl_readerr
        cmp     [ebp.Client_AH], 0
        jne     ioctl_readerr
        mov     ioctlerror, INT13EXT_ERROR_SUCCESS
ioctl_readerr:
        VMMcall End_Nest_Exec                  ; end of nested exec calls
        Pop_Client_State                       ; restore all registers when done

        ; free DAP buffer...
        mov     ecx, AllocLenDAP
        clc                                    ; carry cleared=>no copy
        VxDcall V86MMGR_Free_Buffer

        ; copy and free sector buffer...
        mov     ecx, AllocLenBuf
        mov     edi,dword ptr [esi].lpvInBuffer
        push    esi                            ; save ESI
        mov     esi, [edi].ext_buf
        stc                                    ; carry set=>copy
        push    ds
        pop     fs                             ; fs=ds
        VxDcall V86MMGR_Free_Buffer
        pop     esi                            ; restore ESI
        jmp     ioctl_done


        ;*********** DIOC_EXTENDEDWRITE *****************************************
ioctl_extwrite:
        Trace_Out "INT13EXT_ioctl: DIOC_EXTENDEDWRITE"

        mov     ioctlerror, INT13EXT_ERROR_OUTOFMEMORY
        mov     edi,dword ptr [esi].lpvInBuffer
        mov     al, byte ptr [edi].ext_drv

        mov     ebx, [edi].ext_LBA
        mov     DAP.DAP_blocknumberLO, ebx
        mov     DAP.DAP_numblocks, 1
        mov     DAP.DAP_blocknumberHI, 0
        mov     DAP.DAP_res, 0
        mov     DAP.DAP_res2, 0
        mov     DAP.DAP_packetsize, size diskaddrpacket

        ; allocate sector buffer...
        VMMcall	Get_Sys_VM_Handle              ; ebx = handle of system VM (address of VM control block)
        mov     ebp, [ebx].CB_Client_Pointer   ; ebp = Address of a Client_Reg_Struc structure
        mov     ecx, 512                       ; ecx = NumBytes
        mov     edi,dword ptr [esi].lpvInBuffer
        push    esi                            ; save ESI
        mov     esi, [edi].ext_buf
        stc                                    ; carry flag set: copy extended memory from fs:esi
        push    ds
        pop     fs                             ; fs=ds
        VxDcall V86MMGR_Allocate_Buffer        ; edi = FarPtrBuffer, ecx=BytesCopied
        pop     esi                            ; restore ESI
        jc      ioctl_done
        mov     PtrBuf, edi
        mov     AllocLenBuf, ecx
        mov     DAP.DAP_transferbuf, edi

        ; allocate DAP buffer...
        mov     ecx, size diskaddrpacket
        push    esi                            ; save ESI
        mov     esi, OFFSET32 DAP              ; extended memory to copy if carry set
        push    ds
        pop     fs
        stc                                    ; set carry flag to copy
        VxDcall V86MMGR_Allocate_Buffer        ; edi = FarPtrBuffer
        pop     esi                            ; restore ESI
        jc      ioctl_done
        mov     AllocLenDAP, ecx
        mov     PtrDAP, edi

        ; execute INT13...
        mov     ioctlerror, INT13EXT_ERROR_FAILED
        Push_Client_State                      ; save all registers
        VMMcall Begin_Nest_V86_Exec	       ; Enter nested execution in V86-mode
        mov     edx, PtrDAP
        mov     [ebp.Client_SI], dx
        shr     edx, 16
        mov     [ebp.Client_DS], dx            ; client ds:si=PtrDAP
        mov     [ebp.Client_AH], 43h           ; extended write
        mov     [ebp.Client_AL], 0             ; write with verify off
        mov     edi,dword ptr [esi].lpvInBuffer
        cmp     byte ptr [edi].ext_verify, 1
        jne     wr_no_verify
        mov     [ebp.Client_AL], 2             ; write with verify on
wr_no_verify:
        mov     [ebp.Client_DL], al
        mov     eax, 13h
        VMMCall Exec_Int                       ; current VM to call BIOS
        clc
        test    [ebp.Client_Flags], CARRY_FLAG
        jnz     ioctl_readerr
        cmp     [ebp.Client_AH], 0
        jne     ioctl_writeerr
        mov     ioctlerror, INT13EXT_ERROR_SUCCESS
ioctl_writeerr:
        VMMcall End_Nest_Exec                  ; end of nested exec calls
        Pop_Client_State                       ; restore all registers when done

        ; free DAP buffer...
        mov     ecx, AllocLenDAP
        clc
        VxDcall V86MMGR_Free_Buffer            ; ebp=OFFSET ClientRegs, ebx=VMHandle, ecx=NumBytes

        ; free sector buffer...
        mov     ecx, AllocLenBuf
        clc
        VxDcall V86MMGR_Free_Buffer
        jmp     ioctl_done


        ;*********** DIOC_GETDRIVEPARAMS *****************************************
ioctrl_getparams:
        Trace_Out "INT13EXT_ioctl: DIOC_GETDRIVEPARAMS"

        mov     ioctlerror, INT13EXT_ERROR_OUTOFMEMORY
        mov     edi,dword ptr [esi].lpvInBuffer
        mov     al, byte ptr [edi].ext_drv

        ; allocate result buffer...
        VMMcall	Get_Sys_VM_Handle              ; ebx = handle of system VM (address of VM control block)
        mov     ebp, [ebx].CB_Client_Pointer   ; ebp = Address of a Client_Reg_Struc structure
        mov     ecx, 30                        ; ecx = NumBytes
        mov     edi,dword ptr [esi].lpvInBuffer
        push    esi                            ; save ESI
        mov     esi, [edi].ext_buf
        stc                                    ; carry flag set: copy extended memory from fs:esi
        push    ds
        pop     fs                             ; fs=ds
        VxDcall V86MMGR_Allocate_Buffer        ; edi = FarPtrBuffer, ecx=BytesCopied
        pop     esi                            ; restore ESI
        jc      ioctl_done
        mov     PtrBuf, edi
        mov     AllocLenBuf, ecx

        ; execute INT13...
        mov     ioctlerror, INT13EXT_ERROR_FAILED
        Push_Client_State                      ; save all registers
        VMMcall Begin_Nest_V86_Exec	       ; Enter nested execution in V86-mode
        mov     edx, PtrBuf
        mov     [ebp.Client_SI], dx
        shr     edx, 16
        mov     [ebp.Client_DS], dx            ; client ds:si=PtrBuf
        mov     [ebp.Client_AH], 48h
        mov     [ebp.Client_DL], al
        mov     eax, 13h
        VMMCall Exec_Int                       ; current VM to call BIOS
        clc
        test    [ebp.Client_Flags], CARRY_FLAG
        jnz     ioctl_getparamerr
        cmp     [ebp.Client_AH], 0
        jne     ioctl_getparamerr
        mov     ioctlerror, INT13EXT_ERROR_SUCCESS
ioctl_getparamerr:
        VMMcall End_Nest_Exec                  ; end of nested exec calls
        Pop_Client_State                       ; restore all registers when done

        ; copy and free result buffer...
        push    esi                            ; save ESI
        mov     esi, dword ptr [esi].lpvInBuffer
        mov     esi, [esi].ext_buf
        stc                                    ; carry set=>copy
        push    ds
        pop     fs                             ; fs=ds
        VxDcall V86MMGR_Free_Buffer            ; first copy to fs:esi
        pop     esi                            ; restore ESI
        jmp     ioctl_done

; ------------------------------------------------------------------
ioctl_done:
        mov     eax, ioctlerror
        clc
        cmp     eax, INT13EXT_ERROR_SUCCESS
        je      ioctl_fin
        Trace_Out "INT13EXT_ioctl: error"
        stc
ioctl_fin:
 	ret

EndProc	INT13EXT_ioctl



;============================================================================
;
; INT13EXT_Device_Exit - Cleans up any hooks that are still installed before
;		    exiting.
;
;============================================================================
Public INT13EXT_Device_Exit
BeginProc INT13EXT_Device_Exit
        Trace_Out "INT13EXT_Device_Exit"
	clc
	ret
EndProc INT13EXT_Device_Exit



VxD_LOCKED_CODE_ENDS




;******************************************************************************
;                       R E A L   M O D E   C O D E
;******************************************************************************

;******************************************************************************
;
;       Real mode initialization code
;
;   DESCRIPTION:
;       This code is called when the system is still in real mode, and
;       the VxDs are being loaded.
;
;       This routine as coded shows how a VxD (with a defined VxD ID)
;       could check to see if it was being loaded twice, and abort the 
;       second without an error message. Note that this would require
;       that the VxD have an ID other than Undefined_Device_ID. See
;       the file VXDID.TXT more details.
;
;   ENTRY:
;       AX = VMM Version
;       BX = Flags
;               Bit 0: duplicate device ID already loaded
;               Bit 1: duplicate ID was from the INT 2F device list
;               Bit 2: this device is from the INT 2F device list
;       EDX = Reference data from INT 2F response, or 0
;       SI = Environment segment, passed from MS-DOS
;
;   EXIT:
;       BX = ptr to list of pages to exclude (0, if none)
;       SI = ptr to list of instance data items (0, if none)
;       EDX = DWORD of reference data to be passed to protect mode init
;
;==============================================================================

VxD_REAL_INIT_SEG

BeginProc INT13EXT_Real_Init_Proc

        Trace_Out "INT13EXT_Real_Init_Proc"
	test	bx, Duplicate_Device_ID ; check for already loaded
	jnz	short duplicate         ; jump if so

        xor     bx, bx                  ; no exclusion table
        xor     si, si                  ; no instance data table
        xor     edx, edx                ; no reference data

        mov     ax, Device_Load_Ok
        ret

duplicate:
        mov     ax, Abort_Device_Load + No_Fail_Message
        ret

EndProc INT13EXT_Real_Init_Proc


VxD_REAL_INIT_ENDS


        END
