;****************************************************************************
; INT2F-MSCDEX (Windows CDFS) CD-ROM support VxD
; Version: 1.0
; Copyright (C) 2001 Alexander & Christian Grau,  All Rights Reserved
;****************************************************************************
        .386p

;******************************************************************************
;                             I N C L U D E S
;******************************************************************************

  DEBUG equ 1

        .XLIST
        INCLUDE VMM.Inc
        INCLUDE Debug.Inc
        INCLUDE v86mmgr.inc
	include vwin32.inc
	include shell.inc
        .LIST


;******************************************************************************
;              V I R T U A L   D E V I C E   D E C L A R A T I O N
;******************************************************************************

Declare_Virtual_Device INT2F, \
        INT2F_MAJOR_VERSION,  \
        INT2F_MINOR_VERSION,  \
        INT2F_Control, ,      \
	UNDEFINED_INIT_ORDER


;******************************************************************************
;                                E Q U A T E S
;******************************************************************************

  INT2F_MAJOR_VERSION EQU 1
  INT2F_MINOR_VERSION EQU 0


  DIOC_ISCDROMDRIVE      EQU 1
  DIOC_READSECTOR        EQU 2


  INT2F_ERROR_SUCCESS       EQU 0
  INT2F_ERROR_NOSUCHSERVICE EQU 1
  INT2F_ERROR_FAILED        EQU 2
  INT2F_ERROR_OUTOFMEMORY   EQU 3


  CARRY_FLAG EQU 1


;******************************************************************************
;                             S T R U C T U R E S
;******************************************************************************

  cdstruc struc
    cd_Drv           db ?
    cd_LBA           dd ?
    cd_Blocks        db ?
    cd_Buf           dd ?
  cdstruc ends



;******************************************************************************
;                                D A T A
;******************************************************************************

VxD_IDATA_SEG
;       Initialization data here - discarded after Init_Complete
VxD_IDATA_ENDS


VxD_DATA_SEG
;       Normal Data here
VxD_DATA_ENDS


VxD_LOCKED_DATA_SEG
;       Pagelocked data here - try to keep this to a minimum.

  ioctlerror     dd 0
  AllocLenBuf    dd ?


VxD_LOCKED_DATA_ENDS



;******************************************************************************
;                  I N I T I A L I Z A T I O N   C O D E
;------------------------------------------------------------------------------
;    Code in the initialization segment is discarded after Init_Complete
;******************************************************************************

VxD_ICODE_SEG

;******************************************************************************
;
;   INT2F_Device_Init
;
;   DESCRIPTION:
;       This is a shell for a routine that is called at system BOOT.
;       Typically, a VxD would do its initialization in this routine.
;
;   ENTRY:
;       EBX = System VM handle
;
;   EXIT:
;       Carry clear to indicate load success
;       Carry set to abort loading this VxD
;
;   USES:
;       flags
;
;==============================================================================
VxdCaption	db	"VxD Extensions",0
VxdMessage	db	"         Loading...",0

BeginProc INT2F_Device_Init

        Trace_Out "INT2F_Device_Init"
  ifdef debugmsg
	; Put up message box indicating we're loading
	VMMcall	Get_Cur_VM_Handle
	mov	eax, MB_OK
	mov	ecx, OFFSET32 VxdMessage
	mov	edi, OFFSET32 VxdCaption
	VxDcall	SHELL_SYSMODAL_Message
  endif

        clc                             ;no error - load VxD
        ret

EndProc INT2F_Device_Init

VxD_ICODE_ENDS



;******************************************************************************
;                               C O D E
;------------------------------------------------------------------------------
; The 'body' of the VxD would typically be in the standard code segment.
;******************************************************************************

VxD_CODE_SEG



VxD_CODE_ENDS



;******************************************************************************
;                      P A G E   L O C K E D   C O D E
;------------------------------------------------------------------------------
;       Memory is a scarce resource. Use this only where necessary.
;******************************************************************************
VxD_LOCKED_CODE_SEG



;******************************************************************************
;
;   INT2F_Control
;
;   DESCRIPTION:
;       This is a call-back routine to handle the messages that are sent
;
;   ENTRY:
;       EAX = Message number
;       EBX = VM Handle
;
;==============================================================================

public INT2F_control
BeginProc INT2F_Control
        Control_Dispatch SYS_DYNAMIC_DEVICE_INIT,      INT2F_Device_Init
        Control_Dispatch SYS_DYNAMIC_DEVICE_EXIT,      INT2F_Device_Exit
	Control_Dispatch W32_DEVICEIOCONTROL,          INT2F_ioctl
        clc
        ret
EndProc INT2F_Control



;******************************************************************************
;
; INT2F_ioctl - Respond to DeviceIOcontrol messages sent by Win32 program.
;
; Entry: esi -> DIOC block
; DIOCParams	STRUC
;               Internal1	DD	?
;               VMHandle	DD	?
;               Internal2	DD	?
;               dwIoControlCode	DD	?    ; 0=IsCDRomDrive
;               lpvInBuffer	DD	?
;               cbInBuffer	DD	?
;               lpvOutBuffer	DD	?    
;               cbOutBuffer	DD	?
;               lpcbBytesReturned	DD
;               lpoOverlapped	DD	?
;               hDevice	DD	?
;               tagProcess	DD	?
; DIOCParams	ENDS
;
; Exit:
;
;******************************************************************************


BeginProc INT2F_ioctl

        Debug_Out "Debug_Out!!"
        Trace_Out "INT2F_ioctl..."
        mov     ioctlerror, INT2F_ERROR_NOSUCHSERVICE
	mov	ecx,[esi].dwIoControlCode	; get ioctl code

        cmp     ecx, DIOC_OPEN                  ; DIOC_OPEN is sent when VxD is loaded w/ CreateFile
        je      ioctl_open
        cmp     ecx, DIOC_CLOSEHANDLE           ; DIOC_CLOSEHANDLE is sent when VxD is unloaded w/ CloseHandle
        je      ioctl_close
        cmp     ecx, DIOC_ISCDROMDRIVE
        je      ioctl_iscdrom
        cmp     ecx, DIOC_READSECTOR
        je      ioctl_readsec
        jmp     ioctl_done                      ; Returning a positive value will cause the WIN32 DeviceIOControl call
                                                ; to return FALSE, the error code can then be retrieved via the WIN32 GetLastError


        ;** DIOC_OPEN ********************************************************
ioctl_open:
        Trace_Out "INT2F_ioctl: DIOC_OPEN"
        ; Must return 0 to tell WIN32 that this VxD supports DEVIOCTL
        mov     ioctlerror, INT2F_ERROR_SUCCESS
        jmp     ioctl_done

        ;** DIOC_CLOSE *******************************************************
ioctl_close:
        Trace_Out "INT2F_ioctl: DIOC_CLOSE"
        mov     ioctlerror, INT2F_ERROR_SUCCESS
        jmp     ioctl_done

ioctl_iscdrom:
        ;*** DIOC_ISCDROMDRIVE *********************************************
        Trace_Out "INT2F_ioctl: DIOC_ISCDROMDRIVE"
        mov     edi,dword ptr [esi].lpvInBuffer
        mov     al,[edi]

        Push_Client_State                      ; save all registers
        VMMcall Begin_Nest_V86_Exec            ; Enter nested execution in V86-mode (force VM to V86)
        mov     [ebp.Client_CL], al
        mov     [ebp.Client_CH], 0
        mov     [ebp.Client_AX], 150bh
        mov     [ebp.Client_BX], 0      
        mov     eax, 2fh                       ; MSCDEX int 2f
        VMMCall Exec_Int                       ; current VM to call MSCDEX
        cmp     [ebp.Client_BX], 0ADADh        ; check MSCDEX signature
        jne     ioctl_no_cd
        cmp     [ebp.Client_AX], 0             ; check the drive type
        je      ioctl_no_cd                    ; 0 (zero) means not CD-ROM
        mov     al, 1                          ; result = TRUE
        jmp     ioctl_chk_fin
ioctl_no_cd:
        mov     al, 0                          ; result = FALSE
ioctl_chk_fin:
        VMMcall End_Nest_Exec                  ; end of nested exec calls
        Pop_Client_State                       ; restore all registers when done
        mov     edi, [esi].lpvOutBuffer
        mov     byte ptr [edi], al
        mov     [esi].cbOutBuffer, 1           ; number of bytes to return
        mov     ioctlerror, INT2F_ERROR_SUCCESS
	jmp	ioctl_done		       ; exit successfully


        ;*********** DIOC_READSECTOR *****************************************
ioctl_readsec:
        Trace_Out "INT2F_ioctl: DIOC_READSECTOR"

        mov     ioctlerror, INT2F_ERROR_OUTOFMEMORY
        mov     edi,dword ptr [esi].lpvInBuffer

        ; allocate sector buffer...
        VMMcall	Get_Sys_VM_Handle              
        ; ebx = handle of system VM (address of VM control block)
        mov     ebp, [ebx].CB_Client_Pointer   
        ; ebp = Address of a Client_Reg_Struc structure                    !!! DO NOT CHANGE EBX / EBP   FROM HERE !!!
        xor     ax, ax
        mov     al, [edi].cd_Blocks
        mov     cx, 2048
        mul     cx                             ; dx:ax=result
        xor     ecx, ecx
        mov     cx, ax                         ; ecx = NumBytes
        ; mov     ecx, 2048                      ; ecx = NumBytes
        clc                                    ; carry clear => allocate only
                                              
        VxDcall V86MMGR_Allocate_Buffer        ; Result: edi = FarPtrBuffer (seg in hi, offset in low word of 'EDI' )
                                               ; needs EBX / EBP (VM handle / client reg struc of virtual machine)
        jc      ioctl_done
        mov     AllocLenBuf, ecx               ; save size of PtrBuf

        ; execute INT2F...
        mov     ioctlerror, INT2F_ERROR_FAILED
        
;--------------------------------------------
        Push_Client_State                      ; save all registers         
	VMMcall Begin_Nest_V86_Exec	       ; Enter nested execution in V86-mode

        Trace_Out "Will now exec MSCDEX absolute read with..."
        mov     [ebp.Client_BX], di
        Trace_Out "BX=#DI"
        shr     edi, 16
        mov     [ebp.Client_ES], di            ; client es:bx=PtrBuf
        Trace_Out "ES=#DI"

        mov     edi, dword ptr [esi].lpvInBuffer
        xor     ax, ax
        mov     al, byte ptr [edi].cd_drv
        mov     [ebp.Client_CX], ax
        Trace_Out "CX=#AX"
        mov     [ebp.Client_AX], 01508h        ; MSCDEX Absolute read      
        Trace_Out "AX=01508h"
        xor     ax, ax
        mov     al, [edi].cd_blocks
        mov     [ebp.Client_DX], ax            ; number of sectors
        Trace_Out "DX=#AX"
        mov     eax, [edi].cd_LBA
        mov     [ebp.Client_DI], ax            ; sector low word
        Trace_Out "DI=#AX"
        shr     eax, 16
        mov     [ebp.Client_SI], ax            ; sector high word
        Trace_Out "SI=#AX"

        mov     eax, 2fh                       ; MSCDEX int
        VMMCall Exec_Int                       ; current VM to call MSCDEX
        clc
        test    [ebp.Client_Flags], CARRY_FLAG
        jnz     ioctl_readerr
        mov     ioctlerror, INT2F_ERROR_SUCCESS
ioctl_readerr:

        VMMcall End_Nest_Exec                  ; end of nested exec calls
        Pop_Client_State                       ; restore all registers when done 
;------------------------------
        ; copy and free sector buffer...
        mov     ecx, AllocLenBuf
        mov     edi, dword ptr [esi].lpvInBuffer
        push    esi                            ; save ESI
        ; mov     esi, [edi].cd_buf              ; get win32 destination buffer in ESI!
        stc                                    ; carry set=>copy
        push    ds
        pop     fs                             ; fs=ds (FS:ESI=
        mov     esi, dword ptr [edi].cd_buf     ; FS:ESI = pointer to destination buffer
        VxDcall V86MMGR_Free_Buffer
                                               ; needs EBX / EBP (VM handle / client reg struc of virtual machine)
        pop     esi                            ; restore ESI
        jmp     ioctl_done

; ------------------------------------------------------------------
ioctl_done:
        mov     eax, ioctlerror
        clc
        cmp     eax, INT2F_ERROR_SUCCESS
        je      ioctl_fin
        Trace_Out "INT2F_ioctl: error"
        stc                                   ; if error set carry!
ioctl_fin:
 	ret

EndProc	INT2F_ioctl



;============================================================================
;
; INT2F_Device_Exit - Cleans up any hooks that are still installed before
;		    exiting.
;
;============================================================================
Public INT2F_Device_Exit
BeginProc INT2F_Device_Exit
        Trace_Out "INT2F_Device_Exit"
	clc
	ret
EndProc INT2F_Device_Exit



VxD_LOCKED_CODE_ENDS




;******************************************************************************
;                       R E A L   M O D E   C O D E
;******************************************************************************

;******************************************************************************
;
;       Real mode initialization code
;
;   DESCRIPTION:
;       This code is called when the system is still in real mode, and
;       the VxDs are being loaded.
;
;       This routine as coded shows how a VxD (with a defined VxD ID)
;       could check to see if it was being loaded twice, and abort the 
;       second without an error message. Note that this would require
;       that the VxD have an ID other than Undefined_Device_ID. See
;       the file VXDID.TXT more details.
;
;   ENTRY:
;       AX = VMM Version
;       BX = Flags
;               Bit 0: duplicate device ID already loaded
;               Bit 1: duplicate ID was from the INT 2F device list
;               Bit 2: this device is from the INT 2F device list
;       EDX = Reference data from INT 2F response, or 0
;       SI = Environment segment, passed from MS-DOS
;
;   EXIT:
;       BX = ptr to list of pages to exclude (0, if none)
;       SI = ptr to list of instance data items (0, if none)
;       EDX = DWORD of reference data to be passed to protect mode init
;
;==============================================================================

VxD_REAL_INIT_SEG

BeginProc INT2F_Real_Init_Proc

        Trace_Out "INT2F_Real_Init_Proc"
	test	bx, Duplicate_Device_ID ; check for already loaded
	jnz	short duplicate         ; jump if so

        xor     bx, bx                  ; no exclusion table
        xor     si, si                  ; no instance data table
        xor     edx, edx                ; no reference data

        mov     ax, Device_Load_Ok
        ret

duplicate:
        mov     ax, Abort_Device_Load + No_Fail_Message
        ret

EndProc INT2F_Real_Init_Proc


VxD_REAL_INIT_ENDS


        END
