unit viewerdlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, hHexDump, devices, diskfs, StdCtrls, ComCtrls, ExtCtrls;

type
  TViewerDialog = class(TForm)
    Notebook1: TNotebook;
    Hexdump1: THexDump;
    RichEdit1: TRichEdit;
    procedure FormActivate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
     fDrv: TfatDrive;
     fBuf: array[0..32767] of byte;
     fshandle: TfatFileInfo;
     fFATno: byte;
  public
    { Public declarations }
    function ViewAsHex(drv: TfatDrive; name: string; startclus, size: longword; FATno: byte): boolean;
    function ViewAsText(drv: TfatDrive; name: string; startclus, size: longword; FATno: byte): boolean;
  end;

var
  ViewerDialog: TViewerDialog;

implementation

  uses main;

{$R *.dfm}



function TViewerDialog.ViewAsHex(drv: TfatDrive; name: string;
  startclus, size: longword; FATno: byte): boolean;
var
  mrResult: integer;
  astream: TfatStream;
begin
  hexdump1.Enabled:=false;
  caption:='View as hex: '+name;
  astream:=TfatStream.create(drv, startclus, size, FATno);
  with Hexdump1 do
  begin
    Stream:=astream;
    enabled:=TRUE; /// ??? otherwise does not run - why?
  end;
  Notebook1.ActivePage:='hex';
  result:=(showModal = mrOK);
  astream.free;
end;

function TViewerDialog.ViewAsText(drv: TfatDrive; name: string;
  startclus, size: longword; FATno: byte): boolean;
var
  mrResult: integer;
  astream: TfatStream;
  sz: longword;
begin
  hexdump1.Enabled:=false;
  caption:='View as text: '+name;
  sz:=size;
  //if sz > 1024000 then sz:=1024000;  // limit file size for text viewer
  astream:=TfatStream.create(drv, startclus, sz, FATno);
  with RichEdit1 do
  begin
    Font.Name := 'FixedSys';
    Lines.LoadFromStream(astream);
    SelStart := 0;
  end;
  Notebook1.ActivePage:='text';
  result:=(showModal = mrOK);
  astream.Free;
end;


procedure TViewerDialog.FormActivate(Sender: TObject);
begin
  if Notebook1.ActivePage='text' then RichEdit1.SetFocus
    else if Notebook1.ActivePage='hex' then Hexdump1.setfocus;
end;

procedure TViewerDialog.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case key of
    vk_escape: close;
  end;
end;

end.
