unit secdlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, diskfs;

type
  TSectorDialog = class(TForm)
    Label1: TLabel;
    LabelSize: TLabel;
    OKBtn: TButton;
    CancelBtn: TButton;
    GroupBox1: TGroupBox;
    TrackBarStartSec: TTrackBar;
    EditStartSec: TEdit;
    GroupBox2: TGroupBox;
    TrackBarEndSec: TTrackBar;
    EditEndSec: TEdit;
    Button1: TButton;
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TrackBarStartSecChange(Sender: TObject);
    procedure TrackBarEndSecChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    totalsec: longword;        // total sectors
    startsec: longword;        // ending sector
    endsec: longword;          // start sector
    bytesPerSec: word;          // bytes per sector
    function Execute: boolean;
    procedure UpdateSize;
  end;

var
  SectorDialog: TSectorDialog;

implementation

uses main;


{$R *.DFM}


function TSectorDialog.Execute: boolean;
var
  code: integer;
  starts, ends: longword;
begin
  if SectorDialog.ShowModal = mrOK then
  begin
    val(sectordialog.editstartsec.text, starts, code);
    if code = 0 then startsec:=starts;

    val(sectordialog.editendsec.text, ends, code);
    if code = 0 then endsec:=ends;
  end else result:=false;
end;

procedure TSectorDialog.UpdateSize;
var
  startsec, endsec: longword;
  code: integer;
  size: real;
begin
    val(editstartsec.text, startsec, code);
    if code = 0 then
    begin
      val(editendsec.text, endsec, code);
      if code = 0 then
      begin
        size:=longword(endsec-startsec+1) / 1024 * longword(BytesPerSec) / 1024;
        if size < 1000 then
          labelsize.caption:=Format('%f MB',[size])
        else
          labelsize.caption:=Format('%f GB',[size / 1024]);
      end;
    end;
end;



procedure TSectorDialog.FormActivate(Sender: TObject);
begin
  GroupBox1.caption:='Start sector (min. 0)';
  GroupBox2.caption:='End sector (max. '+inttostr(TotalSec-1)+')';
  {TrackbarstartsecChange(sender);
  TrackbarEndsecChange(sender);}
  TrackbarStartSec.position:=round(StartSec/TotalSec*TrackBarStartSec.Max);
  TrackbarEndSec.position:=round(EndSec/TotalSec*TrackBarEndSec.Max);
  EditStartSec.text:=InttoStr(StartSec);
  EditEndSEc.text:=IntTostr(EndSec);

  updateSize;
end;

procedure TSectorDialog.Button1Click(Sender: TObject);
begin
  updatesize;
end;

procedure TSectorDialog.TrackBarStartSecChange(Sender: TObject);
begin
  if Trackbarstartsec.Position <= Trackbarendsec.position then
  begin
    EditStartSec.text:=Format('%d', [(round((TotalSec-1) *
      (Trackbarstartsec.position / Trackbarstartsec.max)))]);
    updatesize;
  end;
end;

procedure TSectorDialog.TrackBarEndSecChange(Sender: TObject);
begin
  if Trackbarstartsec.Position <= Trackbarendsec.position then
  begin
    EditEndSec.text := Format('%d', [(round((TotalSec-1) *
      (TrackbarEndsec.position / TrackbarEndsec.max)))]);
    updateSize;
  end;
end;

end.
