{ Bugs:


  TODO:
  * add boot sector recovery for FAT12/16
  * improve detect "quick-formatted" disks (=> cleared ZIP is not formatted!)
  * improve MPEG file detection
  * test Multibyte character support!
  * save files with original attributes
  * change 'copy object'-method to 'assign' (see Delphi help)
    example:
      procedure TTextAttributes.Assign(Source: TPersistent);
      if Source is TFont then
      begin
        Color := TFont(Source).Color;
      end
     else if Source is TTextAttributes then
     begin
     end
     else inherited Assign(Source);

    and ASSIGNTO !
     procedure TTextAttributes.AssignTo(Dest: TPersistent);
     begin
       if Dest is TFont then
       begin
           TFont(Dest).Color := Color;
       else inherited AssignTo(Dest);

}

program rescue;

// {$DEFINE DEBUG }

{$IFDEF DEBUG}
  {$D+} // Debug Infos
  {$L+} // local symbols
  {$L+} // symbol infos
  {$C+} // assertions
  {$Q+} // overflow check

{$ELSE}

  {$D-} // Debug Infos
  {$L-} // local symbols
  {$L-} // symbol infos
  {$C-} // assertions
  {$Q-} // overflow check
{$ENDIF}

uses
  Windows,
  Forms,
  main in 'main.pas' {MainForm},
  pdiskio in 'pdiskio.pas',
  diskfs in 'diskfs.pas',
  drvdlg in 'drvdlg.pas' {DriveDlg},
  helpers in 'helpers.pas',
  inputdlg in 'inputdlg.pas' {InputForm},
  aboutdlg in 'aboutdlg.pas' {AboutDialog},
  dirseldlg in 'dirseldlg.pas' {DirSelectDialog},
  statusdlg in 'statusdlg.pas' {StatusDialog},
  secdlg in 'secdlg.pas' {SectorDialog},
  LDISKIO in 'LDISKIO.PAS',
  clusdlg in 'clusdlg.pas' {ClusterDialog},
  sysinfo in 'systeminfo\sysinfo.pas' {DialogSystemInfo},
  predrdlg in 'Predrdlg.pas' {PreviewDrvDialog},
  optdlg in 'optdlg.pas' {OptionsDialog},
  DebugBox in 'debugbox\debugbox.pas',
  devices in 'devices.pas',
  finddlg in 'finddlg.pas' {FindDialog},
  welcodlg in 'welcodlg.pas' {WelcomeDialog},
  viewerdlg in 'viewerdlg.pas' {ViewerDialog},
  hHexDump in 'viewer\hHexDump.pas',
  FATdlg in 'FATdlg.pas' {FATSelectDialog},
  propdlg in 'propdlg.pas' {ItemPropertiesDialog},
  dinfodlg in 'dinfodlg.pas' {DriveInfoDialog},
  filedet in 'filedet.pas',
  common in 'common.pas';

{$R *.RES}




begin
  //OutputDebugString('Delphi program loaded'#13#10);
  Application.Initialize;
  Application.CreateForm(TMainForm, MainForm);
  Application.CreateForm(TDriveDlg, DriveDlg);
  Application.CreateForm(TInputForm, InputForm);
  Application.CreateForm(TAboutDialog, AboutDialog);
  Application.CreateForm(TDirSelectDialog, DirSelectDialog);
  Application.CreateForm(TStatusDialog, StatusDialog);
  Application.CreateForm(TSectorDialog, SectorDialog);
  Application.CreateForm(TClusterDialog, ClusterDialog);
  Application.CreateForm(TDialogSystemInfo, DialogSystemInfo);
  Application.CreateForm(TPreviewDrvDialog, PreviewDrvDialog);
  Application.CreateForm(TOptionsDialog, OptionsDialog);
  Application.CreateForm(TFindDialog, FindDialog);
  Application.CreateForm(TWelcomeDialog, WelcomeDialog);
  Application.CreateForm(TDriveInfoDialog, DriveInfoDialog);
  Application.CreateForm(TViewerDialog, ViewerDialog);
  Application.CreateForm(TFATSelectDialog, FATSelectDialog);
  Application.CreateForm(TItemPropertiesDialog, ItemPropertiesDialog);
  Application.CreateForm(TDriveInfoDialog, DriveInfoDialog);
  Application.Run;
end.



